/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Shape;
import org.alov.map.StatusListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;

public class DistanceTool
extends Panel
implements CarteHostListener,
CarteListener,
ActionListener,
StatusListener {
    private static final String NAME_BTN_ADD = "distance_add";
    private static final String NAME_BTN_CLEAR = "distance_clear";
    private static final String NAME_LBL_INFO = "distance_info";
    private static byte TOOL_ADD_WAYPOINT = (byte)-55;
    private Carte map = null;
    private CarteHost host = null;
    private Label lblInfo;
    private boolean drawingPath;
    private Vector waypoints = new Vector();
    private double pathLength = 0.0;
    private Point lastMousePosition = null;
    private String lastLabel = null;
    private int units;
    private float unitsFormat = 100.0f;
    private static final Font font = new Font("Sans Serif", 1, 14);
    private static final int PATH_OVAL_RADIUS = 4;
    private static final double EARTH_RADIUS_KM = 6378.0;
    private static final int LENGTH_UNITS_FOR_DEGREES = 0;

    private void addWaypoint(float x, float y) {
        this.addWaypoint(new FloatPoint(x, y));
    }

    private void addWaypoint(FloatPoint point) {
        this.waypoints.addElement(point);
        this.recalculatePathLength();
        Graphics g = this.map.getGraphics();
        if (g != null) {
            try {
                this.drawWholePath(g);
                Object var4_3 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                g.dispose();
                throw throwable;
            }
        }
    }

    private void clearPath() {
        this.waypoints.removeAllElements();
        this.map.repaint();
        this.recalculatePathLength();
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.host = host;
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
        this.map.mapListeners.addElement(this);
        Container cont = (Container)((Object)host);
        MapUtils.addActionListener(this, cont, NAME_BTN_CLEAR);
        String unitsS = XmlUtils.getString("precision", layout, null);
        try {
            int rnd = Integer.parseInt(unitsS);
            this.unitsFormat = Math.abs(rnd) > 5 ? 99.0f : (float)Math.pow(10.0, rnd);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void showAttributes(LayerVector lyr, Vector records) {
    }

    public void stop() {
    }

    private void drawWholePath(Graphics g) {
        int waypointCount = this.waypoints.size();
        if (waypointCount <= 0) {
            return;
        }
        Point previousPoint = null;
        g.setColor(Color.black);
        int i = 0;
        while (i < waypointCount) {
            Point currentPoint = this.map.mapToScreen((FloatPoint)this.waypoints.elementAt(i));
            g.drawOval(currentPoint.x - 4, currentPoint.y - 4, 8, 8);
            if (previousPoint != null) {
                Shape.drawBoldLine(g, previousPoint.x, previousPoint.y, currentPoint.x, currentPoint.y);
            }
            previousPoint = currentPoint;
            ++i;
        }
    }

    private void drawPathSegment(Graphics g, Point pointFrom, Point pointTo, boolean drawBoundingCircle) {
        g.drawLine(pointFrom.x, pointFrom.y, pointTo.x, pointTo.y);
        double dx = pointTo.x - pointFrom.x;
        double dy = pointTo.y - pointFrom.y;
        int radius = (int)Math.sqrt(dx * dx + dy * dy);
        g.drawOval(pointFrom.x - radius, pointFrom.y - radius, radius * 2, radius * 2);
    }

    private void mouseAt(Point point, boolean clearOnly) {
        int waypointCount = this.waypoints.size();
        if (waypointCount > 0) {
            FloatPoint lastWaypointMap = (FloatPoint)this.waypoints.elementAt(waypointCount - 1);
            Point lastWaypoint = this.map.mapToScreen(lastWaypointMap);
            Graphics g = this.map.getGraphics();
            if (g != null) {
                try {
                    g.setFont(font);
                    g.setColor(Color.black);
                    g.setXORMode(Color.white);
                    if (this.lastMousePosition != null) {
                        this.drawPathSegment(g, lastWaypoint, this.lastMousePosition, true);
                        g.drawString(this.lastLabel, this.lastMousePosition.x, this.lastMousePosition.y);
                    }
                    if (!clearOnly) {
                        FloatPoint newPoint = this.map.screenToMap(point);
                        this.lastLabel = this.formatLength(this.getPathLength() + this.distance(lastWaypointMap, newPoint, this.units));
                        this.drawPathSegment(g, lastWaypoint, point, true);
                        g.drawString(this.lastLabel, point.x, point.y);
                        g.setXORMode(Color.black);
                        this.lastMousePosition = point;
                    }
                    Object var9_8 = null;
                    g.dispose();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    g.dispose();
                    throw throwable;
                }
            }
        }
    }

    public void mouseMapPressed(MouseEvent e) {
        if (this.map.getTool() == TOOL_ADD_WAYPOINT && (e.getModifiers() & 0x10) != 0) {
            if (this.waypoints.size() <= 0 || this.drawingPath) {
                this.drawingPath = e.getClickCount() <= 1;
            } else {
                this.clearPath();
                this.drawingPath = true;
            }
            Point screenPoint = e.getPoint();
            FloatPoint mapPoint = this.map.screenToMap(screenPoint);
            this.mouseAt(screenPoint, true);
            this.addWaypoint(mapPoint);
            this.lastMousePosition = null;
        }
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
    }

    public void mouseMapMoved(MouseEvent e) {
        if (this.map.getTool() == TOOL_ADD_WAYPOINT && this.drawingPath) {
            Point screenPoint = e.getPoint();
            this.mouseAt(screenPoint, false);
        }
    }

    public void afterMapDraw(Graphics g) {
        this.lastMousePosition = null;
        this.lastLabel = null;
        this.drawWholePath(g);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object o = actionEvent.getSource();
        if (o instanceof Component) {
            String sName = ((Component)o).getName();
            if (sName.equalsIgnoreCase(NAME_BTN_ADD)) {
                this.map.setTool(TOOL_ADD_WAYPOINT);
                if (o instanceof ImageButton) {
                    ((ImageButton)o).setDown(true);
                }
            } else if (sName.equalsIgnoreCase(NAME_BTN_CLEAR)) {
                this.clearPath();
            }
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        Container cont = (Container)((Object)this.host);
        MapUtils.addActionListener(this, cont, NAME_BTN_ADD);
        MapUtils.addActionListener(this, cont, NAME_LBL_INFO);
        this.lblInfo = (Label)MapUtils.findComp(cont, NAME_LBL_INFO);
        this.units = this.map.getProject().MapUnits;
    }

    public void notifyStatus(int code, Object obj) {
        Component c;
        if (this.map.getTool() == TOOL_ADD_WAYPOINT && (c = MapUtils.findComp((Container)((Object)this.host), NAME_BTN_ADD)) instanceof ImageButton) {
            ((ImageButton)c).setDown(true);
        }
    }

    private void recalculatePathLength() {
        this.pathLength = this.getPathLength();
        if (this.lblInfo != null) {
            this.lblInfo.setText(this.formatLength(this.pathLength));
        }
    }

    private double getPathLength() {
        int waypointCount = this.waypoints.size();
        FloatPoint prevPoint = null;
        double length = 0.0;
        int i = 0;
        while (i < waypointCount) {
            FloatPoint currentPoint = (FloatPoint)this.waypoints.elementAt(i);
            if (prevPoint != null) {
                length += this.distance(prevPoint, currentPoint, this.units);
            }
            prevPoint = currentPoint;
            ++i;
        }
        return length;
    }

    private String formatLength(double val) {
        StringBuffer s = new StringBuffer();
        if ((double)this.unitsFormat > 1000000.0 || this.unitsFormat == 1.0f) {
            s.append(String.valueOf(val));
        } else {
            s.append(String.valueOf((float)((int)(val * (double)this.unitsFormat)) / this.unitsFormat));
        }
        s.append(' ');
        int lengthUnits = this.map.getProject().MapUnits;
        if (lengthUnits == 0) {
            lengthUnits = 0;
        }
        switch (lengthUnits) {
            case 1: {
                s.append(this.map.getResource("M"));
                break;
            }
            case 0: 
            case 2: {
                s.append(this.map.getResource("kM"));
                break;
            }
            case 4: {
                s.append(this.map.getResource("ft"));
                break;
            }
            case 5: {
                s.append(this.map.getResource("mi"));
            }
        }
        return s.toString();
    }

    private double distance(FloatPoint a, FloatPoint b, int units) {
        if (units == 0) {
            return this.lengthDegrees(a.x, a.y, b.x, b.y);
        }
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double lengthDegrees(double b1, double a1, double b2, double a2) {
        double value;
        if ((value = Math.acos(Math.cos(a1 *= Math.PI / 180) * Math.cos(b1 *= Math.PI / 180) * Math.cos(a2 *= Math.PI / 180) * Math.cos(b2 *= Math.PI / 180) + Math.cos(a1) * Math.sin(b1) * Math.cos(a2) * Math.sin(b2) + Math.sin(a1) * Math.sin(a2)) * 6378.0) == Double.NaN) {
            value = 0.0;
        }
        return value;
    }
}

