/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import org.alov.map.Carte;

class TipRect
extends Canvas {
    private Carte map;
    private Container containerOnWhichTheTooltipShows;
    private String caption;
    private int x;
    private int y;
    private int width;
    private int height;
    private Font tooltipFont;
    private boolean fill;
    private boolean outline;
    private Color fillColor;
    private Color outlineColor;

    TipRect(String caption, Font tooltipFont, Carte map, Point ppt, boolean fill, boolean outline, Color fillColor, Color outlineColor) {
        this.map = map;
        this.containerOnWhichTheTooltipShows = map.getParent();
        this.containerOnWhichTheTooltipShows.add(this);
        this.caption = caption;
        this.tooltipFont = tooltipFont;
        FontMetrics fontSize = null;
        Graphics g = map.getGraphics();
        try {
            if (tooltipFont != null) {
                g.setFont(tooltipFont);
            }
            fontSize = g.getFontMetrics();
            this.width = fontSize.stringWidth(caption) + 3;
            this.height = fontSize.getHeight() + 2;
            Object var12_11 = null;
            g.dispose();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            g.dispose();
            throw throwable;
        }
        ppt.y -= this.height;
        if (ppt.x < 0) {
            ppt.x = 0;
        }
        if (ppt.y < 0) {
            ppt.y = 0;
        }
        if (ppt.x + this.width > this.containerOnWhichTheTooltipShows.getSize().width) {
            ppt.x = this.containerOnWhichTheTooltipShows.getSize().width - this.width;
        }
        if (ppt.y + this.height > this.containerOnWhichTheTooltipShows.getSize().height) {
            ppt.y = this.containerOnWhichTheTooltipShows.getSize().height - this.height;
        }
        this.x = ppt.x;
        this.y = ppt.y;
        this.fill = fill;
        this.outline = outline;
        this.fillColor = fillColor;
        this.outlineColor = outlineColor;
    }

    void dispose() {
        this.containerOnWhichTheTooltipShows.remove(this);
        this.map.updateMap();
    }

    public void paint(Graphics g) {
        if (this.fill) {
            g.setColor(this.fillColor);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        g.setColor(this.outlineColor);
        if (this.outline) {
            g.drawRect(this.x, this.y, this.width, this.height);
        }
        if (this.tooltipFont != null) {
            g.setFont(this.tooltipFont);
        }
        g.drawString(this.caption, this.x + 2, this.y + this.height - 4);
    }
}

