/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.alov.data.Csv;
import org.alov.data.Dbf;
import org.alov.data.MifHeader;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Shape;

public class Mif {
    private static final String REGION = "REGION ";
    private static final String PLINE_MULTIPLE = "PLINE MULTIPLE ";
    private static final String PLINE = "PLINE ";
    private static final String POINT = "POINT ";
    private static final String LINE = "LINE ";
    private static final String EMPTY = "";
    private static final int MIF_POINT = 1;
    private static final int MIF_LINE = 2;
    private static final int MIF_POLYGON = 3;
    private MifHeader header;

    public Mif(InputStream inputStream, Dbf dbf) {
        this.header = new MifHeader(inputStream, null, dbf, -1);
    }

    public int getObjectType() {
        return this.header.type;
    }

    protected static void deleteSpaces(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = 0;
        int n3 = 0;
        char c = ' ';
        while (n2 < n) {
            char c2;
            if (Character.isWhitespace(c2 = stringBuffer.charAt(n2++)) && Character.isWhitespace(c)) continue;
            stringBuffer.setCharAt(n3++, c2);
            c = c2;
        }
        if (n3 > 0 && Character.isWhitespace(c)) {
            --n3;
        }
        stringBuffer.setLength(n3);
    }

    public static boolean loadFromStream(InputStream inputStream, InputStream inputStream2, Dbf dbf, LayerVector layerVector) {
        MifHeader mifHeader = new MifHeader(inputStream, inputStream2, dbf, layerVector.fi_id);
        if (dbf == null) {
            Csv.resolveCsvFields(mifHeader.fieldNames, mifHeader.fieldsType, layerVector);
        }
        try {
            Record record;
            while ((record = Mif.readNextObject(mifHeader)) != null) {
                if (layerVector.objectType >= 1 && layerVector.objectType != mifHeader.type) continue;
                layerVector.addRecord(record);
            }
            layerVector.objectType = mifHeader.type;
            layerVector.metadata.maxExtent = layerVector.getLayerExtent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mifHeader.objectNumber > 0;
    }

    public Record readNextObject() throws IOException {
        return Mif.readNextObject(this.header);
    }

    private static Record readNextObject(MifHeader mifHeader) throws IOException {
        String string;
        Record record = null;
        Dbf dbf = mifHeader.dbf;
        BufferedReader bufferedReader = mifHeader.reader;
        int n = dbf != null ? dbf.getNumFields() : mifHeader.fieldCountMid;
        while ((string = bufferedReader.readLine()) != null) {
            Shape shape;
            int n2;
            StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
            Mif.deleteSpaces(stringBuffer);
            string = stringBuffer.toString();
            if (string.startsWith(REGION) || string.startsWith(PLINE_MULTIPLE) || string.startsWith(PLINE)) {
                String string2;
                boolean bl = false;
                if (string.startsWith(REGION)) {
                    mifHeader.type = 3;
                    string2 = REGION;
                } else {
                    if (string.startsWith(PLINE_MULTIPLE)) {
                        string2 = PLINE_MULTIPLE;
                    } else {
                        string2 = PLINE;
                        bl = true;
                    }
                    mifHeader.type = 2;
                }
                int n3 = Integer.parseInt(string.substring(string2.length()).trim());
                int n4 = 0;
                if (bl) {
                    n4 = n3;
                    n3 = 1;
                }
                record = new Record(n);
                n2 = 0;
                while (n2 < n3) {
                    if (!bl) {
                        n4 = Integer.parseInt(bufferedReader.readLine().trim());
                    }
                    shape = record.newShape(n4);
                    int n5 = 0;
                    while (n5 < n4) {
                        stringBuffer = new StringBuffer(bufferedReader.readLine());
                        Mif.deleteSpaces(stringBuffer);
                        string = stringBuffer.toString();
                        int n6 = string.indexOf(32, 0);
                        shape.xCoords[n5] = MapUtils.toDouble(string.substring(0, n6));
                        shape.yCoords[n5] = MapUtils.toDouble(string.substring(n6 + 1));
                        ++n5;
                    }
                    ++n2;
                }
            } else if (string.startsWith(POINT)) {
                mifHeader.type = 1;
                string = string.substring(POINT.length());
                int n7 = string.indexOf(32, 0);
                double d = MapUtils.toDouble(string.substring(0, n7));
                double d2 = MapUtils.toDouble(string.substring(n7 + 1));
                record = new Record(n);
                shape = record.newShape(1);
                shape.setVertex(0, d, d2);
            } else if (string.startsWith(LINE)) {
                mifHeader.type = 2;
                string = string.substring(LINE.length());
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                record = new Record(n);
                Shape shape2 = record.newShape(2);
                shape2.setVertex(0, MapUtils.toDouble(stringTokenizer.nextToken()), MapUtils.toDouble(stringTokenizer.nextToken()));
                shape2.setVertex(1, MapUtils.toDouble(stringTokenizer.nextToken()), MapUtils.toDouble(stringTokenizer.nextToken()));
            }
            if (record == null) continue;
            if (dbf != null) {
                dbf.ParseNextDbfRecord(record);
            } else {
                Integer n8 = new Integer(0);
                Double d = new Double(0.0);
                StringBuffer stringBuffer2 = Mif.GrabNextMidRec(mifHeader);
                Record record2 = Csv.ParseCsvRecord(stringBuffer2.toString(), EMPTY, n);
                n2 = 0;
                while (n2 < n) {
                    switch (mifHeader.fieldsType[n2]) {
                        case 'C': 
                        case 'D': 
                        case 'L': {
                            record.setField(n2, record2.getField(n2));
                            break;
                        }
                        case 'F': 
                        case 'N': {
                            try {
                                record.setField(n2, Double.valueOf((String)record2.getField(n2)));
                            }
                            catch (NumberFormatException numberFormatException) {
                                record.setField(n2, d);
                            }
                            break;
                        }
                        case 'I': {
                            try {
                                record.setField(n2, Integer.decode((String)record2.getField(n2)));
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                record.setField(n2, n8);
                            }
                        }
                    }
                    ++n2;
                }
            }
            record.setId(mifHeader.fi_id < 0 ? Integer.toString(++mifHeader.objectNumber) : record.getField(mifHeader.fi_id).toString());
            return record;
        }
        return null;
    }

    private static StringBuffer GrabNextMidRec(MifHeader mifHeader) throws IOException {
        String string = mifHeader.readerMid.readLine();
        StringBuffer stringBuffer = new StringBuffer(string);
        Mif.deleteSpaces(stringBuffer);
        return stringBuffer;
    }
}

