/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import org.alov.data.Dbf;
import org.alov.data.ShpHeader;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.Readers;
import org.alov.util.Utils;
import org.alov.util.XmlUtils;

public class Shp
implements Const {
    public static final int SHP_NULL = 0;
    public static final int SHP_POINT = 1;
    public static final int SHP_POLYLINE = 3;
    public static final int SHP_POLYGON = 5;
    public static final int SHP_MULTIPOINT = 8;
    public static final int SHP_POINTZ = 11;
    public static final int SHP_POLYLINEZ = 13;
    public static final int SHP_POLYGONZ = 15;
    public static final int SHP_MULTIPOINTZ = 18;
    ShpHeader header = null;
    private DataInputStream dataInput = null;

    public Shp(InputStream inputStream, Dbf dbf) throws Exception {
        this(inputStream, dbf, null);
    }

    public Shp(InputStream inputStream, Dbf dbf, LayerVector layerVector) throws Exception {
        if (inputStream != null) {
            this.dataInput = new DataInputStream(inputStream);
            this.header = new ShpHeader(this.dataInput, dbf, false, -1);
            if (layerVector != null) {
                Shp.setLayerParameters(layerVector, this.header);
            }
        } else {
            throw new Exception("Trying to instantiate Shp with InputStream == null");
        }
    }

    public static void loadFromStream(InputStream inputStream, Dbf dbf, LayerVector layerVector, boolean bl) throws AlovMapException {
        try {
            long l;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 65536);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            ShpHeader shpHeader = new ShpHeader(dataInputStream, dbf, bl, layerVector.fi_id);
            Shp.setLayerParameters(layerVector, shpHeader);
            if (Utils.isJava14 && (float)((l = (long)Utils.getFreeMemorySpace()) - (long)shpHeader.length) < 0.2f * (float)Utils.MaxMem) {
                throw new AlovMapException("Shape exceeding threshold size (would use 80% of available memory)");
            }
            int n = 1;
            while (shpHeader.position < shpHeader.length) {
                Record record;
                if ((record = Shp.readNextShape(shpHeader, n++)) == null) continue;
                layerVector.addRecord(record);
                record.figType = (byte)layerVector.objectType;
            }
        }
        catch (AlovMapException alovMapException) {
            throw alovMapException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AlovMapException(324, exception.getMessage());
        }
    }

    private static void setLayerParameters(Layer layer, ShpHeader shpHeader) {
        switch (shpHeader.type) {
            case 1: 
            case 8: {
                layer.objectType = 1;
                break;
            }
            case 3: {
                layer.objectType = 2;
                break;
            }
            case 5: {
                layer.objectType = 3;
            }
        }
        layer.metadata.maxExtent = new FloatRectangle(shpHeader.xmin, shpHeader.ymin, shpHeader.xmax, shpHeader.ymax);
    }

    public Record readNextShape(int n) throws Exception {
        return Shp.readNextShape(this.header, n);
    }

    private static Record readNextShape(ShpHeader shpHeader, int n) throws Exception {
        if (shpHeader.position >= shpHeader.length) {
            throw new Exception("Trying to read past end of Shape file");
        }
        Dbf dbf = shpHeader.dbf;
        boolean bl = shpHeader.fixHoles;
        Record record = null;
        DataInputStream dataInputStream = shpHeader.dataInput;
        int n2 = dataInputStream.readInt();
        if (n != n2) {
            if (dbf != null) {
                dbf.ParseNextDbfRecord(null);
            }
            return null;
        }
        int n3 = dataInputStream.readInt();
        int n4 = Readers.readInt(dataInputStream);
        int n5 = dbf != null ? dbf.getNumFields() : 0;
        shpHeader.position += n3 + 4;
        if (n4 != 0) {
            if (!(n4 == shpHeader.type || 1 == shpHeader.type && n4 == 11 || 8 == shpHeader.type && n4 == 18 || 3 == shpHeader.type && n4 == 13 || 5 == shpHeader.type && n4 == 15)) {
                throw new AlovMapException(323, "Shape type doesn't correspond with header type");
            }
            record = new Record(n5);
            switch (n4) {
                case 1: 
                case 11: {
                    Shape shape = record.newShape(1);
                    shape.xCoords[0] = Readers.readDouble(dataInputStream);
                    shape.yCoords[0] = Readers.readDouble(dataInputStream);
                    if (11 != n4) break;
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    break;
                }
                case 8: 
                case 18: {
                    record.extent = Readers.readRectangleLittle(dataInputStream);
                    int n6 = Readers.readInt(dataInputStream);
                    Shape shape = record.newShape(n6);
                    int n7 = 0;
                    while (n7 < n6) {
                        shape.xCoords[n7] = Readers.readDouble(dataInputStream);
                        shape.yCoords[n7] = Readers.readDouble(dataInputStream);
                        ++n7;
                    }
                    if (18 != n4) break;
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    n7 = 0;
                    while (n7 < n6) {
                        Readers.readDouble(dataInputStream);
                        ++n7;
                    }
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    n7 = 0;
                    while (n7 < n6) {
                        Readers.readDouble(dataInputStream);
                        ++n7;
                    }
                    break;
                }
                case 3: 
                case 5: 
                case 13: 
                case 15: {
                    int n8;
                    int n9;
                    record.extent = Readers.readRectangleLittle(dataInputStream);
                    int n10 = Readers.readInt(dataInputStream);
                    int n11 = n9 = Readers.readInt(dataInputStream);
                    int n12 = n9;
                    if (n10 < 1) {
                        if (dbf != null) {
                            dbf.ParseNextDbfRecord(null);
                        }
                        return null;
                    }
                    int[] nArray = shpHeader.tempArray;
                    if (nArray == null || nArray.length < n10) {
                        shpHeader.tempArray = nArray = new int[n10];
                    }
                    int n13 = 0;
                    int n14 = Readers.readInt(dataInputStream);
                    int n15 = 0;
                    while (n15 < n10 - 1) {
                        nArray[n15] = Readers.readInt(dataInputStream) - n13;
                        n13 += nArray[n15];
                        ++n15;
                    }
                    if (n10 > 0) {
                        nArray[n10 - 1] = n9 - n13;
                    }
                    Shape shape = new Shape();
                    if (n10 > 1) {
                        n11 += n10 - 1;
                    }
                    shape.xCoords = new double[n11];
                    shape.yCoords = new double[n11];
                    int n16 = 0;
                    double d = 0.0;
                    double d2 = 0.0;
                    n15 = 0;
                    while (n15 < n10) {
                        n8 = nArray[n15];
                        int n17 = n8 = n8 < 0 ? 0 : (n8 > n9 ? n9 : n8);
                        if (n15 == n10 - 1 && (n9 -= n8) > 0) {
                            n8 = n9;
                        }
                        Shape shape2 = new Shape();
                        shape2.xCoords = new double[n8];
                        shape2.yCoords = new double[n8];
                        boolean bl2 = false;
                        int n18 = 0;
                        while (n18 < n8) {
                            shape2.xCoords[n18] = Readers.readDouble(dataInputStream);
                            shape2.yCoords[n18] = Readers.readDouble(dataInputStream);
                            shape.xCoords[n18 + n16] = shape2.xCoords[n18];
                            shape.yCoords[n18 + n16] = shape2.yCoords[n18];
                            ++n18;
                        }
                        if (n15 == 0) {
                            d = shape2.xCoords[n16 + n8 - 1];
                            d2 = shape2.yCoords[n16 + n8 - 1];
                        } else {
                            shape.xCoords[n16 + n8] = d;
                            shape.yCoords[n16 + n8] = d2;
                            ++n16;
                        }
                        n16 += n8;
                        record.shapes.addElement(shape2);
                        record.isHasHole = bl && (record.isHasHole || (n4 == 5 || n4 == 15) && shape2.isClockWise());
                        ++n15;
                    }
                    if (record.isHasHole) {
                        XmlUtils.addAll(record.outline_shapes, record.shapes);
                        record.shapes.removeAllElements();
                        record.shapes.addElement(shape);
                    }
                    if (n4 != 15 && n4 != 13) break;
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    n8 = 0;
                    while (n8 < n12) {
                        Readers.readDouble(dataInputStream);
                        ++n8;
                    }
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    int n19 = 0;
                    while (n19 < n12) {
                        Readers.readDouble(dataInputStream);
                        ++n19;
                    }
                    break;
                }
            }
            if (dbf != null) {
                dbf.ParseNextDbfRecord(record);
            }
            record.setId(shpHeader.fi_id < 0 ? Integer.toString(++shpHeader.objectNumber) : record.getField(shpHeader.fi_id).toString());
        } else {
            dbf.ParseNextDbfRecord(null);
        }
        switch (n4) {
            case 11: {
                n4 = 1;
                break;
            }
            case 13: {
                n4 = 3;
                break;
            }
            case 15: {
                n4 = 5;
                break;
            }
            case 18: {
                n4 = 8;
            }
        }
        return record;
    }
}

