/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.DataInputStream;
import org.alov.data.Dbf;
import org.alov.util.AlovMapException;
import org.alov.util.Readers;

class ShpHeader {
    int length;
    int version;
    int type;
    int position;
    int objectNumber = 0;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    double zmin;
    double zmax;
    double mmin;
    double mmax;
    int[] tempArray = null;
    DataInputStream dataInput;
    Dbf dbf;
    boolean fixHoles;
    int fi_id;

    ShpHeader(DataInputStream dataInputStream, Dbf dbf, boolean bl, int n) throws Exception {
        this.dataInput = dataInputStream;
        this.dbf = dbf;
        this.fi_id = n;
        this.fixHoles = bl;
        int n2 = dataInputStream.readInt();
        if (n2 != 9994) {
            throw new AlovMapException(321, "");
        }
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        this.length = dataInputStream.readInt();
        this.version = Readers.readInt(dataInputStream);
        if (this.version != 1000) {
            throw new AlovMapException(322, String.valueOf(this.version));
        }
        this.type = Readers.readInt(dataInputStream);
        switch (this.type) {
            case 11: {
                this.type = 1;
                break;
            }
            case 13: {
                this.type = 3;
                break;
            }
            case 15: {
                this.type = 5;
                break;
            }
            case 18: {
                this.type = 8;
            }
        }
        if (this.type != 1 && this.type != 8 && this.type != 3 && this.type != 5) {
            throw new AlovMapException(323, "Unrecognized shape type");
        }
        this.xmin = Readers.readDouble(dataInputStream);
        this.ymin = Readers.readDouble(dataInputStream);
        this.xmax = Readers.readDouble(dataInputStream);
        this.ymax = Readers.readDouble(dataInputStream);
        this.zmin = Readers.readDouble(dataInputStream);
        this.zmax = Readers.readDouble(dataInputStream);
        this.mmin = Readers.readDouble(dataInputStream);
        this.mmax = Readers.readDouble(dataInputStream);
        this.position = 50;
    }
}

