/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.DisplayContext;
import org.alov.map.DisplayContextImpl;
import org.alov.map.Domain;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Lock;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Projection;
import org.alov.map.Proxy;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.StatusListener;
import org.alov.map.Utils2D;
import org.alov.util.Log;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Carte
extends Canvas
implements Runnable,
ImageObserver,
DisplayContext,
CarteHostListener,
ActionListener,
StatusListener,
TimerListener {
    private Properties parameters = new Properties();
    public static final byte TOOL_NONE = 0;
    public static final byte TOOL_CENTER = 1;
    public static final byte TOOL_ZOOMIN = 2;
    public static final byte TOOL_ZOOMOUT = 3;
    public static final byte TOOL_PAN = 4;
    public static final byte TOOL_SELECT = 5;
    public static final byte TOOL_WEBLINK = 6;
    public static final byte TOOL_RECT_SRCH = 7;
    public static final byte TOOL_RECT = 8;
    public static final byte TOOL_SELPOINT = 9;
    private static final int MAX_RECENT_EXTENTS = 20;
    public static final int SEARCH_EXACT = 1;
    public static final int SEARCH_LIKE = 2;
    public static final int SEARCH_QUERY = 3;
    public static final int SEARCH_WHERE = 4;
    public Proxy proxy = null;
    private Carte mainMap = null;
    CarteHost host = null;
    public Vector mapListeners = new Vector();
    public Vector statusListeners = new Vector();
    public boolean showFrame = true;
    public boolean isMultiSelectionMode = true;
    public Properties stringResources = null;
    private Image backImage = null;
    public Graphics drawTo = null;
    private Integer pntCounter = new Integer(0);
    private boolean dontRedraw = false;
    private byte currentTool = 0;
    private byte alterTool = 0;
    private Point mouseDownPoint = null;
    private Point currentPoint = null;
    Vector usedSpaces = new Vector();
    String sDependent_Maps = null;
    long ext_changing = 0L;
    protected Projection projection = null;
    private FloatRectangle lastExtent = null;
    protected FloatRectangle loadedExtent;
    private FloatRectangle lastSelectExt = null;
    private TimeInterval timeInterval = null;
    private PopupMenu pmSelection = new PopupMenu();
    private boolean moveBeyondProject = false;
    private Vector recentExtents = new Vector();
    private int undoIndex = 0;
    private ProxyRequest request = new ProxyRequest();
    private Layer activeLayer = null;
    private String thematicMap = null;
    private Vector SLD_styles = null;
    private String SLD_url = null;
    private Thread serviceThread;
    private boolean sthRunning = false;
    private boolean stopped = true;
    private boolean isKilled = false;
    protected boolean isFirstRequest = true;
    private boolean isKeyMap = false;
    private Project project;
    private FloatRectangle lastRectSelection = null;
    private FloatPoint lastPointSelection = null;
    private Hashtable customCursors = null;
    private SimpleTimer animationTimer;
    private String sPreviousTipsURL = "";
    private static final Font waitFont = new Font("SansSerif", 1, 14);
    private boolean repaintStaticNeeded = false;
    private boolean repaintNeeded = false;
    private Lock paintLock = new Lock();

    public Carte() {
        this.setBackground(Color.white);
        this.enableEvents(49L);
        this.add(this.pmSelection);
        this.pmSelection.addActionListener(this);
    }

    public void start() {
        this.stopped = false;
        this.startServiceThread();
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        if (this.project == null) {
            return;
        }
        int n = this.project.getLayerCount();
        if (n == 0) {
            return;
        }
        this.timeInterval = timeInterval;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = this.project.getLayerByIndex(n2);
            layer.setTimeInterval(timeInterval);
            ++n2;
        }
        this.extentChanged();
        this.broadcastMessage(108, timeInterval);
        this.updateMap();
    }

    public void extentChanged() {
        if (this.projection != null && !this.stopped) {
            this.lastExtent = this.project.maxExtent.isZero() ? new FloatRectangle(0.0, 0.0, 0.0, 0.0) : this.getExtent();
            this.request.setSpatialExtent(this.lastExtent, null);
            this.startServiceThread();
        }
    }

    public void downloadLayer(String string) {
        if (this.projection != null && !this.stopped) {
            this.lastExtent = this.project.maxExtent.isZero() ? new FloatRectangle(0.0, 0.0, 0.0, 0.0) : this.getExtent();
            this.request.setSpatialExtent(this.lastExtent, string);
            this.startServiceThread();
        }
    }

    private synchronized void startServiceThread() {
        if (!this.sthRunning && !this.isKilled) {
            try {
                this.sthRunning = true;
                this.serviceThread = new Thread(this);
                this.serviceThread.setPriority(5);
                this.serviceThread.start();
            }
            catch (Exception exception) {
                this.sthRunning = false;
                exception.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        if (this.proxy != null) {
            if (!this.isProjectLoaded()) {
                this.proxy.loadProject();
                boolean bl = this.isProjectLoaded();
                if (bl && this.project.startLayer == null) {
                    this.project.startLayer = ((Layer)this.project.layers.elementAt((int)0)).id;
                }
                int n = this.statusListeners.size();
                int n2 = 0;
                while (n2 < n) {
                    ((StatusListener)this.statusListeners.elementAt(n2)).afterProjectLoaded(bl);
                    ++n2;
                }
                this.host.refreshLayout();
                if (!bl) {
                    this.sthRunning = false;
                    return;
                }
                if (!Strings.isNullOrBlank(this.SLD_url) && this.SLD_styles != null) {
                    Log.addMessage(312, this.getName(), null, "SLD loader is not found");
                }
                this.setBackground(this.project.mapBackground);
                int n3 = this.project.getLayerCount();
                int n4 = 0;
                while (n4 < n3) {
                    this.project.getLayerByIndex(n4).setParentMap(this);
                    ++n4;
                }
                this.moveBeyondProject = this.project.moveBeyondProject;
                this.projection = new Projection();
                this.loadedExtent = null;
                this.stopped = false;
                if (this.project.maxExtent.isZero()) {
                    this.extentChanged();
                } else {
                    this.isFirstRequest = false;
                    this.loadedExtent = this.project.maxExtent;
                    this.zoomToDomain(this.project.startExtentName);
                }
                this.setActiveLayer(this.project.getLayerById(this.project.startLayer));
                this.setThematicMap(this.project.startTheme);
                this.updateMap();
            }
            while (!this.request.isClear()) {
                ProxyRequest proxyRequest;
                ProxyRequest proxyRequest2 = this.request;
                synchronized (proxyRequest2) {
                    proxyRequest = this.request.copy();
                    this.request.clear();
                }
                try {
                    this.proxy.handleRequest(proxyRequest);
                    if (this.animationTimer != null || this.project.rendererDynamicCount <= 0 || this.project.animationDelay <= 0) continue;
                    this.animationTimer = new SimpleTimer(this.project.animationDelay, this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.sthRunning = false;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public final boolean isProjectLoaded() {
        return this.project != null && this.project.isLoaded;
    }

    public void repaintMap() {
        this.updateMap();
    }

    public void updateMap() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paint(graphics);
                Object var3_2 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    public void updateMap(boolean bl) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paintMap(graphics, bl);
                Object var4_3 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    private void paintRendererLevel(Vector vector, DisplayContext displayContext, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, int n) {
        Serializable serializable;
        Serializable serializable2;
        Vector vector2 = new Vector();
        int n2 = vector.size();
        Vector<Renderer> vector3 = new Vector<Renderer>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Renderer renderer;
            try {
                renderer = (Renderer)vector.elementAt(n3);
            }
            catch (Exception exception) {
                return;
            }
            serializable2 = renderer.layer;
            if (renderer.enabled && (!this.isKeyMap && ((Layer)serializable2).isVisibleNow(displayContext) || this.isKeyMap && ((Layer)serializable2).isKeyMap) && renderer.isRendererVisible(displayContext)) {
                if (this.isKeyMap) {
                    if (serializable2 instanceof LayerZoomify) {
                        ((Layer)serializable2).isVisibleNow(displayContext);
                    }
                    if ((serializable = (Vector)hashtable.get(serializable2)) == null) {
                        serializable = ((Layer)serializable2).filterRecords(((Layer)serializable2).records, false);
                        if (serializable == null) {
                            serializable = vector2;
                        }
                        hashtable.put(serializable2, serializable);
                    }
                } else {
                    serializable = (Vector)hashtable2.get(serializable2);
                    if (serializable == null) {
                        serializable = ((Layer)serializable2).getRecords();
                        if (serializable == null) {
                            serializable = vector2;
                        }
                        hashtable2.put(serializable2, serializable);
                    }
                }
                ((Layer)serializable2).paintRecords((Vector)serializable, renderer, false, displayContext, n);
                if (this.activeLayer != null && this.activeLayer.id.equals(((Layer)serializable2).id)) {
                    vector3.addElement(renderer);
                }
            }
            ++n3;
        }
        if (!this.isKeyMap) {
            n2 = vector3.size();
            int n4 = 0;
            while (n4 < n2) {
                serializable2 = (Renderer)vector3.elementAt(n4);
                serializable = ((Renderer)serializable2).layer;
                Vector vector4 = (Vector)hashtable3.get(serializable);
                if (vector4 == null) {
                    vector4 = serializable.filterRecords(serializable.getSelection(), true);
                    if (vector4 == null) {
                        vector4 = vector2;
                    }
                    hashtable3.put(serializable, vector4);
                }
                serializable.paintRecords(vector4, (Renderer)serializable2, true, displayContext, n);
                ++n4;
            }
        }
    }

    public void paintMap(Graphics graphics, boolean bl) {
        if (!this.isProjectLoaded()) {
            return;
        }
        Lock lock = this.paintLock;
        synchronized (lock) {
            this.repaintNeeded = true;
            this.repaintStaticNeeded |= !bl;
            if (this.dontRedraw) {
                return;
            }
            if (!this.paintLock.tryLock()) {
                return;
            }
        }
        try {
            do {
                Object object;
                this.repaintNeeded = false;
                boolean bl2 = this.repaintStaticNeeded;
                this.repaintStaticNeeded = false;
                int n = this.project.getLayerCount();
                Dimension dimension = this.getSize();
                int n2 = dimension.width;
                int n3 = dimension.height;
                if (n2 < 1 || n3 < 1) break;
                DisplayContextImpl displayContextImpl = new DisplayContextImpl(this, null, this.projection, this.getLastExtent());
                this.usedSpaces.removeAllElements();
                Vector vector = this.project.renderers;
                int n4 = vector.size();
                int n5 = this.project.rendererDynamicCount;
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                Hashtable hashtable3 = new Hashtable();
                Integer n6 = this.pntCounter;
                synchronized (n6) {
                    this.pntCounter = new Integer(this.pntCounter + 1);
                }
                int n7 = this.pntCounter;
                if (this.backImage == null || bl2) {
                    Serializable serializable;
                    this.backImage = this.createImage(n2, n3);
                    displayContextImpl.graphics = this.drawTo = this.backImage.getGraphics();
                    this.lastExtent = this.getExtent();
                    this.drawTo.setColor(this.getBackground());
                    this.drawTo.fillRect(0, 0, n2, n3);
                    int n8 = 0;
                    while (n8 < n4 - n5) {
                        serializable = (Vector)vector.elementAt(n8);
                        this.paintRendererLevel((Vector)serializable, displayContextImpl, hashtable3, hashtable, hashtable2, n7);
                        ++n8;
                    }
                    if (this.isKeyMap && this.mainMap != null) {
                        serializable = this.mainMap.getLastExtent();
                        if (serializable != null) {
                            object = this.mapToScreen(new FloatPoint(((FloatRectangle)serializable).x, ((FloatRectangle)serializable).y2));
                            Point point = this.mapToScreen(new FloatPoint(((FloatRectangle)serializable).x2, ((FloatRectangle)serializable).y));
                            if (point.y - ((Point)object).y < 6) {
                                n3 = 6;
                                ((Point)object).y -= 2;
                            } else {
                                n3 = point.y - ((Point)object).y;
                            }
                            if (point.x - ((Point)object).x < 6) {
                                n2 = 6;
                                ((Point)object).x -= 2;
                            } else {
                                n2 = point.x - ((Point)object).x;
                            }
                            this.drawTo.setColor(this.project.keyMapOutline);
                            this.drawTo.drawRect(((Point)object).x, ((Point)object).y, n2, n3);
                        }
                    } else if (this.lastRectSelection != null) {
                        serializable = this.mapToScreen(new FloatPoint(this.lastRectSelection.x, this.lastRectSelection.y));
                        Point point = this.mapToScreen(new FloatPoint(this.lastRectSelection.x2, this.lastRectSelection.y2));
                        this.drawTo.setColor(Color.red);
                        this.drawTo.drawRect(((Point)serializable).x, point.y, point.x - ((Point)serializable).x, ((Point)serializable).y - point.y);
                    } else if (this.lastPointSelection != null) {
                        serializable = this.mapToScreen(this.lastPointSelection);
                        this.drawTo.setColor(Color.red);
                        this.drawTo.drawOval(((Point)serializable).x - 3, ((Point)serializable).y - 3, 6, 6);
                    }
                    this.drawTo.dispose();
                }
                Image image = this.createImage(dimension.width, dimension.height);
                this.drawTo = image.getGraphics();
                if (this.backImage != null) {
                    this.drawTo.drawImage(this.backImage, 0, 0, null);
                }
                displayContextImpl.graphics = this.drawTo;
                int n9 = n4 - n5;
                while (n9 < n4) {
                    object = (Vector)vector.elementAt(n9);
                    this.paintRendererLevel((Vector)object, displayContextImpl, hashtable3, hashtable, hashtable2, n7);
                    ++n9;
                }
                if (!this.isKeyMap && !this.isKilled) {
                    this.drawTo.setFont(MapUtils.defaultPlainFont);
                    object = "v0.99n";
                    int n10 = n2 - graphics.getFontMetrics().stringWidth((String)object);
                    this.drawTo.setColor(Color.white);
                    this.drawTo.drawString((String)object, n10 + 1, n3 - 5);
                    this.drawTo.setColor(Color.black);
                    this.drawTo.drawString((String)object, n10, n3 - 6);
                }
                this.drawTo.dispose();
                graphics.drawImage(image, 0, 0, null);
                image.flush();
                if (graphics == null || this.isKeyMap || this.isKilled) continue;
                int n11 = this.mapListeners.size();
                int n12 = 0;
                while (n12 < n11) {
                    ((CarteListener)this.mapListeners.elementAt(n12)).afterMapDraw(graphics);
                    ++n12;
                }
            } while (this.repaintNeeded);
            Object var24_30 = null;
            this.paintLock.unlock();
        }
        catch (Throwable throwable) {
            Object var24_31 = null;
            this.paintLock.unlock();
            throw throwable;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        if (dimension.width > 0 && dimension.height > 0) {
            Object object;
            boolean bl = true;
            boolean bl2 = true;
            int n = this.project != null ? this.project.getLayerCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                object = this.project.getLayerByIndex(n2);
                if (((Layer)object).isVisible()) {
                    bl2 = false;
                }
                if (!((Layer)object).isEmpty()) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                if (!this.isKeyMap) {
                    object = this.getResource(bl2 ? "Switch on layers to view map" : "Wait please...");
                    graphics.setColor(Color.white);
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                    graphics.setFont(waitFont);
                    graphics.setColor(Color.black);
                    graphics.drawString((String)object, dimension.width / 2 - graphics.getFontMetrics().stringWidth((String)object) / 2, dimension.height / 2 + 12);
                }
            } else {
                this.paintMap(graphics, false);
            }
            if (graphics != null && !this.isKeyMap && !this.isKilled) {
                int n3 = this.mapListeners.size();
                int n4 = 0;
                while (n4 < n3) {
                    ((CarteListener)this.mapListeners.elementAt(n4)).afterMapDraw(graphics);
                    ++n4;
                }
            }
        }
    }

    public FloatPoint screenToMap(Point point) {
        if (this.projection == null || this.projection.zoom <= 0.0) {
            return null;
        }
        return new FloatPoint((double)point.x / this.projection.zoom - this.projection.shift.x, -((double)point.y / this.projection.zoom - this.projection.shift.y));
    }

    public Point mapToScreen(FloatPoint floatPoint) {
        if (this.projection == null) {
            return null;
        }
        return new Point((int)((floatPoint.x + this.projection.shift.x) * this.projection.zoom), (int)((-floatPoint.y + this.projection.shift.y) * this.projection.zoom));
    }

    public Point mapToScreen_(double d, double d2) {
        if (this.projection == null) {
            return null;
        }
        return new Point((int)((d + this.projection.shift.x) * this.projection.zoom), (int)((-d2 + this.projection.shift.y) * this.projection.zoom));
    }

    public void zoomToLayer(Layer layer) {
        if (layer != null) {
            FloatRectangle floatRectangle;
            FloatRectangle floatRectangle2 = floatRectangle = layer.isLoadComplete() && layer.getLayerExtent() != null ? layer.getLayerExtent() : layer.metadata.maxExtent;
            if (floatRectangle != null && !floatRectangle.isZero()) {
                this.zoomToExtent(floatRectangle);
                this.broadcastMessage(100, layer.getName());
                this.updateMap();
            }
        }
    }

    public Layer getLayer(String string) {
        return this.project.getLayerByName(string);
    }

    public void setExtent(FloatRectangle floatRectangle, FloatPoint floatPoint) {
        this.setExtent(floatRectangle, floatPoint, null);
        this.storeExtent();
    }

    private void setExtent(FloatRectangle floatRectangle, FloatPoint floatPoint, FloatPoint floatPoint2) {
        this.calcProjection(floatRectangle, floatPoint, floatPoint2);
        this.extentChanged();
        if (!this.isKeyMap && !Strings.isNullOrBlank(this.sDependent_Maps)) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.sDependent_Maps, " ,;");
            ++this.ext_changing;
            while (stringTokenizer.hasMoreTokens()) {
                Carte carte = this.host.getMapByName(stringTokenizer.nextToken());
                if (carte == null) continue;
                carte.setExtentDependent(this.getExtent(), this.ext_changing);
            }
        }
    }

    void setExtentDependent(FloatRectangle floatRectangle, long l) {
        if (this.ext_changing != l) {
            this.setExtent(floatRectangle, null);
            this.updateMap();
        }
    }

    private void calcProjection(FloatRectangle floatRectangle, FloatPoint floatPoint, FloatPoint floatPoint2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        if (this.projection != null) {
            d8 = this.projection.shift.x;
            d7 = this.projection.shift.y;
            d6 = this.projection.zoom;
            d5 = this.projection.minzoom;
            d4 = this.projection.maxzoom;
            d3 = d6;
        } else {
            d8 = 0.0;
            d7 = 0.0;
            d6 = 1.0;
            d5 = 1.0;
            d4 = 1.0;
            d3 = -1.0;
        }
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        boolean bl = true;
        boolean bl2 = true;
        if (floatPoint2 != null) {
            if (this.projection == null) {
                return;
            }
            d8 = floatPoint2.x;
            d7 = -floatPoint2.y;
            floatRectangle = new FloatRectangle(-d8, d7 - (double)n2 / d6, (double)n / d6 - d8, d7);
        } else if (floatRectangle == null) {
            if (this.projection == null || floatPoint == null) {
                return;
            }
            d2 = (double)n / d6 / 2.0;
            d = (double)n2 / d6 / 2.0;
            floatRectangle = new FloatRectangle(floatPoint.x - d2, floatPoint.y - d, floatPoint.x + d2, floatPoint.y + d);
        } else {
            if (this.project.maxExtent == null || this.project.maxExtent.isZero()) {
                if (this.loadedExtent == null) {
                    return;
                }
                this.project.maxExtent = new FloatRectangle(this.loadedExtent);
            }
            if (this.project.MapUnits == -1) {
                int n3 = this.project.MapUnits = Math.abs(this.project.maxExtent.x2) < 361.0 && Math.abs(this.project.maxExtent.x) < 361.0 && Math.abs(this.project.maxExtent.y) < 140.0 && Math.abs(this.project.maxExtent.y2) < 140.0 ? 0 : 1;
            }
            if (this.project.zmax < 0.0) {
                d2 = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x);
                d = Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y);
                this.project.zmax = d > d2 && d2 > 0.0 ? this.getDistance(this.project.maxExtent.scale(d / d2)) : this.getDistance(this.project.maxExtent);
            }
            if (this.project.zmin < 1.0E-4) {
                this.project.zmin = this.getDistance(this.project.maxExtent) / 600.0;
            }
            d2 = Math.abs(floatRectangle.x2 - floatRectangle.x);
            d = Math.abs(floatRectangle.y2 - floatRectangle.y);
            double d9 = MapUtils.toMapUnits(this.project.zmax, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
            double d10 = MapUtils.toMapUnits(this.project.zmin, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
            d5 = (double)n / d10;
            d4 = (double)n / d9;
            if (this.project.zmax > 0.0 && d2 > d9) {
                d6 = d4;
            } else if (this.project.zmin > 0.0 && d2 < d10) {
                d6 = d5;
            } else {
                d9 = d2 > Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x) ? Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x) : d2;
                d10 = d > Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y) ? Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y) : d;
                d9 = (double)n / d9;
                d10 = (double)n2 / d10;
                double d11 = d6 = d9 > d10 ? d10 : d9;
            }
            if (floatPoint != null) {
                floatRectangle.x = floatPoint.x - (d2 /= 2.0);
                floatRectangle.y = floatPoint.y - (d /= 2.0);
                floatRectangle.x2 = floatPoint.x + d2;
                floatRectangle.y2 = floatPoint.y + d;
            }
        }
        if (!this.moveBeyondProject && !this.project.maxExtent.isZero()) {
            double d12 = this.project.maxExtent.x;
            double d13 = this.project.maxExtent.y;
            double d14 = this.project.maxExtent.x2;
            double d15 = this.project.maxExtent.y2;
            double d16 = d14 - d12;
            double d17 = d15 - d13;
            d2 = floatRectangle.x2 - floatRectangle.x;
            d = floatRectangle.y2 - floatRectangle.y;
            if (d16 < d2) {
                floatRectangle.x = (d12 + d14 - d2) / 2.0;
                floatRectangle.x2 = floatRectangle.x + d2;
            } else if (floatRectangle.x < d12) {
                floatRectangle.x = d12;
                floatRectangle.x2 = d12 + d2;
            } else if (floatRectangle.x2 > d14) {
                floatRectangle.x2 = d14;
                floatRectangle.x = d14 - d2;
            } else {
                bl = false;
            }
            if (d17 < d) {
                floatRectangle.y = (d13 + d15 - d) / 2.0;
                floatRectangle.y2 = floatRectangle.y + d;
            } else if (floatRectangle.y < d13) {
                floatRectangle.y = d13;
                floatRectangle.y2 = d13 + d;
            } else if (floatRectangle.y2 > d15) {
                floatRectangle.y2 = d15;
                floatRectangle.y = d15 - d;
            } else {
                bl2 = false;
            }
        }
        if (floatPoint2 == null || bl) {
            d8 = ((double)n / d6 - (floatRectangle.x2 - floatRectangle.x)) / 2.0 - floatRectangle.x;
        }
        if (floatPoint2 == null || bl2) {
            d7 = floatRectangle.y2 + ((double)n2 / d6 - (floatRectangle.y2 - floatRectangle.y)) / 2.0;
        }
        if (this.projection == null) {
            this.projection = new Projection();
        }
        Projection projection = this.projection;
        synchronized (projection) {
            this.projection.zoom = d6;
            this.projection.shift.x = d8;
            this.projection.shift.y = d7;
            this.projection.minzoom = d5;
            this.projection.maxzoom = d4;
            d6 = this.getDistance(this.getExtent());
        }
        if (d6 != d3) {
            this.broadcastMessage(109, new Float(d6));
        }
    }

    public void addExtent(FloatRectangle floatRectangle) {
        if (floatRectangle != null) {
            if (this.loadedExtent == null || this.loadedExtent.isZero()) {
                this.loadedExtent = floatRectangle;
            } else {
                FloatRectangle floatRectangle2 = this.loadedExtent;
                synchronized (floatRectangle2) {
                    this.loadedExtent = this.loadedExtent.union(floatRectangle);
                }
            }
        }
    }

    private void drawSelectRect(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.mouseDownPoint.x > this.currentPoint.x) {
            n4 = this.currentPoint.x;
            n3 = this.mouseDownPoint.x;
        } else {
            n3 = this.currentPoint.x;
            n4 = this.mouseDownPoint.x;
        }
        if (this.mouseDownPoint.y > this.currentPoint.y) {
            n2 = this.currentPoint.y;
            n = this.mouseDownPoint.y;
        } else {
            n = this.currentPoint.y;
            n2 = this.mouseDownPoint.y;
        }
        graphics.drawRect(n4, n2, n3 - n4 + 1, n - n2 + 1);
    }

    public void zoomToExtent(FloatRectangle floatRectangle) {
        if (floatRectangle.isZero()) {
            this.zoomToFullExtent();
        } else {
            this.setExtent(floatRectangle, null);
        }
    }

    public synchronized void zoomToFullExtent() {
        if (this.loadedExtent != null) {
            this.setExtent(this.loadedExtent, null);
        }
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public void setActiveLayer(Layer layer) {
        if (!(layer == null || this.activeLayer == layer && layer.isPassResolved())) {
            this.clearSelection();
            this.activeLayer = layer;
            String string = this.activeLayer == null ? "" : this.activeLayer.getName();
            this.broadcastMessage(107, string);
        }
    }

    public void clearSelection() {
        int n = this.project.getLayerCount();
        int n2 = 0;
        while (n2 < n) {
            this.project.getLayerByIndex(n2).setSelection(null);
            ++n2;
        }
    }

    public void setThematicMap(String string) {
        if (string == null || this.project == null || this.project.themes == null) {
            return;
        }
        String string2 = (String)this.project.themes.get(string);
        if (string2 != null) {
            this.thematicMap = string2;
            this.extentChanged();
            Layer layer = this.project.getLayerById((String)this.project.themesLayer.get(string));
            this.setActiveLayer(layer);
        } else if (this.thematicMap == null && this.project.themesNames != null) {
            this.thematicMap = (String)this.project.themes.get(this.project.themesNames);
        }
        if (this.thematicMap != null) {
            this.broadcastMessage(106, string);
        }
    }

    public void zoomToDomain(String string) {
        if (string == null || this.project == null || this.project.domains == null) {
            return;
        }
        try {
            Domain domain = (Domain)this.project.domains.get(string);
            this.zoomToExtent(domain.ext);
            Layer layer = this.project.getLayerById(domain.layerId);
            this.setActiveLayer(layer);
            this.broadcastMessage(102, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte getTool() {
        return this.currentTool;
    }

    public void setTool(byte by) {
        this.currentTool = by;
        this.setCursor(by);
        this.broadcastMessage(112, new Byte(by));
    }

    void setCursor(int n) {
        Cursor cursor;
        if (this.customCursors != null && (cursor = (Cursor)this.customCursors.get(String.valueOf(n))) != null) {
            this.setCursor(cursor);
            return;
        }
        switch (n) {
            case 2: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        switch (n) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        switch (n) {
            case 503: {
                this.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n = componentEvent.getID();
        switch (n) {
            case 101: {
                this.componentResized(componentEvent);
            }
        }
    }

    public void centerAt(double d, double d2) {
        if (this.project != null && this.projection != null && this.project.maxExtent != null) {
            double d3 = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x);
            double d4 = d3 / 10.0;
            FloatRectangle floatRectangle = new FloatRectangle(d - d4, d2 - d4, d + d4, d2 + d4);
            this.setExtent(floatRectangle, null);
            this.updateMap();
        }
    }

    public void selectObject(Layer layer, Record record) {
        if (record != null) {
            Vector<Record> vector = new Vector<Record>();
            vector.addElement(record);
            this.selectObject(layer, vector);
        }
    }

    public void selectObjectByExpr(Layer layer, String string) {
        try {
            Vector vector = layer.selectObjectsByExpr(string);
            if (vector != null) {
                System.out.print(".");
                this.selectObject(layer, vector);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void selectObject(Layer layer, Vector vector) {
        int n;
        if (layer instanceof LayerRaster) {
            return;
        }
        if (vector != null && (n = vector.size()) > 0) {
            int n2;
            Object object;
            layer.setSelection(new Vector());
            XmlUtils.addAll(layer.getSelection(), vector);
            FloatRectangle floatRectangle = layer.getSelectionExtent();
            Record record = (Record)vector.elementAt(0);
            if (floatRectangle.x2 == floatRectangle.x) {
                object = this.getLastExtent();
                double d = Math.abs(((FloatRectangle)object).x2 - ((FloatRectangle)object).x) / 100.0;
                floatRectangle.x2 += d;
                floatRectangle.x -= d;
            }
            if (layer.zoom_for_select < 0.0f) {
                this.setExtent(null, new FloatPoint(floatRectangle.x + (floatRectangle.x2 - floatRectangle.x) / 2.0, floatRectangle.y + (floatRectangle.y2 - floatRectangle.y) / 2.0));
            } else {
                double d;
                if (layer.zoom_for_select > 0.0f) {
                    d = MapUtils.toMapUnits(layer.zoom_for_select, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
                    floatRectangle = floatRectangle.scale((d + d / 100.0) / Math.abs(floatRectangle.x2 - floatRectangle.x));
                } else {
                    double d2;
                    double d3;
                    double d4 = MapUtils.toMapUnits(this.project.zmin, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
                    d4 = d4 < (d3 = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x)) / 10.0 ? d3 / 10.0 : (d4 *= 10.0);
                    floatRectangle = n == 1 && ((LayerVector)layer).objectType == 1 ? new FloatRectangle(record.centroid.x - d4, record.centroid.y - d4, record.centroid.x + d4, record.centroid.y + d4) : floatRectangle.scale(2.0);
                    d = d3;
                    if (layer.withinZoom) {
                        double d5;
                        if (layer.zmin > 0.0f && d4 < (d5 = MapUtils.toMapUnits(layer.zmin, floatRectangle, this.project.MapUnits, this.project.ZoomUnits))) {
                            d4 = d5;
                        }
                        if (layer.zmax > 0.0f) {
                            d = MapUtils.toMapUnits(layer.zmax, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
                        }
                    }
                    if ((d2 = Math.abs(floatRectangle.x2 - floatRectangle.x)) > d) {
                        floatRectangle = floatRectangle.scale(d / d2);
                    }
                    if (d2 < d4) {
                        floatRectangle = floatRectangle.scale((d4 + d4 / 100.0) / d2);
                    }
                }
                floatRectangle.y += (floatRectangle.y2 - floatRectangle.y) / 2.0;
                floatRectangle.y2 = floatRectangle.y;
                this.setExtent(floatRectangle, null);
            }
            object = " [" + layer.getName() + ']';
            if (n == 1) {
                object = (layer.fi_description >= 0 && layer.fi_description < layer.getFieldCount() ? layer.getFieldString(record, layer.fi_description) : record.getId()) + (String)object;
                n2 = 103;
            } else {
                object = n + (String)object;
                n2 = 104;
            }
            this.activeLayer = layer;
            this.broadcastMessage(n2, object);
            this.updateMap();
        }
    }

    public void selectObject(String string, String string2) {
        try {
            Layer layer = this.project.getLayerByName(string);
            if (layer == null && (layer = this.project.getLayerById(string)) == null) {
                layer = this.project.getLayerByDsId(string);
            }
            if (layer != null && layer instanceof LayerVector) {
                Vector<Record> vector = new Vector<Record>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    Record record = ((LayerVector)layer).findById(string3);
                    if (record == null) continue;
                    vector.addElement(record);
                }
                if (vector.size() > 0) {
                    this.selectObject(layer, vector);
                } else {
                    this.request.setQuery(2, layer.id, string2);
                    this.startServiceThread();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FloatRectangle getFullExtent() {
        return new FloatRectangle(this.loadedExtent);
    }

    synchronized void storeExtent() {
        int n = 0;
        while (n < this.undoIndex) {
            this.recentExtents.removeElementAt(0);
            ++n;
        }
        this.recentExtents.insertElementAt(this.getExtent(), 0);
        n = this.recentExtents.size();
        if (n > 20) {
            this.recentExtents.removeElementAt(n - 1);
        }
        this.undoIndex = 0;
    }

    public void undoExtent() {
        if (this.doUndoExtent()) {
            this.updateMap();
        }
    }

    public void redoExtent() {
        if (this.doRedoExtent()) {
            this.updateMap();
        }
    }

    synchronized boolean doUndoExtent() {
        if (this.undoIndex < this.recentExtents.size() - 1) {
            this.setExtent((FloatRectangle)this.recentExtents.elementAt(++this.undoIndex), null, null);
            return true;
        }
        return false;
    }

    synchronized boolean doRedoExtent() {
        if (this.undoIndex > 0) {
            this.setExtent((FloatRectangle)this.recentExtents.elementAt(--this.undoIndex), null, null);
            return true;
        }
        return false;
    }

    public void showAttribForSelection(String string, int n, FloatRectangle floatRectangle) {
        Vector vector;
        Layer layer;
        if (!this.isProjectLoaded()) {
            return;
        }
        Layer layer2 = layer = string == null ? this.getActiveLayer() : this.project.getLayerById(string);
        if (layer != null && MapUtils.isNotEmpty(vector = layer.getSelection())) {
            this.request.clear();
            this.request.setSpatialExtent(floatRectangle, null);
            this.request.setQuery(n, layer.id, null);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public void executeRequest(int n) {
        if (!this.stopped) {
            this.request.setQuery(33, null, String.valueOf(n));
            this.startServiceThread();
        }
    }

    public void searchAttribute(String string, String string2, int n) {
        if ((n == 1 || n == 2 || n == 3 || n == 4) && string2 != null && string2.length() > 0 && this.isProjectLoaded()) {
            if (string == null) {
                string = this.activeLayer.id;
            }
            if (n == 2 && string2 != null) {
                string2 = '%' + string2 + '%';
            }
            int n2 = n == 3 ? 34 : (n == 4 ? 35 : 32);
            this.request.clear();
            this.request.setQuery(n2, string, string2);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public void searchRectangle(FloatRectangle floatRectangle) {
        if (this.activeLayer != null) {
            this.request.clear();
            this.request.setSpatialExtent(floatRectangle, null);
            this.request.setQuery(31, this.activeLayer.id, null);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public void showURL(String string) {
        if (string != null && string.length() > 0) {
            this.host.showURL(string, "");
        }
    }

    public FloatRectangle getExtent() {
        if (this.projection == null) {
            return null;
        }
        FloatRectangle floatRectangle = new FloatRectangle();
        FloatPoint floatPoint = this.screenToMap(new Point(0, 0));
        if (floatPoint == null) {
            return null;
        }
        floatRectangle.x = floatPoint.x;
        floatRectangle.y2 = floatPoint.y;
        Dimension dimension = this.getSize();
        floatPoint = this.screenToMap(new Point(dimension.width - 1, dimension.height - 1));
        floatRectangle.x2 = floatPoint.x;
        floatRectangle.y = floatPoint.y;
        return floatRectangle;
    }

    public void requestSelection(FloatRectangle floatRectangle) {
        Serializable serializable;
        this.pmSelection.removeAll();
        String string = null;
        int n = this.project.getLayerCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            serializable = this.project.getLayerByIndex(n3);
            Vector vector = ((Layer)serializable).getSelection();
            int n4 = n2 = vector == null || serializable instanceof LayerRaster && ((Layer)serializable).linkMain == null ? 0 : vector.size();
            if (n2 > 0) {
                MenuItem menuItem = new MenuItem(((Layer)serializable).getName() + " [" + n2 + ']', null);
                menuItem.setActionCommand(((Layer)serializable).id);
                this.pmSelection.add(menuItem);
                string = ((Layer)serializable).id;
            }
            ++n3;
        }
        if (this.pmSelection.getItemCount() > 1) {
            serializable = null != floatRectangle ? this.mapToScreen(new FloatPoint(floatRectangle.x2, floatRectangle.y)) : new Point(this.getBounds().width / 2, this.getBounds().height / 2);
            this.pmSelection.show(this, ((Point)serializable).x, ((Point)serializable).y);
        } else if (this.pmSelection.getItemCount() == 1) {
            this.showAttribForSelection(string, 31, floatRectangle);
        }
    }

    void mouseMoved(MouseEvent mouseEvent) {
        if (this.isKilled) {
            return;
        }
        int n = this.mapListeners.size();
        int n2 = 0;
        while (n2 < n) {
            ((CarteListener)this.mapListeners.elementAt(n2)).mouseMapMoved(mouseEvent);
            ++n2;
        }
    }

    void mouseDragged(MouseEvent mouseEvent) {
        if (this.loadedExtent == null || this.projection == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                switch (this.currentTool) {
                    case 4: {
                        if (this.mouseDownPoint == null) break;
                        Point point = mouseEvent.getPoint();
                        int n = point.x - this.mouseDownPoint.x;
                        int n2 = point.y - this.mouseDownPoint.y;
                        Dimension dimension = this.getSize();
                        int n3 = dimension.width;
                        int n4 = dimension.height;
                        graphics.setColor(this.getBackground());
                        if (n > 0) {
                            graphics.fillRect(0, 0, n, n4);
                        } else if (n < 0) {
                            graphics.fillRect(n3 + n, 0, -n, n4);
                        }
                        if (n2 > 0) {
                            graphics.fillRect(0, 0, n3, n2);
                        } else if (n2 < 0) {
                            graphics.fillRect(0, n4 + n2, n3, -n2);
                        }
                        graphics.drawImage(this.backImage, n, n2, null);
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (this.mouseDownPoint == null) break;
                        graphics.setColor(Color.black);
                        graphics.setXORMode(Color.white);
                        this.drawSelectRect(graphics);
                        this.currentPoint = mouseEvent.getPoint();
                        this.drawSelectRect(graphics);
                        graphics.setXORMode(Color.black);
                        break;
                    }
                    default: {
                        int n = this.mapListeners.size();
                        int n5 = 0;
                        while (n5 < n) {
                            ((CarteListener)this.mapListeners.elementAt(n5)).mouseMapMoved(mouseEvent);
                            ++n5;
                        }
                        break block1;
                    }
                }
                Object var10_11 = null;
                graphics.dispose();
                graphics = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                graphics.dispose();
                graphics = null;
                throw throwable;
            }
        }
    }

    void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.lastSelectExt = null;
        if (this.projection == null || this.isKilled) {
            return;
        }
        if (this.loadedExtent == null) {
            this.dontRedraw = false;
            return;
        }
        if (this.getTool() < 50) {
            n = mouseEvent.getModifiers();
            this.alterTool = this.getTool();
            if ((n & 4) != 0 || (n & 8) != 0) {
                if ((n & 1) != 0) {
                    this.setTool((byte)3);
                } else {
                    this.setTool((byte)4);
                }
            } else if ((n & 0x10) != 0) {
                if ((n & 1) != 0) {
                    this.setTool((byte)2);
                } else if ((n & 2) != 0) {
                    this.setTool((byte)6);
                }
            }
        }
        n = this.mapListeners.size();
        int n2 = 0;
        while (n2 < n) {
            ((CarteListener)this.mapListeners.elementAt(n2)).mouseMapPressed(mouseEvent);
            ++n2;
        }
        this.mouseDownPoint = mouseEvent.getPoint();
        this.currentPoint = new Point(this.mouseDownPoint);
        switch (this.currentTool) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.lastPointSelection = null;
                this.lastRectSelection = null;
            }
            case 2: {
                this.dontRedraw = true;
                Graphics graphics = this.getGraphics();
                if (graphics == null) break;
                try {
                    graphics.setXORMode(Color.white);
                    this.drawSelectRect(graphics);
                    graphics.setXORMode(Color.black);
                    Object var8_6 = null;
                    graphics.dispose();
                    break;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            case 4: {
                if (this.backImage == null) {
                    Dimension dimension = this.getSize();
                    this.backImage = this.createImage(dimension.width, dimension.height);
                    Graphics graphics = this.backImage.getGraphics();
                    try {
                        this.paint(graphics);
                        Object var10_10 = null;
                        graphics.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        graphics.dispose();
                        throw throwable;
                    }
                }
                this.dontRedraw = true;
                break;
            }
            case 1: {
                FloatPoint floatPoint = this.screenToMap(mouseEvent.getPoint());
                this.setExtent(null, floatPoint);
                this.updateMap();
                break;
            }
            case 3: {
                FloatPoint floatPoint = this.screenToMap(mouseEvent.getPoint());
                this.setExtent(this.getExtent().scale(2.0), floatPoint);
                this.updateMap();
            }
        }
    }

    void mouseReleased(MouseEvent mouseEvent) {
        FloatPoint floatPoint;
        Serializable serializable;
        if (this.projection == null || this.isKilled) {
            return;
        }
        FloatRectangle floatRectangle = null;
        this.dontRedraw = false;
        if (this.loadedExtent != null && this.mouseDownPoint != null) {
            Object object;
            double d;
            double d2;
            double d3;
            double d4;
            boolean bl;
            floatRectangle = new FloatRectangle();
            this.currentPoint = mouseEvent.getPoint();
            if (this.currentTool == 9 || Math.abs(this.mouseDownPoint.x - this.currentPoint.x) < 6 && Math.abs(this.mouseDownPoint.y - this.currentPoint.y) < 6) {
                bl = true;
                this.currentPoint = new Point(this.currentPoint.x + 3, this.currentPoint.y + 3);
                this.mouseDownPoint = new Point(this.currentPoint.x - 3, this.currentPoint.y - 3);
            } else {
                bl = false;
            }
            serializable = this.screenToMap(this.mouseDownPoint);
            floatPoint = this.screenToMap(this.currentPoint);
            if (serializable.x < floatPoint.x) {
                d4 = serializable.x;
                d3 = floatPoint.x;
            } else {
                d4 = floatPoint.x;
                d3 = serializable.x;
            }
            if (serializable.y < floatPoint.y) {
                d2 = serializable.y;
                d = floatPoint.y;
            } else {
                d2 = floatPoint.y;
                d = serializable.y;
            }
            floatRectangle.x = d4;
            floatRectangle.y = d2;
            floatRectangle.x2 = d3;
            floatRectangle.y2 = d;
            if (this.currentTool == 4) {
                object = mouseEvent.getPoint();
                int n = ((Point)object).x - this.mouseDownPoint.x;
                int n2 = ((Point)object).y - this.mouseDownPoint.y;
                if (n != 0 || n2 != 0) {
                    FloatPoint floatPoint2 = this.screenToMap(new Point(-n, -n2));
                    floatPoint2.x = -floatPoint2.x;
                    floatPoint2.y = -floatPoint2.y;
                    this.setExtent(null, null, floatPoint2);
                    this.storeExtent();
                    this.updateMap();
                }
            } else if (this.currentTool != 3 && this.currentTool != 1 && this.currentTool < 50) {
                Layer layer;
                object = this.getGraphics();
                if (object != null) {
                    try {
                        ((Graphics)object).setColor(Color.black);
                        ((Graphics)object).setXORMode(Color.white);
                        this.drawSelectRect((Graphics)object);
                        ((Graphics)object).setXORMode(Color.black);
                        layer = null;
                        ((Graphics)object).dispose();
                    }
                    catch (Throwable throwable) {
                        Object var19_18 = null;
                        ((Graphics)object).dispose();
                        throw throwable;
                    }
                }
                switch (this.currentTool) {
                    case 8: 
                    case 9: {
                        if (bl || this.currentTool == 9) {
                            this.lastPointSelection = this.screenToMap(mouseEvent.getPoint());
                            this.lastRectSelection = null;
                        } else {
                            this.lastRectSelection = floatRectangle;
                            this.lastPointSelection = null;
                        }
                        this.updateMap();
                        break;
                    }
                    case 2: {
                        if (!bl) {
                            this.setExtent(floatRectangle, null);
                        } else {
                            FloatPoint floatPoint3 = this.screenToMap(this.mouseDownPoint);
                            this.setExtent(this.getExtent().scale(0.5), floatPoint3);
                        }
                        this.updateMap();
                        break;
                    }
                    case 7: {
                        this.searchRectangle(floatRectangle);
                        break;
                    }
                    case 5: 
                    case 6: {
                        floatRectangle = floatRectangle.intersection(this.getExtent());
                        int n = mouseEvent.getModifiers();
                        if ((n & 2) == 0) {
                            this.clearSelection();
                        }
                        layer = null;
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        String string = null;
                        int n6 = this.project.getLayerCount();
                        this.lastSelectExt = floatRectangle;
                        int n7 = 0;
                        while (n7 < n6) {
                            layer = this.project.getLayerByIndex(n7);
                            if (layer.isVisibleNow(this) && layer.canSearch) {
                                Vector vector = layer.filterRecords(layer.findWithinRect(floatRectangle, false), true);
                                if (layer.getSelection() == null && vector != null) {
                                    layer.setSelection(new Vector());
                                }
                                XmlUtils.addAll(layer.getSelection(), vector);
                                if (layer.getSelection() != null && (n3 = layer.getSelection().size()) > 0) {
                                    ++n5;
                                    string = layer.id;
                                    if (this.activeLayer == layer) {
                                        n4 = n3;
                                    }
                                }
                            }
                            ++n7;
                        }
                        int n8 = 14;
                        String string2 = "";
                        if (n4 > 0) {
                            string2 = " [" + this.activeLayer.getName() + ']';
                            if (n4 == 1) {
                                Record record = (Record)this.activeLayer.getSelection().elementAt(0);
                                string2 = string2 + this.activeLayer.getFieldString(record, this.activeLayer.fi_description);
                                n8 = 103;
                            } else {
                                n8 = 104;
                                string2 = n4 + string2;
                            }
                        }
                        this.broadcastMessage(n8, string2);
                        this.updateMap();
                        if (this.currentTool != 6) break;
                        if (this.isMultiSelectionMode && n5 == 1) {
                            this.showAttribForSelection(string, 31, floatRectangle);
                            break;
                        }
                        if (!this.isMultiSelectionMode && n4 > 0) {
                            this.showAttribForSelection(this.activeLayer.id, 31, floatRectangle);
                            break;
                        }
                        if (!this.isMultiSelectionMode) break;
                        this.requestSelection(floatRectangle);
                    }
                }
            }
        }
        if (this.currentTool < 50) {
            this.setTool(this.alterTool);
        }
        if (this.isKeyMap && floatRectangle != null && this.mainMap != null) {
            Point point = this.mapToScreen(new FloatPoint(floatRectangle.x, floatRectangle.y2));
            serializable = this.mapToScreen(new FloatPoint(floatRectangle.x2, floatRectangle.y));
            if (point != null && serializable != null) {
                if (((Point)serializable).y - point.y < 6 || ((Point)serializable).x - point.x < 6) {
                    floatPoint = new FloatPoint(floatRectangle.x, floatRectangle.y2);
                    this.mainMap.setExtent(this.mainMap.getExtent(), floatPoint);
                } else {
                    this.mainMap.setExtent(floatRectangle, null);
                }
                this.mainMap.updateMap();
            }
        }
        int n = this.mapListeners.size();
        int n9 = 0;
        while (n9 < n) {
            ((CarteListener)this.mapListeners.elementAt(n9)).mouseMapReleased(floatRectangle, mouseEvent);
            ++n9;
        }
        this.mouseDownPoint = null;
        this.currentPoint = null;
    }

    public String getResource(String string) {
        String string2 = this.getResource_(string);
        return Strings.isNullOrBlank(string2) ? string : string2;
    }

    public String getResource_(String string) {
        if (this.stringResources == null || string == null) {
            return "";
        }
        String string2 = this.stringResources.getProperty(string.toLowerCase());
        return string2 == null ? "" : string2;
    }

    void componentResized(ComponentEvent componentEvent) {
        if (this.projection == null) {
            return;
        }
        if (this.lastExtent != null) {
            this.setExtent(this.lastExtent, null);
        } else {
            this.extentChanged();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.updateMap();
            return false;
        }
        return true;
    }

    public String getThematicMapName() {
        if (this.project != null) {
            Enumeration enumeration = this.project.themes.keys();
            Enumeration enumeration2 = this.project.themes.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!((String)enumeration2.nextElement()).equals(this.thematicMap)) continue;
                return string;
            }
        }
        return "";
    }

    public Graphics getDrawToGraphics() {
        return this.drawTo;
    }

    public String getThematicMap() {
        return this.thematicMap;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public FloatRectangle getLastExtent() {
        return this.lastExtent;
    }

    public Vector getUsedSpaces() {
        return this.usedSpaces;
    }

    public double getDistance(FloatRectangle floatRectangle) {
        if (floatRectangle == null) {
            floatRectangle = this.getExtent();
        }
        return MapUtils.getDistance(floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
    }

    public Component getComponent() {
        return this;
    }

    public String getRealPath(String string) {
        return MapUtils.getRealPath(string);
    }

    public void broadcastMessage(int n, Object object) {
        if (this.isKilled) {
            return;
        }
        int n2 = this.statusListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            ((StatusListener)this.statusListeners.elementAt(n3)).notifyStatus(n, object);
            ++n3;
        }
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public boolean isStopPaint(int n) {
        return this.isKilled || this.pntCounter > n;
    }

    public String getParameter(String string, String string2) {
        String string3 = this.parameters.getProperty(string, null);
        if (string3 == null) {
            string3 = this.host.getParameter(string, null);
            if (string3 != null) {
                ((Hashtable)this.parameters).put(string, string3);
                return string3;
            }
            return string2;
        }
        return string3;
    }

    public String getSRS() {
        return this.project.SRS;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!Strings.isNullOrBlank(string)) {
            this.showAttribForSelection(string, 31, this.lastSelectExt);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        Object object;
        Vector vector = xmlElement.getElementsByTagName("param");
        int n = 0;
        while (n < vector.size()) {
            String string;
            object = (XmlElement)vector.elementAt(n);
            String string2 = ((XmlElement)object).getAttributeValue("name");
            if (!Strings.isNullOrBlank(string2) && !Strings.isNullOrBlank(string = carteHost.getParameter(string2, ((XmlElement)object).getAttributeValue("value")))) {
                ((Hashtable)this.parameters).put(string2, string);
            }
            ++n;
        }
        this.host = carteHost;
        this.SLD_url = this.getParameter("sld", null);
        this.SLD_url = null;
        this.isKeyMap = XmlUtils.getBoolean("keymap", xmlElement, false) || "keymap".equalsIgnoreCase(XmlUtils.getString("type", xmlElement, null));
        this.isMultiSelectionMode = XmlUtils.getBoolean("multiselect", xmlElement, true);
        this.sDependent_Maps = XmlUtils.getString("dependent", xmlElement, null);
        if (!this.isKeyMap) {
            if (Utils2D.have2d()) {
                object = xmlElement.getElementsByTagName("cursor");
                int n2 = ((Vector)object).size();
                int n3 = 0;
                while (n3 < n2) {
                    XmlElement xmlElement2 = (XmlElement)((Vector)object).elementAt(n3);
                    String string = XmlUtils.getString("tool", xmlElement2, null);
                    if (string != null) {
                        String string3 = XmlUtils.getString("image", xmlElement2, null);
                        Image image = null;
                        try {
                            image = MapUtils.loadImage2(null, string3);
                            Cursor cursor = Utils2D.createCursor(image, string);
                            if (cursor != null) {
                                if (this.customCursors == null) {
                                    this.customCursors = new Hashtable();
                                }
                                this.customCursors.put(string, cursor);
                            }
                        }
                        catch (Exception exception) {
                            Log.addMessage(306, this.getName(), null, "Can't load raster image " + string3);
                        }
                    }
                    ++n3;
                }
            }
            this.proxy.setupProxy(this);
            MapUtils.isTipsActive = XmlUtils.getBoolean("tips", xmlElement, false);
            byte by = 6;
            try {
                by = Byte.parseByte(XmlUtils.getString("starttool", xmlElement, ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setTool(by);
        } else {
            this.setVisible(false);
            this.mainMap = carteHost.getMapByName(xmlElement);
            this.mainMap.statusListeners.addElement(this);
        }
    }

    public void stop() {
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        this.stopped = true;
    }

    public void openProject(String string) {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        try {
            try {
                while (this.sthRunning) {
                    Thread.sleep(300L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.project != null) {
                this.project.kill();
                this.project = null;
                System.gc();
            }
            this.isFirstRequest = true;
            this.projection = null;
            this.lastExtent = null;
            this.loadedExtent = null;
            ((Hashtable)this.parameters).put("pid", string);
            this.proxy.setupProxy(this);
            Object var4_3 = null;
            this.isKilled = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.isKilled = false;
            throw throwable;
        }
        this.start();
    }

    public void kill() {
        this.isKilled = true;
        try {
            while (this.sthRunning) {
                Thread.sleep(300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.project != null) {
            this.project.kill();
            this.project = null;
        }
        Log.kill();
        this.mapListeners = null;
        this.statusListeners = null;
        if (this.stringResources != null) {
            ((Hashtable)this.stringResources).clear();
        }
        this.stringResources = null;
        this.proxy = null;
    }

    public void afterProjectLoaded(boolean bl) {
        if (this.mainMap != null && this.mainMap.isProjectLoaded() && this.mainMap.getProject().hasKeyMap) {
            this.setVisible(true);
            this.setProject(this.mainMap.getProject());
            this.setBackground(this.project.keyMapBackground);
            this.moveBeyondProject = false;
            this.projection = new Projection();
            if (this.project.keyMapTheme != null) {
                this.thematicMap = this.project.keyMapTheme;
            } else {
                this.setThematicMap(this.project.startTheme);
            }
            this.stopped = false;
            this.setTool((byte)8);
        } else {
            this.setVisible(false);
        }
    }

    public void notifyStatus(int n, Object object) {
        if (!this.isKilled && this.isProjectLoaded() && n == 11 && object == null) {
            this.loadedExtent = this.project.maxExtent;
            this.zoomToFullExtent();
            this.updateMap();
        }
    }

    public void timerTick(SimpleTimer simpleTimer) {
        this.updateMap(true);
    }

    public void setLoadedExtent(FloatRectangle floatRectangle) {
        this.lastExtent = null;
        this.loadedExtent = floatRectangle;
        this.projection = new Projection();
    }
}

