/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.Layer;
import org.alov.util.Const;
import org.alov.util.Log;
import org.alov.util.Logger;
import org.alov.util.Strings;

public class ClientLog
implements Logger,
Const {
    private static Hashtable explanations = null;
    static final String ASTERICS = "***";
    private static final String DATE_FORMAT = "yyyy.MM.dd hh:mm:ss";
    public static boolean showMapName = false;
    private SimpleDateFormat sdf2 = new SimpleDateFormat("hh:mm:ss");
    private Vector status = new Vector();

    public void setExplanations(Hashtable hashtable) {
        explanations = hashtable;
    }

    public void init() {
    }

    public void log(int n, String string) {
        if (this.status.size() > 30) {
            this.status.removeElementAt(1);
        }
        this.status.addElement(string);
        if (Log.debugLevel > 1) {
            System.out.println(string);
        }
    }

    public void log(int n, Exception exception) {
        this.log(n, exception.getMessage());
    }

    public Vector getStatus() {
        return this.status;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.status.size()) {
            stringBuffer.append((String)this.status.elementAt(n)).append("\r\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void addStatusInfo(int n, String string, Layer layer, String string2) {
        String string3;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.status.size() == 0) {
            object = new SimpleDateFormat(DATE_FORMAT);
            stringBuffer.append(((DateFormat)object).format(new Date(System.currentTimeMillis())));
        } else {
            stringBuffer.append(this.sdf2.format(new Date(System.currentTimeMillis())));
        }
        if (!Strings.isNullOrBlank(string) && showMapName) {
            stringBuffer.append(" ").append(string);
        }
        object = "";
        if (layer != null) {
            if (!Strings.isNullOrBlank(layer.datasetId) && layer.provider == null) {
                object = "#" + layer.datasetId + ": ";
            }
            object = (String)object + layer.getName() + ". ";
        }
        stringBuffer.append("  ");
        String string4 = string3 = Strings.isNullOrBlank(string2) ? "" : string2 + ". ";
        if (n > 0) {
            String string5;
            this.log(-1, "");
            stringBuffer.append("  ").append(ASTERICS).append(" ").append("ERROR#" + n).append(" ").append(ASTERICS).append("  ").append((String)object).append(string3);
            this.log(-1, stringBuffer.toString());
            if (explanations != null && !Strings.isNullOrBlank(string5 = (String)explanations.get(String.valueOf(n)))) {
                this.log(-1, "");
                this.log(-1, string5);
            }
            this.log(-1, "");
        } else {
            stringBuffer.append("  ").append(string3).append((String)object);
            this.log(0, stringBuffer.toString());
        }
    }

    public void kill() {
        this.status.removeAllElements();
        this.status = null;
    }
}

