/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Component;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.alov.data.DataProvider;
import org.alov.data.SQLConst;
import org.alov.map.Carte;
import org.alov.map.ComplexFigure;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FilterRecords;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerGroup;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Meta;
import org.alov.map.Project;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.ExDate;
import org.alov.util.Log;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;

public abstract class Layer
implements Serializable,
TimerListener {
    transient DisplayContext parentMap = null;
    static final String FILTER_TIME = "TF";
    static final String FILTER_VALUE = "SF";
    public DataProvider provider = null;
    public boolean initiallyVisible = true;
    public int serverType = -1;
    public int objectType = 0;
    public Properties connectionData;
    public Meta metadata = new Meta();
    public Vector records = new Vector();
    private FieldDef[] fieldDefs = null;
    public int fieldCountToDownload = 0;
    FloatRectangle layerExtent = null;
    ComplexFigure loadedExtent = new ComplexFigure();
    public String id = null;
    public String datasetId = null;
    private String title;
    private boolean visible = true;
    public boolean visible_always = false;
    public boolean legendVisible = true;
    public boolean legendWrapText = false;
    public String legendName = null;
    public boolean legendHideOutRange = false;
    boolean removeOutOfExtent = false;
    public boolean legendExpanded = true;
    public Shape legendSymbolShape = null;
    public int legendObjectType = 0;
    public boolean isKeyMap = false;
    private Vector selection = null;
    public Vector renderers = new Vector();
    public boolean canSearch = true;
    public boolean withinZoom = false;
    public float zmin;
    public float zmax;
    public float zoom_for_select = 0.0f;
    public boolean withinDate = false;
    public boolean timeVarying = false;
    public ExDate timeMin;
    public ExDate timeMax;
    public int drawOrder = 0;
    public int fi_description = -1;
    public String linkMain = null;
    public String linkSearch = null;
    public String linkTips = null;
    public boolean notPrepared = true;
    public Vector themes = new Vector();
    public String style = null;
    public Vector controlledLayers = null;
    public Vector controlledLayersUnresolved = null;
    public boolean isDataOnServer;
    public boolean isFullLoad;
    public boolean zoomToExtentAfterCustomLoad = false;
    public String url;
    public Hashtable filters = new Hashtable();
    private Properties fieldAliases = null;
    protected boolean hasChart = false;
    private SimpleTimer reloadTimer;
    private static final String _LAYERNAME = "$LAYERNAME";
    private static final String _LAYERID = "$LAYERID";
    private static final String _DATASETID = "$DATASETID";
    private static final String _PASSTHR = "$PASSTHROUGH";
    private static final String _SEARCHVAL = "$SEARCH";
    private static final String _USER = "$USER";
    private static final String _BBOX_ALL = "$BBOXALL";
    private static final String _BBOX_DR = "$BBOXDR";
    private static final String _BBOX_SEL = "$BBOXSEL";
    private static final String _BBXMIN = "$BBXMIN";
    private static final String _BBXMAX = "$BBXMAX";
    private static final String _BBYMIN = "$BBYMIN";
    private static final String _BBYMAX = "$BBYMAX";
    private static final String _DRXMIN = "$DRXMIN";
    private static final String _DRXMAX = "$DRXMAX";
    private static final String _DRYMIN = "$DRYMIN";
    private static final String _DRYMAX = "$DRYMAX";
    private static final String _SELXMIN = "$SELXMIN";
    private static final String _SELXMAX = "$SELXMAX";
    private static final String _SELYMIN = "$SELYMIN";
    private static final String _SELYMAX = "$SELYMAX";
    private static final String _TSTART = "$TSTART";
    private static final String _TEND = "$TEND";
    private static final int _LOWER_CASE = 1;
    private static final int _UPPER_CASE = 2;

    public String getName() {
        return this.title;
    }

    public void setName(String string) {
        this.title = string;
    }

    public boolean isVisibleNow(DisplayContext displayContext) {
        return this.visible ? this.isOutOfRange(displayContext) == 0 && !this.isOutOfExtent(displayContext) && this.isPassResolved() && this.isTheme(displayContext) : false;
    }

    public boolean isBelongToLegend(String string) {
        return this.legendName == null || this.legendName.equalsIgnoreCase(string);
    }

    public boolean isInvisibleInLegend(DisplayContext displayContext) {
        return !this.isTheme(displayContext) || !this.legendVisible || this.metadata.loadFailed && Log.debugLevel == 0 || this.legendHideOutRange && (this.isOutOfRange(displayContext) != 0 || this.isOutOfExtent(displayContext));
    }

    public boolean isPassResolved() {
        return this.metadata.passResolved;
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        if (this.filters == null) {
            return;
        }
        Enumeration enumeration = this.filters.elements();
        while (enumeration.hasMoreElements()) {
            FilterRecords filterRecords = (FilterRecords)enumeration.nextElement();
            if (!(filterRecords instanceof FilterTime)) continue;
            ((FilterTime)filterRecords).setTimeInterval(timeInterval);
        }
    }

    public Vector filterRecords(Vector vector, boolean bl) {
        if (this.filters != null && vector != null) {
            Enumeration enumeration = this.filters.elements();
            while (enumeration.hasMoreElements() && vector != null) {
                FilterRecords filterRecords = (FilterRecords)enumeration.nextElement();
                if (!bl && !(filterRecords instanceof FilterExpression)) continue;
                vector = filterRecords.apply(vector);
            }
        }
        return vector;
    }

    public Vector getSelection() {
        return this.selection;
    }

    public void setSelection(Vector vector) {
        this.selection = vector;
    }

    public Vector getRecords() {
        return this.filterRecords(this.records, true);
    }

    public void initFields(int n) {
        this.fieldCountToDownload = n;
        if (n > 0) {
            this.fieldDefs = new FieldDef[n];
        }
    }

    public FieldDef[] getFields() {
        return this.fieldDefs;
    }

    public void assignFields(FieldDef[] fieldDefArray) {
        this.fieldDefs = fieldDefArray;
    }

    public int getFieldCount() {
        return this.fieldDefs == null ? 0 : this.fieldDefs.length;
    }

    public FieldDef getFieldDef(int n) {
        return this.fieldDefs == null ? null : this.fieldDefs[n];
    }

    public FieldDef getFieldDef_(int n) {
        return this.fieldDefs != null && n < this.fieldDefs.length && n >= 0 ? this.fieldDefs[n] : null;
    }

    public void setFieldDef(int n, FieldDef fieldDef) {
        if (n >= 0 && n < this.fieldDefs.length) {
            this.fieldDefs[n] = fieldDef;
        }
    }

    public int getFieldIndex(String string) {
        if (string != null && this.fieldDefs != null) {
            int n = this.fieldDefs.length;
            if (this.fieldAliases != null) {
                string = this.fieldAliases.getProperty(string.toLowerCase(), string);
            }
            int n2 = 0;
            while (n2 < n) {
                if (string.equalsIgnoreCase(this.fieldDefs[n2].name)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object getFieldValue(Record record, int n) {
        if (n >= 0) {
            if (n < this.fieldCountToDownload) {
                return record.getField(n);
            }
            if (n < this.fieldDefs.length) {
                FieldDef fieldDef = this.fieldDefs[n];
                if (fieldDef.field != null) {
                    return fieldDef.field.getFieldValue(record, fieldDef);
                }
            }
        }
        return null;
    }

    public String getFieldString(Record record, int n) {
        Object object = this.getFieldValue(record, n);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public double getFieldDouble(Record record, int n) {
        Object object = this.getFieldValue(record, n);
        return MapUtils.toDouble(object);
    }

    public boolean isSomethingVisible(DisplayContext displayContext) {
        if (this.isVisibleNow(displayContext) || this.isKeyMap) {
            int n = this.renderers.size();
            int n2 = 0;
            while (n2 < n) {
                Renderer renderer = (Renderer)this.renderers.elementAt(n2);
                if (renderer.isVisible(displayContext)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isTheme(DisplayContext displayContext) {
        String string = this.style;
        if (this.style == null) {
            if (displayContext == null || this.themes == null) {
                return true;
            }
            string = displayContext.getThematicMap();
        }
        return this.themes == null || this.themes.size() == 0 || string == null || this.themes.indexOf(string) >= 0;
    }

    public int isOutOfRange(DisplayContext displayContext) {
        TimeInterval timeInterval;
        int n = 0;
        if (this.withinZoom && displayContext != null) {
            double d = displayContext.getDistance(displayContext.getLastExtent());
            int n2 = this.zmin > 0.0f && (double)this.zmin > d ? -1 : (n = this.zmax > 0.0f && d > (double)this.zmax ? 1 : 0);
        }
        if (n == 0 && this.withinDate && displayContext != null && (timeInterval = displayContext.getTimeInterval()) != null) {
            n = timeInterval.inInterval(this.timeMin, this.timeMax);
        }
        return n;
    }

    public boolean isOutOfExtent(DisplayContext displayContext) {
        boolean bl = displayContext != null && !this.metadata.maxExtent.isZero() && !this.metadata.maxExtent.intersects(displayContext.getLastExtent());
        return bl;
    }

    public boolean isEmpty() {
        return this.records == null || this.records.size() == 0;
    }

    public abstract void paintRecords(Vector var1, Renderer var2, boolean var3, DisplayContext var4, int var5);

    public abstract Vector findWithinRect(FloatRectangle var1, boolean var2);

    public abstract Vector findWithinShape(Shape var1, boolean var2, boolean var3);

    public abstract Vector findWithinCircle(FloatPoint var1, double var2, boolean var4, boolean var5);

    public void setParentMap(DisplayContext displayContext) {
        this.parentMap = displayContext;
    }

    public DisplayContext getMap() {
        return this.parentMap;
    }

    public void clearRenderers() {
        int n = this.renderers.size();
        int n2 = 0;
        while (n2 < n) {
            Renderer renderer = (Renderer)this.renderers.elementAt(n2);
            renderer.symbols = null;
            renderer = null;
            ++n2;
        }
        this.renderers.removeAllElements();
        this.renderers = null;
    }

    public void clear(boolean bl) {
        int n = this.records.size();
        int n2 = 0;
        while (n2 < n) {
            Record record = (Record)this.records.elementAt(n2);
            record.clear();
            record = null;
            ++n2;
        }
        this.records.removeAllElements();
        this.metadata.memsize = 0;
        this.layerExtent = null;
        this.setSelection(null);
        this.loadedExtent = null;
        if (bl) {
            if (this.reloadTimer != null) {
                this.reloadTimer.stop();
            }
            this.clearRenderers();
            this.provider = null;
            this.themes = null;
            this.filters = null;
            if (this instanceof LayerRaster) {
                ((LayerRaster)this).image = null;
            }
        } else {
            this.metadata.loadFailed = false;
            this.metadata.forceClearCache = true;
            this.setLoadComplete(false);
        }
        System.gc();
        this.loadedExtent = new ComplexFigure();
    }

    public void setLoadComplete(boolean bl) {
        this.metadata.isLoaded = bl;
        if (bl && this.layerExtent != null && this.metadata.maxExtent.isZero()) {
            this.metadata.maxExtent = this.layerExtent;
        }
    }

    public boolean isLoadComplete() {
        return this.metadata.isLoaded;
    }

    public FloatRectangle getLayerExtent() {
        return this.layerExtent;
    }

    public void setLayerExtent(FloatRectangle floatRectangle, boolean bl) {
        if (this.layerExtent == null) {
            this.layerExtent = new FloatRectangle(floatRectangle);
        } else {
            this.layerExtent.setBounds(floatRectangle.x, floatRectangle.y, floatRectangle.x2, floatRectangle.y2);
        }
        if (bl) {
            this.metadata.maxExtent = this.layerExtent;
        }
    }

    public abstract FloatRectangle calculateRecordsExtent(Vector var1);

    FloatRectangle calculateExtent(DisplayContext displayContext) {
        Vector vector = this.records;
        synchronized (vector) {
            FloatRectangle floatRectangle = this.layerExtent = this.calculateRecordsExtent(this.records);
            return floatRectangle;
        }
    }

    FloatRectangle getSelectionExtent() {
        if (this.getSelection() != null) {
            return this.calculateRecordsExtent(this.getSelection());
        }
        return null;
    }

    public void addExtent(Record record) {
        record.calculateExtent();
        FloatRectangle floatRectangle = record.extent;
        if (record.extent != null) {
            if (this.layerExtent == null) {
                this.layerExtent = new FloatRectangle(record.extent);
            } else {
                if (this.layerExtent.x > floatRectangle.x) {
                    this.layerExtent.x = floatRectangle.x;
                }
                if (this.layerExtent.y > floatRectangle.y) {
                    this.layerExtent.y = floatRectangle.y;
                }
                if (this.layerExtent.x2 < floatRectangle.x2) {
                    this.layerExtent.x2 = floatRectangle.x2;
                }
                if (this.layerExtent.y2 < floatRectangle.y2) {
                    this.layerExtent.y2 = floatRectangle.y2;
                }
            }
        }
    }

    public void prepareLayer() {
        int n = this.renderers.size();
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Renderer renderer = (Renderer)this.renderers.elementAt(n2);
                try {
                    renderer.prepare();
                    if (renderer.isPrepared) {
                        this.notPrepared = false;
                    }
                }
                catch (Exception exception) {
                    if (!(this.parentMap instanceof Carte)) break block6;
                    Log.addMessage(108, ((Component)((Object)this.parentMap)).getName(), this, exception.getMessage());
                }
            }
            ++n2;
        }
        if (this.parentMap instanceof Carte) {
            ((Carte)this.parentMap).broadcastMessage(15, this.id);
            if (this.reloadTimer == null && this.metadata.reloadTimeRange > 0) {
                this.reloadTimer = new SimpleTimer(this.metadata.reloadTimeRange * 1000, this);
            }
        }
    }

    public void afterDeserialization() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.setVisible(bl, true);
    }

    private void setVisible(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.visible_always || bl;
        if (this.visible != bl3) {
            this.visible = bl3;
            if (this.controlledLayers != null) {
                int n = this.controlledLayers.size();
                int n2 = 0;
                while (n2 < n) {
                    ((Layer)this.controlledLayers.elementAt(n2)).setVisible(bl3, false);
                    ++n2;
                }
            }
            if (this.parentMap instanceof Carte) {
                ((Carte)this.parentMap).broadcastMessage(101, this.id);
                if (bl2 && bl3) {
                    ((Carte)this.parentMap).downloadLayer(this.id);
                }
            }
        }
    }

    public void setExpanded(boolean bl) {
        if (this.legendExpanded != bl) {
            this.legendExpanded = bl;
            if (this instanceof LayerGroup && this.controlledLayers != null) {
                int n = this.controlledLayers.size();
                int n2 = 0;
                while (n2 < n) {
                    Layer layer = (Layer)this.controlledLayers.elementAt(n2);
                    layer.legendVisible = bl;
                    if (layer.controlledLayers != null) {
                        layer.setExpanded(bl);
                    }
                    ++n2;
                }
            }
        }
    }

    public Vector selectObjectsByExpr(String string) {
        Vector vector = null;
        try {
            FilterExpression filterExpression = new FilterExpression(string, this);
            vector = filterExpression.apply(this.getRecords());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public Record findAtScreenPoint(Point point) {
        if (this.parentMap != null && this.parentMap instanceof Carte) {
            Carte carte = (Carte)this.parentMap;
            FloatPoint floatPoint = carte.screenToMap(new Point(point.x + 2, point.y + 2));
            FloatPoint floatPoint2 = carte.screenToMap(new Point(point.x - 4, point.y - 4));
            FloatRectangle floatRectangle = new FloatRectangle(floatPoint2.x, floatPoint.y, floatPoint.x, floatPoint2.y);
            Vector vector = this.filterRecords(this.findWithinRect(floatRectangle, true), true);
            if (MapUtils.isNotEmpty(vector)) {
                return (Record)vector.elementAt(0);
            }
        }
        return null;
    }

    void setDepend(Project project) {
        if (this.controlledLayers != null) {
            int n = this.controlledLayers.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.controlledLayers.elementAt(n2);
                Layer layer = project.getLayerById(string);
                if (layer == null || layer == this) {
                    if (this.controlledLayersUnresolved == null) {
                        this.controlledLayersUnresolved = new Vector();
                    }
                    this.controlledLayersUnresolved.addElement(string);
                    this.controlledLayers.removeElementAt(n2);
                    --n;
                    continue;
                }
                if (this instanceof LayerGroup) {
                    layer.legendVisible = this.legendExpanded;
                }
                this.controlledLayers.setElementAt(layer, n2);
                ++n2;
            }
            if (n == 0) {
                this.controlledLayers = null;
            }
        }
    }

    protected void readMetadata_(DataInputStream dataInputStream) throws Exception {
        int n;
        while ((n = dataInputStream.readShort()) != 0) {
            this.metadata.put(n, dataInputStream.readUTF());
        }
        if (this instanceof LayerVector) {
            this.objectType = dataInputStream.read();
            n = dataInputStream.readShort();
            this.initFields(n);
            int n2 = 0;
            while (n2 < n) {
                FieldDef fieldDef = new FieldDef();
                fieldDef.name = dataInputStream.readUTF();
                fieldDef.label = this.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
                fieldDef.type = dataInputStream.readInt();
                fieldDef.index = n2;
                fieldDef.visible = dataInputStream.read() == 1;
                this.fieldDefs[n2] = fieldDef;
                ++n2;
            }
        }
        this.resolveMetadata();
        this.prepareLayer();
    }

    public void resolveMetadata() throws AlovMapException {
        this.serverType = Meta.getSrvId(this.metadata.getVal(168));
        if (this.linkMain == null) {
            this.linkMain = this.metadata.getVal(63);
        }
        this.metadata.maxExtent.x = MapUtils.toDouble(this.metadata.getVal(4));
        this.metadata.maxExtent.x2 = MapUtils.toDouble(this.metadata.getVal(5));
        this.metadata.maxExtent.y = MapUtils.toDouble(this.metadata.getVal(6));
        this.metadata.maxExtent.y2 = MapUtils.toDouble(this.metadata.getVal(7));
    }

    public String getWebLink(String string, Object object, String string2, FloatRectangle floatRectangle, String string3) {
        if (Strings.isNullOrBlank(string) || !this.canSearch) {
            return null;
        }
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = true;
        int n4 = 0;
        n4 = object == null ? 0 : (object instanceof Record ? 1 : ((Vector)object).size());
        FloatRectangle floatRectangle2 = this.parentMap.getLastExtent();
        TimeInterval timeInterval = this.parentMap.getTimeInterval();
        if (floatRectangle == null) {
            floatRectangle = floatRectangle2;
        }
        FloatRectangle floatRectangle3 = this.getSelectionExtent();
        int n5 = 0;
        while (n5 < n) {
            char c = string.charAt(n5);
            if (bl2 || c == '[') {
                if (c == ']' && stringBuffer3.length() > 0) {
                    int n6;
                    String string4 = stringBuffer3.toString().trim();
                    if (string4.length() > 0) {
                        string4 = string4.substring(1);
                        n6 = string4.lastIndexOf(44);
                        n2 = 0;
                        n3 = 0;
                        bl3 = true;
                        while (n6 > 0) {
                            String string5;
                            if (n6 < string4.length() && (string5 = string4.substring(n6 + 1, string4.length()).trim()).length() > 0) {
                                if (string5.equalsIgnoreCase("$u")) {
                                    n3 = 2;
                                } else if (string5.equalsIgnoreCase("$l")) {
                                    n3 = 1;
                                } else if (string5.equalsIgnoreCase("$ne")) {
                                    bl3 = false;
                                } else {
                                    n2 = Strings.strToInt(string5, 0);
                                }
                            }
                            string4 = string4.substring(0, n6);
                            n6 = string4.lastIndexOf(44);
                        }
                    }
                    if (string4.startsWith("#")) {
                        stringBuffer.append(this.parentMap.getParameter(string4.substring(1), ""));
                    } else if (string4.equalsIgnoreCase(_BBOX_ALL)) {
                        stringBuffer.append(floatRectangle2.x).append(',').append(floatRectangle2.y).append(',').append(floatRectangle2.x2).append(',').append(floatRectangle2.y2);
                    } else if (string4.equalsIgnoreCase(_BBXMIN)) {
                        stringBuffer.append(floatRectangle2.x);
                    } else if (string4.equalsIgnoreCase(_BBYMIN)) {
                        stringBuffer.append(floatRectangle2.y);
                    } else if (string4.equalsIgnoreCase(_BBXMAX)) {
                        stringBuffer.append(floatRectangle2.x2);
                    } else if (string4.equalsIgnoreCase(_BBYMAX)) {
                        stringBuffer.append(floatRectangle2.y2);
                    } else if (string4.equalsIgnoreCase(_BBOX_SEL)) {
                        stringBuffer.append(floatRectangle3.x).append(',').append(floatRectangle3.y).append(',').append(floatRectangle3.x2).append(',').append(floatRectangle3.y2);
                    } else if (string4.equalsIgnoreCase(_SELXMIN)) {
                        stringBuffer.append(floatRectangle3.x);
                    } else if (string4.equalsIgnoreCase(_SELYMIN)) {
                        stringBuffer.append(floatRectangle3.y);
                    } else if (string4.equalsIgnoreCase(_SELXMAX)) {
                        stringBuffer.append(floatRectangle3.x2);
                    } else if (string4.equalsIgnoreCase(_SELYMAX)) {
                        stringBuffer.append(floatRectangle3.y2);
                    } else if (string4.equalsIgnoreCase(_BBOX_DR)) {
                        stringBuffer.append(floatRectangle.x).append(',').append(floatRectangle.y).append(',').append(floatRectangle.x2).append(',').append(floatRectangle.y2);
                    } else if (string4.equalsIgnoreCase(_DRXMIN)) {
                        stringBuffer.append(floatRectangle.x);
                    } else if (string4.equalsIgnoreCase(_DRYMIN)) {
                        stringBuffer.append(floatRectangle.y);
                    } else if (string4.equalsIgnoreCase(_DRXMAX)) {
                        stringBuffer.append(floatRectangle.x2);
                    } else if (string4.equalsIgnoreCase(_DRYMAX)) {
                        stringBuffer.append(floatRectangle.y2);
                    } else if (string4.equalsIgnoreCase(_TSTART)) {
                        if (timeInterval != null) {
                            stringBuffer.append(timeInterval.date1().toString());
                        }
                    } else if (string4.equalsIgnoreCase(_TEND)) {
                        if (timeInterval != null) {
                            stringBuffer.append(timeInterval.date2().toString());
                        }
                    } else if (string4.equalsIgnoreCase(_LAYERNAME)) {
                        stringBuffer.append(this.title);
                    } else if (string4.equalsIgnoreCase(_LAYERID)) {
                        stringBuffer.append(this.id);
                    } else if (string4.equalsIgnoreCase(_DATASETID)) {
                        stringBuffer.append(this.datasetId);
                    } else if (string4.equalsIgnoreCase(_USER)) {
                        if (string3 != null) {
                            stringBuffer.append(string3);
                        }
                    } else if (string4.equalsIgnoreCase(_SEARCHVAL)) {
                        if (string2 != null) {
                            stringBuffer.append(URLEncoder.encode(string2));
                        }
                    } else {
                        int n7 = this.getFieldIndex(string4);
                        if (object != null && n7 >= 0) {
                            int n8 = 0;
                            while (n8 < n4) {
                                Record record = object instanceof Record ? (Record)object : (Record)((Vector)object).elementAt(n8);
                                String string6 = this.getFieldString(record, n7);
                                n6 = string6.length();
                                int n9 = stringBuffer.length();
                                if (n3 == 2) {
                                    string6 = string6.toUpperCase();
                                }
                                if (n3 == 1) {
                                    string6 = string6.toLowerCase();
                                }
                                if (bl3) {
                                    string6 = URLEncoder.encode(string6);
                                }
                                stringBuffer.append(string6);
                                int n10 = n6;
                                while (n10 < n2) {
                                    stringBuffer.insert(n9, '0');
                                    ++n10;
                                }
                                if (n4 > 1 && n8 + 1 < n4) {
                                    stringBuffer.append(',');
                                }
                                ++n8;
                            }
                        }
                    }
                    bl2 = false;
                    stringBuffer3.setLength(0);
                } else {
                    stringBuffer3.append(c);
                    bl2 = true;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n5;
        }
        return Strings.setObj(stringBuffer.toString(), '+', "%20");
    }

    public Record newRecord() {
        return new Record(this.getFieldCount());
    }

    public void addRecord(Record record) {
        this.records.addElement(record);
        this.addExtent(record);
        if (this.hasChart) {
            int n = this.fieldDefs.length;
            int n2 = 0;
            while (n2 < n) {
                if (SQLConst.isNumber(this.fieldDefs[n2].type)) {
                    double d = this.getFieldDouble(record, n2);
                    if (this.fieldDefs[n2].minvalue > d) {
                        this.fieldDefs[n2].minvalue = d;
                    }
                    if (this.fieldDefs[n2].maxvalue < d) {
                        this.fieldDefs[n2].maxvalue = d;
                    }
                }
                ++n2;
            }
        }
    }

    public void deleteRecord(Record record) {
        int n = this.records.indexOf(record);
        if (n >= 0) {
            record.clear();
            record = null;
            this.records.removeElementAt(n);
        }
    }

    public Renderer getRenderer(String string) {
        if (string != null) {
            int n = this.renderers.size();
            int n2 = 0;
            while (n2 < n) {
                if (((Renderer)this.renderers.elementAt((int)n2)).name.equals(string)) {
                    return (Renderer)this.renderers.elementAt(n2);
                }
                ++n2;
            }
        }
        return null;
    }

    public void timerTick(SimpleTimer simpleTimer) {
        if (this.parentMap instanceof Carte) {
            this.clear(false);
            ((Carte)this.parentMap).extentChanged();
        }
    }
}

