/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.alov.data.DataProviderImg;
import org.alov.map.DisplayContext;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.RendererImage;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;

public class LayerRaster
extends Layer {
    public Point fixedPosition = null;
    public Color transparentColor = null;
    public int transparency = -1;
    public int imgWidth = 0;
    public int imgHeight = 0;
    public int resolutionMaxLevel = 0;
    public int resolutionLevel = -1;
    public String wmsLayers = null;
    public String wmsStyles = null;
    public String wmsExtraParams = null;
    public transient Image imageOriginal = null;
    public transient Image image = null;
    public String imageUrl = null;

    public LayerRaster() {
        this.setSelection(null);
    }

    public void paintRecords(Vector vector, Renderer renderer, boolean bl, DisplayContext displayContext, int n) {
        if (!bl) {
            ((RendererImage)renderer).paintRecord(null, bl, displayContext);
        }
    }

    public boolean isEmpty() {
        return this.image == null;
    }

    public void resolveMetadata() throws AlovMapException {
        super.resolveMetadata();
        boolean bl = true;
        this.url = this.connectionData.getProperty("url");
        int n = Strings.strToInt(this.metadata.getVal(138), -1);
        int n2 = Strings.strToInt(this.metadata.getVal(139), -1);
        if (n != -1 && n2 != -1) {
            this.fixedPosition = new Point(n, n2);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            String string = this.metadata.getVal(146);
            if (string != null) {
                this.imgWidth = Integer.parseInt(string);
            }
            if ((string = this.metadata.getVal(147)) != null) {
                this.imgHeight = Integer.parseInt(string);
            }
            if ((string = this.metadata.getVal(148)) != null) {
                this.resolutionMaxLevel = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            throw new AlovMapException(301, this.getName());
        }
        if (this.imgWidth > 0 && this.imgHeight > 0) {
            if (bl) {
                d3 = (this.metadata.maxExtent.x2 - this.metadata.maxExtent.x) / (1.0 * (double)this.imgWidth);
                d4 = (this.metadata.maxExtent.y - this.metadata.maxExtent.y2) / (1.0 * (double)this.imgHeight);
            } else {
                this.metadata.maxExtent = new FloatRectangle(d - d3 / 2.0, d2 + d4 / 2.0 - Math.abs((double)this.imgHeight * d4), d - d3 / 2.0 + (double)this.imgWidth * d3, d2 + d4 / 2.0);
            }
        }
        if (this.metadata.maxExtent.isZero()) {
            throw new AlovMapException(301, "Extent of raster image is not defined");
        }
        this.wmsLayers = this.metadata.getVal(166);
        this.wmsStyles = this.metadata.getVal(167);
        this.wmsExtraParams = this.metadata.getVal(311);
    }

    public void prepareLayer() {
        if (!this.isDataOnServer) {
            this.layerExtent = this.metadata.maxExtent;
            this.setLoadComplete(true);
            this.applyRasterFilters(this.transparency);
        }
        super.prepareLayer();
    }

    FloatRectangle calculateExtent(DisplayContext displayContext) {
        this.layerExtent = this.metadata.maxExtent;
        return this.layerExtent;
    }

    public FloatRectangle calculateRecordsExtent(Vector vector) {
        return this.calculateExtent(null);
    }

    public Vector findWithinRect(FloatRectangle floatRectangle, boolean bl) {
        if (this.layerExtent == null && this.calculateExtent(null) == null || floatRectangle == null) {
            return null;
        }
        if (this.layerExtent.intersects(floatRectangle) || floatRectangle.intersects(this.layerExtent)) {
            Vector<Record> vector = new Vector<Record>();
            Record record = new Record();
            record.extent = this.layerExtent;
            vector.addElement(record);
            return vector;
        }
        return null;
    }

    public Vector findWithinCircle(FloatPoint floatPoint, double d, boolean bl, boolean bl2) {
        if (null == this.layerExtent && null == this.calculateExtent(null) || null == floatPoint) {
            return null;
        }
        double d2 = MapUtils.sqr(d);
        double d3 = this.layerExtent.x - floatPoint.x;
        double d4 = this.layerExtent.x2 - floatPoint.x;
        double d5 = this.layerExtent.y - floatPoint.y;
        double d6 = this.layerExtent.y2 - floatPoint.y;
        if (MapUtils.sqr(d3) + MapUtils.sqr(d5) <= d2 && MapUtils.sqr(d4) + MapUtils.sqr(d5) <= d2 && MapUtils.sqr(d3) + MapUtils.sqr(d6) <= d2 && MapUtils.sqr(d4) + MapUtils.sqr(d6) <= d2 || !bl && (this.layerExtent.contain(floatPoint) || MapUtils.intersectCircle(new FloatPoint(d3, d5), new FloatPoint(d4, d5), d) || MapUtils.intersectCircle(new FloatPoint(d4, d5), new FloatPoint(d4, d6), d) || MapUtils.intersectCircle(new FloatPoint(d4, d6), new FloatPoint(d3, d6), d) || MapUtils.intersectCircle(new FloatPoint(d3, d6), new FloatPoint(d3, d5), d))) {
            Vector<Record> vector = new Vector<Record>();
            Record record = new Record();
            record.extent = this.layerExtent;
            vector.addElement(record);
            return vector;
        }
        return null;
    }

    public Vector findWithinShape(Shape shape, boolean bl, boolean bl2) {
        if (null == this.layerExtent && null == this.calculateExtent(null) || null == shape) {
            return null;
        }
        FloatPoint floatPoint = new FloatPoint(this.layerExtent.x2, this.layerExtent.y);
        FloatPoint floatPoint2 = new FloatPoint(this.layerExtent.x, this.layerExtent.y);
        FloatPoint floatPoint3 = new FloatPoint(this.layerExtent.x2, this.layerExtent.y2);
        FloatPoint floatPoint4 = new FloatPoint(this.layerExtent.x, this.layerExtent.y2);
        boolean bl3 = shape.containsPoint(floatPoint);
        boolean bl4 = shape.containsPoint(floatPoint2);
        boolean bl5 = shape.containsPoint(floatPoint3);
        boolean bl6 = shape.containsPoint(floatPoint4);
        if (bl && bl3 && bl4 && bl5 && bl6 || !bl && (bl3 || bl4 || bl5 || bl6 || MapUtils.intersectShape(floatPoint2, floatPoint, shape) || MapUtils.intersectShape(floatPoint, floatPoint3, shape) || MapUtils.intersectShape(floatPoint3, floatPoint4, shape) || MapUtils.intersectShape(floatPoint4, floatPoint2, shape))) {
            Vector<Record> vector = new Vector<Record>();
            Record record = new Record();
            record.extent = this.layerExtent;
            vector.addElement(record);
            return vector;
        }
        return null;
    }

    public void clear(boolean bl) {
        this.image = null;
        this.imageOriginal = null;
        super.clear(bl);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            ((DataProviderImg)this.provider).loadRaster();
        }
        catch (AlovMapException alovMapException) {
            alovMapException.printStackTrace();
        }
    }

    public void applyRasterFilters(int n) {
        if (this.imageOriginal == null) {
            return;
        }
        this.transparency = n;
        if (this.transparentColor != null || this.transparency >= 0) {
            this.image = MapUtils.makeColorTransparent(this.imageOriginal, this.transparentColor, 255 - this.transparency);
        }
    }
}

