/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alov.data.DataProviderFile;
import org.alov.map.Carte;
import org.alov.map.ComplexFigure;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.ProxyLocal;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Readers;
import org.alov.util.Strings;

public class ProxyServer
extends ProxyLocal {
    public String servletURL = "";
    private String maxsidkb = "";
    private String additionalParams = "";
    private String lastQueryProjStr = "";
    private static final int version = 20050613;
    private int requestNo = 0;
    private boolean bHandshake = false;
    private FloatRectangle previousRect = null;

    void setProjectURLServer() {
        this.projectURL = this.servletURL + '?' + "pid" + '=' + this.projectId + '&' + "rq" + '=' + "GetProject";
    }

    void processGeoResponse(ProxyLocal.GeoReqParams geoReqParams) throws Exception {
        if (this.sessionUser != 0 && this.sessionMagic != 0) {
            geoReqParams.getReq.append("&id=").append(this.sessionUser).append("&m=").append(this.sessionMagic);
        }
        if (!Strings.isNullOrBlank(this.maxsidkb) && geoReqParams.hasImage) {
            geoReqParams.getReq.append('&').append("maxsidsize").append('=').append(this.maxsidkb);
        }
        this.map.broadcastMessage(10, "");
        geoReqParams.url = new URL(geoReqParams.getReq.toString());
        this.map.broadcastMessage(0, "");
        try {
            geoReqParams.input = geoReqParams.url.openStream();
            if (geoReqParams.input == null) {
                throw new AlovMapException(202, "Server busy or inaccessible");
            }
            geoReqParams.counter = new StreamCounter(geoReqParams.input, 1024, null);
        }
        catch (Exception exception) {
            this.bHandshake = false;
            this.addStatusInfo(202, null, exception.getMessage());
            this.map.broadcastMessage(-6, "");
            throw exception;
        }
        geoReqParams.errorCode = Readers.readInt(geoReqParams.counter);
        if (geoReqParams.errorCode == 0) {
            int n;
            Layer layer;
            int n2;
            String string;
            int n3 = Readers.readInt(geoReqParams.counter);
            geoReqParams.counter.setCounter(n3, "");
            ZipInputStream zipInputStream = new ZipInputStream(geoReqParams.counter);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            StreamCounter streamCounter = new StreamCounter(zipInputStream, 1024, this.map);
            DataInputStream dataInputStream = new DataInputStream(streamCounter);
            int n4 = dataInputStream.readInt();
            if (n4 != 20050613) {
                this.map.broadcastMessage(-9, "");
                this.addStatusInfo(206, null, "Versions mismatch: server - " + n4 + " client - " + 20050613);
                return;
            }
            this.sessionUser = dataInputStream.readInt();
            this.sessionMagic = dataInputStream.readInt();
            this.bHandshake = false;
            geoReqParams.layerCount = dataInputStream.readInt();
            boolean bl = dataInputStream.readBoolean();
            if (bl) {
                String string2 = string = dataInputStream.readUTF();
                n2 = 0;
                while (n2 < geoReqParams.layerCount) {
                    geoReqParams.errorCode = Readers.readInt(dataInputStream);
                    layer = geoReqParams.project.getLayerByDsId(string);
                    if (layer != null) {
                        if (geoReqParams.errorCode != 0) {
                            if (geoReqParams.errorCode == 221) {
                                layer.metadata.passResolved = false;
                                layer.metadata.delElement(303);
                            } else {
                                layer.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, layer.getName());
                            }
                            this.addStatusInfo(geoReqParams.errorCode, layer, dataInputStream.readUTF());
                        } else {
                            String string3 = dataInputStream.readUTF();
                            if (!Strings.isNullOrBlank(string3)) {
                                this.addStatusInfo(0, layer, "WARNING#" + string3);
                            }
                            n = dataInputStream.readBoolean();
                            string3 = layer instanceof LayerVector && n == 0 ? "Layer defined as vector but it is raster in fact" : (layer instanceof LayerRaster && n != 0 ? "Layer defined as raster but it is vector in fact" : null);
                            if (string3 != null) {
                                layer.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, layer.getName());
                                this.addStatusInfo(205, layer, string3);
                                return;
                            }
                            try {
                                layer.readMetadata_(dataInputStream);
                                layer.metadata.forceEmptyLoad = false;
                                geoReqParams.project.setSameLayers(layer, this);
                                geoReqParams.project.sortRenderersByLevels();
                            }
                            catch (Exception exception) {
                                layer.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, layer.getName());
                                this.addStatusInfo(0, layer, "Can't read metadata. " + exception.getMessage());
                            }
                        }
                    } else {
                        this.addStatusInfo(205, null, string);
                    }
                    string = dataInputStream.readUTF();
                    if (string.equals(string2)) break;
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < geoReqParams.layerCount) {
                string = dataInputStream.readUTF();
                geoReqParams.errorCode = Readers.readInt(dataInputStream);
                layer = geoReqParams.project.getLayerByDsId(string);
                if (layer != null) {
                    if (geoReqParams.errorCode != 0) {
                        layer.metadata.networkActivity = false;
                        boolean bl2 = layer.metadata.loadFailed = geoReqParams.errorCode == 205;
                        if (geoReqParams.errorCode == 221) {
                            this.map.broadcastMessage(11, "");
                        } else {
                            this.map.broadcastMessage(-8, layer.getName());
                        }
                        this.addStatusInfo(geoReqParams.errorCode, layer, dataInputStream.readUTF());
                    } else {
                        n3 = Readers.readInt(dataInputStream);
                        streamCounter.setCounter(n3, "[ " + layer.getName() + ']');
                        if (n3 > 0) {
                            this.map.broadcastMessage(2, layer.getName());
                            try {
                                this.receiveData(dataInputStream, layer, n3);
                                if (layer.serverType != 23 && layer instanceof LayerVector) {
                                    int n5 = geoReqParams.project.getLayerCount();
                                    n = 0;
                                    while (n < n5) {
                                        Layer layer2 = geoReqParams.project.getLayerByIndex(n);
                                        if (layer2.datasetId.equals(layer.datasetId) && geoReqParams.rect != null) {
                                            layer2.loadedExtent.combineRect(geoReqParams.rect);
                                        }
                                        ++n;
                                    }
                                }
                                if (layer instanceof LayerZoomify && layer.isLoadComplete()) {
                                    ((LayerZoomify)layer).loadZoomifyImages(geoReqParams.rect);
                                }
                            }
                            catch (Exception exception) {
                                layer.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, layer.getName());
                                this.addStatusInfo(0, layer, exception.getMessage());
                            }
                        }
                        layer.metadata.forceClearCache = false;
                        layer.metadata.networkActivity = false;
                        this.map.broadcastMessage(11, "");
                    }
                } else {
                    this.addStatusInfo(205, null, string);
                }
                ++n2;
            }
            n3 = (int)streamCounter.getReceived();
            dataInputStream.close();
            streamCounter.close();
            geoReqParams.counter.close();
            this.map.broadcastMessage(14, "");
        } else if (geoReqParams.errorCode == 215) {
            this.addStatusInfo(215, null, "Server busy");
            geoReqParams.counter.close();
            this.map.broadcastMessage(-7, "");
        } else if (geoReqParams.errorCode == 222) {
            this.bHandshake = false;
            this.restoreSession(geoReqParams);
        } else {
            DataInputStream dataInputStream = new DataInputStream(geoReqParams.counter);
            this.addStatusInfo(geoReqParams.errorCode, null, dataInputStream.readUTF());
            dataInputStream.close();
            geoReqParams.counter.close();
            this.map.broadcastMessage(-5, "");
        }
    }

    private int restoreSession(ProxyLocal.GeoReqParams geoReqParams) throws Exception {
        this.sessionUser = 0;
        this.sessionMagic = 0;
        Project project = this.map.getProject();
        int n = project.getLayerCount();
        int n2 = 0;
        while (n2 < n) {
            Layer layer = project.getLayerByIndex(n2);
            layer.metadata.memsize = 0;
            layer.clear(false);
            ++n2;
        }
        this.map.extentChanged();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    int processGeoRequest(ProxyLocal.GeoReqParams geoReqParams) throws Exception {
        Object object;
        int n2;
        if (this.sessionUser == 0 && this.sessionMagic == 0 && this.bHandshake) {
            return -1;
        }
        if (geoReqParams.project.isDynamic && (geoReqParams.project.forceSearchForDynamic || !geoReqParams.rect.equals(this.previousRect) && geoReqParams.project.isDynamic_SearchAlways)) {
            geoReqParams.project.forceSearchForDynamic = false;
            int n3 = geoReqParams.project.getLayerCount();
            n2 = 0;
            while (n2 < n3) {
                object = geoReqParams.project.getLayerByIndex(n2);
                if (((Layer)object).removeOutOfExtent && (((Layer)object).isOutOfRange(this.map) != 0 || ((Layer)object).isOutOfExtent(this.map))) {
                    geoReqParams.project.layers.removeElementAt(n2);
                    this.addStatusInfo(0, (Layer)object, "Removed");
                    this.map.broadcastMessage(116, null);
                    geoReqParams.lyrList = geoReqParams.lyrList + ((Layer)object).datasetId + ',';
                    ((Layer)object).clear(true);
                    object = null;
                    --n3;
                    continue;
                }
                ++n2;
            }
            this.bHandshake = true;
            geoReqParams.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetDs").append('&').append("bbox").append('=').append(geoReqParams.rect.x).append(',').append(geoReqParams.rect.y).append(',').append(geoReqParams.rect.x2).append(',').append(geoReqParams.rect.y2).append("&z=").append(this.map.getDistance(null));
            if (!Strings.isNullOrBlank(geoReqParams.lyrList)) {
                geoReqParams.lyrList = geoReqParams.lyrList.substring(0, geoReqParams.lyrList.length() - 1);
                geoReqParams.getReq.append('&').append("l").append('=').append(geoReqParams.lyrList);
                geoReqParams.lyrList = "";
            }
            if (geoReqParams.project.isDynamic_LayerVisible) {
                geoReqParams.getReq.append("&visible=ON");
            }
            if (this.sessionUser != 0 && this.sessionMagic != 0) {
                geoReqParams.getReq.append("&id=").append(this.sessionUser).append("&m=").append(this.sessionMagic);
            }
            if (geoReqParams.project.sDynamoAdd.length() > 0) {
                geoReqParams.getReq.append("&d=").append(geoReqParams.project.sDynamoAdd);
            }
            if (geoReqParams.project.isTimeMap) {
                geoReqParams.getReq.append("&tm=ON");
            }
            try {
                geoReqParams.input = new URL(geoReqParams.getReq.toString()).openStream();
                if (geoReqParams.input == null) {
                    throw new AlovMapException(202, "Server busy or inaccessible");
                }
            }
            catch (Exception exception) {
                this.bHandshake = false;
                this.addStatusInfo(202, null, exception.getMessage());
                this.map.broadcastMessage(-6, "");
                throw exception;
            }
            this.bHandshake = false;
            geoReqParams.errorCode = Readers.readInt(geoReqParams.input);
            if (geoReqParams.errorCode == 0) {
                object = new DataInputStream(geoReqParams.input);
                this.sessionUser = ((DataInputStream)object).readInt();
                this.sessionMagic = ((DataInputStream)object).readInt();
                try {
                    geoReqParams.project.load((InputStream)object, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((FilterInputStream)object).close();
                this.map.broadcastMessage(14, "");
                this.previousRect = new FloatRectangle(geoReqParams.rect);
                int n4 = geoReqParams.project.getLayerCount();
                if (geoReqParams.layerCount < n4) {
                    void var6_11;
                    boolean n = false;
                    while (var6_11 < n4) {
                        geoReqParams.project.getLayerByIndex((int)var6_11).setParentMap(this.map);
                        ++var6_11;
                    }
                    this.map.broadcastMessage(111, null);
                }
            } else if (geoReqParams.errorCode == 215) {
                this.addStatusInfo(215, null, "Server busy");
                this.map.broadcastMessage(-7, "");
            } else {
                object = new DataInputStream(geoReqParams.input);
                this.addStatusInfo(geoReqParams.errorCode, null, ((DataInputStream)object).readUTF());
                ((FilterInputStream)object).close();
                this.map.broadcastMessage(-5, "");
            }
        }
        geoReqParams.layerCount = geoReqParams.project.getLayerCount();
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 0;
        while (n2 < geoReqParams.layerCount) {
            boolean bl;
            Object object2 = object = geoReqParams.req.layerId != null ? geoReqParams.project.getLayerById(geoReqParams.req.layerId) : geoReqParams.project.getLayerByIndex(n2);
            if (object == null) {
                geoReqParams.req.layerId = null;
                object = geoReqParams.project.getLayerByIndex(n2);
            }
            String string = ((Layer)object).metadata.getVal(303);
            boolean bl2 = ((Layer)object).isLoadComplete();
            boolean bl3 = ((Layer)object).isSomethingVisible(this.map);
            boolean bl4 = bl = (((Layer)object).isPassResolved() || Strings.isNullOrBlank(string)) && !((Layer)object).metadata.forceEmptyLoad && !bl3;
            if (object instanceof LayerZoomify && bl2 && bl3) {
                ((LayerZoomify)object).loadZoomifyImages(geoReqParams.rect);
            }
            if (this.map.loadedExtent != null && (bl2 || ((Layer)object).metadata.loadFailed || bl)) {
                if (geoReqParams.req.layerId != null) {
                    break;
                }
            } else {
                if (!((Layer)object).isDataOnServer) {
                    super.loadDirect(geoReqParams, (Layer)object);
                } else {
                    ComplexFigure complexFigure = ((Layer)object).loadedExtent.rectSubtract(geoReqParams.rect);
                    FloatRectangle floatRectangle = complexFigure.getExtent();
                    FloatRectangle floatRectangle2 = geoReqParams.newRect = geoReqParams.newRect == null ? floatRectangle : geoReqParams.newRect.union(floatRectangle);
                    if (floatRectangle != null && geoReqParams.lyrList.indexOf(((Layer)object).datasetId + ',') < 0) {
                        geoReqParams.lyrList = geoReqParams.lyrList + ((Layer)object).datasetId + ',';
                        if (!((Layer)object).isPassResolved() && !Strings.isNullOrBlank(string)) {
                            stringBuffer.append("&pwd_").append(((Layer)object).datasetId).append("=").append(URLEncoder.encode(string));
                            ((Layer)object).metadata.passResolved = true;
                        }
                        if (object instanceof LayerVector && !Strings.isNullOrBlank(((LayerVector)object).serverFilter)) {
                            stringBuffer.append("&flt_").append(((Layer)object).datasetId).append("=").append(URLEncoder.encode(((LayerVector)object).serverFilter));
                        }
                        geoReqParams.getMode = ((Layer)object).isFullLoad ? geoReqParams.getMode + '0' : (((Layer)object).metadata.forceEmptyLoad ? geoReqParams.getMode + '3' : (((Layer)object).metadata.cachesize > 0 && ((Layer)object).metadata.memsize > ((Layer)object).metadata.cachesize ? geoReqParams.getMode + '2' : geoReqParams.getMode + '1'));
                        geoReqParams.getMode = geoReqParams.getMode + ",";
                        ++geoReqParams.k;
                        ((Layer)object).metadata.networkActivity = true;
                        boolean bl5 = geoReqParams.hasImage = geoReqParams.hasImage || object instanceof LayerRaster;
                    }
                }
                if (geoReqParams.req.layerId != null) break;
            }
            ++n2;
        }
        geoReqParams.layerCount = geoReqParams.k;
        if (geoReqParams.layerCount == 0 || this.sessionUser == 0 && this.sessionMagic == 0 && this.bHandshake) {
            return -1;
        }
        this.bHandshake = true;
        geoReqParams.lyrList = geoReqParams.lyrList.substring(0, geoReqParams.lyrList.length() - 1);
        geoReqParams.getMode = geoReqParams.getMode.substring(0, geoReqParams.getMode.length() - 1);
        geoReqParams.getReq.setLength(0);
        geoReqParams.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetMap").append('&').append("bbox").append('=').append(geoReqParams.newRect.x).append(',').append(geoReqParams.newRect.y).append(',').append(geoReqParams.newRect.x2).append(',').append(geoReqParams.newRect.y2).append('&').append("l").append('=').append(geoReqParams.lyrList).append('&').append("gm").append('=').append(geoReqParams.getMode).append(Strings.isNullOrBlank(this.additionalParams) ? "" : '&' + this.additionalParams);
        geoReqParams.getReq.append(stringBuffer.toString());
        if (geoReqParams.project.geoProjection != null) {
            object = URLEncoder.encode(geoReqParams.project.geoProjection);
            if (this.lastQueryProjStr.equals(object)) {
                object = "sa";
            } else {
                this.lastQueryProjStr = object;
            }
            geoReqParams.getReq.append('&').append("projection").append('=').append((String)object);
        }
        return 0;
    }

    public void setupProxy(Carte carte) {
        this.servletURL = MapUtils.getRealPath(carte.getParameter("servlet", "mapserv"));
        this.additionalParams = carte.getParameter("external", "");
        super.setupProxy(carte);
        this.maxsidkb = carte.getParameter("maxsidsize", "");
    }

    void loadProjectServer(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            throw new AlovMapException(202, "Server busy or inaccessible");
        }
        int n = Readers.readInt(inputStream);
        if (n == 215) {
            throw new AlovMapException(215, "Server busy");
        }
        if (n != 0) {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            throw new AlovMapException(n, dataInputStream.readUTF());
        }
    }

    int searchQuery(ProxyLocal.GeoReqParams geoReqParams) {
        Layer layer = geoReqParams.project.getLayerById(geoReqParams.req.layerId);
        if (layer != null && layer.isPassResolved()) {
            geoReqParams.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetMap").append('&').append("q").append('=').append(URLEncoder.encode(geoReqParams.req.query)).append('&').append("l").append('=').append(layer.datasetId).append(Strings.isNullOrBlank(this.additionalParams) ? "" : '&' + this.additionalParams);
            if (geoReqParams.req.type == 34) {
                geoReqParams.getReq.append('&').append("t").append("=query").append('&').append("gm").append("=0");
            } else if (geoReqParams.req.type == 35) {
                geoReqParams.getReq.append('&').append("t").append("=query").append('&').append("gm").append('=').append(layer.isFullLoad ? (char)'0' : '1');
            } else if (geoReqParams.req.type <= 32) {
                if (geoReqParams.req.type < 32) {
                    geoReqParams.getReq.append('&').append("t").append("=id");
                }
                geoReqParams.getReq.append('&').append("gm").append('=').append(layer.isFullLoad ? (char)'0' : '1');
            }
        } else {
            return -1;
        }
        geoReqParams.k = 1;
        return 0;
    }

    public void receiveData(DataInputStream dataInputStream, Layer layer, int n) throws Exception {
        Project project = this.map.getProject();
        if (layer instanceof LayerRaster) {
            LayerRaster layerRaster = (LayerRaster)layer;
            int n2 = Readers.readInt(dataInputStream);
            if (layerRaster.imgWidth <= 0) {
                layerRaster.imgWidth = n2;
            }
            int n3 = Readers.readInt(dataInputStream);
            if (layerRaster.imgHeight <= 0) {
                layerRaster.imgHeight = n3;
            }
            double d = dataInputStream.readDouble();
            double d2 = dataInputStream.readDouble();
            double d3 = dataInputStream.readDouble();
            double d4 = dataInputStream.readDouble();
            layer.setLoadComplete(dataInputStream.read() != 0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n - 32);
            try {
                int n4 = n - 32;
                int n5 = 0;
                while (n5 < n4) {
                    byteArrayOutputStream.write(dataInputStream.read());
                    ++n5;
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Toolkit toolkit = this.map.getComponent().getToolkit();
                layerRaster.image = layerRaster.imageOriginal = toolkit.createImage(byArray);
                Object var23_27 = null;
            }
            catch (Throwable throwable) {
                Object var23_28 = null;
                byteArrayOutputStream.close();
                throw throwable;
            }
            byteArrayOutputStream.close();
            if (layerRaster.transparentColor != null || layerRaster.transparency > 0) {
                layerRaster.image = MapUtils.makeColorTransparent(layerRaster.imageOriginal, layerRaster.transparentColor, 255 - layerRaster.transparency);
            }
            layerRaster.setLayerExtent(new FloatRectangle(d, d2, d3, d4), false);
            project.setSameLayers(layer, this);
            this.addStatusInfo(0, layer, "Download image. " + (n - 32) + " bytes" + (layer.isLoadComplete() ? ". COMPLETE" : ""));
            FloatRectangle floatRectangle = layer.getLayerExtent();
            this.map.addExtent(floatRectangle);
            if (this.map.getLastExtent().intersects(floatRectangle)) {
                this.map.updateMap();
            }
        } else if (layer instanceof LayerZoomify) {
            String string = dataInputStream.readUTF();
            DataProviderFile dataProviderFile = (DataProviderFile)((LayerZoomify)layer).provider;
            dataProviderFile.loadZoomify(string);
            this.addStatusInfo(0, layer, "Download Zoomify image config " + string);
            project.setSameLayers(layer, this);
            FloatRectangle floatRectangle = layer.getLayerExtent();
            this.map.addExtent(floatRectangle);
            if (this.map.getLastExtent().intersects(floatRectangle)) {
                this.map.updateMap();
            }
        } else {
            if (layer.serverType == 23 || layer.metadata.cachesize > 0 && layer.metadata.memsize > layer.metadata.cachesize) {
                project.clearSameLayers(layer);
            }
            String string = "";
            boolean bl = true;
            int n6 = 0;
            int n7 = Readers.readInt(dataInputStream);
            int n8 = 0;
            int n9 = 0;
            while (n9 < n7) {
                Object object;
                String string2 = dataInputStream.readUTF();
                if (bl && string2.equals(string)) {
                    bl = false;
                    this.addStatusInfo(0, layer, "WARNING#115");
                }
                string = string2;
                Record record = new Record(layer.fieldCountToDownload);
                record.setId(string2);
                try {
                    n8 = record.readFromStream(dataInputStream, true);
                    if (layer.objectType < 1) {
                        layer.objectType = n8;
                        project.setSameLayers(layer, this);
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Data packet contains damaged data. Can't read geo data \n Record id=" + string2);
                }
                int n10 = 0;
                while (n10 < layer.fieldCountToDownload) {
                    int n11 = 0;
                    switch (layer.getFieldDef((int)n10).type) {
                        case -7: 
                        case -6: {
                            record.setField(n10, new Byte(dataInputStream.readByte()));
                            n11 = 1;
                            break;
                        }
                        case 5: {
                            record.setField(n10, new Short(dataInputStream.readShort()));
                            n11 = 2;
                            break;
                        }
                        case 4: {
                            record.setField(n10, new Integer(dataInputStream.readInt()));
                            n11 = 4;
                            break;
                        }
                        case -5: {
                            record.setField(n10, new Long(dataInputStream.readLong()));
                            n11 = 8;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: {
                            record.setField(n10, new Float(dataInputStream.readFloat()));
                            n11 = 4;
                            break;
                        }
                        case 8: {
                            record.setField(n10, new Double(dataInputStream.readDouble()));
                            n11 = 8;
                            break;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            object = new String(dataInputStream.readUTF());
                            n11 = ((String)object).length();
                            record.setField(n10, object);
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            record.setField(n10, new Date(dataInputStream.readLong()));
                            n11 = 8;
                            break;
                        }
                        default: {
                            record.setField(n10, "");
                        }
                    }
                    ++n10;
                }
                object = layer.records;
                synchronized (object) {
                    layer.addRecord(record);
                    this.map.addExtent(record.extent);
                }
                ++n6;
                ++n9;
            }
            dataInputStream.readUTF();
            layer.setLoadComplete(dataInputStream.read() != 0);
            if (n6 > 0) {
                this.map.addExtent(layer.getLayerExtent());
                this.map.updateMap();
            }
            layer.metadata.memsize += n;
            this.addStatusInfo(0, layer, "Download " + n6 + '/' + n7 + " records. " + n + " bytes" + (layer.isLoadComplete() ? ". COMPLETE" : ""));
        }
    }

    static String getParam(String string, String string2, String string3) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf(61);
                if (n <= 0 || n >= string4.length() - 1 || !string4.substring(0, n).equalsIgnoreCase(string2)) continue;
                return string4.substring(n + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    private void doAttribRequest(ProxyRequest proxyRequest) throws Exception {
        LayerVector layerVector;
        String string;
        if (proxyRequest.layerId == null) {
            return;
        }
        Project project = this.map.getProject();
        Layer layer = project.getLayerById(proxyRequest.layerId);
        if (layer == null || !layer.canSearch) {
            return;
        }
        String string2 = null;
        Vector vector = null;
        if (proxyRequest.type == 32 || proxyRequest.type == 35) {
            string = layer.linkSearch != null ? layer.linkSearch : project.linkSearch;
        } else {
            vector = layer.getSelection();
            if (proxyRequest.type == 30 || vector != null && vector.size() > 1) {
                layerVector = (LayerVector)layer;
                String string3 = string = layerVector.linkInfo != null ? layerVector.linkInfo : project.linkInfo;
                if (string != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = vector.size();
                    if (n > 255) {
                        n = 255;
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        Record record = (Record)vector.elementAt(n2);
                        stringBuffer.append(record.getId()).append(',');
                        ++n2;
                    }
                    proxyRequest.query = stringBuffer.toString().substring(0, stringBuffer.length() - 1);
                }
            } else {
                string = layer.linkMain != null ? layer.linkMain : project.linkMain;
            }
        }
        string2 = layer.getWebLink(string, vector, proxyRequest.query, proxyRequest.extent, "id=" + this.sessionUser + "&m=" + this.sessionMagic);
        if (string2 != null) {
            this.map.showURL(string2);
        } else if (layer instanceof LayerVector) {
            if (!this.map.showFrame) {
                return;
            }
            layerVector = (LayerVector)layer;
            if (proxyRequest.type == 32 || proxyRequest.type == 35) {
                if (!layer.isLoadComplete() && layer.isDataOnServer && layer.serverType != 23) {
                    this.doGeoRequest(proxyRequest);
                }
                if ((vector = proxyRequest.type == 32 ? layerVector.doSearch(proxyRequest.query) : layerVector.selectObjectsByExpr(proxyRequest.query)) == null || vector.size() == 0) {
                    this.map.broadcastMessage(114, "");
                } else {
                    this.map.broadcastMessage(115, String.valueOf(vector.size()));
                }
            }
            if (vector != null && vector.size() == 1 && this.zoomToOneResult && proxyRequest.type == 32) {
                this.map.selectObject((Layer)layerVector, vector);
            } else {
                this.map.host.showAttributes(layerVector, vector);
            }
        }
    }
}

