/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterTime;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.Strings;

public abstract class Renderer
implements Serializable {
    public static final int RT_DEFAULT = 0;
    public static final int RT_GRADUATED_COLOR = 1;
    public static final int RT_LABEL = 4;
    public static final int RT_CHART = 5;
    public Layer layer = null;
    public Vector themes = new Vector();
    public boolean withinZoom = false;
    public float zmin;
    public float zmax;
    public int equal = 0;
    public String name;
    public String label;
    public boolean legendVisible = true;
    public boolean enabled = true;
    public boolean allowToggle = false;
    protected Symbol[] symbols = null;
    protected boolean isPrepared = false;
    public Vector symbolsUnprepared = null;
    boolean useDefault = false;
    public int sampleHeight = 0;
    public int rendLabelHeight = 0;
    public boolean drawMarker = false;
    static final int RL_LOWEST = 10;
    static final int RL_IMAGE = 20;
    static final int RL_POLYGON = 20;
    static final int RL_LINE = 30;
    static final int RL_POINT = 40;
    static final int RL_FEATURE = 50;
    static final int RL_LABEL = 60;

    public Renderer(Layer layer) {
        this.layer = layer;
    }

    public boolean isRendererVisible(DisplayContext displayContext) {
        if (displayContext == null) {
            displayContext = this.layer.parentMap;
        }
        return this.isPrepared && this.isVisible(displayContext);
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isVisible(DisplayContext displayContext) {
        String string;
        if (displayContext == null) {
            displayContext = this.layer.parentMap;
        }
        if (displayContext == null) {
            return false;
        }
        if (this.withinZoom) {
            int n;
            double d = displayContext.getDistance(displayContext.getLastExtent());
            int n2 = this.zmin > 0.0f && (double)this.zmin > d ? -1 : (n = this.zmax > 0.0f && d > (double)this.zmax ? 1 : 0);
            if (n != 0) {
                return false;
            }
        }
        if ((string = this.layer.style) == null) {
            string = displayContext.getThematicMap();
        }
        return this.themes.size() == 0 || string == null || this.themes.indexOf(string) >= 0;
    }

    public abstract void paintRecord(Record var1, boolean var2, DisplayContext var3);

    protected void prepare() throws Exception {
        this.isPrepared = true;
    }

    public int getSymbolCount() {
        return this.symbols == null ? 0 : this.symbols.length;
    }

    public Symbol getSymbol(int n) {
        return this.symbols != null && n >= 0 && n < this.symbols.length ? this.symbols[n] : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void prepareSymbols(FieldDef fieldDef) throws Exception {
        int n;
        Symbol symbol;
        if (this.symbolsUnprepared == null) {
            return;
        }
        int n2 = this.symbolsUnprepared.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            block10: {
                symbol = (Symbol)this.symbolsUnprepared.elementAt(n4);
                symbol.prepare(this.layer);
                if (fieldDef == null && symbol.valueStr == null) {
                    if ((symbol.offsetMin != 0.0 || symbol.offsetMax != 0.0) && this.layer instanceof LayerVector) {
                        symbol.value = new FilterTime((LayerVector)this.layer);
                        ++n3;
                        break block10;
                    } else {
                        symbol.value = "";
                        ++n3;
                        break;
                    }
                }
                n = -1;
                if (fieldDef != null) {
                    n = fieldDef.type;
                }
                try {
                    symbol.setValue(symbol.valueStr, n, this.layer);
                    ++n3;
                }
                catch (Exception exception) {
                    System.out.println(">>. " + exception.getMessage());
                    symbol.value = null;
                }
                symbol.valueStr = null;
            }
            ++n4;
        }
        this.symbols = new Symbol[n3];
        n3 = 0;
        n = 0;
        while (n < n2) {
            symbol = (Symbol)this.symbolsUnprepared.elementAt(n);
            if (symbol.value != null) {
                symbol.loadSymbolImages(this.layer);
                this.symbols[n3] = symbol;
                ++n3;
            }
            ++n;
        }
        this.symbolsUnprepared.removeAllElements();
        this.symbolsUnprepared = null;
    }

    int getLevel() {
        int n = 100 * (this.layer.drawOrder + 1);
        if (this.layer instanceof LayerVector) {
            int n2 = this.drawMarker ? 1 : this.layer.objectType;
            switch (n2) {
                case 1: {
                    return n + 40;
                }
                case 2: {
                    return n + 30;
                }
            }
            return n + 20;
        }
        return n + 10;
    }

    private float lg(double d) {
        return (d += 1.0) != 0.0 ? (float)Math.log(d) : -15000.0f;
    }

    protected void defaultPaintRecord(Record record, Symbol symbol, DisplayContext displayContext) {
        Object object;
        int n = record.shapes.size();
        int n2 = ((LayerVector)this.layer).objectType;
        Projection projection = displayContext.getProjection();
        if (symbol.sizeFieldIndex >= 0) {
            object = this.layer.getFieldValue(record, symbol.sizeFieldIndex);
            symbol.size = (int)((float)Strings.objToInt(object, symbol.size) * symbol.factor);
        } else if (symbol.useZoom) {
            double d = (double)(symbol.maxSize - symbol.minSize) / (Math.log(projection.minzoom) - Math.log(projection.maxzoom));
            symbol.size = (int)Math.abs(Math.round((Math.log(projection.zoom) - Math.log(projection.maxzoom)) * d));
            if (symbol.size < symbol.minSize) {
                symbol.size = symbol.minSize;
            }
        }
        if (symbol.rotationFieldIndex >= 0) {
            object = this.layer.getFieldValue(record, symbol.rotationFieldIndex);
            symbol.rotation = (float)(MapUtils.toDoubleDef(object, symbol.rotation) / 180.0 * Math.PI);
        }
        if (symbol.drawMarker) {
            Shape.drawPoint(displayContext.getDrawToGraphics(), symbol, (int)((record.centroid.x + projection.shift.x) * projection.zoom), (int)((-record.centroid.y + projection.shift.y) * projection.zoom));
            return;
        }
        if (record.isHasHole && symbol.outline) {
            int n3;
            boolean bl = symbol.outline;
            if (symbol.fill) {
                symbol.outline = false;
                n3 = 0;
                while (n3 < n) {
                    ((Shape)record.shapes.elementAt(n3)).paintShape(displayContext.getDrawToGraphics(), projection, symbol, n2, displayContext.getSize());
                    ++n3;
                }
                symbol.outline = bl;
            }
            bl = symbol.fill;
            symbol.fill = false;
            n = record.outline_shapes.size();
            n3 = 0;
            while (n3 < n) {
                ((Shape)record.outline_shapes.elementAt(n3)).paintShape(displayContext.getDrawToGraphics(), projection, symbol, n2, displayContext.getSize());
                ++n3;
            }
            symbol.fill = bl;
        } else {
            int n4 = 0;
            while (n4 < n) {
                ((Shape)record.shapes.elementAt(n4)).paintShape(displayContext.getDrawToGraphics(), projection, symbol, n2, displayContext.getSize());
                ++n4;
            }
        }
    }
}

