/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.Layer;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;

public class RendererDot
extends Renderer {
    public int fieldIndex;
    public String fieldName;
    public float dotSize;

    public RendererDot(Layer layer) {
        super(layer);
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        if (this.fieldIndex >= 0) {
            int n;
            double d = this.layer.getFieldDouble(record, this.fieldIndex);
            int n2 = (int)(d / (double)this.dotSize);
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            int n3 = record.shapes.size();
            int n4 = 0;
            while (n4 < n2) {
                n = 0;
                double d2 = 0.0;
                double d3 = 0.0;
                while (n == 0) {
                    d2 = (record.extent.x2 - record.extent.x) * Math.random() + record.extent.x;
                    d3 = (record.extent.y2 - record.extent.y) * Math.random() + record.extent.y;
                    int n5 = 0;
                    while (n5 < n3 && n == 0) {
                        if (((Shape)record.shapes.elementAt(n5)).containsPoint(d2, d3)) {
                            n = 1;
                        }
                        ++n5;
                    }
                }
                dArray[n4] = d2;
                dArray2[n4] = d3;
                ++n4;
            }
            n = 0;
            while (n < n2) {
                Projection projection = displayContext.getProjection();
                int n6 = (int)((dArray[n] + projection.shift.x) * projection.zoom);
                int n7 = (int)((-dArray2[n] + projection.shift.y) * projection.zoom);
                Shape.drawPoint(displayContext.getDrawToGraphics(), this.symbols[0], n6, n7);
                ++n;
            }
        }
    }

    protected void prepare() throws Exception {
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(this.fieldName));
        int n = this.fieldIndex = fieldDef == null ? -1 : fieldDef.index;
        if (this.fieldIndex < 0 && this.fieldName != null) {
            throw new Exception("  Renderer: " + this.name + "  " + this.fieldName);
        }
        if (this.symbols == null) {
            this.symbols = new Symbol[1];
            this.symbols[0] = new Symbol(Color.black, Color.black, true, false, 3);
        }
        this.symbols[0].drawMarker = true;
        this.isPrepared = true;
    }
}

