/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FilterTime;
import org.alov.map.FlashUtil;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;

public class RendererGrad
extends Renderer {
    public int fieldIndex;
    public String fieldName;
    public boolean drawDefault = false;

    public RendererGrad(Layer layer) {
        super(layer);
    }

    public boolean isDynamic() {
        int n = this.symbols != null ? this.symbols.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (this.symbols[n2].imageAnimated) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        Serializable serializable;
        Symbol symbol = null;
        Symbol[] symbolArray = this.symbols;
        int n = symbolArray.length;
        if (this.fieldIndex < 0) {
            int n2 = 0;
            while (n2 < n) {
                Symbol symbol2 = symbolArray[n2];
                if (symbol2.value != null) {
                    if (symbol2.value.equals("")) {
                        symbol = symbol2;
                        break;
                    }
                    if (symbol2.value instanceof FilterExpression) {
                        if (((FilterExpression)symbol2.value).checkRecord(record)) {
                            symbol = symbol2;
                            break;
                        }
                    } else if (symbol2.value instanceof FilterTime) {
                        double d;
                        serializable = new TimeInterval(displayContext.getTimeInterval().date1(), displayContext.getTimeInterval().date2());
                        double d2 = symbol2.offsetMin >= 0.0 ? ((TimeInterval)serializable).date1().getDays() + symbol2.offsetMin : ((TimeInterval)serializable).date2().getDays() + symbol2.offsetMin;
                        double d3 = d = symbol2.offsetMax > 0.0 ? ((TimeInterval)serializable).date1().getDays() + symbol2.offsetMax : ((TimeInterval)serializable).date2().getDays() + symbol2.offsetMax;
                        if (d2 > d) {
                            double d4 = d;
                            d = d2;
                            d2 = d4;
                        }
                        ((TimeInterval)serializable).setDate1(new ExDate(d2));
                        ((TimeInterval)serializable).setDate2(new ExDate(d));
                        ((FilterTime)symbol2.value).setTimeInterval((TimeInterval)serializable);
                        if (((FilterTime)symbol2.value).checkRecord(record)) {
                            symbol = symbol2;
                            break;
                        }
                    }
                }
                ++n2;
            }
        } else {
            Object object = this.layer.getFieldValue(record, this.fieldIndex);
            int n3 = 0;
            while (n3 < n) {
                serializable = symbolArray[n3];
                int n4 = MapUtils.compare(object, ((Symbol)serializable).value);
                if (n4 == this.equal) {
                    if (symbol == null || MapUtils.compare(((Symbol)serializable).value, symbol.value) == this.equal) {
                        symbol = serializable;
                    }
                    if (this.equal == 0) break;
                }
                ++n3;
            }
        }
        if (symbol == null && this.drawDefault) {
            symbol = ((LayerVector)this.layer).symbol;
        }
        if (symbol != null && symbol.visible) {
            if (bl) {
                Symbol symbol3;
                symbol = symbol3 = ((LayerVector)this.layer).selectedSymbol;
            }
            if (symbol.sizeFieldIndex >= 0) {
                Object object = this.layer.getFieldValue(record, symbol.sizeFieldIndex);
                symbol.size = (int)((float)Strings.objToInt(object, symbol.size) * symbol.factor);
            }
            if (symbol.rotationFieldIndex >= 0) {
                Object object = this.layer.getFieldValue(record, symbol.rotationFieldIndex);
                symbol.rotation = (float)(MapUtils.toDoubleDef(object, symbol.rotation) / 180.0 * Math.PI);
            }
            if (symbol.drawMarker) {
                Projection projection = displayContext.getProjection();
                int n5 = (int)((record.centroid.x + projection.shift.x) * projection.zoom);
                int n6 = (int)((-record.centroid.y + projection.shift.y) * projection.zoom);
                Shape.drawPoint(displayContext.getDrawToGraphics(), symbol, n5, n6);
            } else if (displayContext.getProjection().forSWF) {
                FlashUtil.RGaddRecord(this, record, symbol);
            } else {
                this.defaultPaintRecord(record, symbol, displayContext);
            }
        }
    }

    protected void prepare() throws Exception {
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(this.fieldName));
        this.prepareSymbols(fieldDef);
        int n = this.fieldIndex = fieldDef == null ? -1 : fieldDef.index;
        if (this.fieldIndex < 0 && this.fieldName != null || this.symbols == null || this.symbols.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.fieldName);
        }
        int n2 = this.symbols.length;
        int n3 = this.equal > 0 ? 1 : 0;
        int n4 = this.equal < 0 ? 1 : 0;
        int n5 = 0;
        if (this.equal != 2) {
            int n6 = 0;
            while (n6 < n2) {
                String string = this.symbols[n6].label;
                if (string == null) {
                    if (this.equal == 0) {
                        string = "" + this.symbols[n6].value;
                    } else if (n2 >= 2) {
                        string = n6 == 0 ? "... " + this.symbols[n6 + n3].value : (n6 < n2 - 1 ? this.symbols[n6 + n5].value + " ... " + this.symbols[n6 + n5 + 1].value : this.symbols[n6 - n4].value + " ...");
                    }
                    this.symbols[n6].label = string;
                }
                ++n6;
            }
        }
        this.isPrepared = true;
    }
}

