/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FlashUtil;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.Strings;

public class RendererLabel
extends Renderer {
    public int labelFieldIndex = 0;
    public int symbolFieldIndex = 0;
    public String labelFieldName = null;
    public String symbolFieldName = null;
    public String rotationFieldName = null;
    public String sizeFieldName = null;
    protected int rotationFieldIndex = -1;
    protected int sizeFieldIndex = -1;
    public boolean drawDefault = false;
    public boolean notOverlap = true;
    private static final byte DRAW_IN_CENTROID = 0;
    private static final byte DRAW_ALONG_LINE = 1;
    private static final byte DRAW_ROTATE = 2;
    private static final byte DRAW_IN_FRAME = 3;
    private static final byte DRAW_IN_BULB = 4;

    public RendererLabel(Layer layer) {
        super(layer);
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        int n;
        int n2;
        if (bl) {
            return;
        }
        Graphics graphics = displayContext.getDrawToGraphics();
        int n3 = record.shapes.size();
        String string = this.layer.getFieldString(record, this.labelFieldIndex);
        if (graphics == null || n3 == 0 || Strings.isNullOrBlank(string)) {
            return;
        }
        Symbol symbol = null;
        Symbol[] symbolArray = this.symbols;
        boolean bl2 = false;
        int n4 = symbolArray.length;
        if (this.symbolFieldIndex < 0) {
            int n5 = 0;
            while (n5 < n4) {
                Symbol symbol2 = symbolArray[n5];
                if (symbol2.value != null && (symbol2.value.equals("") || ((FilterExpression)symbol2.value).checkRecord(record))) {
                    symbol = symbol2;
                    break;
                }
                ++n5;
            }
        } else {
            Object object = this.layer.getFieldValue(record, this.symbolFieldIndex);
            int n6 = 0;
            while (n6 < n4) {
                Symbol symbol3 = symbolArray[n6];
                n2 = MapUtils.compare(object, symbol3.value);
                if (n2 == this.equal) {
                    if (symbol == null || MapUtils.compare(symbol3.value, symbol.value) == this.equal) {
                        symbol = symbol3;
                    }
                    if (this.equal == 0) break;
                }
                ++n6;
            }
        }
        if (symbol == null || !symbol.visible || Strings.isNullOrBlank(symbol.fontName)) {
            return;
        }
        Projection projection = displayContext.getProjection();
        int n7 = n = symbol.sizeFieldIndex >= 0 ? symbol.sizeFieldIndex : this.sizeFieldIndex;
        if (n >= 0 || symbol.useZoom || symbol.font == null) {
            int n8 = symbol.size;
            if (n >= 0) {
                Object object = this.layer.getFieldValue(record, n);
                n8 = (int)((float)Strings.objToInt(object, n8) * symbol.factor);
            } else if (symbol.useZoom) {
                double d = (double)(symbol.maxSize - symbol.minSize) / (Math.log(projection.minzoom) - Math.log(projection.maxzoom));
                n8 = (int)Math.abs(Math.round((Math.log(projection.zoom) - Math.log(projection.maxzoom)) * d));
                if (n8 < symbol.minSize) {
                    n8 = symbol.minSize;
                }
            }
            symbol.font = MapUtils.createAndVerifyFont(symbol.fontName, symbol.fontStyle, n8, string);
            if (symbol.font == null) {
                System.out.println(">>Can't set font " + symbol.fontName);
                symbol.fontName = null;
                return;
            }
        }
        graphics.setFont(symbol.font);
        int n9 = (int)((record.centroid.x + projection.shift.x) * projection.zoom);
        n2 = (int)((-record.centroid.y + projection.shift.y) * projection.zoom);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n10 = fontMetrics.stringWidth(string);
        int n11 = fontMetrics.getHeight();
        int n12 = n9;
        int n13 = n2;
        if (symbol.position != 1) {
            switch (symbol.position) {
                case 0: {
                    n9 -= n10 / 2;
                    n2 += n11 / 2;
                    break;
                }
                case 1: {
                    n2 -= 2;
                    break;
                }
                case 2: {
                    n2 += n11 / 2;
                    break;
                }
                case 3: {
                    n2 = n2 + 2 + n11;
                    break;
                }
                case 4: {
                    n9 -= n10 / 2;
                    n2 = n2 + 2 + n11;
                    break;
                }
                case 5: {
                    n9 -= n10;
                    n2 = n2 + 2 + n11;
                    break;
                }
                case 6: {
                    n9 -= n10;
                    n2 += n11 / 2;
                    break;
                }
                case 7: {
                    n9 -= n10;
                    n2 -= 2;
                    break;
                }
                case 8: {
                    n9 -= n10 / 2;
                    n2 -= 2;
                }
            }
        }
        n9 += symbol.xOffset;
        n2 += symbol.yOffset;
        Shape shape = (Shape)record.shapes.elementAt(0);
        int n14 = symbol.rotationFieldIndex >= 0 ? symbol.rotationFieldIndex : this.rotationFieldIndex;
        double d = 0.0;
        if (n14 >= 0) {
            Object object = this.layer.getFieldValue(record, n14);
            d = -(MapUtils.toDoubleDef(object, d) / 180.0 * 3.1415927410125732);
        } else {
            d = symbol.rotation;
        }
        boolean bl3 = d != 0.0;
        Object object = null;
        if (symbol.align > 2) {
            graphics.setColor(symbol.outlineColor);
            if (bl3) {
                object = Utils2D.getTransform(graphics);
                Utils2D.rotateGraphics(graphics, n9, n2, d);
            }
            if (symbol.align == 4) {
                int[] nArray = new int[7];
                int[] nArray2 = new int[7];
                nArray[0] = n9;
                nArray2[0] = n2;
                nArray[1] = nArray[0];
                nArray2[1] = nArray2[0] - 10;
                nArray[2] = nArray[0] - 5;
                nArray2[2] = nArray2[1];
                nArray[3] = nArray[0] - 5;
                nArray2[3] = nArray2[1] - n11 - 2;
                nArray[4] = nArray[3] + n10 + 3;
                nArray2[4] = nArray2[3];
                nArray[5] = nArray[4];
                nArray2[5] = nArray2[1];
                nArray[6] = nArray[0] + 5;
                nArray2[6] = nArray2[1];
                nArray[0] = n12;
                nArray2[0] = n13;
                graphics.fillPolygon(nArray, nArray2, 7);
                graphics.setColor(symbol.fillColor);
                graphics.drawPolygon(nArray, nArray2, 7);
                graphics.drawString(string, nArray[3] + 2, nArray2[1] - 2);
                if (projection.forSWF) {
                    FlashUtil.drawText(record, string, nArray[3] + 2, nArray2[1] - 2, symbol);
                }
            } else {
                int[] nArray = new int[4];
                int[] nArray3 = new int[4];
                nArray[0] = n9;
                nArray3[0] = n2;
                nArray[1] = n9;
                nArray3[1] = n2 - n11 - 2;
                nArray[2] = n9 + n10 + 3;
                nArray3[2] = nArray3[1];
                nArray[3] = nArray[2];
                nArray3[3] = nArray3[0];
                graphics.fillPolygon(nArray, nArray3, 4);
                graphics.setColor(symbol.fillColor);
                graphics.drawPolygon(nArray, nArray3, 4);
                graphics.drawString(string, nArray[1] + 2, nArray3[0] - 2);
                if (projection.forSWF) {
                    FlashUtil.drawText(record, string, nArray[1] + 2, nArray3[0] - 2, symbol);
                }
            }
            if (bl3) {
                Utils2D.setTransform(graphics, object);
            }
        } else if (((LayerVector)this.layer).objectType == 2 && symbol.align > 0) {
            Dimension dimension = displayContext.getSize();
            if (Utils2D.have2d() && symbol.align == 2) {
                Utils2D.textAlongLine(graphics, shape, string, projection, symbol, dimension);
            } else {
                RendererLabel.textAlongLine(graphics, shape, string, projection, symbol, dimension);
            }
        } else {
            boolean bl4 = true;
            Rectangle rectangle = new Rectangle(n9, n2, n10, n11);
            if (this.notOverlap) {
                int n15 = displayContext.getUsedSpaces().size();
                int n16 = 0;
                while (n16 < n15) {
                    Rectangle rectangle2 = (Rectangle)displayContext.getUsedSpaces().elementAt(n16);
                    if (rectangle2.intersects(rectangle)) {
                        bl4 = false;
                        break;
                    }
                    ++n16;
                }
            }
            if (bl4) {
                if (bl3) {
                    object = Utils2D.getTransform(graphics);
                    Utils2D.rotateGraphics(graphics, n9, n2, d);
                }
                if (symbol.outline) {
                    graphics.setColor(symbol.outlineColor);
                    graphics.drawString(string, n9 + 1, n2 + 1);
                }
                graphics.setColor(symbol.fillColor);
                graphics.drawString(string, n9, n2);
                if (projection.forSWF) {
                    FlashUtil.drawText(record, string, n9, n2, symbol);
                }
                if (this.notOverlap) {
                    displayContext.getUsedSpaces().addElement(rectangle);
                }
                if (bl3) {
                    Utils2D.setTransform(graphics, object);
                }
            }
        }
    }

    protected void prepare() throws Exception {
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(this.symbolFieldName));
        this.symbolFieldIndex = fieldDef != null ? fieldDef.index : -1;
        this.prepareSymbols(fieldDef);
        if (this.symbolFieldName != null && this.symbolFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.symbolFieldName);
        }
        this.rotationFieldIndex = this.layer.getFieldIndex(this.rotationFieldName);
        this.sizeFieldIndex = this.layer.getFieldIndex(this.sizeFieldName);
        if (this.rotationFieldName != null && this.rotationFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.rotationFieldName);
        }
        if (this.sizeFieldName != null && this.sizeFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.sizeFieldName);
        }
        this.labelFieldIndex = this.layer.getFieldIndex(this.labelFieldName);
        if (this.labelFieldIndex < 0 || this.symbols.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.labelFieldName);
        }
        int n = this.symbols.length;
        int n2 = this.equal > 0 ? 1 : 0;
        int n3 = this.equal < 0 ? 1 : 0;
        int n4 = 0;
        while (n4 < n) {
            String string = this.symbols[n4].label;
            if (string == null) {
                if (this.symbolFieldIndex >= 0) {
                    if (this.equal == 0) {
                        string = "" + this.symbols[n4].value;
                    } else if (n >= 2) {
                        string = n4 == 0 ? "... " + this.symbols[n4 + n2].value : (n4 < n - 1 ? this.symbols[n4].value + " ... " + this.symbols[n4 + 1].value : this.symbols[n4 - n3].value + " ...");
                    }
                } else {
                    string = "Sample";
                }
                this.symbols[n4].label = string;
            }
            ++n4;
        }
        this.isPrepared = true;
    }

    int getLevel() {
        return 100 * (this.layer.drawOrder + 1) + 60;
    }

    static void textAlongLine(Graphics graphics, Shape shape, String string, Projection projection, Symbol symbol, Dimension dimension) {
        int n;
        int n2;
        int n3;
        int n4;
        if (string == null || shape == null || shape.xCoords == null) {
            return;
        }
        double[] dArray = shape.xCoords;
        int n5 = dArray.length;
        if (n5 < 2) {
            return;
        }
        int n6 = string.length();
        if (n6 <= 0) {
            return;
        }
        char[] cArray = new char[n6];
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int n7 = 0;
        int n8 = dimension.width;
        int n9 = dimension.height;
        double[] dArray2 = shape.yCoords;
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        int n10 = 0;
        while (n10 < n5) {
            int n11 = (int)((dArray[n10] + projection.shift.x) * projection.zoom);
            n4 = (int)((-dArray2[n10] + projection.shift.y) * projection.zoom);
            nArray3[n10] = n11;
            nArray4[n10] = n4;
            ++n10;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n4 = fontMetrics.getAscent() + fontMetrics.getLeading();
        char[] cArray2 = new char[n6];
        int[] nArray5 = new int[n6];
        int n12 = 0;
        int n13 = 0;
        while (n13 < n6) {
            cArray2[n13] = string.charAt(n13);
            nArray5[n13] = n3 = fontMetrics.charWidth(cArray2[n13]);
            if (n12 < n3) {
                n12 = n3;
            }
            ++n13;
        }
        int n14 = n3 = n4 > n12 ? n4 : n12;
        if (n3 <= 0) {
            return;
        }
        if (nArray3[0] > nArray3[1]) {
            n2 = -1;
            n = n6 - 1;
        } else {
            n2 = 1;
            n = 0;
        }
        int n15 = n;
        Color color = symbol.outline ? symbol.outlineColor : null;
        Color color2 = symbol.fillColor;
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        int n16 = 0;
        while (n16 < n5 - 1) {
            float f3;
            float f4;
            int n17 = nArray3[n16];
            int n18 = nArray4[n16];
            float f5 = nArray3[n16 + 1] - n17;
            float f6 = nArray4[n16 + 1] - n18;
            float f7 = Math.abs(f5) / (float)n3;
            float f8 = Math.abs(f6) / (float)n3;
            f = f2;
            if (f7 > f8) {
                f4 = f5 / f7;
                f3 = f6 / f7;
                f += f7;
            } else {
                f4 = f5 / f8;
                f3 = f6 / f8;
                f += f8;
            }
            int n19 = (int)f;
            float f9 = f2;
            f2 = f - (float)n19;
            int n20 = 0;
            while (n20 < n19) {
                float f10 = (float)n17 + f4 * ((float)n20 + 0.5f - f9);
                float f11 = (float)n18 + f3 * ((float)n20 + 0.5f - f9);
                if (f10 > 0.0f && f10 < (float)n8 && f11 > 0.0f && f11 < (float)n9) {
                    if (!bl) {
                        n15 = n;
                        n7 = 0;
                        bl = true;
                    }
                    nArray[n7] = (int)(f10 - (float)(nArray5[n15] / 2));
                    nArray2[n7] = (int)((double)f11 + (double)n4 * 0.3);
                    cArray[n7] = cArray2[n15];
                    if ((n15 += n2) >= n6) {
                        n15 = 0;
                    } else if (n15 < 0) {
                        n15 = n6 - 1;
                    }
                    if (++n7 >= n6 || n20 == n19) {
                        int n21;
                        if (color != null) {
                            graphics.setColor(color);
                            n21 = 0;
                            while (n21 < n7) {
                                graphics.drawChars(cArray, n21, 1, nArray[n21] + 1, nArray2[n21] + 1);
                                ++n21;
                            }
                        }
                        graphics.setColor(color2);
                        n21 = 0;
                        while (n21 < n7) {
                            graphics.drawChars(cArray, n21, 1, nArray[n21], nArray2[n21]);
                            ++n21;
                        }
                        return;
                    }
                } else {
                    bl = false;
                }
                ++n20;
            }
            ++n16;
        }
    }
}

