/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import java.util.Vector;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;

public class Shape
implements Serializable {
    private static final int MARKER_CIRCLE = 0;
    public static final int MARKER_SQUARE = 1;
    public static final int MARKER_TRIANGLE = 2;
    public static final int MARKER_CROSS = 3;
    public static final int MARKER_CHAR = 4;
    private static final int LINE_SOLID = 0;
    private static final int LINE_DASH = 1;
    private static final int LINE_DOT = 2;
    private static final int LINE_DASHDOT = 3;
    private static final int LINE_DASHDOTDOT = 4;
    private static final int LINE_STRIPE = 5;
    public double[] xCoords = null;
    public double[] yCoords = null;

    public Shape() {
    }

    public Shape(double[] dArray) {
        int n = dArray.length / 2;
        this.xCoords = new double[n];
        this.yCoords = new double[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            this.xCoords[n3] = dArray[n2];
            this.yCoords[n3] = dArray[n2 + 1];
            ++n3;
            n2 += 2;
        }
    }

    public static void drawBoldLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n < 0 && n2 < 0 && n3 < 0 && n4 < 0) {
            return;
        }
        int[] nArray = new int[]{n, n3};
        int[] nArray2 = new int[]{n2, n4};
        graphics.drawPolyline(nArray, nArray2, 2);
        if (n3 != n) {
            float f = (n4 - n2) / (n3 - n);
            if (!((double)Math.abs(f) > 2.7)) {
                // empty if block
            }
        } else {
            ++n;
            ++n3;
        }
        nArray[0] = ++n;
        nArray[1] = ++n3;
        nArray2[0] = ++n2;
        nArray2[1] = ++n4;
        graphics.drawPolyline(nArray, nArray2, 2);
    }

    private static void drawBoldPolyline(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        if (n < 2) {
            return;
        }
        int n2 = 1;
        while (n2 < n) {
            Shape.drawBoldLine(graphics, nArray[n2 - 1], nArray2[n2 - 1], nArray[n2], nArray2[n2]);
            ++n2;
        }
    }

    private static void drawCustomLine(Graphics graphics, int[] nArray, int[] nArray2, Symbol symbol) {
        int n = nArray.length;
        if (symbol.style == 0 || symbol.style == 5) {
            if (symbol.size == 2) {
                Shape.drawBoldPolyline(graphics, nArray, nArray2, n);
                return;
            }
            graphics.drawPolyline(nArray, nArray2, n);
            if (symbol.style == 0) {
                return;
            }
        }
        double d = (double)symbol.step / 4.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        while (n5 < n) {
            int n6 = nArray[n5] - nArray[n5 - n4];
            int n7 = nArray2[n5] - nArray2[n5 - n4];
            double d6 = Math.sqrt(n6 * n6 + n7 * n7);
            if (d6 > 0.0) {
                double d7;
                double d8;
                double d9;
                d2 = (double)n7 / d6;
                d3 = (double)n6 / d6;
                if (n6 == 0) {
                    d9 = d2 * (double)symbol.step;
                    d8 = d2 * (double)symbol.step / 2.0;
                    d7 = d2 * d;
                    d4 = 0.0;
                } else {
                    d4 = 1.0 * (double)n7 / (double)n6;
                    d5 = (double)nArray2[n5 - n4] - d4 * (double)nArray[n5 - n4];
                    d9 = d3 * (double)symbol.step;
                    d8 = d3 * (double)symbol.step / 2.0;
                    d7 = d3 * d;
                }
                int n8 = (int)(d3 * 3.0);
                int n9 = (int)(d2 * 3.0);
                double d10 = nArray[n5 - n4];
                double d11 = nArray2[n5 - n4];
                double d12 = nArray[n5 - n4];
                double d13 = nArray2[n5 - n4];
                double d14 = 0.0;
                while (true) {
                    boolean bl;
                    boolean bl2 = bl = (symbol.style == 1 || symbol.style == 3 || symbol.style == 4) && n2 > 0 && n3 == 0;
                    if (n6 == 0) {
                        d13 = d11 + d7;
                        d14 = (d13 - (double)nArray2[n5 - n4]) / d2;
                    } else {
                        d12 = d10 + d7;
                        d13 = d4 * d12 + d5;
                        d14 = (d12 - (double)nArray[n5 - n4]) / d3;
                    }
                    if (d14 > d6 || d6 == 0.0 || d14 <= 0.0) {
                        if (!bl) break;
                        if (symbol.size == 2) {
                            Shape.drawBoldLine(graphics, (int)d10, (int)d11, nArray[n5], nArray2[n5]);
                            break;
                        }
                        graphics.drawLine((int)d10, (int)d11, nArray[n5], nArray2[n5]);
                        break;
                    }
                    if (bl) {
                        if (symbol.size == 2) {
                            Shape.drawBoldLine(graphics, (int)d10, (int)d11, (int)d12, (int)d13);
                        } else {
                            graphics.drawLine((int)d10, (int)d11, (int)d12, (int)d13);
                        }
                        n2 = 0;
                    } else {
                        ++n2;
                    }
                    d10 = d12;
                    d11 = d13;
                    if (symbol.style == 5) {
                        graphics.drawLine((int)(d10 - (double)n9), (int)(d11 + (double)n8), (int)(d10 + (double)n9), (int)(d11 - (double)n8));
                    } else if (symbol.style == 2 || n3 == 1 || symbol.style == 4 && n3 == 2) {
                        if (symbol.size == 2) {
                            graphics.fillRect((int)d10 - 1, (int)d11 - 1, 2, 2);
                        } else {
                            graphics.fillRect((int)d10, (int)d11, 1, 1);
                        }
                    }
                    if (symbol.style == 3 && n3 < 2 || symbol.style == 4 && n3 < 3) {
                        n2 = 0;
                        ++n3;
                        d = symbol.step / 2;
                        d7 = d8;
                        continue;
                    }
                    n3 = 0;
                    d = symbol.step;
                    d7 = d9;
                }
                d = d14 - d6;
                n4 = 1;
            } else {
                ++n4;
            }
            ++n5;
        }
    }

    public static void drawPoint(Graphics graphics, Symbol symbol, int n, int n2) {
        Image image = symbol.image;
        if (image != null) {
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            n3 = n - n3 / 2;
            n4 = n2 - n4 / 2;
            graphics.drawImage(image, n3, n4, MapUtils.getGlobalImageObserver());
            return;
        }
        int n5 = symbol.size;
        int n6 = n - n5 / 2;
        int n7 = n2 - n5 / 2;
        int[] nArray = null;
        int[] nArray2 = null;
        int n8 = 3;
        switch (symbol.style) {
            case 1: {
                nArray = new int[]{n6, n6 + n5, n6 + n5, n6};
                nArray2 = new int[]{n7, n7, n7 + n5, n7 + n5};
                n8 = 4;
            }
            case 2: {
                if (symbol.style == 2) {
                    nArray = new int[]{n6, n, n + n5 / 2};
                    nArray2 = new int[]{n2 + n5 / 2, n7, n2 + n5 / 2};
                }
                MapUtils.rotate_coords(nArray, nArray2, n, n2, symbol.rotation);
                if (symbol.fill) {
                    graphics.setColor(symbol.fillColor);
                    graphics.fillPolygon(nArray, nArray2, n8);
                }
                if (!symbol.outline) break;
                graphics.setColor(symbol.outlineColor);
                graphics.drawPolygon(nArray, nArray2, n8);
                break;
            }
            case 3: {
                if (!symbol.outline) {
                    return;
                }
                nArray = new int[]{n6, n + n5 / 2, n, n};
                nArray2 = new int[]{n2, n2, n7, n2 + n5 / 2};
                MapUtils.rotate_coords(nArray, nArray2, n, n2, symbol.rotation);
                graphics.setColor(symbol.fillColor);
                graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
                break;
            }
            case 4: {
                if (symbol.fontName == null) break;
                if (symbol.font == null) {
                    symbol.font = MapUtils.createAndVerifyFont(symbol.fontName, symbol.fontStyle, symbol.size > 0 ? symbol.size : MapUtils.defaultPlainFont.getSize(), symbol.charMarker);
                    if (symbol.font == null) {
                        System.out.println("Can't set font " + symbol.fontName + " for character " + symbol.charMarker);
                        symbol.fontName = null;
                        return;
                    }
                }
                graphics.setFont(symbol.font);
                graphics.setColor(symbol.fillColor);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n9 = fontMetrics.stringWidth(symbol.charMarker);
                int n10 = fontMetrics.getHeight();
                n6 = n - n9 / 2;
                n7 = n2 + n10 / 2;
                graphics.drawString(symbol.charMarker, n6, n7);
                break;
            }
            default: {
                if (symbol.fill) {
                    graphics.setColor(symbol.fillColor);
                    graphics.fillOval(n6, n7, n5, n5);
                }
                if (!symbol.outline) break;
                graphics.setColor(symbol.outlineColor);
                graphics.drawOval(n6, n7, n5, n5);
            }
        }
    }

    public void paintShape(Graphics graphics, Projection projection, Symbol symbol, int n, Dimension dimension) {
        try {
            int n2 = this.xCoords.length;
            int[] nArray = new int[this.xCoords.length];
            int[] nArray2 = new int[this.yCoords.length];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = (int)((this.xCoords[n3] + projection.shift.x) * projection.zoom);
                if (nArray[n3] > 31999) {
                    nArray[n3] = 31999;
                } else if (nArray[n3] < -31999) {
                    nArray[n3] = -31999;
                }
                nArray2[n3] = (int)((-this.yCoords[n3] + projection.shift.y) * projection.zoom);
                if (nArray2[n3] > 31999) {
                    nArray2[n3] = 31999;
                } else if (nArray2[n3] < -31999) {
                    nArray2[n3] = -31999;
                }
                ++n3;
            }
            switch (n) {
                case 1: {
                    Shape.drawPoint(graphics, symbol, nArray[0], nArray2[0]);
                    break;
                }
                case 3: {
                    Utils2D.polygon(graphics, nArray, nArray2, n2, symbol);
                    break;
                }
                case 2: {
                    if (!symbol.outline) {
                        return;
                    }
                    if (Utils2D.have2d() && symbol.g2dStroke != null) {
                        Utils2D.line(graphics, nArray, nArray2, n2, symbol);
                        break;
                    }
                    graphics.setColor(symbol.outlineColor);
                    Shape.drawCustomLine(graphics, nArray, nArray2, symbol);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FloatRectangle calculateExtent() {
        double d = this.xCoords[0];
        double d2 = this.yCoords[0];
        double d3 = d;
        double d4 = d2;
        int n = 1;
        while (n < this.xCoords.length) {
            if (d < this.xCoords[n]) {
                d = this.xCoords[n];
            } else if (d3 > this.xCoords[n]) {
                d3 = this.xCoords[n];
            }
            if (d2 < this.yCoords[n]) {
                d2 = this.yCoords[n];
            } else if (d4 > this.yCoords[n]) {
                d4 = this.yCoords[n];
            }
            ++n;
        }
        return new FloatRectangle(d3, d4, d, d2);
    }

    public boolean containsPoint(FloatPoint floatPoint) {
        return Shape.containsPoint(this, floatPoint.x, floatPoint.y);
    }

    static boolean containsPoint(Shape shape, double d, double d2) {
        double[] dArray = shape.xCoords;
        double[] dArray2 = shape.yCoords;
        int n = 0;
        int n2 = dArray.length;
        double d3 = dArray[n2 - 1];
        double d4 = dArray2[n2 - 1];
        int n3 = 0;
        while (n3 < n2) {
            double d5 = dArray[n3];
            double d6 = dArray2[n3];
            if ((d < d3 || d < d5) && (d2 < d4 && d2 >= d6 || d2 < d6 && d2 >= d4)) {
                if (d < d3 && d < d5) {
                    ++n;
                } else if ((d2 - d4) * (d5 - d3) / (d6 - d4) + d3 > d) {
                    ++n;
                }
            }
            d3 = d5;
            d4 = d6;
            ++n3;
        }
        return n & true;
    }

    boolean containsPoint(double d, double d2) {
        return Shape.containsPoint(this, d, d2);
    }

    public boolean isClockWise() {
        int n = this.xCoords.length - 1;
        double d = this.xCoords[n] * this.yCoords[0] - this.xCoords[0] * this.yCoords[n];
        int n2 = 0;
        while (n2 < n) {
            d += this.xCoords[n2] * this.yCoords[n2 + 1] - this.xCoords[n2 + 1] * this.yCoords[n2];
            ++n2;
        }
        return d >= 0.0;
    }

    public void setVertex(int n, double d, double d2) {
        if (n >= 0 && n < this.xCoords.length) {
            this.xCoords[n] = d;
            this.yCoords[n] = d2;
        }
    }

    public Vector getCoordinates() {
        int n = this.xCoords.length;
        Vector<FloatPoint> vector = new Vector<FloatPoint>(n - 1);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(new FloatPoint(this.xCoords[n2], this.yCoords[n2]));
            ++n2;
        }
        return vector;
    }
}

