/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.FilterExpression;
import org.alov.map.Layer;
import org.alov.map.Load2D;
import org.alov.map.MapUtils;
import org.alov.util.Log;
import org.alov.util.Strings;

public class Symbol
implements Serializable {
    public int style = 0;
    public boolean drawMarker = false;
    public boolean fill;
    public boolean outline;
    public Color fillColor;
    public Color outlineColor;
    public int size = 0;
    public int minSize;
    public int maxSize;
    public boolean useZoom = false;
    public int step = 20;
    public int align = 2;
    public int position = 1;
    public int xOffset = 0;
    public int yOffset = 0;
    public boolean legendVisible = true;
    public boolean visible = true;
    public Object value = null;
    public String valueStr;
    public String label;
    public String imageUrl = null;
    public String fontName = null;
    public Font font = null;
    public int fontStyle = 0;
    public String charMarker = null;
    public Dimension sampleSize = new Dimension(0, 0);
    public String rotationFieldName = null;
    public String sizeFieldName = null;
    protected int rotationFieldIndex = -1;
    protected int sizeFieldIndex = -1;
    protected float factor = 1.0f;
    public float rotation = 0.0f;
    public transient Image image = null;
    public transient Image imageOriginal = null;
    public boolean imageAnimated = false;
    public int imageAnimationDelay = 1000;
    public double offsetMin = 0.0;
    public double offsetMax = 0.0;
    int SymType;
    Rectangle textureAnchor = null;
    String textureUrl = null;
    transient Object g2dPaint = null;
    transient Vector g2dStroke = null;
    transient Vector g2dStrokeColours = null;
    transient Object g2dPaintComposite = null;
    transient Object g2dStrokeComposite = null;

    public Symbol() {
        this(Color.white, Color.black, true, true, 1);
    }

    public Symbol(Color color, Color color2, boolean bl, boolean bl2, int n) {
        this.fillColor = color;
        this.outlineColor = color2;
        this.fill = bl;
        this.outline = bl2;
        this.size = n;
    }

    public void setValue(String string, int n, Layer layer) throws Exception {
        if (layer != null && n < 0) {
            this.value = new FilterExpression(string, layer);
            if (this.label == null) {
                this.label = this.valueStr;
            }
        } else if (n > 0) {
            this.value = Strings.strToObject(string, n);
        }
    }

    public Color getColor(String string) throws Exception {
        return (Color)Strings.strToObject(string, 1004);
    }

    protected void prepare(Layer layer) throws Exception {
        this.rotationFieldIndex = layer.getFieldIndex(this.rotationFieldName);
        this.sizeFieldIndex = layer.getFieldIndex(this.sizeFieldName);
        if (this.rotationFieldName != null && this.rotationFieldIndex < 0) {
            throw new Exception("  Symbol: " + this.label + "  " + this.rotationFieldName);
        }
        if (this.sizeFieldName != null && this.sizeFieldIndex < 0) {
            throw new Exception("  Symbol: " + this.label + "  " + this.sizeFieldName);
        }
    }

    protected void loadSymbolImages(Layer layer) {
        block12: {
            int n;
            Object object;
            if (this.imageUrl != null) {
                try {
                    this.imageOriginal = this.image = MapUtils.loadImage2(layer, this.imageUrl);
                    try {
                        object = this.fillColor.getClass().getMethod("getAlpha", null);
                        Integer n2 = (Integer)((Method)object).invoke((Object)this.fillColor, null);
                        n = n2;
                        if (n < 255) {
                            this.image = MapUtils.makeColorTransparent(this.imageOriginal, null, 255 - n);
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Exception exception) {
                    if (layer != null && layer.parentMap instanceof Carte) {
                        Log.addMessage(306, "Map", layer, "Can't load raster image " + this.imageUrl + "  " + exception.getMessage());
                    }
                    System.out.println("Can't load image " + this.imageUrl);
                    exception.printStackTrace();
                }
            }
            if (this.textureUrl != null) {
                try {
                    object = MapUtils.loadImage2(layer, this.textureUrl);
                    int n3 = ((Image)object).getWidth(null);
                    n = ((Image)object).getHeight(null);
                    if (this.textureAnchor == null) {
                        this.textureAnchor = n3 > 0 && n > 0 ? new Rectangle(0, 0, n3 - 1, n - 1) : new Rectangle(0, 0, 8, 8);
                    }
                    this.g2dPaint = Load2D.getTexturePaint((Image)object, n3, n, this.textureAnchor);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (layer == null) break block12;
                    Log.addMessage(306, "Map", layer, "Can't load raster image " + this.textureUrl + "  " + exception.getMessage());
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.loadSymbolImages(null);
    }
}

