/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Shape;
import org.alov.map.Symbol;

public class Utils2D {
    private static boolean have2d;
    private Graphics graphics;
    private static Method setStroke;
    private static Method setPaint;
    private static Method setComposite;
    private static Method setTransform;
    private static Method getStroke;
    private static Method getPaint;
    private static Method getComposite;
    private static Method getTransform;
    private static Method setRenderingHint;
    private static Method rotate;
    private static Method createCustomCursor;
    private static Class graphics2dClass;
    private static Class renderingHintsClass;
    private static Object[] oneArgument;

    private Utils2D() {
    }

    public static boolean have2d() {
        return have2d;
    }

    static void setRenderingHint(Graphics graphics, String string, String string2) {
        if (setRenderingHint == null || renderingHintsClass == null) {
            return;
        }
        try {
            Object object = renderingHintsClass.getField(string).get(null);
            Object object2 = renderingHintsClass.getField(string2).get(null);
            setRenderingHint.invoke((Object)graphics, object, object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setStroke(Graphics graphics, Object object) {
        if (setStroke == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setStroke.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setComposite(Graphics graphics, Object object) {
        if (setComposite == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setComposite.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void setTransform(Graphics graphics, Object object) {
        if (setTransform == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setTransform.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setPaint(Graphics graphics, Object object) {
        if (setPaint == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setPaint.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object getStroke(Graphics graphics) {
        if (getStroke == null) {
            return null;
        }
        try {
            return getStroke.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getComposite(Graphics graphics) {
        if (getComposite == null) {
            return null;
        }
        try {
            return getComposite.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getTransform(Graphics graphics) {
        if (getTransform == null) {
            return null;
        }
        try {
            return getTransform.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getPaint(Graphics graphics) {
        if (getPaint == null) {
            return null;
        }
        try {
            return getPaint.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void drawStringRotated(Graphics graphics, String string, int n, int n2, double d, double d2, double d3) {
        Object object = null;
        if (d3 != 0.0) {
            object = Utils2D.getTransform(graphics);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d, d2, d3);
            Utils2D.setTransform(graphics, affineTransform);
        }
        graphics.drawString(string, n, n2);
        if (object != null) {
            Utils2D.setTransform(graphics, object);
        }
    }

    public static void rotateGraphics(Graphics graphics, double d, double d2, double d3) {
        if (have2d) {
            Utils2D.do_rotate(graphics, d, d2, d3);
        }
    }

    private static void do_rotate(Graphics graphics, double d, double d2, double d3) {
        if (rotate != null) {
            try {
                Object object = Utils2D.getTransform(graphics);
                rotate.invoke(object, new Double(d3), new Double(d), new Double(d2));
                Utils2D.setTransform(graphics, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void polygon(Graphics graphics, int[] nArray, int[] nArray2, int n, Symbol symbol) {
        Object object = Utils2D.getStroke(graphics);
        Object object2 = Utils2D.getPaint(graphics);
        Object object3 = Utils2D.getComposite(graphics);
        if (symbol.fill) {
            if (symbol.g2dPaint != null) {
                Utils2D.setPaint(graphics, symbol.g2dPaint);
            } else {
                graphics.setColor(symbol.fillColor);
            }
            if (symbol.g2dPaintComposite != null) {
                Utils2D.setComposite(graphics, symbol.g2dPaintComposite);
            }
            graphics.fillPolygon(nArray, nArray2, n);
        }
        if (symbol.outline) {
            if (symbol.g2dStrokeComposite != null) {
                Utils2D.setComposite(graphics, symbol.g2dStrokeComposite);
            }
            if (MapUtils.isNotEmpty(symbol.g2dStroke)) {
                int n2 = symbol.g2dStroke.size();
                int n3 = 0;
                while (n3 < n2) {
                    Utils2D.setStroke(graphics, symbol.g2dStroke.elementAt(n3));
                    graphics.setColor((Color)symbol.g2dStrokeColours.elementAt(n3));
                    graphics.drawPolygon(nArray, nArray2, n);
                    ++n3;
                }
            } else {
                graphics.setColor(symbol.outlineColor);
                graphics.drawPolygon(nArray, nArray2, n);
            }
        }
        Utils2D.setStroke(graphics, object);
        Utils2D.setPaint(graphics, object2);
        Utils2D.setComposite(graphics, object3);
    }

    static void line(Graphics graphics, int[] nArray, int[] nArray2, int n, Symbol symbol) {
        if (symbol.outline) {
            Object object = null;
            Object object2 = null;
            if (symbol.g2dStrokeComposite != null) {
                object2 = Utils2D.getComposite(graphics);
                Utils2D.setComposite(graphics, symbol.g2dStrokeComposite);
            }
            if (MapUtils.isNotEmpty(symbol.g2dStroke)) {
                object = Utils2D.getStroke(graphics);
                int n2 = 0;
                while (n2 < symbol.g2dStroke.size()) {
                    Utils2D.setStroke(graphics, symbol.g2dStroke.elementAt(n2));
                    graphics.setColor((Color)symbol.g2dStrokeColours.elementAt(n2));
                    graphics.drawPolyline(nArray, nArray2, n);
                    ++n2;
                }
            } else {
                graphics.setColor(symbol.outlineColor);
                graphics.drawPolyline(nArray, nArray2, n);
            }
            Utils2D.setStroke(graphics, object);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void textAlongLine(Graphics var0, Shape var1_1, String var2_2, Projection var3_3, Symbol var4_4, Dimension var5_5) {
        if (var2_2 == null) return;
        if (var1_1 == null) return;
        if (var1_1.xCoords == null) {
            return;
        }
        var6_6 = var1_1.xCoords;
        var7_7 = var6_6.length;
        if (var7_7 < 2) {
            return;
        }
        var8_8 = var2_2.length();
        if (var8_8 <= 0) {
            return;
        }
        var9_9 = new char[var8_8];
        var10_10 = new int[var8_8];
        var11_11 = new int[var8_8];
        var12_12 = new double[var8_8];
        var13_13 = new float[var8_8];
        var14_14 = new float[var8_8];
        var15_15 = 0;
        var19_16 = var5_5.width;
        var20_17 = var5_5.height;
        var21_18 = var1_1.yCoords;
        var22_19 = new int[var7_7];
        var23_20 = new int[var7_7];
        var24_21 = 0;
        while (var24_21 < var7_7) {
            var25_22 = (int)((var6_6[var24_21] + var3_3.shift.x) * var3_3.zoom);
            var26_24 = (int)((-var21_18[var24_21] + var3_3.shift.y) * var3_3.zoom);
            var22_19[var24_21] = var25_22;
            var23_20[var24_21] = var26_24;
            ++var24_21;
        }
        var25_23 = var0.getFontMetrics();
        var26_24 = var25_23.getAscent() + var25_23.getLeading();
        var27_25 = new char[var8_8];
        var28_26 = new int[var8_8];
        var29_27 = 0;
        var30_28 = 0;
        while (var30_28 < var8_8) {
            var27_25[var30_28] = var2_2.charAt(var30_28);
            var28_26[var30_28] = var31_29 = var25_23.charWidth(var27_25[var30_28]);
            if (var29_27 < var31_29) {
                var29_27 = var31_29;
            }
            ++var30_28;
        }
        v0 = var31_29 = var26_24 > var29_27 ? var26_24 : var29_27;
        if (var31_29 <= 0) {
            return;
        }
        var32_30 = 0;
        var33_31 = 0;
        var34_32 = 0.0;
        var36_33 = 0.0;
        var38_34 = 0;
        while (var38_34 < var7_7 - 1) {
            var34_32 += Math.sqrt((var22_19[var38_34 + 1] - var22_19[var38_34]) * (var22_19[var38_34 + 1] - var22_19[var38_34]) + (var23_20[var38_34 + 1] - var23_20[var38_34]) * (var23_20[var38_34 + 1] - var23_20[var38_34]));
            ++var38_34;
        }
        switch (var4_4.position) {
            case 0: 
            case 4: 
            case 8: {
                var36_33 = (var34_32 - (double)(var8_8 * var31_29)) / 2.0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                var36_33 = var34_32 - (double)((var8_8 + 1) * var31_29);
                break;
            }
        }
        if (var36_33 > 0.0) {
            var41_35 = 0;
            while (var41_35 < var7_7 - 1) {
                var39_37 = Math.sqrt((var22_19[var41_35 + 1] - var22_19[var41_35]) * (var22_19[var41_35 + 1] - var22_19[var41_35]) + (var23_20[var41_35 + 1] - var23_20[var41_35]) * (var23_20[var41_35 + 1] - var23_20[var41_35]));
                if (var36_33 > var39_37) {
                    var36_33 -= var39_37;
                } else {
                    var32_30 = var41_35;
                    if (var39_37 != 0.0) {
                        var42_39 = var36_33 / var39_37;
                        v1 = var41_35;
                        var22_19[v1] = (int)((double)var22_19[v1] + (double)(var22_19[var41_35 + 1] - var22_19[var41_35]) * var42_39);
                        v2 = var41_35;
                        var23_20[v2] = (int)((double)var23_20[v2] + (double)(var23_20[var41_35 + 1] - var23_20[var41_35]) * var42_39);
                        break;
                    }
                }
                ++var41_35;
            }
        }
        switch (var4_4.position) {
            case 1: 
            case 7: 
            case 8: {
                var33_31 = -var26_24 / 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                var33_31 = var26_24 / 2;
                break;
            }
        }
        if (var22_19[var32_30] > var22_19[var32_30 + 1]) {
            var17_41 = -1;
            var18_42 = var8_8 - 1;
        } else {
            var17_41 = 1;
            var18_42 = 0;
        }
        var16_43 = var18_42;
        var39_38 = var4_4.outline != false ? var4_4.outlineColor : null;
        var40_44 = var4_4.fillColor;
        var41_36 = Utils2D.getTransform(var0);
        try {
            var42_40 = false;
            var43_45 = 0.0f;
            var44_46 = 0.0f;
            var45_47 = var32_30;
            block14: while (true) {
                if (var45_47 >= var7_7 - 1) break;
                var46_48 = var22_19[var45_47];
                var47_49 = var23_20[var45_47];
                var48_50 = var22_19[var45_47 + 1] - var46_48;
                var49_51 = var23_20[var45_47 + 1] - var47_49;
                var50_52 = Math.abs(var48_50) / (float)var31_29;
                var51_53 = Math.abs(var49_51) / (float)var31_29;
                var43_45 = var44_46;
                if (var50_52 > var51_53) {
                    var52_54 = var48_50 / var50_52;
                    var53_55 = var49_51 / var50_52;
                    var43_45 += var50_52;
                } else {
                    var52_54 = var48_50 / var51_53;
                    var53_55 = var49_51 / var51_53;
                    var43_45 += var51_53;
                }
                var54_56 = Math.atan2(var21_18[var45_47] - var21_18[var45_47 + 1], var6_6[var45_47 + 1] - var6_6[var45_47]);
                var56_57 = (int)var43_45;
                var57_58 = var44_46;
                var44_46 = var43_45 - (float)var56_57;
                var58_59 = 0;
                while (true) {
                    block38: {
                        block37: {
                            if (var58_59 >= var56_57) {
                                ++var45_47;
                                continue block14;
                            }
                            var59_60 = (float)var46_48 + var52_54 * ((float)var58_59 + 0.5f - var57_58);
                            var60_61 = (float)var47_49 + (float)var33_31 + var53_55 * ((float)var58_59 + 0.5f - var57_58);
                            if (!(var59_60 > 0.0f) || var19_16 != 0 && !(var59_60 < (float)var19_16) || !(var60_61 > 0.0f) || var20_17 != 0 && !(var60_61 < (float)var20_17)) break block37;
                            if (!var42_40) {
                                var16_43 = var18_42;
                                var15_15 = 0;
                                var42_40 = true;
                            }
                            var13_13[var15_15] = var59_60;
                            var14_14[var15_15] = var60_61;
                            var10_10[var15_15] = (int)(var59_60 - (float)(var28_26[var16_43] / 2));
                            var11_11[var15_15] = (int)((double)var60_61 + (double)var26_24 * 0.3);
                            var9_9[var15_15] = var27_25[var16_43];
                            var12_12[var15_15] = var54_56;
                            if ((var16_43 += var17_41) >= var8_8) {
                                var16_43 = 0;
                            } else if (var16_43 < 0) {
                                var16_43 = var8_8 - 1;
                            }
                            if (++var15_15 < var8_8) break block38;
                            var61_62 = 0;
                            if (true) ** GOTO lbl177
                        }
                        var42_40 = false;
                    }
                    ++var58_59;
                }
                break;
            }
            var64_65 = null;
            Utils2D.setTransform(var0, var41_36);
            return;
        }
        catch (Throwable var63_67) {
            var64_66 = null;
            Utils2D.setTransform(var0, var41_36);
            throw var63_67;
        }
        do {
            var62_63 = new AffineTransform();
            if (var17_41 < 0) {
                var62_63.scale(-1.0, -1.0);
                var62_63.translate(-var13_13[var61_62] * 2.0f, -var14_14[var61_62] * 2.0f);
            }
            var62_63.rotate(var12_12[var61_62], var13_13[var61_62], var14_14[var61_62]);
            Utils2D.setTransform(var0, var62_63);
            if (var39_38 != null) {
                var0.setColor(var39_38);
                var0.drawChars(var9_9, var61_62, 1, var10_10[var61_62] + 1, var11_11[var61_62] + 1);
            }
            var0.setColor(var40_44);
            var0.drawChars(var9_9, var61_62, 1, var10_10[var61_62], var11_11[var61_62]);
            ++var61_62;
lbl177:
            // 2 sources

        } while (var61_62 < var15_15);
        var64_64 = null;
        Utils2D.setTransform(var0, var41_36);
    }

    public static Cursor createCursor(Image image, String string) throws Exception {
        Cursor cursor = null;
        if (image != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Point point = new Point(1, 1);
            cursor = (Cursor)createCustomCursor.invoke((Object)toolkit, image, point, string);
        }
        return cursor;
    }

    static {
        int n;
        have2d = false;
        setStroke = null;
        setPaint = null;
        setComposite = null;
        setTransform = null;
        getStroke = null;
        getPaint = null;
        getComposite = null;
        getTransform = null;
        setRenderingHint = null;
        rotate = null;
        createCustomCursor = null;
        graphics2dClass = null;
        renderingHintsClass = null;
        oneArgument = new Object[1];
        String string = System.getProperty("java.version");
        System.out.println("Java v." + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 1;
        int n3 = n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 3;
        if (n2 > 1 || n > 2) {
            try {
                Class<?>[] classArray;
                GenericDeclaration genericDeclaration;
                graphics2dClass = Class.forName("java.awt.Graphics2D");
                renderingHintsClass = Class.forName("java.awt.RenderingHints");
                Class<?> clazz = Class.forName("java.awt.Paint");
                Class<?> clazz2 = Class.forName("java.awt.Stroke");
                Class<?> clazz3 = Class.forName("java.awt.Composite");
                Class<?> clazz4 = Class.forName("java.awt.geom.AffineTransform");
                Class[] classArray2 = new Class[]{clazz2};
                setStroke = graphics2dClass.getMethod("setStroke", classArray2);
                classArray2[0] = clazz;
                setPaint = graphics2dClass.getMethod("setPaint", classArray2);
                classArray2[0] = clazz3;
                setComposite = graphics2dClass.getMethod("setComposite", classArray2);
                classArray2[0] = clazz4;
                setTransform = graphics2dClass.getMethod("setTransform", classArray2);
                getStroke = graphics2dClass.getMethod("getStroke", null);
                getPaint = graphics2dClass.getMethod("getPaint", null);
                getComposite = graphics2dClass.getMethod("getComposite", null);
                getTransform = graphics2dClass.getMethod("getTransform", null);
                Class<?> clazz5 = Class.forName("java.awt.RenderingHints$Key");
                setRenderingHint = graphics2dClass.getMethod("setRenderingHint", clazz5, new Object().getClass());
                Method[] methodArray = clazz4.getMethods();
                int n4 = methodArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    genericDeclaration = methodArray[n5];
                    if ("rotate".equals(((Method)genericDeclaration).getName()) && (classArray = ((Method)genericDeclaration).getParameterTypes()) != null && classArray.length == 3) {
                        rotate = genericDeclaration;
                        break;
                    }
                    ++n5;
                }
                genericDeclaration = Class.forName("java.awt.Toolkit");
                classArray = Class.forName("java.awt.Image");
                createCustomCursor = ((Class)genericDeclaration).getMethod("createCustomCursor", classArray, new Point().getClass(), new String().getClass());
                have2d = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

