/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alov.map.FloatRectangle;
import org.alov.util.LangDriver;
import org.alov.util.Strings;

public class Readers {
    public static String ENCODING = "";
    public static LangDriver langDriver = null;

    private Readers() {
    }

    public static Color readColor(InputStream inputStream) throws IOException {
        return new Color(inputStream.read(), inputStream.read(), inputStream.read());
    }

    public static long readLong(InputStream inputStream) throws IOException {
        return Readers.readInt(inputStream) | Readers.readInt(inputStream) << 32;
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble((long)inputStream.read() & 0xFFL | ((long)inputStream.read() & 0xFFL) << 8 | ((long)inputStream.read() & 0xFFL) << 16 | ((long)inputStream.read() & 0xFFL) << 24 | ((long)inputStream.read() & 0xFFL) << 32 | ((long)inputStream.read() & 0xFFL) << 40 | ((long)inputStream.read() & 0xFFL) << 48 | ((long)inputStream.read() & 0xFFL) << 56);
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(Readers.readInt(inputStream));
    }

    public static int readInt(InputStream inputStream) throws IOException {
        return inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
    }

    public static int readShort(InputStream inputStream) throws IOException {
        return inputStream.read() + (inputStream.read() << 8);
    }

    public static FloatRectangle readRectangleLittle(InputStream inputStream) throws IOException {
        return new FloatRectangle(Readers.readDouble(inputStream), Readers.readDouble(inputStream), Readers.readDouble(inputStream), Readers.readDouble(inputStream));
    }

    public static FloatRectangle readRect(InputStream inputStream) throws IOException {
        return new FloatRectangle(Readers.readFloat(inputStream), Readers.readFloat(inputStream), Readers.readFloat(inputStream), Readers.readFloat(inputStream));
    }

    public static String readUTFCond(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.read() != 0) {
            return dataInputStream.readUTF();
        }
        return null;
    }

    public static String Read2Unicode(String string, String string2) {
        if (string == null) {
            return "";
        }
        if (Strings.isNullOrBlank(string2)) {
            return langDriver == null ? string : langDriver.read2Unicode(string);
        }
        try {
            int n = string.length();
            byte[] byArray = new byte[string.length()];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)string.charAt(n2);
                ++n2;
            }
            string = new String(byArray, string2);
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }
}

