/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.io.Serializable;
import org.alov.util.ExDate;

public class TimeInterval
implements Serializable {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    private ExDate dateFrom;
    private ExDate dateTo;

    public TimeInterval() {
    }

    public TimeInterval(ExDate exDate, ExDate exDate2) {
        this.dateFrom = exDate;
        this.dateTo = exDate2;
    }

    public boolean contains(ExDate exDate) {
        return this.dateFrom.compareTo(exDate) <= 0 && this.dateTo.compareTo(exDate) >= 0;
    }

    public boolean intersects(ExDate exDate, ExDate exDate2) {
        return this.dateFrom.compareTo(exDate2) <= 0 && this.dateTo.compareTo(exDate) >= 0;
    }

    public int inInterval(ExDate exDate, ExDate exDate2) {
        return this.dateFrom.compareTo(exDate2) > 0 ? 2 : (this.dateTo.compareTo(exDate) < 0 ? -2 : 0);
    }

    public ExDate date1() {
        return this.dateFrom;
    }

    public ExDate date2() {
        return this.dateTo;
    }

    public void setDate1(ExDate exDate) {
        this.dateFrom = exDate;
    }

    public void setDate2(ExDate exDate) {
        this.dateTo = exDate;
    }

    public double getLength(int n) {
        if (this.dateFrom == null || this.dateTo == null) {
            return Double.NaN;
        }
        double d = this.dateFrom.days;
        double d2 = this.dateTo.days;
        d2 -= d;
        switch (n) {
            case 0: {
                return d2 / 365.25;
            }
            case 1: {
                return d2 / 30.4375;
            }
            case 2: {
                return d2;
            }
            case 3: {
                return d2 / 0.041666666666666664;
            }
            case 4: {
                return d2 / 6.944444444444444E-4;
            }
            case 5: {
                return d2 / 1.1574074074074073E-5;
            }
        }
        return Double.NaN;
    }

    public String toString() {
        return this.dateFrom.toString() + " / " + this.dateTo.toString();
    }
}

