/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import org.alov.map.StatusListener;

public class Animation
extends Canvas
implements Runnable,
ImageObserver,
StatusListener {
    private Image image;
    private boolean stop = true;
    private boolean running = false;
    private boolean isStill = true;
    private int width;
    private int height;
    private int delay = 300;
    private int proxyOperCount = 0;

    public void setImage(Image image, int n, int n2) {
        this.image = image;
        this.width = n;
        this.height = n2;
    }

    public void showImage() {
        this.delay = 1000;
        this.showAnimation();
        this.isStill = true;
    }

    public void showAnimation() {
        if (!this.running) {
            this.isStill = false;
            this.running = true;
            this.stop = false;
            new Thread((Runnable)this, "Animation update thread").start();
            this.setVisible(true);
        }
    }

    public void hideAnimation() {
        this.running = false;
        this.stop = true;
        this.setVisible(false);
    }

    public void paint(Graphics graphics) {
        if (this.running) {
            this.paintImage(graphics);
        }
    }

    private void paintImage(Graphics graphics) {
        if (graphics != null && this.image != null) {
            Dimension dimension = this.getSize();
            int n = this.image.getWidth(null);
            int n2 = this.image.getHeight(null);
            if (n > 0 && n2 > 0) {
                int n3 = (dimension.width - n) / 2;
                int n4 = (dimension.height - n2) / 2;
                graphics.drawImage(this.image, n3, n4, null);
                this.stop = this.isStill;
            }
        }
    }

    public void run() {
        while (!this.stop) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                Object var3_4;
                try {
                    this.paintImage(graphics);
                    var3_4 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    var3_4 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.repaint();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public void afterProjectLoaded(boolean bl) {
    }

    public void notifyStatus(int n, Object object) {
        if (object == null) {
            if (n == 10) {
                ++this.proxyOperCount;
                this.showAnimation();
            } else if (n == 11) {
                --this.proxyOperCount;
                if (this.proxyOperCount <= 0) {
                    this.hideAnimation();
                    this.proxyOperCount = 0;
                }
            }
        }
    }
}

