/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteAttribute;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.FieldDef;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.StatusListener;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.EditForm;
import org.alov.viewer.FrameAlign;
import org.alov.viewer.GridCellEventListener;
import org.alov.viewer.LightForm;
import org.alov.viewer.LightGrid;

public class FrameRes
extends FrameAlign
implements ActionListener,
GridCellEventListener,
CarteHostListener,
CarteAttribute,
StatusListener {
    private static final String PAR_SHOWONMAP = "showonmap";
    private static final String PAR_CLOSEONEXTENTCHANGE = "close_on_extentchange";
    private static final String BTN_WEBLINK = "btn_weblink";
    private static final String BTN_SHOWWEBLINK = "btn_showweblink";
    private static final String BTN_ONMAP = "btn_onmap";
    private static final String BTN_CLOSE = "btn_close";
    private static final String LBL_WEBLINK = "lbl_weblink";
    private static final String LBL_RECNO = "lbl_recno";
    private static final String BTN_NEXT = "btn_next";
    private static final String BTN_PREVIOUS = "btn_previous";
    private static final String BTN_FIRSTRECORD = "btn_firstrecord";
    private static final String BTN_LASTRECORD = "btn_lastrecord";
    private static final String BTN_APPLY = "btn_apply";
    private static final String BTN_APPLYALLRECORDS = "btn_applyallrecords";
    private String currWebLink = null;
    private int fi_description = 0;
    private int fi_description_original = 0;
    private boolean showOnClick = false;
    private boolean closeOnExtentChange = false;
    protected Carte map = null;
    protected LayerVector layer;
    protected LightGrid sg = null;
    protected LightForm lf = null;
    protected EditForm ef = null;
    private int minWidth = 330;
    private int xPos;
    private int yPos;
    private int wPos;
    private int hPos = -1;

    public FrameRes() {
        this.enableEvents(1L);
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n = componentEvent.getID();
        switch (n) {
            case 101: {
                Rectangle rectangle = this.getBounds();
                if (rectangle.width < this.minWidth) {
                    rectangle.width = this.minWidth;
                }
                if (rectangle.height < 300) {
                    rectangle.height = 300;
                }
                super.setBounds(rectangle);
                if (null == this.layer || null == this.sg) {
                    return;
                }
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.sg.colCount) {
                    n2 += this.sg.getColWidth(n3);
                    ++n3;
                }
                int n4 = this.sg.getViewportSize().width - n2;
                this.sg.setColumnWidth(this.fi_description, this.sg.getColWidth(this.fi_description) + n4 >= this.fi_description_original ? this.sg.getColWidth(this.fi_description) + n4 : this.fi_description_original);
                this.sg.endUpdate();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Component) {
            String string = ((Component)object).getName();
            if (string.equalsIgnoreCase(BTN_WEBLINK) || string.equalsIgnoreCase(BTN_SHOWWEBLINK)) {
                this.map.showURL(this.currWebLink);
            } else if (string.equalsIgnoreCase(BTN_ONMAP)) {
                this.showOnMap();
            } else if (string.equalsIgnoreCase(BTN_CLOSE)) {
                ((Component)this).setVisible(false);
            } else if (this.lf != null) {
                if (string.equalsIgnoreCase(BTN_NEXT)) {
                    this.lf.next();
                } else if (string.equalsIgnoreCase(BTN_PREVIOUS)) {
                    this.lf.previous();
                } else if (string.equalsIgnoreCase(BTN_FIRSTRECORD)) {
                    this.lf.firstRecord();
                } else if (string.equalsIgnoreCase(BTN_LASTRECORD)) {
                    this.lf.lastRecord();
                }
                this.setLabels(this.lf.getCell(this.lf.colCount - 1, this.lf.currRow), this.lf.currRow + ":" + (this.lf.rowCount - 1));
            } else if (this.sg != null) {
                if (string.equalsIgnoreCase(BTN_NEXT)) {
                    this.sg.next();
                } else if (string.equalsIgnoreCase(BTN_PREVIOUS)) {
                    this.sg.previous();
                } else if (string.equalsIgnoreCase(BTN_FIRSTRECORD)) {
                    this.sg.firstRecord();
                } else if (string.equalsIgnoreCase(BTN_LASTRECORD)) {
                    this.sg.lastRecord();
                } else if (string.equalsIgnoreCase(BTN_APPLYALLRECORDS)) {
                    if (this.ef != null && this.ef.wasEdited) {
                        this.ef.saveCurRow();
                        this.sg.setGridColumn(this.ef.row);
                        this.sg.updateAll();
                    }
                } else if (string.equalsIgnoreCase(BTN_APPLY)) {
                    if (this.ef != null && this.ef.wasEdited) {
                        this.sg.lastCurrRow = this.sg.currRow;
                        this.ef.saveCurRow();
                        this.sg.setGridRow(this.ef.row);
                        this.sg.updateAll();
                    }
                    if (this.sg.wasEdited) {
                        this.saveChangesToLayer();
                        this.map.updateMap();
                    }
                }
            }
        }
    }

    private void setLabels(String string, String string2) {
        Component component = MapUtils.findComp(this, LBL_RECNO);
        if (component instanceof Label) {
            ((Label)component).setText(string2);
        }
        if (Strings.isNullOrBlank(string)) {
            return;
        }
        Record record = this.layer.findById(string);
        this.currWebLink = this.map.getProject().getWebLink(this.layer, record);
        if (this.currWebLink == null) {
            this.currWebLink = "";
        }
        if ((component = MapUtils.findComp(this, BTN_SHOWWEBLINK)) != null) {
            component.setEnabled(!Strings.isNullOrBlank(this.currWebLink));
        }
        if ((component = MapUtils.findComp(this, BTN_WEBLINK)) != null) {
            component.setEnabled(!Strings.isNullOrBlank(this.currWebLink));
        }
        if ((component = MapUtils.findComp(this, LBL_WEBLINK)) instanceof Label) {
            ((Label)component).setText(this.currWebLink);
        }
    }

    private void showOnMap() {
        String string = null;
        if (this.sg != null) {
            string = this.sg.getCell(this.sg.colCount - 1, this.sg.currRow);
        } else if (this.lf != null) {
            string = this.lf.getCell(this.lf.colCount - 1, this.lf.currRow);
        }
        if (!Strings.isNullOrBlank(string)) {
            this.map.selectObject(this.layer.getName(), string);
        }
    }

    private void saveChangesToLayer() {
        Record record = null;
        int n = 0;
        int n2 = 1;
        while (n2 < this.sg.rowCount) {
            if (this.sg.rowWasEdited[n2]) {
                record = this.layer.findById(this.sg.getCell(this.sg.colCount - 1, n2));
                int n3 = 0;
                while (n3 < this.sg.colCount - 1) {
                    n = this.sg.getColDefIndex(n3);
                    record.setField(n, this.sg.getCell(n3, n2));
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public void gridCellClicked(Point point, InputEvent inputEvent) {
        this.setLabels(this.sg.getCell(this.sg.colCount - 1, this.sg.currRow), this.sg.currRow + ":" + (this.sg.rowCount - 1));
        if (this.sg.lastCurrRow != this.sg.currRow) {
            if (this.ef != null) {
                if (this.ef.wasEdited) {
                    this.ef.saveCurRow();
                    this.sg.setGridRow(this.ef.row);
                    this.sg.updateAll();
                }
                String[] stringArray = this.sg.getGridRow(this.sg.currRow);
                this.ef.setRow(stringArray);
            }
            this.sg.lastCurrRow = this.sg.currRow;
        }
        if (this.showOnClick) {
            this.showOnMap();
        }
    }

    private void loadToGrid(LayerVector layerVector, Vector vector) {
        int n;
        String string;
        if (this.sg == null && this.lf == null) {
            return;
        }
        int n2 = layerVector.getFieldCount();
        int n3 = vector.size();
        this.layer = layerVector;
        boolean bl = this.sg != null;
        FontMetrics fontMetrics = null;
        int n4 = 0;
        if (bl) {
            this.sg.beginUpdate();
            Graphics graphics = this.sg.getGraphics();
            fontMetrics = graphics.getFontMetrics();
            n4 = fontMetrics.getHeight() + 2;
            graphics.dispose();
            this.sg.colType = new int[n2];
            this.sg.cols = new Vector();
            this.sg.setDimension(1, 1, n4);
            this.sg.setDimension(n2 + 1, 1, n4);
        } else {
            this.lf.colType = new int[n2];
            this.lf.setDimension(n2 + 1, n3 + 1);
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            FieldDef fieldDef = layerVector.getFieldDef(n6);
            if (fieldDef != null && fieldDef.visible) {
                if (n6 == this.layer.fi_description) {
                    this.fi_description = n6;
                }
                string = fieldDef.label;
                if (bl) {
                    this.sg.colType[n5] = fieldDef.type;
                    int n7 = fontMetrics.stringWidth(string + "W");
                    this.sg.setColumnWidth(n5, n7);
                    this.sg.setCell(n5, 0, string);
                    this.sg.colType[n5] = fieldDef.type;
                    this.sg.addColDef(string, fieldDef.type, fieldDef.editable, fieldDef.index);
                } else {
                    this.lf.colType[n5] = fieldDef.type;
                    this.lf.setCell(n5, 0, string);
                }
                ++n5;
            }
            ++n6;
        }
        if (bl) {
            this.sg.setRowHeight(0, n4);
            this.sg.setDimension(n5 + 1, n3 + 1, n4);
            this.sg.setCell(n5, 0, "");
            if (n5 > 0) {
                this.sg.setColumnWidth(n5, 0);
            }
        } else {
            this.lf.setDimension(n5 + 1, n3 + 1);
            this.lf.setCell(n5, 0, "");
        }
        int n8 = 0;
        while (n8 < n3) {
            Record record = (Record)vector.elementAt(n8);
            n = 0;
            if (n5 > 0) {
                int n9 = 0;
                while (n9 < n2) {
                    if (layerVector.getFieldDef((int)n9).visible) {
                        string = layerVector.getFieldString(record, n9);
                        if (bl) {
                            int n10 = fontMetrics.stringWidth(string + "W");
                            if (n10 > this.sg.getColWidth(n)) {
                                this.sg.setColumnWidth(n, n10);
                            }
                            this.sg.setCell(n, n8 + 1, string);
                        } else {
                            this.lf.setCell(n, n8 + 1, string);
                        }
                        ++n;
                    }
                    ++n9;
                }
            }
            if (bl) {
                this.fi_description_original = this.sg.getColWidth(this.fi_description);
                this.sg.setCell(n5, n8 + 1, String.valueOf(record.getId()));
            } else {
                this.lf.setCell(n5, n8 + 1, String.valueOf(record.getId()));
            }
            ++n8;
        }
        if (bl) {
            this.sg.endUpdate();
            int n11 = 0;
            n = 0;
            while (n < n5) {
                n11 += this.sg.getColWidth(n) + 1;
                ++n;
            }
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(10, 10, (n11 += this.sg.getVScrollbarWidth()) + 10 > dimension.width ? dimension.width - 10 : (n11 < this.minWidth ? this.minWidth : n11), 300);
            this.processComponentEvent(new ComponentEvent(this, 101));
            this.sg.setUnEdited();
            if (this.ef != null) {
                int n12 = this.sg.cols.size();
                boolean[] blArray = new boolean[n12];
                int n13 = 0;
                while (n13 < n12) {
                    blArray[n13] = this.sg.getColDefEditable(n13);
                    ++n13;
                }
                this.ef.setEditable(blArray);
                String[] stringArray = this.sg.getGridRow(0);
                this.ef.loadLabels(stringArray);
                this.sg.lastCurrRow = 0;
            }
            this.gridCellClicked(null, null);
        } else {
            this.lf.loadLabels();
            this.lf.updateView();
            this.setLabels(this.lf.getCell(this.lf.colCount - 1, this.lf.currRow), this.lf.currRow + ":" + (this.lf.rowCount - 1));
            if (this.hPos > 0) {
                this.setBounds(this.xPos, this.yPos, this.wPos, this.hPos);
            }
        }
    }

    private void setBtn(String string) {
        MapUtils.addActionListener(this, this, string);
        Component component = MapUtils.findComp(this, string);
        if (component != null && component instanceof Button) {
            ((Button)component).setLabel(this.map.getResource(((Button)component).getLabel()));
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        this.map = carteHost.getMapByName(xmlElement);
        this.map.statusListeners.addElement(this);
        this.showOnClick = XmlUtils.getBoolean(PAR_SHOWONMAP, xmlElement, false);
        this.closeOnExtentChange = XmlUtils.getBoolean(PAR_CLOSEONEXTENTCHANGE, xmlElement, false);
        String string = XmlUtils.getString("bounds", xmlElement, null);
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                this.xPos = Integer.valueOf(stringTokenizer.nextToken());
                this.yPos = Integer.valueOf(stringTokenizer.nextToken());
                this.wPos = Integer.valueOf(stringTokenizer.nextToken());
                this.hPos = Integer.valueOf(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                this.hPos = -1;
            }
        }
    }

    public void stop() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void showAttributes(LayerVector layerVector, Vector vector) {
        if (layerVector != null && layerVector.getMap() == this.map && MapUtils.isNotEmpty(vector)) {
            this.loadToGrid(layerVector, vector);
            this.show();
            this.requestFocus();
        }
    }

    public void afterProjectLoaded(boolean bl) {
        if (bl) {
            this.setTitle(this.map.getResource("Attribute Data"));
            this.setBtn(BTN_SHOWWEBLINK);
            this.setBtn(BTN_WEBLINK);
            this.setBtn(BTN_ONMAP);
            this.setBtn(BTN_CLOSE);
            this.setBtn(BTN_NEXT);
            this.setBtn(BTN_PREVIOUS);
            this.setBtn(BTN_FIRSTRECORD);
            this.setBtn(BTN_LASTRECORD);
            this.setBtn(BTN_APPLY);
            this.setBtn(BTN_APPLYALLRECORDS);
            this.sg = (LightGrid)MapUtils.findComp(this, "lightgrid");
            if (this.sg != null) {
                this.sg.setGridCellEventListener(this);
                this.sg.colSizing = true;
                this.ef = (EditForm)MapUtils.findComp(this, "editform");
                if (this.ef != null) {
                    Dimension dimension = this.ef.getSize();
                    this.minWidth += dimension.width;
                }
            } else {
                this.lf = (LightForm)MapUtils.findComp(this, "lightform");
            }
            this.addWindowListener(new WindowEventHandler());
            this.pack();
        }
    }

    public void notifyStatus(int n, Object object) {
        if (this.closeOnExtentChange && n == 109) {
            ((Component)this).setVisible(false);
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)FrameRes.this).setVisible(false);
        }
    }
}

