/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.MapUtils;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Symbol;
import org.alov.viewer.LayerCtl;
import org.alov.viewer.LayerCtlImpl;
import org.alov.viewer.LayerItemButton;

class LayerControlItem {
    int cwidth = 120;
    private static final int buttonSize = 10;
    private static final int checkX = 2;
    private static final int expandX = 14;
    private static final int captionX = 24;
    private boolean drawSeparator = false;
    private boolean drawSelection = true;
    private int headHeight;
    private Color foreColor = Color.black;
    Color backColor = Color.white;
    private Color networkColor;
    private Color selectionColor = this.networkColor = new Color(208, 208, 238);
    private Color disabledColor = Color.gray;
    private Color failureColor = Color.gray;
    private Font fontBold;
    private Font fontPlain;
    private Image imageClock = null;
    private Image imageZoomIn = null;
    private Image imageZoomOut = null;
    private Image imageNetwork = null;
    private Image imageOutExt = null;
    private Image imageKey = null;
    private Rectangle bounds = new Rectangle();
    private int itemSampleHeight;
    Object animation = null;
    private Layer layer;
    LayerCtlImpl layerCtl;
    private Vector visibleRenderers = new Vector();
    private Vector buttons = new Vector();

    LayerControlItem(Layer layer, LayerCtlImpl layerCtlImpl) {
        this.layerCtl = layerCtlImpl;
        this.layer = layer;
        if (layerCtlImpl != null) {
            this.foreColor = layerCtlImpl.getForeground();
            this.backColor = layerCtlImpl.getBackground();
            this.networkColor = layerCtlImpl.networkColor;
            this.selectionColor = layerCtlImpl.selectionColor;
            this.disabledColor = layerCtlImpl.disabledColor;
            this.failureColor = layerCtlImpl.failureColor;
            this.drawSeparator = layerCtlImpl.drawSeparator;
            this.drawSelection = layerCtlImpl.drawSelection;
            this.fontBold = layerCtlImpl.fontBold;
            this.fontPlain = layerCtlImpl.fontPlain;
            this.imageClock = layerCtlImpl.imageClock;
            this.imageZoomIn = layerCtlImpl.imageZoomIn;
            this.imageZoomOut = layerCtlImpl.imageZoomOut;
            this.imageNetwork = layerCtlImpl.imageNetwork;
            this.imageOutExt = layerCtlImpl.imageOutExt;
        } else {
            this.fontBold = MapUtils.defaultBoldFont;
            this.fontPlain = MapUtils.defaultPlainFont;
        }
    }

    private int calcControlWidth() {
        return this.layerCtl != null ? this.layerCtl.getWidth() : this.cwidth;
    }

    public void updateBounds(DisplayContext displayContext) {
        Layer layer = this.layer;
        this.visibleRenderers.removeAllElements();
        Graphics graphics = displayContext.getDrawToGraphics();
        if (graphics == null) {
            return;
        }
        int n = this.calcControlWidth();
        int n2 = 0;
        int n3 = 0;
        this.itemSampleHeight = 0;
        graphics.setFont(this.fontBold);
        this.headHeight = MapUtils.textHeight(this.layer.getName(), graphics, n - 24 - 4, this.layer.legendWrapText) + 4;
        graphics.setFont(MapUtils.defaultBoldFont);
        if (this.layer.isInvisibleInLegend(displayContext)) {
            n3 = 0;
        } else if (this.layer.notPrepared || this.layer.metadata.loadFailed || !this.layer.isPassResolved() || this.layer.isOutOfRange(displayContext) != 0 || this.layer.isOutOfExtent(displayContext) || this.layer.records.size() < 1) {
            n3 = this.headHeight;
        } else {
            Vector vector = this.layer.renderers;
            int n4 = vector.size();
            int n5 = 0;
            while (n5 < n4) {
                Renderer renderer = (Renderer)vector.elementAt(n5);
                if (renderer.isRendererVisible(displayContext) && renderer.legendVisible) {
                    renderer.sampleHeight = this.getRendererHeight(renderer, graphics, n - 14);
                    if (renderer.sampleHeight > 0) {
                        n2 += renderer.sampleHeight + 3;
                        if (renderer.label != null) {
                            renderer.rendLabelHeight = MapUtils.textHeight(renderer.label, graphics, n - 14, this.layer.legendWrapText);
                            n2 += renderer.rendLabelHeight;
                        }
                        this.visibleRenderers.addElement(renderer);
                    }
                }
                ++n5;
            }
            this.itemSampleHeight = n2;
            n3 = layer.legendExpanded ? this.headHeight + this.itemSampleHeight : this.headHeight;
        }
        this.bounds = new Rectangle(0, 0, n, n3);
    }

    int getRendererHeight(Renderer renderer, Graphics graphics, int n) {
        int n2;
        int n3 = 0;
        if (renderer instanceof RendererChart) {
            int n4 = MapUtils.getCurrentFontHeight(graphics);
            n3 = n4 > 20 ? n4 : 20;
            n3 = ((RendererChart)renderer).fields == null ? 0 : n3 * ((RendererChart)renderer).fields.length;
        } else if (renderer instanceof RendererLabel) {
            int n5 = renderer.getSymbolCount();
            if (n5 > 0) {
                int n6 = 0;
                while (n6 < n5) {
                    Symbol symbol = renderer.getSymbol(n6);
                    if (symbol.legendVisible && symbol.font != null) {
                        graphics.setFont(symbol.font);
                        int n7 = MapUtils.getCurrentFontHeight(graphics);
                        symbol.sampleSize.setSize(n7, n7);
                        n3 += n7;
                    }
                    ++n6;
                }
                graphics.setFont(MapUtils.defaultBoldFont);
            }
        } else if ((renderer instanceof RendererGrad || renderer instanceof RendererDef || renderer instanceof RendererDot) && (n2 = renderer.getSymbolCount()) > 0) {
            int n8 = 0;
            while (n8 < n2) {
                Symbol symbol = renderer.getSymbol(n8);
                int n9 = 1;
                if (!symbol.drawMarker) {
                    n9 = renderer.layer.objectType < 1 ? renderer.layer.legendObjectType : renderer.layer.objectType;
                }
                this.calcSymbolSize(symbol, graphics, n, n9, renderer.layer.legendWrapText);
                n3 += Math.max(symbol.sampleSize.height, symbol.sampleSize.width);
                ++n8;
            }
        }
        return n3;
    }

    private void calcSymbolSize(Symbol symbol, Graphics graphics, int n, int n2, boolean bl) {
        if (symbol.legendVisible) {
            int n3 = 0;
            if (n2 == 1) {
                n3 = (symbol.image == null ? symbol.size : symbol.image.getHeight(MapUtils.getGlobalImageObserver())) + 2;
            }
            if (n3 < 20) {
                n3 = 20;
            }
            int n4 = MapUtils.textHeight(symbol.label, graphics, n - n3 - 4, bl);
            symbol.sampleSize.setSize(n3, n4);
        } else {
            symbol.sampleSize.setSize(0, 0);
        }
    }

    public void setLocation(int n, int n2) {
        this.bounds.x = n;
        this.bounds.y = n2;
    }

    public void setSize(int n, int n2) {
        this.bounds.width = n;
        this.bounds.height = n2;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Layer getLayer() {
        return this.layer;
    }

    private static void drawCheckbox(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.drawRect(n, n2, n3, n4);
        if (bl) {
            graphics.fillRect(n + 2, n2 + 2, n3 - 3, n4 - 3);
        }
    }

    void paint(boolean bl, boolean bl2, DisplayContext displayContext) {
        Graphics graphics = displayContext.getDrawToGraphics();
        try {
            boolean bl3;
            this.buttons.removeAllElements();
            int n = this.bounds.x;
            int n2 = this.bounds.y;
            int n3 = 0;
            int n4 = this.bounds.width;
            int n5 = this.bounds.height;
            int n6 = this.bounds.x;
            int n7 = this.bounds.y;
            int n8 = n4;
            boolean bl4 = false;
            if (n5 <= 0 || n4 <= 0) {
                return;
            }
            int n9 = n7 + (this.headHeight - 10) / 2;
            int n10 = n6 + 6;
            int n11 = n6 + 2;
            if (this.layer.metadata.networkActivity) {
                graphics.setColor(this.networkColor);
            } else if (bl && this.drawSelection) {
                graphics.setColor(this.selectionColor);
            } else {
                graphics.setColor(this.backColor);
            }
            graphics.fillRect(n6, n7, n4, n5);
            if (this.drawSeparator) {
                graphics.setColor(this.disabledColor);
                graphics.drawLine(n6, n7 + n5 - 1, n4, n7 + n5 - 1);
            }
            int n12 = this.layer.isOutOfRange(displayContext);
            boolean bl5 = bl3 = this.layer.metadata.loadFailed || !this.layer.isPassResolved() || n12 != 0 || this.layer.notPrepared;
            if (this.layer.metadata.loadFailed) {
                graphics.setColor(this.failureColor);
                graphics.setFont(this.fontBold);
                graphics.drawString("!", n10 + 4, n7 + this.headHeight - 4);
            } else {
                graphics.setColor(this.foreColor);
                if (this.layer.metadata.networkActivity && this.imageNetwork != null) {
                    bl2 = false;
                    graphics.drawImage(this.imageNetwork, n11, n9, MapUtils.getGlobalImageObserver());
                }
                if (!this.layer.isPassResolved()) {
                    if (this.imageKey != null) {
                        graphics.drawImage(this.imageKey, n11, n9, MapUtils.getGlobalImageObserver());
                    } else {
                        graphics.drawOval(n10, n9, 4, 4);
                        graphics.drawLine(n10 + 4, n9 + 2, n10 + 10, n9 + 2);
                        graphics.drawLine(n10 + 10, n9 + 2, n10 + 10, n9 + 4);
                    }
                } else if (n12 != 0) {
                    if (Math.abs(n12) == 2) {
                        if (this.imageClock == null) {
                            graphics.drawOval(n10, n9, 10, 10);
                            graphics.drawLine(n10 + 5, n9, n10 + 5, n9 + 5);
                            graphics.drawLine(n10 + 3, n9 + 3, n10 + 5, n9 + 5);
                        } else {
                            graphics.drawImage(this.imageClock, n11, n9, MapUtils.getGlobalImageObserver());
                        }
                    } else if (this.imageZoomIn != null && n12 > 0) {
                        graphics.drawImage(this.imageZoomIn, n11, n9, MapUtils.getGlobalImageObserver());
                    } else if (this.imageZoomOut != null && n12 < 0) {
                        graphics.drawImage(this.imageZoomOut, n11, n9, MapUtils.getGlobalImageObserver());
                    } else {
                        graphics.drawOval(n10, n9, 8, 8);
                        graphics.drawLine(n10 + 2, n9 + 4, n10 + 6, n9 + 4);
                        if (n12 > 0) {
                            graphics.drawLine(n10 + 4, n9 + 2, n10 + 4, n9 + 6);
                        }
                        graphics.drawLine(n10 + 7, n9 + 7, n10 + 9, n9 + 9);
                    }
                } else if (this.layer.isOutOfExtent(displayContext)) {
                    if (this.imageOutExt != null) {
                        graphics.drawImage(this.imageOutExt, n11, n9, MapUtils.getGlobalImageObserver());
                    } else {
                        graphics.drawRect(n10, n9, 6, 6);
                        graphics.drawRect(n10 + 3, n9 + 3, 6, 6);
                    }
                } else {
                    graphics.setColor(this.foreColor);
                    if (bl2) {
                        if (this.layer.visible_always) {
                            graphics.setColor(this.disabledColor);
                        }
                        LayerControlItem.drawCheckbox(graphics, n6 + 2, n9, 9, 9, this.layer.isVisible());
                        if (!this.layer.visible_always) {
                            this.buttons.addElement(new LayerItemButton(new Rectangle(n6 + 2, n9 - n7, 9, 9), this.layer));
                        }
                        if (this.layer.visible_always) {
                            graphics.setColor(this.foreColor);
                        }
                    }
                    Vector vector = this.visibleRenderers;
                    int n13 = vector.size();
                    n10 += 10;
                    if (this.layer.legendExpanded) {
                        Object object;
                        if ((n13 > 0 || this.layer instanceof LayerGroup) && bl2) {
                            int n14 = 10;
                            int[] nArray = new int[]{n10, n10 + n14 / 2, n10 + n14};
                            object = new int[]{n9 + n14 / 3, n9 + n14 / 3 + n14 / 2, n9 + n14 / 3};
                            graphics.fillPolygon(nArray, (int[])object, 3);
                        }
                        if (!bl3) {
                            n3 += this.headHeight;
                            graphics.setFont(this.fontPlain);
                            Rectangle rectangle = new Rectangle();
                            int n15 = 0;
                            while (n15 < n13) {
                                object = (Renderer)vector.elementAt(n15);
                                graphics.setColor(this.foreColor);
                                if (bl2 && ((Renderer)object).allowToggle && !this.layer.visible_always) {
                                    LayerControlItem.drawCheckbox(graphics, n6 + 2 + 2, n7 + n3 + 2, 7, 7, ((Renderer)object).enabled);
                                    this.buttons.addElement(new LayerItemButton(new Rectangle(n6 + 2, n3 + 2, 9, 9), object));
                                }
                                if (((Renderer)object).rendLabelHeight > 0) {
                                    MapUtils.drawString(graphics, ((Renderer)object).label, n6 + 14, n7 + n3, n8 - n6 - 14, ((Renderer)object).rendLabelHeight, this.layer.legendWrapText);
                                    n3 += ((Renderer)object).rendLabelHeight;
                                }
                                int n16 = ((Renderer)object).sampleHeight;
                                rectangle.setBounds(n6 + 14, n7 + n3, n4 - 14, n16);
                                LayerCtl.paintSample(graphics, rectangle, (Renderer)object);
                                n3 += n16;
                                if (n15 < n13 - 1 && n16 > 0) {
                                    graphics.setColor(this.disabledColor);
                                    graphics.drawLine(n6 + 5, n7 + n3 + 1, n6 + n4 - 6, n7 + n3 + 1);
                                    n3 += 3;
                                }
                                ++n15;
                            }
                        }
                    } else if ((n13 > 0 || this.layer instanceof LayerGroup) && bl2) {
                        graphics.drawRect(n6 + 2, n9, 9, 9);
                        int[] nArray = new int[]{n10, n10 + 5, n10};
                        int[] nArray2 = new int[]{n9, n9 + 5, n9 + 10};
                        graphics.fillPolygon(nArray, nArray2, 3);
                    }
                }
            }
            if (bl3) {
                if (this.layer.metadata.loadFailed) {
                    graphics.setColor(this.failureColor);
                } else {
                    graphics.setColor(this.disabledColor);
                }
            } else {
                graphics.setColor(this.foreColor);
            }
            graphics.setFont(this.fontBold);
            MapUtils.drawString(graphics, this.layer.getName(), n6 + 24 + 4, n7 - 2, n8 - n6 - 24 - 4, this.headHeight, this.layer.legendWrapText);
            if (bl && this.drawSelection) {
                graphics.setColor(this.foreColor);
                graphics.drawRect(n6, n7, n4 - 1, n5 - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isExpandButton(Point point) {
        return point.x > 14 && point.x < 24 && point.y < this.headHeight;
    }

    public Object getCheckboxObject(Point point) {
        int n = this.buttons.size();
        Object object = null;
        int n2 = 0;
        while (n2 < n) {
            LayerItemButton layerItemButton = (LayerItemButton)this.buttons.elementAt(n2);
            if (layerItemButton.rect.contains(point)) {
                object = layerItemButton.object;
                break;
            }
            ++n2;
        }
        return object;
    }

    void expandClicked() {
        this.layer.setExpanded(!this.layer.legendExpanded);
        this.bounds.height = this.layer.legendExpanded ? this.headHeight + this.itemSampleHeight : this.headHeight;
    }
}

