/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.DisplayContext;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Projection;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Shape;
import org.alov.map.StatusListener;
import org.alov.map.Symbol;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.LayerCtlImpl;

public class LayerCtl
extends ScrollPane
implements CarteHostListener,
StatusListener {
    private CarteHost host;
    private LayerCtlImpl impl = new LayerCtlImpl(this);
    private static final double[] ptCoords = new double[]{0.0, 0.0};
    private static final double[] lineCoords = new double[]{-6.0, -6.0, -2.0, 6.0, 2.0, -6.0, 6.0, 6.0};
    private static final double[] polygonCoords = new double[]{-5.0, -8.0, -3.0, -4.0, -8.0, -1.0, -3.0, 2.0, -5.0, 8.0, 4.0, 5.0, 8.0, 8.0, 8.0, -8.0, 4.0, -7.0};
    private static final Shape shpPoint = new Shape(ptCoords);
    private static final Shape shpLine = new Shape(lineCoords);
    private static final Shape shpPolygon = new Shape(polygonCoords);

    LayerCtl() {
        this.add(this.impl);
    }

    private Dimension minSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(this.impl.getPreferredSize());
        int n = this.getVScrollbarWidth();
        dimension.width += insets.right + insets.left;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    void setLayers(Vector vector) {
        this.impl.setLayers(vector);
    }

    void setMap(Carte carte) {
        this.impl.setMap(carte);
    }

    void setWidth(int n) {
        this.impl.legendWidth = n;
        this.impl.minSize = new Dimension(this.impl.legendWidth, 10);
    }

    void clear() {
        this.impl.clear();
    }

    void selectItem(String string) {
        this.impl.selectItem(string);
    }

    Layer getSelected() {
        return this.impl.getSelected();
    }

    public static BufferedImage paintLayers(Vector vector, DisplayContext displayContext, Color color, int n, int n2) {
        return LayerCtlImpl.paintLayers(vector, displayContext, color, n, n2);
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        Object object;
        this.host = carteHost;
        this.impl.selectionColor = XmlUtils.getColor("select_clr", xmlElement, this.impl.selectionColor);
        this.impl.disabledColor = XmlUtils.getColor("disabled_clr", xmlElement, SystemColor.textInactiveText);
        this.impl.failureColor = XmlUtils.getColor("err_color", xmlElement, SystemColor.textInactiveText);
        this.impl.networkColor = XmlUtils.getColor("net_color", xmlElement, this.impl.networkColor);
        this.impl.drawSeparator = XmlUtils.getBoolean("separator", xmlElement, false);
        this.impl.drawSelection = XmlUtils.getBoolean("selection", xmlElement, true);
        this.impl.fontBold = XmlUtils.getFont("font_bold", xmlElement, MapUtils.defaultBoldFont);
        this.impl.fontPlain = XmlUtils.getFont("font_plain", xmlElement, MapUtils.defaultPlainFont);
        this.impl.imageClock = carteHost.getImage(XmlUtils.getString("image_clock", xmlElement, null));
        this.impl.imageZoomIn = carteHost.getImage(XmlUtils.getString("image_zoomin", xmlElement, null));
        this.impl.imageZoomOut = carteHost.getImage(XmlUtils.getString("image_zoomout", xmlElement, null));
        this.impl.imageNetwork = carteHost.getImage(XmlUtils.getString("image_network", xmlElement, null));
        this.impl.imageOutExt = carteHost.getImage(XmlUtils.getString("image_outext", xmlElement, null));
        this.impl.imageKey = carteHost.getImage(XmlUtils.getString("image_key", xmlElement, null));
        String string = XmlUtils.getString("sync_with", xmlElement, null);
        if (string != null) {
            object = new StringTokenizer(string, " ,;");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                this.impl.sync_with.addElement(string2);
            }
        }
        this.clear();
        object = carteHost.getMapByName(xmlElement);
        ((Carte)object).statusListeners.addElement(this);
        this.setMap((Carte)object);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bl) {
        if (bl) {
            Project project = this.impl.map.getProject();
            if (project != null) {
                this.impl.setLayers(project.layers);
                this.impl.selectItem(project.startLayer);
            }
            int n = this.impl.sync_with.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.impl.sync_with.elementAt(n2);
                Component component = this.host.findComponent(string);
                if (component instanceof LayerCtl) {
                    this.impl.sync_with.setElementAt(component, n2);
                }
                ++n2;
            }
        }
    }

    public void notifyStatus(int n, Object object) {
        if (n == 106 || (n == 10 || n == 11) && object != null || n == -8 || n == 108 || n == 109 || n == 107) {
            this.impl.mapUpdated();
        } else if (n == 111 || n == 116) {
            String string = this.impl.map.getActiveLayer().id;
            Project project = this.impl.map.getProject();
            this.impl.setLayers(project.layers);
            this.impl.selectItem(string);
        } else if (n == 101 && object != null && object instanceof String) {
            if (this.impl.sync_with.size() > 0) {
                this.impl.synchronyzeLegends((String)object);
            }
        } else if (n == 118 && object != null) {
            this.impl.changeLayerVisibility((Object[])object);
            if (this.impl.map != null) {
                this.impl.map.updateMap();
            }
            this.impl.repaint();
        }
    }

    public static void paintSample(Graphics graphics, Rectangle rectangle, Renderer renderer) {
        if (renderer instanceof RendererGrad || renderer instanceof RendererDef || renderer instanceof RendererDot) {
            Shape shape = null;
            Color color = graphics.getColor();
            Projection projection = new Projection();
            int n = renderer.getSymbolCount();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Symbol symbol = renderer.getSymbol(n3);
                if (symbol.legendVisible) {
                    int n4 = 1;
                    if (!symbol.drawMarker) {
                        int n5 = n4 = renderer.layer.objectType < 1 ? renderer.layer.legendObjectType : renderer.layer.objectType;
                    }
                    if (renderer.layer.legendSymbolShape != null) {
                        shape = renderer.layer.legendSymbolShape;
                    } else {
                        switch (n4) {
                            case 1: {
                                shape = shpPoint;
                                break;
                            }
                            case 2: {
                                shape = shpLine;
                                break;
                            }
                            case 3: {
                                shape = shpPolygon;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    int n6 = symbol.sampleSize.width;
                    int n7 = Math.max(n6, symbol.sampleSize.height);
                    projection.shift.x = rectangle.x + n6 / 2;
                    projection.shift.y = rectangle.y + n7 / 2 + n2;
                    shape.paintShape(graphics, projection, symbol, n4, rectangle.getSize());
                    graphics.setColor(color);
                    MapUtils.drawString(graphics, symbol.label, rectangle.x + n6 + 4, rectangle.y + n2, rectangle.width - n6 - 4, n7, renderer.layer.legendWrapText);
                    n2 += n7;
                }
                ++n3;
            }
        } else if (renderer instanceof RendererChart) {
            RendererChart rendererChart = (RendererChart)renderer;
            rendererChart.paintSample(graphics, rectangle);
        } else if (renderer instanceof RendererLabel) {
            int n = rectangle.x;
            int n8 = rectangle.y;
            int n9 = renderer.getSymbolCount();
            int n10 = 0;
            Font font = graphics.getFont();
            int n11 = 0;
            while (n11 < n9) {
                Symbol symbol = renderer.getSymbol(n11);
                if (symbol.legendVisible && symbol.font != null) {
                    String string = symbol.label;
                    graphics.setFont(symbol.font);
                    int n12 = symbol.sampleSize.height;
                    if (symbol.outline) {
                        graphics.setColor(symbol.outlineColor);
                        graphics.drawString(string, rectangle.x + 11, rectangle.y + n12 + n10 + 1);
                    }
                    graphics.setColor(symbol.fillColor);
                    graphics.drawString(string, rectangle.x + 10, rectangle.y + n12 + n10);
                    n10 += n12;
                }
                ++n11;
            }
            graphics.setFont(font);
        }
    }
}

