/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.SystemColor;

public class LightForm
extends ScrollPane {
    public static final String LIGHTFORM = "lightform";
    private static final byte HEADER = 0;
    private static final byte SELECTED = 1;
    private static final byte NORMAL = 2;
    private static final int EPS = 5;
    protected String[][] cells = null;
    protected int[] colType = null;
    private boolean dontRefresh = false;
    private boolean needUpdate;
    public int colCount = 0;
    public int rowCount = 0;
    public int currRow = 1;
    private Panel panel = null;
    private int defHeight = 23;

    public LightForm() {
        super(1);
        this.setName(LIGHTFORM);
        this.setBackground(SystemColor.window);
        this.panel = new Panel();
        this.panel.setLayout(null);
        this.panel.setSize(1000, 1000);
        this.add(this.panel);
    }

    public void firstRecord() {
        this.currRow = 1;
        this.updateView();
    }

    public void lastRecord() {
        this.currRow = this.rowCount - 1;
        this.updateView();
    }

    public void next() {
        if (this.currRow < this.rowCount - 1) {
            ++this.currRow;
            this.updateView();
        }
    }

    public void previous() {
        if (this.currRow > 1) {
            --this.currRow;
            this.updateView();
        }
    }

    protected void loadLabels() {
        this.panel.removeAll();
        Graphics graphics = this.getGraphics();
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize() + 1);
        this.panel.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.defHeight = fontMetrics.getHeight() + 2;
        int n = 2;
        int n2 = 2;
        Label label = null;
        int n3 = 0;
        while (n3 < this.colCount - 1) {
            label = new Label(this.getCell(n3, 0));
            label.setFont(font);
            this.panel.add(label);
            label.setBounds(n, n2, 100, this.defHeight);
            label = new Label();
            this.panel.add(label);
            label.setBounds(n + 102, n2, 100, this.defHeight);
            n2 = n2 + this.defHeight + 2;
            ++n3;
        }
    }

    protected void updateView() {
        Label label = null;
        Graphics graphics = this.panel.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n2 < this.colCount - 1) {
            label = (Label)this.panel.getComponent(n3);
            String string = this.getCell(n2, this.currRow);
            int n4 = fontMetrics.stringWidth(string + "W") + 10;
            label.setText(string);
            label.setSize(n4, this.defHeight);
            if (n4 > n) {
                n = n4;
            }
            ++n2;
            n3 += 2;
        }
        this.panel.setSize(104 + n, (this.defHeight + 2) * this.colCount);
        this.doLayout();
        this.repaint();
    }

    public String getCell(int n, int n2) {
        if (n >= this.colCount || n2 >= this.rowCount || n < 0 || n2 < 0) {
            return null;
        }
        return this.cells[n2][n];
    }

    public void setCell(int n, int n2, String string) {
        if (n < this.colCount && n2 < this.rowCount && n >= 0 && n2 >= 0) {
            this.cells[n2][n] = string;
        }
    }

    public int getCurrRow() {
        return this.currRow;
    }

    public void setCurrRow(int n) {
        if (this.currRow != n) {
            this.currRow = n;
        }
    }

    public boolean setDimension(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.colCount == n && this.rowCount == n2) {
            return false;
        }
        String[][] stringArray = new String[n2][n];
        int n3 = n < this.colCount ? n : this.colCount;
        int n4 = 0;
        while (n4 < n3) {
            stringArray[0][n4] = this.cells[0][n4];
            ++n4;
        }
        this.colCount = n;
        this.rowCount = n2;
        this.cells = stringArray;
        this.currRow = 1;
        return true;
    }
}

