/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import org.alov.data.SQLConst;
import org.alov.viewer.GridCellEventListener;

public class LightGrid
extends ScrollPane
implements AdjustmentListener {
    private static final int DEFAULT_COLUMN_WIDTH = 40;
    private static final int DEFAULT_ROW_HEIGHT = 17;
    public int rowHeight = 17;
    public static final String _GRID = "lightgrid";
    private static final byte HEADER = 0;
    private static final byte SELECTED = 1;
    private static final byte NORMAL = 2;
    private static final int MIN_COL_SIZE = 10;
    private static final int EPS = 5;
    protected String[][] cells = null;
    protected int[] colWidths = null;
    protected boolean[] colSort = null;
    protected int[] colType = null;
    protected int[] rowHeights = null;
    protected int[] colX = null;
    protected int[] rowY = null;
    private GridCellEventListener gridCellEventListener = null;
    private boolean dontRefresh = false;
    private boolean needUpdate;
    private GridPanel panel;
    private int topVisibleRow = 0;
    private int bottomVisibleRow = 0;
    public boolean colSizing = false;
    private int col = -1;
    private Point lastPressed = null;
    private Cursor oldCursor = null;
    protected boolean[] rowWasEdited = null;
    protected boolean wasEdited = false;
    protected Vector cols = null;
    protected int lastCurrRow = 0;
    public int colCount = 0;
    public int rowCount = 0;
    public int currRow = 1;

    public LightGrid() {
        super(1);
        this.setName(_GRID);
        this.setBackground(SystemColor.window);
        this.panel = new GridPanel(this);
        this.add(this.panel);
        Adjustable adjustable = this.getVAdjustable();
        adjustable.setUnitIncrement(17);
        adjustable.setBlockIncrement(85);
        adjustable.addAdjustmentListener(this);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        Adjustable adjustable = (Adjustable)adjustmentEvent.getSource();
        double d = (double)n * 1.0 / (double)this.rowHeight;
        int n2 = n / this.rowHeight;
        if (d > (double)n2 * 1.0) {
            adjustable.setValue((n2 + 1) * this.rowHeight);
        }
    }

    public String getCell(int n, int n2) {
        if (n >= this.colCount || n2 >= this.rowCount || n < 0 || n2 < 0) {
            return null;
        }
        return this.cells[n2][n];
    }

    public void setCell(int n, int n2, String string) {
        if (n < this.colCount && n2 < this.rowCount && n >= 0 && n2 >= 0) {
            this.cells[n2][n] = string;
        }
    }

    public GridCellEventListener getGridCellEventListener() {
        return this.gridCellEventListener;
    }

    public void setGridCellEventListener(GridCellEventListener gridCellEventListener) {
        this.gridCellEventListener = gridCellEventListener;
    }

    public int getColWidth(int n) {
        if (n >= this.colCount || n < 0) {
            return 0;
        }
        return this.colWidths[n];
    }

    public int getRowHeight(int n) {
        if (n >= this.rowCount || n < 0) {
            return 0;
        }
        return this.rowHeights[n];
    }

    public void setColumnWidth(int n, int n2) {
        if (n >= this.colCount || n < 0) {
            return;
        }
        this.colWidths[n] = n2;
        this.updated();
    }

    public void setRowHeight(int n, int n2) {
        if (n >= this.rowCount || n < 0) {
            return;
        }
        this.rowHeights[n] = n2;
        this.updated();
    }

    public void firstRecord() {
        Adjustable adjustable = this.getVAdjustable();
        this.setScrollPosition(new Point(0, adjustable.getMinimum()));
        this.currRow = 0;
        this.cellClick();
        this.updated();
    }

    public void lastRecord() {
        Adjustable adjustable = this.getVAdjustable();
        this.setScrollPosition(new Point(0, adjustable.getMaximum()));
        this.currRow = this.rowCount - 1;
        this.cellClick();
        this.updated();
    }

    public void next() {
        if (this.currRow < this.rowCount - 1) {
            this.setCurrRow(this.currRow + 1);
            this.cellClick();
        }
    }

    public void previous() {
        if (this.currRow > 1) {
            this.setCurrRow(this.currRow - 1);
            this.cellClick();
        }
    }

    private void cellClick() {
        GridCellEventListener gridCellEventListener = this.getGridCellEventListener();
        if (gridCellEventListener != null) {
            gridCellEventListener.gridCellClicked(new Point(0, this.currRow), null);
        }
    }

    public void setCurrRow(int n) {
        if (this.currRow != n) {
            this.currRow = n;
            Adjustable adjustable = this.getVAdjustable();
            int n2 = adjustable.getValue();
            if (this.currRow < this.topVisibleRow) {
                adjustable.setValue(n2 - this.rowHeight);
            } else if (this.currRow > this.bottomVisibleRow) {
                adjustable.setValue(n2 + this.rowHeight);
            }
            this.updated();
        }
    }

    protected String[] getGridRow(int n) {
        if (this.cells != null) {
            String[] stringArray = new String[this.colCount - 1];
            int n2 = 0;
            while (n2 < this.colCount - 1) {
                stringArray[n2] = this.getCell(n2, n);
                ++n2;
            }
            return stringArray;
        }
        return null;
    }

    protected void setGridRow(String[] stringArray) {
        if (this.cells != null && this.lastCurrRow > 0) {
            this.wasEdited = true;
            this.rowWasEdited[this.lastCurrRow] = true;
            int n = 0;
            while (n < this.colCount - 1) {
                this.setCell(n, this.lastCurrRow, stringArray[n]);
                ++n;
            }
        }
    }

    protected void setGridColumn(String[] stringArray) {
        if (this.cells != null && this.lastCurrRow > 0) {
            int n;
            this.wasEdited = true;
            int n2 = 0;
            while (n2 < this.colCount - 1) {
                if (!this.getCell(n2, this.currRow).equalsIgnoreCase(stringArray[n2])) {
                    n = 1;
                    while (n < this.rowCount) {
                        this.setCell(n2, n, stringArray[n2]);
                        ++n;
                    }
                }
                ++n2;
            }
            n = 0;
            while (n < this.rowWasEdited.length) {
                this.rowWasEdited[n] = true;
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void sort(int var1_1, int var2_2, int var3_3, boolean var4_4, Compare var5_5) {
        do {
            var6_6 = var1_1;
            var7_7 = var2_2;
            var8_8 = (var1_1 + var2_2) / 2;
            do {
                block11: {
                    if (!var4_4) ** GOTO lbl15
                    while (var5_5.compare(this.getCell(var3_3, var8_8), this.getCell(var3_3, var6_6)) < 0) {
                        ++var6_6;
                    }
                    while (var5_5.compare(this.getCell(var3_3, var8_8), this.getCell(var3_3, var7_7)) > 0) {
                        --var7_7;
                    }
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        ++var6_6;
lbl15:
                        // 2 sources

                        ** while (var5_5.compare((String)this.getCell((int)var3_3, (int)var6_6), (String)this.getCell((int)var3_3, (int)var8_8)) < 0)
                    }
lbl16:
                    // 2 sources

                    while (var5_5.compare(this.getCell(var3_3, var7_7), this.getCell(var3_3, var8_8)) > 0) {
                        --var7_7;
                    }
                }
                if (var6_6 > var7_7) continue;
                var10_10 = 0;
                while (var10_10 < this.colCount) {
                    var9_9 = this.getCell(var10_10, var6_6);
                    this.setCell(var10_10, var6_6, this.getCell(var10_10, var7_7));
                    this.setCell(var10_10, var7_7, var9_9);
                    ++var10_10;
                }
                if (var8_8 == var6_6) {
                    var8_8 = var7_7;
                } else if (var8_8 == var7_7) {
                    var8_8 = var6_6;
                }
                ++var6_6;
                --var7_7;
            } while (var6_6 <= var7_7);
            if (var1_1 < var7_7) {
                this.sort(var1_1, var7_7, var3_3, var4_4, var5_5);
            }
            var1_1 = var6_6;
        } while (var6_6 < var2_2);
    }

    public void beginUpdate() {
        this.dontRefresh = true;
        this.needUpdate = false;
    }

    public void endUpdate() {
        this.dontRefresh = false;
        if (this.needUpdate) {
            this.updateColRowXY();
            this.updateAll();
        }
    }

    private void updated() {
        if (this.dontRefresh) {
            this.needUpdate = true;
        } else {
            this.updateAll();
        }
    }

    protected void updateAll() {
        int n = this.colCount > 0 ? this.colX[this.colCount - 1] + this.colWidths[this.colCount - 1] : 0;
        int n2 = this.rowCount > 0 ? this.rowY[this.rowCount - 1] + this.rowHeights[this.rowCount - 1] : 0;
        this.panel.setSize(n, n2);
        this.doLayout();
        this.panel.repaint();
    }

    public boolean setDimension(int n, int n2, int n3) {
        int n4;
        int[] nArray;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.colCount == n && this.rowCount == n2) {
            return false;
        }
        this.colSort = new boolean[n];
        String[][] stringArrayArray = new String[n2][];
        int n5 = 0;
        while (n5 < n2) {
            stringArrayArray[n5] = new String[n];
            ++n5;
        }
        int n6 = n < this.colCount ? n : this.colCount;
        int n7 = n2 < this.rowCount ? n2 : this.rowCount;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            if (n8 < n7) {
                System.arraycopy(this.cells[n8], 0, stringArrayArray[n8], 0, n6);
                n9 = n6;
            }
            ++n8;
        }
        this.rowHeight = n3 > 0 ? n3 : 17;
        Adjustable adjustable = this.getVAdjustable();
        adjustable.setUnitIncrement(this.rowHeight);
        if (n2 != this.rowCount) {
            nArray = new int[n2];
            if (n7 > 0) {
                System.arraycopy(this.rowHeights, 0, nArray, 0, n7);
            }
            n4 = n7;
            while (n4 < n2) {
                nArray[n4] = this.rowHeight;
                ++n4;
            }
            this.rowHeights = nArray;
        }
        if (n != this.colCount) {
            nArray = new int[n];
            if (n6 > 0) {
                System.arraycopy(this.colWidths, 0, nArray, 0, n6);
            }
            n4 = n6;
            while (n4 < n) {
                nArray[n4] = 40;
                ++n4;
            }
            this.colWidths = nArray;
        }
        this.colCount = n;
        this.rowCount = n2;
        this.cells = stringArrayArray;
        this.updateColRowXY();
        this.setScrollPosition(0, 0);
        this.currRow = 1;
        this.updated();
        return true;
    }

    private void updateColRowXY() {
        int n = this.colCount;
        int n2 = this.rowCount;
        int[] nArray = this.colX;
        int[] nArray2 = this.rowY;
        if (nArray == null || nArray.length != n) {
            nArray = new int[n];
        }
        if (nArray2 == null || nArray2.length != n2) {
            nArray2 = new int[n2];
        }
        if (n > 0) {
            nArray[0] = 0;
        }
        if (n2 > 0) {
            nArray2[0] = 0;
        }
        int n3 = 1;
        while (n3 < n) {
            nArray[n3] = nArray[n3 - 1] + this.colWidths[n3 - 1];
            ++n3;
        }
        int n4 = 1;
        while (n4 < n2) {
            nArray2[n4] = nArray2[n4 - 1] + this.rowHeights[n4 - 1];
            ++n4;
        }
        this.colX = nArray;
        this.rowY = nArray2;
    }

    public Rectangle getVisibleArea() {
        Point point = this.getScrollPosition();
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n = this.colCount;
        int n2 = this.rowCount;
        int[] nArray = this.colX;
        int[] nArray2 = this.rowY;
        int[] nArray3 = this.colWidths;
        int[] nArray4 = this.rowHeights;
        int n3 = point.x;
        int n4 = point.y;
        int n5 = n3 + dimension.width - 1;
        int n6 = n4 + dimension.height - 1;
        int n7 = -1;
        int n8 = -2;
        int n9 = -1;
        int n10 = -2;
        int n11 = 0;
        while (n11 < n) {
            if (nArray[n11] <= n5 && nArray[n11] + nArray3[n11] >= n3) {
                if (n7 < 0) {
                    n7 = n11;
                }
                n8 = n11;
            } else if (n7 >= 0) break;
            ++n11;
        }
        int n12 = 0;
        while (n12 < n2) {
            if (nArray2[n12] <= n6 && nArray2[n12] + nArray4[n12] > n4) {
                if (n9 < 0) {
                    n9 = n12;
                }
                n10 = n12;
            } else if (n9 >= 0) break;
            ++n12;
        }
        this.topVisibleRow = n9 + 1;
        this.bottomVisibleRow = n10;
        return new Rectangle(n7, n9, n8 - n7 + 1, n10 - n9 + 1);
    }

    public Point getCellAt(Point point) {
        int n;
        int n2 = point.x;
        int n3 = -1;
        int n4 = this.colCount;
        int n5 = 0;
        while (n5 < n4) {
            n = this.colX[n5];
            if (n2 >= n && n2 < n + this.colWidths[n5]) {
                n3 = n5;
                break;
            }
            ++n5;
        }
        if (n3 < 0) {
            return null;
        }
        n = -1;
        int n6 = point.y;
        int n7 = this.rowCount;
        Point point2 = this.getScrollPosition();
        if (n7 > 0 && n6 - point2.y < this.rowHeights[0]) {
            n = 0;
        } else {
            int n8 = 0;
            while (n8 < n7) {
                int n9 = this.rowY[n8];
                if (n6 >= n9 && n6 < n9 + this.rowHeights[n8]) {
                    n = n8;
                    break;
                }
                ++n8;
            }
        }
        if (n < 0) {
            return null;
        }
        return new Point(n3, n);
    }

    protected void drawCell2(Rectangle rectangle, Graphics graphics, String string, byte by, int n, int n2) {
        int n3;
        if (by == 0) {
            int n4 = rectangle.x;
            n3 = rectangle.y;
            int n5 = rectangle.width;
            int n6 = rectangle.height;
            graphics.setColor(SystemColor.control);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n4 + n5 - 2, n3, n4 + n5 - 2, n3 + n6 - 2);
            graphics.drawLine(n4, n3 + n6 - 2, n4 + n5 - 2, n3 + n6 - 2);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n4, n3, n4 + n5 - 1, n3);
            graphics.drawLine(n4, n3, n4, n3 + n6 - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n4 + n5 - 1, n3, n4 + n5 - 1, n3 + n6 - 1);
            graphics.drawLine(n4, n3 + n6 - 1, n4 + n5 - 1, n3 + n6 - 1);
        } else {
            graphics.setColor(by == 1 ? SystemColor.activeCaption : this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.getForeground());
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(by == 1 ? SystemColor.activeCaptionText : this.getForeground());
        Font font = graphics.getFont();
        n3 = rectangle.y + (rectangle.height + font.getSize()) / 2 - 2;
        if (string != null) {
            graphics.drawString(string, rectangle.x + 2, n3);
        }
    }

    protected void setUnEdited() {
        this.wasEdited = false;
        this.rowWasEdited = new boolean[this.rowCount];
    }

    protected void addColDef(String string, int n, boolean bl, int n2) {
        ColDef colDef = new ColDef(string, n, bl, n2);
        this.cols.addElement(colDef);
    }

    protected int getColDefIndex(int n) {
        ColDef colDef = (ColDef)this.cols.get(n);
        return colDef.index;
    }

    protected boolean getColDefEditable(int n) {
        ColDef colDef = (ColDef)this.cols.get(n);
        return colDef.editable;
    }

    private class ColDef {
        String label;
        int colType;
        boolean editable;
        int index;

        public ColDef(String string, int n, boolean bl, int n2) {
            this.label = string;
            this.colType = n;
            this.editable = bl;
            this.index = n2;
        }
    }

    private class GridPanel
    extends Canvas
    implements MouseListener,
    KeyListener,
    MouseMotionListener {
        private LightGrid parentGrid = null;

        GridPanel(LightGrid lightGrid2) {
            this.parentGrid = lightGrid2;
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.addMouseMotionListener(this);
        }

        public void repaint() {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    this.paint(graphics);
                    Object var3_2 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
        }

        public void paint(Graphics graphics) {
            LightGrid lightGrid = this.parentGrid;
            if (lightGrid.cells == null) {
                return;
            }
            Rectangle rectangle = lightGrid.getVisibleArea();
            if (rectangle == null) {
                return;
            }
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = n + rectangle.width - 1;
            int n4 = n2 + rectangle.height - 1;
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                return;
            }
            Rectangle rectangle2 = new Rectangle();
            int n5 = lightGrid.colX[n];
            int n6 = lightGrid.colX[n3] + lightGrid.getColWidth(n3);
            int n7 = lightGrid.rowY[n2];
            int n8 = n6 - n5;
            int n9 = lightGrid.rowY[n4] + lightGrid.getRowHeight(n4);
            int n10 = n9 - n7;
            Image image = this.createImage(n8, n10);
            if (image == null) {
                return;
            }
            Graphics graphics2 = image.getGraphics();
            try {
                int n11;
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, n8, n10);
                int n12 = LightGrid.this.currRow;
                if (LightGrid.this.currRow <= n2) {
                    LightGrid.this.currRow = n2 + 1;
                } else if (LightGrid.this.currRow > n4 && n4 > 0) {
                    LightGrid.this.currRow = n4;
                }
                int n13 = n;
                while (n13 <= n3) {
                    int n14 = lightGrid.colX[n13] - n5;
                    n11 = lightGrid.getColWidth(n13);
                    graphics2.setClip(null);
                    graphics2.clipRect(n14, 0, n11, n10);
                    int n15 = n2;
                    while (n15 <= n4) {
                        rectangle2.setBounds(n14, lightGrid.rowY[n15] - n7, n11, lightGrid.getRowHeight(n15));
                        LightGrid.this.drawCell2(rectangle2, graphics2, lightGrid.cells[n15][n13], n15 == LightGrid.this.currRow ? (byte)1 : 2, n15, n13);
                        ++n15;
                    }
                    ++n13;
                }
                Point point = lightGrid.getScrollPosition();
                n11 = point.y;
                Adjustable adjustable = LightGrid.this.getVAdjustable();
                int n16 = adjustable.getValue();
                int n17 = n;
                while (n17 <= n3) {
                    int n18 = lightGrid.colX[n17] - n5;
                    int n19 = lightGrid.getColWidth(n17);
                    graphics2.setClip(null);
                    graphics2.clipRect(n18, n11 - n7, n19, lightGrid.getRowHeight(0));
                    rectangle2.setBounds(n18, n11 - n7, n19, lightGrid.getRowHeight(0));
                    graphics2.setColor(this.getBackground());
                    graphics2.fillRect(n18, n11 - n7, n19, lightGrid.getRowHeight(0));
                    LightGrid.this.drawCell2(rectangle2, graphics2, LightGrid.this.cells[0][n17], (byte)0, 0, n17);
                    ++n17;
                }
                graphics.setClip(null);
                graphics.setColor(this.getBackground());
                Dimension dimension = this.getSize();
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.drawImage(image, n5, n7, null);
                image.flush();
                if (LightGrid.this.currRow != n12) {
                    LightGrid.this.cellClick();
                }
                Object var27_29 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var27_30 = null;
                graphics2.dispose();
                throw throwable;
            }
        }

        public Dimension getPreferredSize() {
            LightGrid lightGrid = this.parentGrid;
            int n = lightGrid.colCount;
            int n2 = lightGrid.rowCount;
            if (n2 <= 0 || n2 <= 0) {
                return new Dimension(0, 0);
            }
            return new Dimension(lightGrid.colX[--n] + lightGrid.getColWidth(n), lightGrid.rowY[--n2] + lightGrid.getRowHeight(n2));
        }

        protected void CheckMousePos(MouseEvent mouseEvent) {
            boolean bl;
            LightGrid.this.lastPressed = mouseEvent.getPoint();
            Point point = LightGrid.this.getCellAt(LightGrid.this.lastPressed);
            boolean bl2 = bl = null != point && 0 == point.y;
            if (bl) {
                LightGrid.this.col = point.x;
                if (((LightGrid)LightGrid.this).lastPressed.x - LightGrid.this.colX[LightGrid.this.col] <= 5) {
                    --LightGrid.this.col;
                } else if (LightGrid.this.colX[LightGrid.this.col] + LightGrid.this.colWidths[LightGrid.this.col] - ((LightGrid)LightGrid.this).lastPressed.x > 5) {
                    LightGrid.this.col = -1;
                    LightGrid.this.lastPressed = null;
                    bl = false;
                }
            } else {
                LightGrid.this.lastPressed = null;
                LightGrid.this.col = -1;
            }
            if (bl) {
                if (null == LightGrid.this.oldCursor) {
                    LightGrid.this.oldCursor = this.getCursor();
                    this.setCursor(new Cursor(10));
                }
            } else if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
                LightGrid.this.oldCursor = null;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (LightGrid.this.dontRefresh) {
                return;
            }
            Point point = this.parentGrid.getCellAt(mouseEvent.getPoint());
            if (point != null) {
                GridCellEventListener gridCellEventListener = this.parentGrid.getGridCellEventListener();
                if (point.y == 0) {
                    this.parentGrid.beginUpdate();
                    if (SQLConst.isNumber(this.parentGrid.colType[point.x])) {
                        this.parentGrid.sort(1, this.parentGrid.rowCount - 1, point.x, this.parentGrid.colSort[point.x], new CompareNumber());
                    } else {
                        this.parentGrid.sort(1, this.parentGrid.rowCount - 1, point.x, this.parentGrid.colSort[point.x], new CompareString());
                    }
                    this.parentGrid.endUpdate();
                    this.parentGrid.updateAll();
                    boolean bl = this.parentGrid.colSort[point.x] = !this.parentGrid.colSort[point.x];
                }
                if (point.y > 0) {
                    this.parentGrid.setCurrRow(point.y);
                }
                if (gridCellEventListener != null) {
                    gridCellEventListener.gridCellClicked(point, mouseEvent);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (LightGrid.this.colSizing && 16 == mouseEvent.getModifiers()) {
                this.CheckMousePos(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
            }
            if (LightGrid.this.colSizing && 16 == mouseEvent.getModifiers() && 0 <= LightGrid.this.col && null != LightGrid.this.lastPressed) {
                int n = mouseEvent.getPoint().x - ((LightGrid)LightGrid.this).lastPressed.x;
                if (0 < LightGrid.this.col && 0 > n && -n >= LightGrid.this.colWidths[LightGrid.this.col] - 10) {
                    n = -(LightGrid.this.colWidths[LightGrid.this.col] - 10);
                }
                int n2 = LightGrid.this.col++;
                LightGrid.this.colWidths[n2] = LightGrid.this.colWidths[n2] + n;
                int n3 = LightGrid.this.col;
                while (n3 < LightGrid.this.colCount) {
                    int n4 = n3++;
                    LightGrid.this.colX[n4] = LightGrid.this.colX[n4] + n;
                }
                LightGrid.this.col = -1;
                LightGrid.this.lastPressed = null;
                this.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (LightGrid.this.colSizing) {
                this.CheckMousePos(mouseEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (LightGrid.this.dontRefresh) {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 40 || n == 38) {
                int n2 = this.parentGrid.currRow;
                if (n2 > 0) {
                    if (n == 38 && n2 > 1) {
                        --n2;
                    } else if (n == 40 && n2 < this.parentGrid.rowCount - 1) {
                        ++n2;
                    }
                }
                this.parentGrid.setCurrRow(n2);
                GridCellEventListener gridCellEventListener = this.parentGrid.getGridCellEventListener();
                if (gridCellEventListener != null) {
                    gridCellEventListener.gridCellClicked(new Point(0, n2), keyEvent);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class CompareNumber
    implements Compare {
        private CompareNumber() {
        }

        public int compare(String string, String string2) {
            Float f = new Float(Float.parseFloat(string));
            Float f2 = new Float(Float.parseFloat(string2));
            return f.compareTo(f2);
        }
    }

    private class CompareString
    implements Compare {
        private CompareString() {
        }

        public int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    }

    static interface Compare {
        public int compare(String var1, String var2);
    }
}

