/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimerListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;
import org.alov.viewer.TipRect;

public class Tooltip
extends ImageButton
implements CarteHostListener,
CarteListener,
ActionListener,
TimerListener {
    private Carte map;
    private boolean isTipsActive = false;
    private boolean searchInActiveOnly = true;
    private boolean showInCentroid = false;
    private boolean showWithLayerName = false;
    private TipRect tooltipInstance = null;
    private String previousTip = null;
    private int showTips = 0;
    private boolean fill = true;
    private boolean outline = true;
    private Color fillColor = Color.yellow;
    private Color outlineColor = Color.black;
    private Font font;
    private SimpleTimer st;
    private Point ptForShow = null;
    private Point ptForSearch = null;
    private int reset = 0;
    private String sTip = null;

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            this.isTipsActive = !this.isTipsActive;
            this.setDown(this.isTipsActive);
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        XmlElement xmlElement2 = xmlElement.getFirstElementByName("tip");
        if (xmlElement2 != null) {
            this.searchInActiveOnly = XmlUtils.getBoolean("active_only", xmlElement2, true);
            this.showWithLayerName = XmlUtils.getBoolean("layername", xmlElement2, false);
            this.showInCentroid = XmlUtils.getBoolean("centroid", xmlElement2, false);
            this.fill = XmlUtils.getBoolean("filled", xmlElement2, true);
            this.fillColor = XmlUtils.getColor("fill", xmlElement2, Color.yellow);
            this.outline = XmlUtils.getBoolean("outlined", xmlElement2, true);
            this.outlineColor = XmlUtils.getColor("outline", xmlElement2, Color.black);
            this.font = XmlUtils.getFont("font", xmlElement2, MapUtils.defaultPlainFont);
        } else {
            this.font = MapUtils.defaultPlainFont;
        }
        this.map = carteHost.getMapByName(xmlElement);
        this.map.mapListeners.addElement(this);
        this.addActionListener(this);
        super.setParameters(carteHost, xmlElement);
        if (XmlUtils.getBoolean("startup", xmlElement, false)) {
            this.isTipsActive = true;
            this.setDown(true);
        }
        this.st = new SimpleTimer(500L, this);
    }

    public void stop() {
    }

    public void mouseMapPressed(MouseEvent mouseEvent) {
    }

    public void mouseMapReleased(FloatRectangle floatRectangle, MouseEvent mouseEvent) {
    }

    public void mouseMapMoved(MouseEvent mouseEvent) {
        Point point;
        FloatPoint floatPoint;
        if ((this.map.getTool() == 5 || this.map.getTool() == 6) && (floatPoint = this.map.screenToMap(point = mouseEvent.getPoint())) != null && this.isTipsActive) {
            this.ptForSearch = point;
            if (this.reset != 1) {
                this.reset = 0;
            }
            this.showTips = 11;
            if (this.tooltipInstance != null && this.showTips > 10) {
                this.sTip = null;
                this.tooltipInstance.dispose();
                this.tooltipInstance = null;
            }
        }
    }

    public void afterMapDraw(Graphics graphics) {
    }

    public void timerTick(SimpleTimer simpleTimer) {
        Object object;
        if (!this.map.isProjectLoaded()) {
            return;
        }
        Record record = null;
        Layer layer = null;
        if (this.reset == 1 && this.ptForSearch != null) {
            if (this.searchInActiveOnly) {
                layer = this.map.getActiveLayer();
                if (layer != null && layer.canSearch && layer.isVisibleNow(this.map)) {
                    this.sTip = null;
                    record = layer.findAtScreenPoint(this.ptForSearch);
                    if (record != null) {
                        this.sTip = layer.getFieldString(record, layer.fi_description);
                        if (Strings.isNullOrBlank(this.sTip)) {
                            this.sTip = null;
                        } else if (this.showWithLayerName) {
                            this.sTip = this.sTip + " [" + layer.getName() + "]";
                        }
                    }
                }
            } else {
                object = this.map.getProject().renderers;
                int n = ((Vector)object).size() - 1;
                Vector<Layer> vector = new Vector<Layer>();
                try {
                    this.sTip = null;
                    int n2 = n;
                    while (n2 >= 0) {
                        int n3;
                        Vector vector2 = (Vector)((Vector)object).elementAt(n2);
                        int n4 = n3 = vector2.size() - 1;
                        while (n4 >= 0) {
                            Renderer renderer = null;
                            try {
                                renderer = (Renderer)vector2.elementAt(n4);
                                layer = renderer.layer;
                                if (layer.canSearch && renderer.enabled && vector.indexOf(layer) < 0 && layer.isVisibleNow(this.map) && renderer.isRendererVisible(this.map)) {
                                    record = layer.findAtScreenPoint(this.ptForSearch);
                                    if (record != null) {
                                        this.sTip = layer.getFieldString(record, layer.fi_description);
                                        if (this.sTip.length() == 0) {
                                            this.sTip = null;
                                        }
                                        if (this.sTip != null) {
                                            if (this.showWithLayerName) {
                                                this.sTip = this.sTip + " [" + layer.getName() + "]";
                                            }
                                            n4 = -1;
                                            n2 = -1;
                                        }
                                    }
                                    vector.addElement(layer);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            --n4;
                        }
                        --n2;
                    }
                    Object var14_13 = null;
                    vector.removeAllElements();
                    vector = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    vector.removeAllElements();
                    vector = null;
                    throw throwable;
                }
            }
            this.ptForShow = new Point(this.ptForSearch);
            this.ptForSearch = null;
            this.reset = 0;
        } else {
            ++this.reset;
        }
        if (!(this.tooltipInstance == null || this.sTip != null && this.sTip.equals(this.previousTip) && this.showTips <= 10)) {
            if (this.showTips > 10) {
                this.sTip = null;
            }
            this.tooltipInstance.dispose();
            this.tooltipInstance = null;
        }
        if (this.sTip != null) {
            if (this.tooltipInstance == null) {
                object = this.map.getGraphics();
                if (object != null) {
                    try {
                        if (this.showInCentroid && record != null && record.centroid != null) {
                            this.ptForShow = new Point(this.map.mapToScreen(record.centroid));
                        }
                        this.tooltipInstance = new TipRect(this.sTip, this.font, this.map, this.ptForShow, this.fill, this.outline, this.fillColor, this.outlineColor);
                        this.tooltipInstance.paint((Graphics)object);
                        this.previousTip = this.sTip;
                        Object var16_16 = null;
                        ((Graphics)object).dispose();
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        ((Graphics)object).dispose();
                        throw throwable;
                    }
                }
                this.showTips = 0;
            }
            this.previousTip = this.sTip;
            ++this.showTips;
        }
    }
}

