/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alov.data.Csv;
import org.alov.data.DataProvider;
import org.alov.data.Dbf;
import org.alov.data.Gml;
import org.alov.data.Mif;
import org.alov.data.SQLConst;
import org.alov.data.Shp;
import org.alov.map.FieldDef;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.MapUtils;
import org.alov.map.Meta;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class DataProviderFile
extends DataProvider {
    transient Dbf dbf = null;
    public boolean fixHoles = true;

    public DataProviderFile(Layer layer) {
        super(layer);
    }

    private static void readZip(byte[] byArray, ZipInputStream zipInputStream) throws IOException {
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            int n3 = zipInputStream.read(byArray, n2, n);
            n2 += n3;
            n -= n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadComplete() throws AlovMapException {
        try {
            boolean bl;
            String string;
            if (this.layer.connectionData == null || (string = this.layer.connectionData.getProperty("url")) == null) {
                throw new AlovMapException(105, this.layer.getName());
            }
            String string2 = null;
            if (this.layer instanceof LayerZoomify && !Strings.checkSuffix(string, ".dbf")) {
                if (this.layer.metadata.isNotLoaded) {
                    string2 = Strings.changeSuffix(string, ".xml");
                    try {
                        this.layer.metadata.loadMetadata(this.openURL(string2));
                    }
                    catch (AlovMapException alovMapException) {
                        throw new AlovMapException(alovMapException.getCode(), alovMapException.getMessage());
                    }
                    catch (Exception exception) {
                        throw new AlovMapException(314, "Can't load file " + string2);
                    }
                    string = Strings.getAbsPath(Strings.extractDir(string2), "ImageProperties.xml");
                }
                if (!string.endsWith("ImageProperties.xml")) throw new AlovMapException(314, "Can't load Zoomify file " + string);
                this.loadZoomify(string);
                return "";
            }
            StreamCounter streamCounter = null;
            try {
                bl = string.startsWith("file:/");
                streamCounter = this.openURL(string);
            }
            catch (Exception exception) {
                throw new AlovMapException(308, "Can't load file " + string);
            }
            if (streamCounter != null) {
                try {
                    Meta meta = this.layer.metadata;
                    String string3 = null;
                    byte[] byArray = null;
                    byte[] byArray2 = null;
                    byte[] byArray3 = null;
                    byte[] byArray4 = null;
                    byte[] byArray5 = null;
                    byte[] byArray6 = null;
                    if (Strings.checkSuffix(string, ".zip")) {
                        ByteArrayInputStream byteArrayInputStream;
                        Object object;
                        ZipEntry zipEntry;
                        ZipInputStream zipInputStream = new ZipInputStream(streamCounter);
                        do {
                            zipEntry = zipInputStream.getNextEntry();
                            object = null;
                            if (zipEntry == null) continue;
                            String string4 = zipEntry.getName();
                            int n = (int)zipEntry.getSize();
                            if (byArray2 == null && Strings.checkSuffix(string4, ".dbf")) {
                                byArray2 = new byte[n];
                                object = byArray2;
                            } else if (byArray3 == null && Strings.checkSuffix(string4, ".mid")) {
                                byArray3 = new byte[n];
                                object = byArray3;
                            } else if (byArray == null && (Strings.checkSuffix(string4, ".xml") || Strings.checkSuffix(string4, ".tmm"))) {
                                byArray = new byte[n];
                                object = byArray;
                            } else if (byArray4 == null && byArray5 == null) {
                                if (Strings.checkSuffix(string4, ".shp")) {
                                    byArray4 = new byte[n];
                                    object = byArray4;
                                } else if (Strings.checkSuffix(string4, ".mif")) {
                                    byArray5 = new byte[n];
                                    object = byArray5;
                                } else if (Strings.checkSuffix(string4, ".csv") || Strings.checkSuffix(string4, ".txt")) {
                                    byArray6 = new byte[n];
                                    object = byArray6;
                                }
                            }
                            if (object != null) {
                                DataProviderFile.readZip((byte[])object, zipInputStream);
                            }
                            if (((byArray4 != null || byArray5 != null) && byArray2 != null || byArray5 != null && byArray3 != null) && byArray != null) break;
                        } while (zipEntry != null);
                        zipInputStream.close();
                        if (byArray != null && meta.isNotLoaded) {
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            try {
                                meta.loadMetadata(byteArrayInputStream);
                            }
                            catch (AlovMapException alovMapException) {
                                throw new AlovMapException(alovMapException.getCode(), alovMapException.getMessage());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            byteArrayInputStream.close();
                        }
                        ((LayerVector)this.layer).resolveMetadata();
                        string3 = meta.getStr(305);
                        if (byArray2 != null) {
                            byteArrayInputStream = new ByteArrayInputStream(byArray2);
                            this.dbf = new Dbf(byteArrayInputStream, string3);
                            byteArrayInputStream.close();
                            this.resolveFields();
                        }
                        if (byArray4 != null) {
                            byteArrayInputStream = new ByteArrayInputStream(byArray4);
                            Shp.loadFromStream(byteArrayInputStream, this.dbf, (LayerVector)this.layer, this.fixHoles);
                            byteArrayInputStream.close();
                        } else if (byArray5 != null) {
                            if (!MapUtils.isMIF_Enabled()) throw new AlovMapException(111, "MIF loader is not found.");
                            byteArrayInputStream = new ByteArrayInputStream(byArray5);
                            if (this.dbf != null) {
                                Mif.loadFromStream(byteArrayInputStream, null, this.dbf, (LayerVector)this.layer);
                            } else if (byArray3 != null) {
                                object = new ByteArrayInputStream(byArray3);
                                Mif.loadFromStream(byteArrayInputStream, (InputStream)object, null, (LayerVector)this.layer);
                                ((ByteArrayInputStream)object).close();
                            }
                            byteArrayInputStream.close();
                        } else if (this.dbf != null) {
                            this.dbf.loadToLayer((LayerVector)this.layer);
                        } else if (byArray6 != null) {
                            byteArrayInputStream = new ByteArrayInputStream(byArray6);
                            Csv.loadFromStream(byteArrayInputStream, (LayerVector)this.layer, string3);
                            byteArrayInputStream.close();
                        }
                    } else {
                        if (this.layer.metadata.isNotLoaded) {
                            string2 = Strings.changeSuffix(string, ".xml");
                            try {
                                meta.loadMetadata(this.openURL(string2));
                            }
                            catch (AlovMapException alovMapException) {
                                throw new AlovMapException(alovMapException.getCode(), alovMapException.getMessage());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ((LayerVector)this.layer).resolveMetadata();
                        string3 = meta.getStr(305);
                        StreamCounter streamCounter2 = null;
                        if (Strings.checkSuffix(string, ".gml")) {
                            throw new AlovMapException(310, "GML is not supported in this version.");
                        }
                        if (Strings.checkSuffix(string, ".csv") || Strings.checkSuffix(string, ".txt")) {
                            streamCounter2 = this.openURL(string);
                            Csv.loadFromStream(streamCounter2, (LayerVector)this.layer, string3);
                        } else {
                            Object object;
                            boolean bl2;
                            String string5;
                            block71: {
                                string5 = Strings.changeSuffix(string, ".dbf");
                                streamCounter2 = null;
                                bl2 = true;
                                try {
                                    streamCounter2 = this.openURL(string5);
                                }
                                catch (Exception exception) {
                                    bl2 = false;
                                    if (!Strings.checkSuffix(string, ".shp")) break block71;
                                    throw new AlovMapException(308, "Can't load file " + string5);
                                }
                            }
                            if (!bl2 && Strings.checkSuffix(string, ".mif")) {
                                object = Strings.changeSuffix(string, ".mid");
                                try {
                                    streamCounter2 = this.openURL((String)object);
                                }
                                catch (Exception exception) {
                                    throw new AlovMapException(308, "Can't load file " + string5 + " or " + (String)object);
                                }
                            }
                            if (streamCounter2 != null && bl2) {
                                if (bl) {
                                    object = new BufferedInputStream(streamCounter2, 20480);
                                    this.dbf = new Dbf((InputStream)object, string3);
                                    ((BufferedInputStream)object).close();
                                } else {
                                    int n;
                                    int n2 = 8192;
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
                                    byte[] byArray7 = new byte[n2];
                                    while ((n = ((InputStream)streamCounter2).read(byArray7)) > 0) {
                                        byteArrayOutputStream.write(byArray7, 0, n);
                                    }
                                    byArray7 = byteArrayOutputStream.toByteArray();
                                    byteArrayOutputStream = null;
                                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray7);
                                    this.dbf = new Dbf(byteArrayInputStream, string3);
                                    byteArrayInputStream.close();
                                }
                                this.resolveFields();
                                try {
                                    ((InputStream)streamCounter2).close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (Strings.checkSuffix(string, ".shp")) {
                                Shp.loadFromStream(streamCounter, this.dbf, (LayerVector)this.layer, this.fixHoles);
                            } else if (Strings.checkSuffix(string, ".mif")) {
                                if (bl2) {
                                    Mif.loadFromStream(streamCounter, null, this.dbf, (LayerVector)this.layer);
                                } else if (streamCounter2 != null) {
                                    Mif.loadFromStream(streamCounter, streamCounter2, null, (LayerVector)this.layer);
                                }
                            } else {
                                if (!Strings.checkSuffix(string, ".dbf")) throw new AlovMapException(110, string);
                                this.dbf.loadToLayer((LayerVector)this.layer);
                            }
                        }
                    }
                    try {
                        ((InputStream)streamCounter).close();
                    }
                    catch (Exception exception) {}
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new AlovMapException(309, "Can't load file " + string);
                }
            }
            this.layer.setLoadComplete(true);
            return "";
        }
        catch (Error error) {
            this.layer.clear(false);
            if (!(error instanceof OutOfMemoryError)) return "";
            throw new AlovMapException(313, "Not enough memory");
        }
    }

    public String loadZoomify(String string) throws AlovMapException {
        StreamCounter streamCounter = null;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = 59.0;
        double d5 = 38.0;
        double d6 = 75.0 - d4;
        double d7 = d5 - 28.0;
        try {
            d4 = Double.valueOf(this.layer.metadata.getVal(142));
            d5 = Double.valueOf(this.layer.metadata.getVal(143));
            d6 = Double.valueOf(this.layer.metadata.getVal(144));
            d7 = -Double.valueOf(this.layer.metadata.getVal(145)).doubleValue();
        }
        catch (Exception exception) {
            throw new AlovMapException(301, "Missed or wrong image registration parameters");
        }
        if (d6 == 0.0) {
            throw new AlovMapException(301, "X pixel size is zero");
        }
        if (d6 == 0.0) {
            throw new AlovMapException(301, "Y pixel size is zero");
        }
        try {
            String string2 = string;
            streamCounter = this.openURL(string2);
            XmlElement xmlElement = XmlUtils.parseStream(streamCounter, null);
            ((InputStream)streamCounter).close();
            if (xmlElement != null) {
                n = Integer.parseInt(xmlElement.getAttributeValue("NUMIMAGES"));
                n2 = Integer.parseInt(xmlElement.getAttributeValue("NUMTILES"));
                d = Integer.parseInt(xmlElement.getAttributeValue("WIDTH"));
                d2 = Integer.parseInt(xmlElement.getAttributeValue("HEIGHT"));
                d3 = Integer.parseInt(xmlElement.getAttributeValue("TILESIZE"));
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new AlovMapException(308, "Can't load file " + string);
        }
        d4 -= d6 / 2.0;
        d5 += d7 / 2.0;
        d6 *= d;
        d7 *= d2;
        if (!bl) {
            return null;
        }
        double d8 = d4 + d6;
        double d9 = d5 - d7;
        double d10 = d3;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (d10 < d || d10 < d2) {
            d10 *= 2.0;
            ++n5;
        }
        String string3 = Strings.extractDir(string) + "TileGroup";
        FieldDef fieldDef = new FieldDef();
        fieldDef.index = 0;
        fieldDef.name = "level";
        fieldDef.type = 4;
        FieldDef fieldDef2 = new FieldDef();
        fieldDef2.index = 1;
        fieldDef2.name = "image";
        fieldDef2.type = 12;
        this.layer.assignFields(new FieldDef[]{fieldDef, fieldDef2});
        this.layer.objectType = 3;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n7 < n5) {
            int n9 = (int)(Math.ceil(d / d10) + 0.01);
            int n10 = (int)(Math.ceil(d2 / d10) + 0.01);
            double d11 = d6 * (d10 / d);
            double d12 = d7 * (d10 / d2);
            double d13 = d5;
            int n11 = 0;
            while (n11 < n10) {
                double d14 = d12;
                if (d13 - d14 < d9) {
                    d14 = d13 - d9;
                }
                double d15 = d4;
                int n12 = 0;
                while (n12 < n9) {
                    double d16 = d11;
                    if (d15 + d16 > d8) {
                        d16 = d8 - d15;
                    }
                    Record record = this.layer.newRecord();
                    record.setId(String.valueOf(++n6));
                    Shape shape = new Shape();
                    shape.xCoords = new double[]{d15, d15 + d16, d15 + d16, d15};
                    shape.yCoords = new double[]{d13, d13, d13 - d14, d13 - d14};
                    record.shapes.addElement(shape);
                    String string4 = string3 + n4 + "/" + n7 + "-" + n12 + "-" + n11 + ".jpg";
                    record.setFieldValues(new Object[]{new Integer(n7), string4});
                    record.calculateExtent();
                    this.layer.addRecord(record);
                    if (++n3 > 255) {
                        n3 = 0;
                        ++n4;
                    }
                    ++n12;
                    d15 += d11;
                }
                ++n11;
                d13 -= d12;
            }
            ++n8;
            d10 /= 2.0;
            ++n7;
        }
        LayerZoomify layerZoomify = (LayerZoomify)this.layer;
        layerZoomify.setDimensions(d6, d7, d, d2, d3, n8);
        this.layer.objectType = 3;
        this.layer.metadata.isLoaded = true;
        this.layer.metadata.isNotLoaded = false;
        this.layer.metadata.loadFailed = false;
        this.layer.prepareLayer();
        this.layer.setLoadComplete(true);
        return null;
    }

    private void resolveGmlFields() {
        if (Gml.f_names == null) {
            return;
        }
        int n = Gml.f_names.length;
        String string = this.layer.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(string)) {
            string = string + ',';
        }
        Vector<FieldDef> vector = new Vector<FieldDef>();
        int n2 = 0;
        while (n2 < n) {
            if (!Strings.isNullOrBlank(Gml.f_names[n2])) {
                FieldDef fieldDef = new FieldDef();
                fieldDef.type = 12;
                fieldDef.index = vector.size();
                fieldDef.name = Gml.f_names[n2];
                fieldDef.label = this.layer.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
                fieldDef.visible = Strings.isNullOrBlank(string) || string.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
                vector.addElement(fieldDef);
            }
            ++n2;
        }
        n = vector.size();
        this.layer.initFields(n);
        int n3 = 0;
        while (n3 < n) {
            this.layer.setFieldDef(n3, (FieldDef)vector.elementAt(n3));
            ++n3;
        }
        LayerVector layerVector = (LayerVector)this.layer;
        layerVector.fi_description = layerVector.getFieldIndex(layerVector.f_description);
        layerVector.fi_id = layerVector.getFieldIndex(layerVector.f_id);
        if (layerVector.fi_id >= 0) {
            layerVector.f_id_istext = SQLConst.isText(layerVector.getFieldDef((int)layerVector.fi_id).type);
        }
        this.layer.prepareLayer();
    }

    private void resolveFields() {
        String string;
        int n = this.dbf == null ? 0 : this.dbf.getNumFields();
        String string2 = this.layer.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(string2)) {
            string2 = ',' + string2 + ',';
        }
        if (!Strings.isNullOrBlank(string = this.layer.metadata.getVal(311, MapUtils.language))) {
            string = ',' + string + ',';
        }
        Vector<FieldDef> vector = new Vector<FieldDef>();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = this.dbf.getFieldType(n2);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'L': {
                    n3 = 1;
                    break;
                }
                case 'I': {
                    n3 = 4;
                    break;
                }
                case 'F': 
                case 'N': {
                    n3 = 8;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if (SQLConst.isAllowedType(n3)) {
                FieldDef fieldDef = new FieldDef();
                fieldDef.type = n3;
                fieldDef.index = vector.size();
                fieldDef.name = this.dbf.getFieldName(n2).toString();
                fieldDef.label = this.layer.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
                fieldDef.visible = Strings.isNullOrBlank(string2) || string2.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
                fieldDef.editable = !Strings.isNullOrBlank(string) && string.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
                vector.addElement(fieldDef);
            }
            ++n2;
        }
        n = vector.size();
        this.layer.initFields(n);
        int n4 = 0;
        while (n4 < n) {
            this.layer.setFieldDef(n4, (FieldDef)vector.elementAt(n4));
            ++n4;
        }
        LayerVector layerVector = (LayerVector)this.layer;
        layerVector.fi_description = layerVector.getFieldIndex(layerVector.f_description);
        layerVector.fi_id = layerVector.getFieldIndex(layerVector.f_id);
        if (layerVector.fi_id >= 0) {
            layerVector.f_id_istext = SQLConst.isText(layerVector.getFieldDef((int)layerVector.fi_id).type);
        }
        this.layer.prepareLayer();
    }
}

