/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alov.data.DbfConsts;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.ExDate;
import org.alov.util.Readers;
import org.alov.util.Strings;
import org.alov.util.Utils;

public class Dbf
implements DbfConsts {
    private int dbf_id;
    private int last_update_d;
    private int last_update_m;
    private int last_update_y;
    private int last_rec;
    private int position = -1;
    private int data_offset;
    private int rec_size;
    private StringBuffer[] records = null;
    private boolean hasmemo;
    private int filesize;
    private int numfields;
    private DataInputStream dataInput = null;
    private String encoding = null;
    public DbfFieldDef[] fielddef = null;

    public Dbf(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, true);
    }

    public Dbf(InputStream inputStream, String string, boolean bl) throws IOException {
        DataInputStream dataInputStream;
        this.encoding = Strings.isNullOrBlank(string) ? Readers.ENCODING : string;
        this.dataInput = dataInputStream = new DataInputStream(inputStream);
        this.init();
        if (bl) {
            this.records = this.GrabFile();
        }
    }

    public int getLastRec() {
        return this.last_rec;
    }

    public int getNumFields() {
        return this.numfields;
    }

    public int getFieldNumber(String string) {
        int n = 0;
        while (n < this.numfields) {
            if (string.equalsIgnoreCase(this.fielddef[n].fieldname.toString())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public StringBuffer getFieldName(int n) {
        return this.fielddef[n].fieldname;
    }

    public char getFieldType(int n) {
        return this.fielddef[n].fieldtype;
    }

    private void init() throws IOException {
        DbfFileHeader dbfFileHeader = new DbfFileHeader(this.dataInput);
        this.fielddef = new DbfFieldDef[this.numfields];
        int n = 1;
        int n2 = 0;
        while (n2 < this.numfields) {
            this.fielddef[n2] = new DbfFieldDef(this.dataInput, n);
            n += this.fielddef[n2].fieldlen;
            ++n2;
        }
        this.dataInput.skipBytes(1);
        this.position = -1;
    }

    private StringBuffer GrabNextDbfRec() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.rec_size + this.numfields);
        if (this.position >= this.last_rec) {
            return stringBuffer;
        }
        long l = 1L;
        while (l > 0L) {
            char c = (char)this.dataInput.readUnsignedByte();
            if (c != ' ') {
                l = this.dataInput.skip(this.rec_size - 1);
                --this.last_rec;
                if (this.position != this.last_rec) continue;
                return stringBuffer;
            }
            stringBuffer.append(c);
            break;
        }
        int n = 1;
        while (n < this.rec_size) {
            char c = (char)this.dataInput.readUnsignedByte();
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer;
    }

    private StringBuffer[] GrabFile() throws IOException {
        StringBuffer[] stringBufferArray = new StringBuffer[this.last_rec];
        this.position = 0;
        while (this.position < this.last_rec) {
            stringBufferArray[this.position] = this.GrabNextDbfRec();
            ++this.position;
        }
        this.position = -1;
        return stringBufferArray;
    }

    public void ParseNextDbfRecord(Record record) throws IOException {
        String string;
        StringBuffer stringBuffer;
        ++this.position;
        StringBuffer stringBuffer2 = stringBuffer = this.records == null ? this.GrabNextDbfRec() : this.records[this.position];
        if (record == null) {
            return;
        }
        Integer n = new Integer(0);
        Double d = new Double(0.0);
        String string2 = string = stringBuffer == null ? "" : stringBuffer.toString();
        if ("&".equals(string) || string.length() < 1) {
            record.setId("&");
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < this.numfields) {
            String string3 = this.fielddef[n3].fieldstart > n2 ? "" : string.substring(this.fielddef[n3].fieldstart, this.fielddef[n3].fieldstart + this.fielddef[n3].fieldlen).trim();
            switch (this.fielddef[n3].fieldtype) {
                case 'C': {
                    record.setField(n3, Readers.Read2Unicode(string3, this.encoding).trim());
                    break;
                }
                case 'D': {
                    record.setField(n3, ExDate.parseDBFstring(string3));
                    break;
                }
                case 'F': 
                case 'I': 
                case 'N': {
                    if (this.fielddef[n3].fieldnumdec > 0) {
                        try {
                            record.setField(n3, Double.valueOf(string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            record.setField(n3, d);
                        }
                        break;
                    }
                    try {
                        record.setField(n3, Integer.decode(string3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        record.setField(n3, n);
                    }
                    break;
                }
                case 'L': {
                    record.setField(n3, string3);
                    break;
                }
            }
            ++n3;
        }
    }

    public void loadToLayer(LayerVector layerVector) throws AlovMapException {
        try {
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            if (layerVector instanceof LayerZoomify) {
                layerVector.objectType = 4;
            }
            if (layerVector.objectType == 4 || layerVector.objectType == 2) {
                n = layerVector.getFieldIndex(layerVector.f_xmin);
                n2 = layerVector.getFieldIndex(layerVector.f_xmax);
                n3 = layerVector.getFieldIndex(layerVector.f_ymin);
                n4 = layerVector.getFieldIndex(layerVector.f_ymax);
                if (n < 0 && n2 < 0 && n3 < 0 && n4 < 0) {
                    n = layerVector.getFieldIndex("xmin");
                    n2 = layerVector.getFieldIndex("xmax");
                    n3 = layerVector.getFieldIndex("ymin");
                    n4 = layerVector.getFieldIndex("ymax");
                }
                if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
                if (layerVector.objectType != 2) {
                    layerVector.objectType = 3;
                }
            } else {
                layerVector.objectType = 1;
                n5 = layerVector.getFieldIndex(layerVector.f_x);
                n6 = layerVector.getFieldIndex(layerVector.f_y);
                if (n5 < 0 && n6 < 0) {
                    n5 = layerVector.getFieldIndex("LONG");
                    n6 = layerVector.getFieldIndex("LAT");
                }
                if (n5 < 0 && n6 < 0) {
                    n5 = layerVector.getFieldIndex("X");
                    n6 = layerVector.getFieldIndex("Y");
                }
                if (n5 < 0 || n6 < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
            }
            int n7 = this.records.length;
            int n8 = this.getNumFields();
            int n9 = 0;
            while (n9 < n7) {
                Record record = new Record(n8);
                this.ParseNextDbfRecord(record);
                if (!"&".equals(record.getId())) {
                    Shape shape;
                    if (layerVector.objectType == 3) {
                        shape = record.newShape(4);
                        shape.xCoords[0] = layerVector.getFieldDouble(record, n);
                        shape.yCoords[0] = layerVector.getFieldDouble(record, n3);
                        shape.xCoords[1] = shape.xCoords[0];
                        shape.yCoords[1] = layerVector.getFieldDouble(record, n4);
                        shape.xCoords[2] = layerVector.getFieldDouble(record, n2);
                        shape.yCoords[2] = shape.yCoords[1];
                        shape.xCoords[3] = shape.xCoords[2];
                        shape.yCoords[3] = shape.yCoords[0];
                    } else if (layerVector.objectType == 2) {
                        shape = record.newShape(2);
                        shape.xCoords[0] = layerVector.getFieldDouble(record, n);
                        shape.yCoords[0] = layerVector.getFieldDouble(record, n3);
                        shape.xCoords[1] = layerVector.getFieldDouble(record, n2);
                        shape.yCoords[1] = layerVector.getFieldDouble(record, n4);
                    } else {
                        shape = record.newShape(1);
                        shape.xCoords[0] = layerVector.getFieldDouble(record, n5);
                        shape.yCoords[0] = layerVector.getFieldDouble(record, n6);
                    }
                    record.setId(layerVector.fi_id < 0 ? Integer.toString(n9 + 1) : record.getField(layerVector.fi_id).toString());
                    layerVector.addRecord(record);
                }
                ++n9;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AlovMapException(106, exception.getMessage());
        }
    }

    public class DbfFieldDef {
        public StringBuffer fieldname = new StringBuffer(11);
        public char fieldtype;
        public int fieldstart;
        public int fieldlen;
        public int fieldnumdec;

        DbfFieldDef(DataInputStream dataInputStream, int n) throws IOException {
            boolean bl = true;
            int n2 = 0;
            while (n2 < 11) {
                char c = (char)dataInputStream.readUnsignedByte();
                if (c > '\u0000' && bl) {
                    this.fieldname.append(c);
                } else if (this.fieldname.length() > 0) {
                    bl = false;
                }
                ++n2;
            }
            this.fieldtype = (char)dataInputStream.readUnsignedByte();
            this.fieldstart = n;
            dataInputStream.skipBytes(4);
            switch (this.fieldtype) {
                case 'C': 
                case 'D': 
                case 'G': 
                case 'L': 
                case 'M': 
                case 'c': {
                    this.fieldlen = dataInputStream.readUnsignedByte();
                    this.fieldnumdec = dataInputStream.readUnsignedByte();
                    this.fieldnumdec = 0;
                    break;
                }
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    this.fieldlen = dataInputStream.readUnsignedByte();
                    this.fieldnumdec = dataInputStream.readUnsignedByte();
                    if (this.fieldnumdec != 0) break;
                    this.fieldtype = (char)73;
                    break;
                }
            }
            dataInputStream.skipBytes(14);
        }
    }

    class DbfFileHeader {
        DbfFileHeader(DataInputStream dataInputStream) throws IOException {
            this.getDbfFileHeader(dataInputStream);
        }

        private void getDbfFileHeader(DataInputStream dataInputStream) throws IOException {
            long l;
            Dbf.this.dbf_id = dataInputStream.readUnsignedByte();
            if (Dbf.this.dbf_id == 3) {
                Dbf.this.hasmemo = true;
            } else {
                Dbf.this.hasmemo = false;
            }
            Dbf.this.last_update_y = dataInputStream.readUnsignedByte();
            Dbf.this.last_update_m = dataInputStream.readUnsignedByte();
            Dbf.this.last_update_d = dataInputStream.readUnsignedByte();
            Dbf.this.last_rec = Readers.readInt(dataInputStream);
            Dbf.this.data_offset = Readers.readShort(dataInputStream);
            Dbf.this.rec_size = Readers.readShort(dataInputStream);
            Dbf.this.filesize = Dbf.this.rec_size * Dbf.this.last_rec + Dbf.this.data_offset + 1;
            if (Utils.isJava14 && (float)((l = (long)Utils.getFreeMemorySpace()) - (long)Dbf.this.filesize) < 0.2f * (float)Utils.MaxMem) {
                throw new IOException("DBF exceeding threshold size (would use 80% of available memory)");
            }
            Dbf.this.numfields = (Dbf.this.data_offset - 32 - 1) / 32;
            dataInputStream.skipBytes(20);
        }
    }
}

