/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import org.alov.map.FilterRecords;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.util.ExDate;
import org.alov.util.TimeInterval;

public class FilterTime
extends FilterRecords {
    private int timeFieldIndex1;
    private int timeFieldIndex2;
    private int dateType;
    private LayerVector layer;
    private TimeInterval time = null;

    public FilterTime(LayerVector layerVector) {
        this.layer = layerVector;
        this.timeFieldIndex1 = layerVector.getFieldIndex(layerVector.f_dateLow);
        this.timeFieldIndex2 = layerVector.getFieldIndex(layerVector.f_dateHigh);
        this.dateType = layerVector.dateType;
        this.state = this.dateType == 1 && this.timeFieldIndex1 >= 0 && this.timeFieldIndex2 >= 0 || this.dateType == 2 && this.timeFieldIndex1 >= 0 ? 2 : 3;
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        this.time = timeInterval;
        this.state = this.time == null ? 0 : 2;
    }

    public boolean checkRecord(Record record) {
        Object object;
        if (record.dateInvalid || this.time == null) {
            return true;
        }
        if (record.dateLow == null) {
            object = this.layer.getFieldValue(record, this.timeFieldIndex1);
            try {
                record.dateLow = ExDate.parseObject(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (record.dateLow == null) {
                record.dateInvalid = true;
                return true;
            }
        }
        if (this.dateType == 1 && record.dateHigh == null) {
            object = this.layer.getFieldValue(record, this.timeFieldIndex2);
            try {
                record.dateHigh = ExDate.parseObject(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (record.dateHigh == null) {
                record.dateHigh = record.dateLow;
            }
        }
        if (this.dateType == 2) {
            return this.time.contains(record.dateLow);
        }
        if (this.dateType == 1) {
            return this.time.intersects(record.dateLow, record.dateHigh);
        }
        return true;
    }
}

