/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Loader;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.Const;
import org.alov.util.ExDate;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Project
implements Const,
Serializable {
    public String name;
    public String language = "en";
    public int MapUnits;
    protected String geoProjection = null;
    public int ZoomUnits;
    public Vector layers = new Vector();
    public Hashtable domains = new Hashtable();
    public Hashtable themes = new Hashtable();
    public Hashtable themesLayer = new Hashtable();
    public String domainsNames = "";
    public String themesNames = "";
    public FloatRectangle maxExtent = null;
    public String startExtentName = null;
    public String startTheme = null;
    public String startLayer = null;
    public double zmin;
    public double zmax;
    public Color mapBackground;
    public boolean moveBeyondProject = false;
    public boolean hasKeyMap = false;
    public Color keyMapOutline;
    public Color keyMapBackground;
    public String keyMapTheme = "unnamed";
    public String linkSearch = null;
    public String linkInfo = null;
    public String linkMain = null;
    public boolean isDynamic = true;
    public boolean isDynamic_LayerVisible = true;
    public boolean isDynamic_RemoveOutOfExtent = true;
    public int iDynamic_OrderOfLayers = 0;
    public boolean isTimeMap = false;
    public boolean isDynamic_SearchAlways = true;
    public boolean isDynamic_AcceptAll = false;
    public String sDynamoAdd = "";
    public boolean forceSearchForDynamic = false;
    public Vector dynamicLayers = null;
    public Vector renderers = new Vector();
    public int rendererDynamicCount = 0;
    public int animationDelay = 1000;
    boolean isLoaded = false;
    public boolean isTimeEnabled = false;
    protected String SRS = "EPSG:4326";
    public ExDate startDate;
    public ExDate endDate;

    public String getWebLink(Layer layer, Record record) {
        return layer.getWebLink(layer.linkMain != null ? layer.linkMain : this.linkMain, record, null, null, null);
    }

    public void sortRenderersByLevels() {
        Serializable serializable;
        int n;
        Enumeration enumeration;
        Hashtable<Integer, Vector<Renderer>> hashtable = new Hashtable<Integer, Vector<Renderer>>();
        Vector<Renderer> vector = new Vector<Renderer>();
        int n2 = this.getLayerCount();
        int n3 = 0;
        while (n3 < n2) {
            enumeration = (Layer)this.layers.elementAt(n3);
            Vector vector2 = ((Layer)((Object)enumeration)).renderers;
            int n4 = vector2.size();
            n = 0;
            while (n < n4) {
                Renderer renderer = (Renderer)vector2.elementAt(n);
                if (renderer.isDynamic()) {
                    vector.addElement(renderer);
                } else {
                    Integer n5 = new Integer(renderer.getLevel());
                    serializable = (Vector<Renderer>)hashtable.get(n5);
                    if (serializable == null) {
                        serializable = new Vector<Renderer>();
                        hashtable.put(n5, (Vector<Renderer>)serializable);
                    }
                    serializable.addElement(renderer);
                }
                ++n;
            }
            ++n3;
        }
        enumeration = hashtable.keys();
        int n6 = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n6;
        }
        Integer[] integerArray = new Integer[n6];
        enumeration = hashtable.keys();
        n = 0;
        while (n < n6) {
            integerArray[n] = (Integer)enumeration.nextElement();
            ++n;
        }
        boolean bl = false;
        while (!bl) {
            bl = true;
            int n7 = 0;
            while (n7 < n6 - 1) {
                if (integerArray[n7] > integerArray[n7 + 1]) {
                    serializable = integerArray[n7];
                    integerArray[n7] = integerArray[n7 + 1];
                    integerArray[n7 + 1] = serializable;
                    bl = false;
                }
                ++n7;
            }
        }
        int n8 = this.renderers.size();
        int n9 = 0;
        while (n9 < n8) {
            ((Vector)this.renderers.elementAt(n9)).removeAllElements();
            ++n9;
        }
        this.renderers.removeAllElements();
        int n10 = 0;
        while (n10 < n6) {
            this.renderers.addElement(hashtable.get(integerArray[n10]));
            ++n10;
        }
        if (vector.size() > 0) {
            this.renderers.addElement(vector);
            this.rendererDynamicCount = 1;
        }
    }

    public int getLayerCount() {
        return this.layers == null ? 0 : this.layers.size();
    }

    public Layer getLayerById(String string) {
        int n = this.getLayerCount();
        int n2 = 0;
        while (n2 < n) {
            Layer layer = (Layer)this.layers.elementAt(n2);
            if (layer.id.equals(string)) {
                return layer;
            }
            ++n2;
        }
        return null;
    }

    public Layer getLayerByDsId(String string) {
        int n = this.getLayerCount();
        int n2 = 0;
        while (n2 < n) {
            Layer layer = (Layer)this.layers.elementAt(n2);
            if (layer.datasetId.equals(string)) {
                return layer;
            }
            ++n2;
        }
        return null;
    }

    public Layer getLayerByName(String string) {
        int n = this.getLayerCount();
        if (string != null) {
            int n2 = 0;
            while (n2 < n) {
                Layer layer = (Layer)this.layers.elementAt(n2);
                if (string.equalsIgnoreCase(layer.getName())) {
                    return layer;
                }
                ++n2;
            }
        }
        return null;
    }

    public Layer getLayerByIndex(int n) {
        return (Layer)this.layers.elementAt(n);
    }

    public XmlElement load(InputStream inputStream, LayerSetup layerSetup) throws Exception {
        XmlElement xmlElement = XmlUtils.parseStream(inputStream, "");
        Loader.parseProject(this, xmlElement, layerSetup);
        int n = this.getLayerCount();
        int n2 = 0;
        while (n2 < n) {
            Layer layer = this.getLayerByIndex(n2);
            layer.setDepend(this);
            ++n2;
        }
        layerSetup.addStatusInfo(0, null, "end parse " + n);
        this.isLoaded = true;
        return xmlElement;
    }

    public void kill() {
        this.isLoaded = false;
        int n = this.layers.size();
        int n2 = 0;
        while (n2 < n) {
            Layer layer = this.getLayerByIndex(n2);
            layer.clear(true);
            layer = null;
            ++n2;
        }
        this.renderers.removeAllElements();
        this.layers.removeAllElements();
        this.layers = null;
        this.domains = null;
        this.themes = null;
        this.themesLayer = null;
    }

    void clearSameLayers(Layer layer) {
        layer.clear(false);
        int n = this.getLayerCount();
        int n2 = 0;
        while (n2 < n) {
            Layer layer2 = this.getLayerByIndex(n2);
            if (layer2.datasetId.equals(layer.datasetId) && !layer2.id.equals(layer.id)) {
                layer2.clear(false);
            }
            ++n2;
        }
    }

    void setSameLayers(Layer layer, LayerSetup layerSetup) {
        block20: {
            block19: {
                if (!(layer instanceof LayerVector)) break block19;
                int n = this.getLayerCount();
                int n2 = 0;
                while (n2 < n) {
                    Layer layer2 = this.getLayerByIndex(n2);
                    if (layer2.datasetId.equals(layer.datasetId) && !layer2.id.equals(layer.id)) {
                        LayerVector layerVector = (LayerVector)layer;
                        LayerVector layerVector2 = (LayerVector)layer2;
                        layerVector2.objectType = layerVector.objectType;
                        layerVector2.assignFields(layerVector.getFields());
                        layerVector2.fieldCountToDownload = layerVector.fieldCountToDownload;
                        layerVector2.fi_description = layerVector.fi_description;
                        if (layerVector2.linkMain == null) {
                            layerVector2.linkMain = layerVector.linkMain;
                        }
                        if (layerVector2.linkSearch == null) {
                            layerVector2.linkSearch = layerVector.linkSearch;
                        }
                        if (layerVector2.linkInfo == null) {
                            layerVector2.linkInfo = layerVector.linkInfo;
                        }
                        if (layerVector2.linkTips == null) {
                            layerVector2.linkTips = layerVector.linkTips;
                        }
                        if (layerVector2.localFilter == null) {
                            layerVector2.localFilter = layerVector.localFilter;
                        }
                        layerVector2.dateType = layerVector.dateType;
                        layerVector2.f_dateLow = layerVector.f_dateLow;
                        layerVector2.f_dateHigh = layerVector.f_dateHigh;
                        if (layer instanceof LayerZoomify) {
                            LayerZoomify layerZoomify = (LayerZoomify)layerVector;
                            ((LayerZoomify)layerVector2).setDimensions(layerZoomify.geoWidth, layerZoomify.geoHeight, layerZoomify.imageWidth, layerZoomify.imageHeight, layerZoomify.tileSize, layerZoomify.levelCount);
                        }
                        try {
                            layer2.prepareLayer();
                        }
                        catch (Exception exception) {
                            layer2.metadata.loadFailed = true;
                            layerSetup.addStatusInfo(0, layer2, exception.getMessage());
                        }
                    }
                    ++n2;
                }
                break block20;
            }
            if (!(layer instanceof LayerRaster)) break block20;
            int n = this.getLayerCount();
            int n3 = 0;
            while (n3 < n) {
                Layer layer3 = this.getLayerByIndex(n3);
                if (layer3.datasetId.equals(layer.datasetId) && !layer3.id.equals(layer.id)) {
                    LayerRaster layerRaster = (LayerRaster)layer;
                    LayerRaster layerRaster2 = (LayerRaster)layer3;
                    if (layerRaster.resolutionLevel <= 0 && layerRaster2.resolutionLevel <= 0) {
                        if (layerRaster2.linkMain == null) {
                            layerRaster2.linkMain = layerRaster.linkMain;
                        }
                        if (layerRaster2.linkSearch == null) {
                            layerRaster2.linkSearch = layerRaster.linkSearch;
                        }
                        if (layerRaster2.linkTips == null) {
                            layerRaster2.linkTips = layerRaster.linkTips;
                        }
                        layerRaster2.imageOriginal = layerRaster.imageOriginal;
                        layerRaster2.image = layerRaster.image;
                        if (!layerRaster.isDataOnServer || layerRaster2.notPrepared) {
                            try {
                                layer3.prepareLayer();
                            }
                            catch (Exception exception) {
                                layer3.metadata.loadFailed = true;
                                layerSetup.addStatusInfo(0, layer3, exception.getMessage());
                            }
                        }
                        layerRaster2.layerExtent = layerRaster.layerExtent;
                    }
                }
                ++n3;
            }
        }
    }

    public void saveToRawFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            gZIPOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Project loadFromRawFile(InputStream inputStream) throws IOException, ClassNotFoundException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        Project project = (Project)objectInputStream.readObject();
        gZIPInputStream.close();
        return project;
    }
}

