/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.alov.util.Strings;

public class ExDate
implements Serializable {
    static final double _YRS = 365.25;
    static final double _MON = 30.4375;
    static final double _HRS = 0.041666666666666664;
    static final double _MIN = 6.944444444444444E-4;
    static final double _SEC = 1.1574074074074073E-5;
    private static final long dateOrigin = 2044000L;
    private static final long D1 = 365L;
    private static final long D4 = 1461L;
    private static final long D100 = 36524L;
    private static final long D400 = 146097L;
    private static final int[][] monthDays = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    double days;

    public ExDate() {
    }

    public ExDate(double d) {
        this.days = d;
    }

    public ExDate(long l, long l2, long l3) {
        this(l, l2, l3, 0L, 0L, 0L);
    }

    public ExDate(long l, long l2, long l3, long l4, long l5, long l6) {
        this.days = ExDate.encode(l, l2, l3, l4, l5, l6);
    }

    public static double encode(long l, long l2, long l3, long l4, long l5, long l6) {
        int[] nArray = monthDays[ExDate.isLeapYear(l += 2044000L)];
        if (l < 0L || l2 < 1L || l2 > 12L || l3 < 1L || l3 > (long)nArray[(int)l2 - 1] || l4 < 0L || l4 > 23L || l5 < 0L || l5 > 59L || l6 < 0L || l6 > 59L) {
            return Double.NaN;
        }
        int n = 1;
        while ((long)n <= l2 - 1L) {
            l3 += (long)nArray[n - 1];
            ++n;
        }
        long l7 = l - 1L;
        double d = (double)l7 * 365.0 + (double)(l7 / 4L) - (double)(l7 / 100L) + (double)(l7 / 400L) + (double)l3;
        return d += ((double)l4 + (double)l5 / 60.0 + (double)l6 / 3600.0) / 24.0;
    }

    public double getDays() {
        return this.days;
    }

    public int compareTo(ExDate exDate) {
        if (exDate.days > this.days) {
            return -1;
        }
        if (exDate.days < this.days) {
            return 1;
        }
        return 0;
    }

    public void increaseUnits(int n, double d) throws Exception {
        switch (n) {
            case 0: {
                long[] lArray = this.getYMDHMS();
                lArray[0] = (long)((double)lArray[0] + Math.ceil(d));
                this.days = ExDate.encode(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5]);
                this.days += 365.25 * (d - Math.ceil(d));
                break;
            }
            case 1: {
                long[] lArray = this.getYMDHMS();
                lArray[1] = (long)((double)lArray[1] + Math.ceil(d));
                this.days = ExDate.encode(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5]);
                this.days += 30.4375 * (d - Math.ceil(d));
                break;
            }
            case 2: {
                this.days += d;
                break;
            }
            case 3: {
                this.days += 0.041666666666666664 * d;
                break;
            }
            case 4: {
                this.days += 6.944444444444444E-4 * d;
                break;
            }
            case 5: {
                this.days += 1.1574074074074073E-5 * d;
                break;
            }
            default: {
                throw new Exception("Invalid time units: " + n);
            }
        }
    }

    public static ExDate parseObject(Object object) {
        if (object instanceof ExDate) {
            return (ExDate)object;
        }
        if (object instanceof String) {
            return ExDate.parseString((String)object);
        }
        if (object instanceof Number) {
            return ExDate.parseNumber((Number)object);
        }
        return null;
    }

    public static ExDate parseNumber(Number number) {
        long l = (long)number.doubleValue();
        if (Math.abs(l) > 9999L) {
            String string = number.toString();
            return ExDate.parseDBFstring(string);
        }
        return new ExDate(l, 1L, 1L);
    }

    public static ExDate parseDBFstring(String string) {
        int n = string.charAt(0) == '-' ? 5 : 4;
        int n2 = string.length();
        long l = Strings.strToInt(string.substring(0, n), 1);
        long l2 = n2 > n ? (long)Strings.strToInt(string.substring(n, n + 2), 1) : 1L;
        long l3 = n2 > n + 2 ? (long)Strings.strToInt(string.substring(n + 2, n + 4), 1) : 1L;
        return new ExDate(l, l2, l3);
    }

    public static ExDate parseString(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        int n = 1;
        if (string.charAt(0) == '-') {
            string = string.substring(1);
            n = -1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-T:/ ");
        long[] lArray = new long[6];
        int n2 = 0;
        while (n2 < 6) {
            lArray[n2] = stringTokenizer.hasMoreTokens() ? Long.parseLong(stringTokenizer.nextToken()) : (n2 < 3 ? 1L : 0L);
            ++n2;
        }
        return new ExDate((long)n * lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5]);
    }

    private static int isLeapYear(long l) {
        return l % 4L == 0L && (l % 100L != 0L || l % 400L == 0L) ? 1 : 0;
    }

    public static long[] getYMDHMS(double d) {
        long l;
        long l2;
        long l3;
        double d2 = (d += 1.1574074074074074E-6) - Math.floor(d);
        long l4 = (long)Math.floor(d2 * 24.0) % 24L;
        long l5 = (long)Math.floor(d2 * 24.0 * 60.0) % 60L;
        long l6 = (long)Math.floor(d2 * 24.0 * 3600.0) % 60L;
        long l7 = (long)Math.floor(d);
        if (l7 <= 0L) {
            l3 = 0L;
            l2 = 0L;
            l = 0L;
            long l8 = 0L;
        } else {
            long l9 = l7 % 7L;
            --l7;
            long l10 = 1L;
            while (l7 >= 146097L) {
                l7 -= 146097L;
                l10 += 400L;
            }
            long l11 = l7 / 36524L;
            long l12 = l7 % 36524L;
            if (l11 == 4L) {
                --l11;
                l12 += 36524L;
            }
            l10 += l11 * 100L;
            l11 = l12 / 1461L;
            l10 += l11 * 4L;
            l11 = (l12 %= 1461L) / 365L;
            l12 %= 365L;
            if (l11 == 4L) {
                --l11;
                l12 += 365L;
            }
            int[] nArray = monthDays[ExDate.isLeapYear(l10 += l11)];
            int n = 1;
            while (l12 >= (l11 = (long)nArray[n - 1])) {
                l12 -= l11;
                ++n;
            }
            l3 = l10 - 2044000L;
            l2 = n;
            l = l12 + 1L;
        }
        long[] lArray = new long[]{l3, l2, l, l4, l5, l6};
        return lArray;
    }

    public long[] getYMDHMS() {
        return ExDate.getYMDHMS(this.days);
    }

    public long getYear() {
        long[] lArray = ExDate.getYMDHMS(this.days);
        return lArray[0];
    }

    public static String toString(double d) {
        return ExDate.toString(d, 5);
    }

    public static String toString(double d, int n) {
        long[] lArray = ExDate.getYMDHMS(d);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 <= n) {
            if (n2 > 0) {
                stringBuffer.append("-- ::".charAt(n2 - 1));
            }
            stringBuffer.append(lArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return ExDate.toString(this.days);
    }

    public String toString(int n) {
        return ExDate.toString(this.days, n);
    }
}

