/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.util.Vector;
import org.alov.util.TimerListener;

public class SimpleTimer
implements Runnable {
    public Vector listeners = new Vector();
    public long interval;
    public long currentTime = 0L;
    public boolean terminate;

    public SimpleTimer(long l) {
        if (l < 1L) {
            l = 1L;
        }
        this.interval = l;
    }

    public SimpleTimer(long l, TimerListener timerListener) {
        if (l < 1L) {
            l = 1L;
        }
        this.interval = l;
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeAllElements();
            this.listeners.addElement(timerListener);
            this.listeners.notify();
        }
        this.terminate = false;
        Thread thread = new Thread((Runnable)this, "ALOV SimpleTimer");
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.terminate = true;
            this.listeners.notify();
            this.listeners.removeAllElements();
        }
    }

    public void run() {
        while (!this.terminate) {
            try {
                Object object;
                Vector vector = this.listeners;
                synchronized (vector) {
                    while (this.listeners.size() == 0 && !this.terminate) {
                        this.listeners.wait();
                    }
                }
                if (this.terminate) break;
                Object object2 = object = new Object();
                synchronized (object2) {
                    object.wait(this.interval);
                    if (this.terminate) {
                        break;
                    }
                    this.currentTime += this.interval;
                    Vector vector2 = this.listeners;
                    synchronized (vector2) {
                        int n = 0;
                        while (n < this.listeners.size()) {
                            TimerListener timerListener = (TimerListener)this.listeners.elementAt(n);
                            timerListener.timerTick(this);
                            ++n;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

