/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.util.Strings;
import org.alov.util.XmlUtils;

public class XmlElement {
    Vector children = new Vector();
    Hashtable attributes = new Hashtable();
    String tagName;
    public String value = null;

    public XmlElement(String string) {
        this.tagName = string;
    }

    public String getNodeName() {
        return this.tagName;
    }

    public Vector getChildren() {
        return this.children;
    }

    public Vector getElementsByTagName(String string) {
        return this.getElementsByTagName(string, false);
    }

    public Vector getElementsByTagName(String string, boolean bl) {
        Vector<XmlElement> vector = new Vector<XmlElement>();
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            XmlElement xmlElement = (XmlElement)this.children.elementAt(n2);
            if (XmlElement.stringEquals(xmlElement.tagName, string, bl)) {
                vector.addElement(xmlElement);
            }
            ++n2;
        }
        return vector;
    }

    public XmlElement getFirstElementByName(String string) {
        return this.getFirstElementByName(string, false);
    }

    public XmlElement getFirstElementByName(String string, boolean bl) {
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            XmlElement xmlElement = (XmlElement)this.children.elementAt(n2);
            if (XmlElement.stringEquals(xmlElement.tagName, string, bl)) {
                return xmlElement;
            }
            ++n2;
        }
        return null;
    }

    public XmlElement getLangElementByName(String string, String string2, boolean bl) {
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            String string3;
            XmlElement xmlElement = (XmlElement)this.children.elementAt(n2);
            if (XmlElement.stringEquals(xmlElement.tagName, string, bl) && (string3 = xmlElement.getAttributeValue("xml:lang")).equalsIgnoreCase(string2)) {
                return xmlElement;
            }
            ++n2;
        }
        return null;
    }

    public XmlElement findElementByAttrib(String string, String string2, String string3, boolean bl) {
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            String string4;
            XmlElement xmlElement = (XmlElement)this.children.elementAt(n2);
            if (XmlElement.stringEquals(xmlElement.tagName, string, bl) && (string4 = xmlElement.getAttributeValue(string2)) != null && XmlElement.stringEquals(string4, string3, bl)) {
                return xmlElement;
            }
            ++n2;
        }
        return null;
    }

    public Vector findAllElementByAttrib(String string, String string2, String string3, boolean bl) {
        Vector<XmlElement> vector = new Vector<XmlElement>();
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            XmlElement xmlElement = (XmlElement)this.children.elementAt(n2);
            if (XmlElement.stringEquals(xmlElement.tagName, string, bl)) {
                String string4 = xmlElement.getAttributeValue(string2);
                if (string4 != null && XmlElement.stringEquals(string4, string3, bl)) {
                    vector.addElement(xmlElement);
                }
                XmlUtils.addAll(vector, xmlElement.findAllElementByAttrib(string, string2, string3, bl));
            }
            ++n2;
        }
        return vector;
    }

    public String getAttributeValue(String string) {
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (String)this.attributes.get(string2);
        }
        return null;
    }

    public void addChild(XmlElement xmlElement) {
        this.children.addElement(xmlElement);
    }

    public XmlElement addChildElement(String string, String string2) {
        XmlElement xmlElement = new XmlElement(string);
        if (!Strings.isNullOrBlank(string2)) {
            xmlElement.value = string2;
        }
        this.addChild(xmlElement);
        return xmlElement;
    }

    public void addAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    void addCharacters(char[] cArray) {
        String string = new String(cArray);
        this.value = this.value != null ? this.value + string : string;
    }

    public String getElValue(String string, String string2) {
        return this.getElValue(string, string2, false);
    }

    public String getElValue(String string, String string2, boolean bl) {
        XmlElement xmlElement = this.getFirstElementByName(string, bl);
        return xmlElement == null || xmlElement.value == null ? string2 : xmlElement.value.trim();
    }

    private static boolean stringEquals(String string, String string2, boolean bl) {
        if (bl) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }
}

