/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DisplayContext;
import org.alov.map.DisplayContextImpl;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.MapUtils;
import org.alov.map.Renderer;
import org.alov.viewer.LayerControlItem;
import org.alov.viewer.LayerCtl;
import org.alov.viewer.MyDisplayContext;

class LayerCtlImpl
extends Canvas
implements MouseListener,
ComponentListener {
    Color selectionColor = Color.white;
    Color networkColor = new Color(208, 208, 238);
    Color disabledColor = Color.gray;
    Color failureColor = Color.gray;
    boolean drawSeparator = false;
    boolean drawSelection = true;
    Font fontBold = MapUtils.defaultBoldFont;
    Font fontPlain = MapUtils.defaultPlainFont;
    Image imageClock = null;
    Image imageZoomIn = null;
    Image imageZoomOut = null;
    Image imageNetwork = null;
    Image imageOutExt = null;
    Image imageKey = null;
    Vector sync_with = new Vector();
    int legendWidth = 120;
    private static final int minItemHeight = 16;
    private int itemWidth = 24;
    private int selection = -1;
    Dimension minSize = null;
    LayerCtl parentCtl;
    LayerControlItem[] items = null;
    Carte map = null;

    LayerCtlImpl(LayerCtl layerCtl) {
        this.parentCtl = layerCtl;
        this.minSize = new Dimension(this.legendWidth, 10);
        this.setSize(this.minSize);
        this.addMouseListener(this);
    }

    public synchronized void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paint(graphics);
                Object var3_2 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (graphics != null && this.items != null) {
            Dimension dimension = this.getSize();
            if (dimension == null || dimension.width <= 0 || dimension.height <= 0) {
                return;
            }
            Image image = this.createImage(dimension.width, dimension.height);
            if (image == null) {
                return;
            }
            try {
                DisplayContextImpl displayContextImpl = new DisplayContextImpl(this.map, graphics, this.map.getProjection(), this.map.getLastExtent());
                LayerCtlImpl.paintItems(this.items, displayContextImpl, this.selection, true);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    private static void paintItems(LayerControlItem[] layerControlItemArray, DisplayContext displayContext, int n, boolean bl) {
        int n2 = layerControlItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            LayerControlItem layerControlItem = layerControlItemArray[n3];
            int n4 = layerControlItem.getHeight();
            if (n4 > 0) {
                layerControlItem.paint(n3 == n, bl, displayContext);
            }
            ++n3;
        }
    }

    void synchronyzeLegends(String string) {
        Layer layer;
        if (this.map != null && (layer = this.map.getProject().getLayerById(string)) != null) {
            Object[] objectArray = new Object[]{layer.datasetId, new Boolean(layer.isVisible())};
            int n = this.sync_with.size();
            int n2 = 0;
            while (n2 < n) {
                LayerCtl layerCtl = (LayerCtl)this.sync_with.elementAt(n2);
                layerCtl.notifyStatus(118, objectArray);
                ++n2;
            }
        }
    }

    void changeLayerVisibility(Object[] objectArray) {
        Layer layer;
        if (this.map != null && (layer = this.map.getProject().getLayerByDsId((String)objectArray[0])) != null) {
            layer.setVisible((Boolean)objectArray[1]);
        }
    }

    void setMap(Carte carte) {
        this.map = carte;
    }

    void clear() {
        this.items = null;
    }

    void setLayers(Vector vector) {
        this.items = LayerCtlImpl.refreshItemList(vector, this);
        this.mapUpdated();
    }

    public int getWidth() {
        Dimension dimension = this.getSize();
        return dimension.width;
    }

    static BufferedImage paintLayers(Vector vector, DisplayContext displayContext, Color color, int n, int n2) {
        Graphics graphics;
        Object object;
        if (n <= 0) {
            n = 200;
        }
        LayerControlItem[] layerControlItemArray = LayerCtlImpl.refreshItemList(vector, null);
        int n3 = layerControlItemArray.length;
        int n4 = 0;
        while (n4 < n3) {
            layerControlItemArray[n4].cwidth = n;
            ++n4;
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics graphics2 = bufferedImage.getGraphics();
        if (graphics2 != null) {
            try {
                object = new MyDisplayContext(graphics2, displayContext);
                LayerCtlImpl.updateItemBounds(layerControlItemArray, (DisplayContext)object);
                graphics = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        object = LayerCtlImpl.updateItemLocations(layerControlItemArray, n, n2);
        ((Dimension)object).width += 10;
        ((Dimension)object).height = n2 > 0 ? n2 : (((Dimension)object).height += 20);
        BufferedImage bufferedImage2 = new BufferedImage(((Dimension)object).width, ((Dimension)object).height, 2);
        graphics = bufferedImage2.getGraphics();
        if (graphics != null) {
            try {
                int n5 = 0;
                while (n5 < layerControlItemArray.length) {
                    layerControlItemArray[n5].backColor = color;
                    ++n5;
                }
                graphics.setColor(color);
                graphics.fillRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
                DisplayContextImpl displayContextImpl = new DisplayContextImpl(displayContext, graphics, displayContext.getProjection(), displayContext.getLastExtent());
                LayerCtlImpl.paintItems(layerControlItemArray, displayContextImpl, -1, false);
                Object var16_17 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                graphics.dispose();
                throw throwable;
            }
        }
        return bufferedImage2;
    }

    void selectItem(String string) {
        if (this.items != null && string != null) {
            String string2 = this.parentCtl.getName();
            int n = 0;
            while (n < this.items.length) {
                Layer layer = this.items[n].getLayer();
                if (layer.id.equals(string) && layer.isBelongToLegend(string2) && layer.legendVisible) {
                    this.selection = n;
                    return;
                }
                ++n;
            }
        }
        this.selection = -1;
    }

    public Layer getSelected() {
        if (this.selection >= 0 && this.selection < this.items.length) {
            return this.items[this.selection].getLayer();
        }
        return null;
    }

    public void mapUpdated() {
        if (this.items == null) {
            return;
        }
        this.updateItemBounds();
        this.updateItemLocations();
        Layer layer = this.map.getActiveLayer();
        if (layer != null) {
            this.selectItem(layer.id);
        }
        this.repaint();
    }

    private static void updateItemBounds(LayerControlItem[] layerControlItemArray, DisplayContext displayContext) {
        int n = layerControlItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            layerControlItemArray[n2].updateBounds(displayContext);
            ++n2;
        }
    }

    void updateItemBounds() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                MyDisplayContext myDisplayContext = new MyDisplayContext(graphics, this.map);
                LayerCtlImpl.updateItemBounds(this.items, myDisplayContext);
                Object var4_3 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    private static LayerControlItem[] refreshItemList(Vector vector, LayerCtlImpl layerCtlImpl) {
        Object object;
        int n = vector.size();
        LayerControlItem[] layerControlItemArray = new LayerControlItem[n];
        int n2 = 0;
        String string = layerCtlImpl == null ? null : layerCtlImpl.parentCtl.getName();
        int n3 = 0;
        while (n3 < n) {
            object = (Layer)vector.elementAt(n3);
            if (string == null || ((Layer)object).isBelongToLegend(string)) {
                LayerControlItem layerControlItem = new LayerControlItem((Layer)object, layerCtlImpl);
                layerControlItem.layerCtl = layerCtlImpl;
                layerControlItemArray[n2++] = layerControlItem;
            }
            ++n3;
        }
        object = new LayerControlItem[n2];
        System.arraycopy(layerControlItemArray, 0, object, 0, n2);
        return object;
    }

    private static Dimension updateItemLocations(LayerControlItem[] layerControlItemArray, int n, int n2) {
        int n3 = layerControlItemArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            LayerControlItem layerControlItem = layerControlItemArray[n5];
            layerControlItem.setLocation(0, n4);
            int n6 = layerControlItem.getHeight();
            n4 += n6;
            layerControlItem.setSize(n, n6);
            ++n5;
        }
        return new Dimension(n, n4);
    }

    void updateItemLocations() {
        Dimension dimension = this.parentCtl.getSize();
        Insets insets = this.parentCtl.getInsets();
        int n = dimension.width - insets.left - insets.left;
        Dimension dimension2 = LayerCtlImpl.updateItemLocations(this.items, n, dimension.height);
        if (dimension.height - insets.top - insets.top < dimension2.height) {
            LayerCtlImpl.updateItemLocations(this.items, n -= this.parentCtl.getVScrollbarWidth(), dimension.height);
        }
        this.minSize = new Dimension(n, dimension2.height);
        this.setSize(n, dimension2.height);
        this.parentCtl.doLayout();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2;
        int n3;
        if (this.items == null || this.items.length == 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n4 = this.selection;
        int n5 = -1;
        LayerControlItem layerControlItem = null;
        int n6 = point.y;
        if (n6 >= 0) {
            n3 = this.items.length;
            n2 = 0;
            n = 0;
            while (n < n3) {
                int n7 = this.items[n].getHeight();
                if (n6 < (n2 += n7) && n7 > 0) {
                    n5 = n;
                    layerControlItem = this.items[n];
                    break;
                }
                ++n;
            }
        }
        n3 = 0;
        n2 = 0;
        n = 0;
        this.selection = n5;
        Layer layer = null;
        if (n5 >= 0) {
            n3 = n5 != n4 ? 1 : 0;
            object = new Point(point.x, point.y - layerControlItem.getBounds().y);
            boolean bl = layerControlItem.isExpandButton((Point)object);
            Object object2 = layerControlItem.getCheckboxObject((Point)object);
            int n8 = n = object2 != null ? 1 : 0;
            if (n != 0) {
                layer = layerControlItem.getLayer();
                if (object2 instanceof Layer) {
                    layer.setVisible(!layer.isVisible());
                } else if (object2 instanceof Renderer) {
                    Renderer renderer = (Renderer)object2;
                    renderer.enabled = !renderer.enabled;
                }
                n2 = MapUtils.isNotEmpty(layer.controlledLayers) ? 1 : 0;
                n3 = 1;
            } else if (bl) {
                layerControlItem.expandClicked();
                this.updateItemBounds();
                this.updateItemLocations();
                n2 = 1;
            }
        }
        if (this.map != null) {
            boolean bl = false;
            if (n5 >= 0 && n4 != n5) {
                Vector vector = this.map.getActiveLayer().getSelection();
                bl = MapUtils.isNotEmpty(vector);
            }
            Layer layer2 = null;
            if (this.selection >= 0 && this.selection < this.items.length && (layer2 = this.items[this.selection].getLayer()) instanceof LayerGroup) {
                layer2 = null;
                this.selection = n4;
            }
            if (this.drawSelection) {
                this.map.setActiveLayer(layer2);
            }
            if (bl || n != 0) {
                this.map.updateMap();
            }
        }
        if (n2 != 0) {
            this.repaint();
        } else {
            object = this.getGraphics();
            if (object != null) {
                try {
                    DisplayContextImpl displayContextImpl = new DisplayContextImpl(this.map, (Graphics)object, this.map.getProjection(), this.map.getLastExtent());
                    if (n3 != 0 && this.selection >= 0) {
                        this.items[this.selection].paint(true, true, displayContextImpl);
                    }
                    if (n4 != this.selection && n4 >= 0) {
                        this.items[n4].paint(false, true, displayContextImpl);
                    }
                    Object var16_20 = null;
                    ((Graphics)object).dispose();
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    ((Graphics)object).dispose();
                    throw throwable;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setBounds(0, 0, this.minSize.width, this.minSize.height);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

