/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.alov.addon.TipRect;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;

public class Tooltip
extends ImageButton
implements CarteHostListener,
CarteListener,
ActionListener {
    private Carte map;
    private boolean isTipsActive = false;
    private boolean searchInActiveOnly = true;
    private boolean showInCentroid = false;
    private boolean showWithLayerName = false;
    private TipRect tooltipInstance = null;
    private String previousTip = null;
    private int showTips = 0;
    private boolean fill = true;
    private boolean outline = true;
    private Color fillColor = Color.yellow;
    private Color outlineColor = Color.black;
    private Font font;

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this) {
            this.isTipsActive = !this.isTipsActive;
            this.setDown(this.isTipsActive);
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        String sImage = XmlUtils.getString("image", layout, null);
        this.setImage(host.getImage(sImage));
        this.group = XmlUtils.getInt("group", layout, -1);
        XmlElement el = layout.getFirstElementByName("tip");
        if (el != null) {
            this.searchInActiveOnly = XmlUtils.getBoolean("active_only", el, true);
            this.showWithLayerName = XmlUtils.getBoolean("layername", el, false);
            this.showInCentroid = XmlUtils.getBoolean("centroid", el, false);
            this.fill = XmlUtils.getBoolean("filled", el, true);
            this.fillColor = XmlUtils.getColor("fill", el, Color.yellow);
            this.outline = XmlUtils.getBoolean("outlined", el, true);
            this.outlineColor = XmlUtils.getColor("outline", el, Color.black);
            this.font = XmlUtils.getFont("font", el, MapUtils.defaultPlainFont);
        } else {
            this.font = MapUtils.defaultPlainFont;
        }
        this.map = host.getMapByName(layout);
        this.map.mapListeners.addElement(this);
        this.addActionListener(this);
        if (XmlUtils.getBoolean("startup", layout, false)) {
            this.isTipsActive = true;
            this.setDown(true);
        }
    }

    public void stop() {
    }

    public void showAttributes(LayerVector lyr, Vector records) {
    }

    public void mouseMapPressed(MouseEvent e) {
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
    }

    public void mouseMapMoved(MouseEvent e) {
        Point ppt;
        FloatPoint pt;
        if ((this.map.getTool() == 5 || this.map.getTool() == 6) && (pt = this.map.screenToMap(ppt = e.getPoint())) != null && this.isTipsActive) {
            Graphics g;
            String sTip = null;
            Record rec = null;
            Layer lyr = null;
            if (this.searchInActiveOnly) {
                lyr = this.map.getActiveLayer();
                if (lyr != null && lyr.canSearch && lyr.isVisibleNow(this.map) && (rec = lyr.findAtScreenPoint(ppt)) != null) {
                    sTip = lyr.getFieldString(rec, lyr.fi_description);
                    if (Strings.isNullOrBlank(sTip)) {
                        sTip = null;
                    } else if (this.showWithLayerName) {
                        sTip = sTip + " [" + lyr.getName() + "]";
                    }
                }
            } else {
                Vector levels = this.map.getProject().renderers;
                int levelCount = levels.size() - 1;
                Vector<Layer> itWasAlready = new Vector<Layer>();
                try {
                    int i = levelCount;
                    while (i >= 0) {
                        int rendCount;
                        Vector level = (Vector)levels.elementAt(i);
                        int j = rendCount = level.size() - 1;
                        while (j >= 0) {
                            Renderer rend = null;
                            try {
                                rend = (Renderer)level.elementAt(j);
                                lyr = rend.layer;
                                if (lyr.canSearch && rend.enabled && itWasAlready.indexOf(lyr) < 0 && lyr.isVisibleNow(this.map) && rend.isRendererVisible(this.map)) {
                                    rec = lyr.findAtScreenPoint(ppt);
                                    if (rec != null) {
                                        sTip = lyr.getFieldString(rec, lyr.fi_description);
                                        if (sTip.length() == 0) {
                                            sTip = null;
                                        }
                                        if (sTip != null) {
                                            if (this.showWithLayerName) {
                                                sTip = sTip + " [" + lyr.getName() + "]";
                                            }
                                            j = -1;
                                            i = -1;
                                        }
                                    }
                                    itWasAlready.addElement(lyr);
                                }
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            --j;
                        }
                        --i;
                    }
                    Object var17_16 = null;
                    itWasAlready.removeAllElements();
                    itWasAlready = null;
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    itWasAlready.removeAllElements();
                    itWasAlready = null;
                    throw throwable;
                }
            }
            if (this.tooltipInstance != null && (this.showTips == 0 || this.showTips > 50)) {
                this.tooltipInstance.dispose();
                this.tooltipInstance = null;
            }
            if (sTip != null && this.showTips == 5 && (g = this.map.getGraphics()) != null) {
                try {
                    if (this.showInCentroid && rec != null && rec.centroid != null) {
                        ppt = new Point(this.map.mapToScreen(rec.centroid));
                    }
                    this.tooltipInstance = new TipRect(sTip, this.font, this.map, ppt, this.fill, this.outline, this.fillColor, this.outlineColor);
                    this.tooltipInstance.paint(g);
                    this.previousTip = sTip;
                    Object var19_19 = null;
                    g.dispose();
                }
                catch (Throwable throwable) {
                    Object var19_20 = null;
                    g.dispose();
                    throw throwable;
                }
            }
            this.showTips = sTip == null || !sTip.equals(this.previousTip) ? 0 : ++this.showTips;
            this.previousTip = sTip;
        }
    }

    public void afterMapDraw(Graphics g) {
    }
}

