/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.FieldDef;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Readers;
import org.alov.util.Strings;

public class Csv {
    private static String delims = "\t,;";

    protected static Record ParseCsvRecord(String string, String string2, int n) {
        String string3 = string == null ? "" : string;
        Record record = new Record(n);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (string3.length() > 0 && n2 < n) {
            String string4;
            int n3 = -1;
            while (++n3 < string3.length()) {
                char c = string3.charAt(n3);
                if (c == '\"') {
                    if (bl) {
                        bl2 = true;
                        bl = false;
                    } else {
                        bl = true;
                    }
                }
                if (bl || delims.indexOf(c) < 0) continue;
            }
            if (bl2) {
                string4 = string3.substring(1, n3 - 1);
                bl2 = false;
            } else {
                string4 = string3.substring(0, n3);
            }
            record.setField(n2, Readers.Read2Unicode(string4, string2).trim());
            if (n3 + 1 > string3.length()) break;
            string3 = string3.substring(n3 + 1, string3.length());
            ++n2;
        }
        return record;
    }

    protected static void resolveCsvFields(String[] stringArray, char[] cArray, LayerVector layerVector) {
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        String string = layerVector.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(string)) {
            string = string + ',';
        }
        Vector<FieldDef> vector = new Vector<FieldDef>();
        int n2 = 0;
        while (n2 < n) {
            if (!Strings.isNullOrBlank(stringArray[n2])) {
                FieldDef fieldDef = new FieldDef();
                if (cArray == null) {
                    fieldDef.type = 12;
                } else {
                    switch (cArray[n2]) {
                        case 'C': 
                        case 'D': 
                        case 'L': {
                            fieldDef.type = 1;
                            break;
                        }
                        case 'I': {
                            fieldDef.type = 4;
                            break;
                        }
                        case 'F': 
                        case 'N': {
                            fieldDef.type = 8;
                            break;
                        }
                        default: {
                            fieldDef.type = 0;
                        }
                    }
                }
                fieldDef.index = vector.size();
                fieldDef.name = stringArray[n2];
                fieldDef.label = layerVector.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
                fieldDef.visible = Strings.isNullOrBlank(string) || string.indexOf(fieldDef.name.toUpperCase() + ',') >= 0;
                vector.addElement(fieldDef);
            }
            ++n2;
        }
        n = vector.size();
        layerVector.initFields(n);
        int n3 = 0;
        while (n3 < n) {
            layerVector.setFieldDef(n3, (FieldDef)vector.elementAt(n3));
            ++n3;
        }
        LayerVector layerVector2 = layerVector;
        layerVector2.fi_description = layerVector2.getFieldIndex(layerVector2.f_description);
        layerVector2.fi_id = layerVector2.getFieldIndex(layerVector2.f_id);
        if (layerVector2.fi_id >= 0) {
            layerVector2.f_id_istext = true;
        }
        layerVector.prepareLayer();
    }

    public static void loadFromStream(InputStream inputStream, LayerVector layerVector, String string) throws AlovMapException {
        try {
            int n;
            String string2;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 2048);
            String[] stringArray = null;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (Strings.isNullOrBlank(string2)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, delims);
                n2 = stringTokenizer.countTokens();
                stringArray = new String[n2];
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("\"") && string3.endsWith("\"")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    stringArray[n] = string3;
                    ++n;
                }
                break block4;
            }
            Csv.resolveCsvFields(stringArray, null, layerVector);
            int n3 = -1;
            n = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            n6 = layerVector.getFieldIndex(layerVector.f_x);
            n7 = layerVector.getFieldIndex(layerVector.f_y);
            if (layerVector.objectType == 4 || layerVector.objectType == 2) {
                n3 = layerVector.getFieldIndex(layerVector.f_xmin);
                n = layerVector.getFieldIndex(layerVector.f_xmax);
                n4 = layerVector.getFieldIndex(layerVector.f_ymin);
                n5 = layerVector.getFieldIndex(layerVector.f_ymax);
                if (n3 < 0 && n < 0 && n4 < 0 && n5 < 0) {
                    n3 = layerVector.getFieldIndex("xmin");
                    n = layerVector.getFieldIndex("xmax");
                    n4 = layerVector.getFieldIndex("ymin");
                    n5 = layerVector.getFieldIndex("ymax");
                }
                if (n3 < 0 || n < 0 || n4 < 0 || n5 < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
                if (layerVector.objectType != 2) {
                    layerVector.objectType = 3;
                }
            } else {
                layerVector.objectType = 1;
                n6 = layerVector.getFieldIndex(layerVector.f_x);
                n7 = layerVector.getFieldIndex(layerVector.f_y);
                if (n6 < 0 && n7 < 0) {
                    n6 = layerVector.getFieldIndex("LONG");
                    n7 = layerVector.getFieldIndex("LAT");
                }
                if (n6 < 0 && n7 < 0) {
                    n6 = layerVector.getFieldIndex("X");
                    n7 = layerVector.getFieldIndex("Y");
                }
                if (n6 < 0 || n7 < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
            }
            if (Strings.isNullOrBlank(string)) {
                string = Readers.ENCODING;
            }
            int n8 = 1;
            while ((string2 = bufferedReader.readLine()) != null) {
                Record record;
                if (Strings.isNullOrBlank(string2) || (record = Csv.ParseCsvRecord(string2, string, n2)) == null) continue;
                try {
                    Shape shape;
                    if (layerVector.objectType == 3) {
                        shape = record.newShape(4);
                        shape.xCoords[0] = layerVector.getFieldDouble(record, n3);
                        shape.yCoords[0] = layerVector.getFieldDouble(record, n4);
                        shape.xCoords[1] = shape.xCoords[0];
                        shape.yCoords[1] = layerVector.getFieldDouble(record, n5);
                        shape.xCoords[2] = layerVector.getFieldDouble(record, n);
                        shape.yCoords[2] = shape.yCoords[1];
                        shape.xCoords[3] = shape.xCoords[2];
                        shape.yCoords[3] = shape.yCoords[0];
                    } else if (layerVector.objectType == 2) {
                        shape = record.newShape(2);
                        shape.xCoords[0] = layerVector.getFieldDouble(record, n3);
                        shape.yCoords[0] = layerVector.getFieldDouble(record, n4);
                        shape.xCoords[1] = layerVector.getFieldDouble(record, n);
                        shape.yCoords[1] = layerVector.getFieldDouble(record, n5);
                    } else {
                        shape = record.newShape(1);
                        shape.xCoords[0] = layerVector.getFieldDouble(record, n6);
                        shape.yCoords[0] = layerVector.getFieldDouble(record, n7);
                    }
                }
                catch (Exception exception) {
                    throw new AlovMapException(106, "Coordinate field does not contains numeric value. Line#" + n8 + ". " + exception.getMessage());
                }
                record.setId(layerVector.fi_id < 0 ? Integer.toString(n8) : record.getField(layerVector.fi_id).toString());
                layerVector.addRecord(record);
                ++n8;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AlovMapException(106, exception.getMessage());
        }
    }
}

