/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FilterRecords;
import org.alov.map.FilterTime;
import org.alov.map.FlashUtil;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.MathRec;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.RecordField;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;

public class LayerVector
extends Layer {
    public int fi_search = -1;
    public int fi_id = -1;
    public String f_dateLow = null;
    public String f_dateHigh = null;
    public int dateType = 0;
    public String f_id = null;
    public boolean f_id_istext = true;
    public String f_xmin;
    public String f_ymin;
    public String f_xmax;
    public String f_ymax;
    public String f_geoblob = null;
    public String f_x;
    public String f_y;
    public String f_description = null;
    public String tableName = null;
    public String selectSQL = null;
    public String linkInfo = null;
    public String localFilter = null;
    Boolean changed = Boolean.FALSE;
    public String serverFilter = null;
    public Symbol symbol = new Symbol(Color.yellow, Color.black, true, true, 4);
    public Symbol selectedSymbol = new Symbol(new Color(0, 255, 128), new Color(255, 0, 0), true, true, 6);

    public FloatRectangle calculateRecordsExtent(Vector vector) {
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        Record record = (Record)vector.elementAt(0);
        record.calculateExtent();
        double d = record.extent.x;
        double d2 = record.extent.y;
        double d3 = record.extent.x2;
        double d4 = record.extent.y2;
        int n2 = 1;
        while (n2 < n) {
            record = (Record)vector.elementAt(n2);
            record.calculateExtent();
            FloatRectangle floatRectangle = record.extent;
            if (floatRectangle.x < d) {
                d = floatRectangle.x;
            }
            if (floatRectangle.x2 > d3) {
                d3 = floatRectangle.x2;
            }
            if (floatRectangle.y < d2) {
                d2 = floatRectangle.y;
            }
            if (floatRectangle.y2 > d4) {
                d4 = floatRectangle.y2;
            }
            ++n2;
        }
        return new FloatRectangle(d, d2, d3, d4);
    }

    public Vector doSearch(String string) {
        if (!this.canSearch) {
            return null;
        }
        Vector<Record> vector = new Vector<Record>();
        string = string.toUpperCase();
        int n = 0;
        if (string.charAt(0) == '%') {
            n = 1;
            string = string.substring(1);
        }
        if (string.charAt(string.length() - 1) == '%') {
            n += 2;
            string = string.substring(0, string.length() - 1);
        }
        if (this.fi_search < 0) {
            this.fi_search = this.fi_description;
        }
        if (this.fi_search >= 0 && string.length() > 0) {
            Vector vector2 = this.records;
            synchronized (vector2) {
                int n2 = this.records.size();
                switch (n) {
                    case 0: {
                        int n3 = 0;
                        while (n3 < n2) {
                            Record record = (Record)this.records.elementAt(n3);
                            String string2 = this.getFieldString(record, this.fi_search).toUpperCase();
                            if (string2.equals(string)) {
                                vector.addElement(record);
                            }
                            ++n3;
                        }
                        break;
                    }
                    case 1: {
                        int n4 = 0;
                        while (n4 < n2) {
                            Record record = (Record)this.records.elementAt(n4);
                            String string3 = this.getFieldString(record, this.fi_search).toUpperCase();
                            if (string3.endsWith(string)) {
                                vector.addElement(record);
                            }
                            ++n4;
                        }
                        break;
                    }
                    case 2: {
                        int n5 = 0;
                        while (n5 < n2) {
                            Record record = (Record)this.records.elementAt(n5);
                            String string4 = this.getFieldString(record, this.fi_search).toUpperCase();
                            if (string4.startsWith(string)) {
                                vector.addElement(record);
                            }
                            ++n5;
                        }
                        break;
                    }
                    case 3: {
                        int n6 = 0;
                        while (n6 < n2) {
                            Record record = (Record)this.records.elementAt(n6);
                            String string5 = this.getFieldString(record, this.fi_search).toUpperCase();
                            if (string5.indexOf(string) >= 0) {
                                vector.addElement(record);
                            }
                            ++n6;
                        }
                        break;
                    }
                }
            }
        }
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    public void paintRecords(Vector vector, Renderer renderer, boolean bl, DisplayContext displayContext, int n) {
        try {
            int n2 = vector.size();
            FloatRectangle floatRectangle = displayContext.getLastExtent();
            Projection projection = displayContext.getProjection();
            if (projection == null) {
                return;
            }
            Vector<Record> vector2 = null;
            if (projection.forSWF) {
                vector2 = new Vector<Record>();
            }
            int n3 = 0;
            while (n3 < n2) {
                Record record = (Record)vector.elementAt(n3);
                if (floatRectangle == null || floatRectangle.intersects(record.extent)) {
                    if (projection.forSWF) {
                        vector2.addElement(record);
                    } else {
                        renderer.paintRecord(record, bl, displayContext);
                    }
                }
                if (n > 0 && displayContext.isStopPaint(n)) {
                    return;
                }
                ++n3;
            }
            if (projection.forSWF) {
                FlashUtil.processLayer(renderer, vector2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector findWithinRect(FloatRectangle floatRectangle, boolean bl) {
        Vector<Record> vector = new Vector<Record>();
        Vector vector2 = this.records;
        synchronized (vector2) {
            int n = this.records.size();
            double d = floatRectangle.x;
            double d2 = floatRectangle.y;
            double d3 = floatRectangle.x2;
            double d4 = floatRectangle.y2;
            MathRec mathRec = new MathRec(d, d2, d3, d4);
            MathRec mathRec2 = new MathRec(d3, d2, d, d4);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            switch (this.objectType) {
                case 1: {
                    if (this.parentMap != null) {
                        FloatRectangle floatRectangle2 = this.parentMap.getLastExtent();
                        double d5 = Math.abs(floatRectangle2.x2 - floatRectangle2.x) / 200.0;
                        d3 = floatRectangle.x2 + d5;
                        d = floatRectangle.x - d5;
                        d5 = Math.abs(floatRectangle2.y2 - floatRectangle2.y) / 200.0;
                        d4 = floatRectangle.y2 + d5;
                        d2 = floatRectangle.y - d5;
                    } else {
                        d3 = floatRectangle.x2;
                        d = floatRectangle.x;
                        d4 = floatRectangle.y2;
                        d2 = floatRectangle.y;
                    }
                    bl4 = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                }
                case 2: {
                    bl3 = true;
                    break;
                }
                default: {
                    Vector vector3 = null;
                    return vector3;
                }
            }
            int n2 = 0;
            while (n2 < n) {
                Record record = (Record)this.records.elementAt(n2);
                int n3 = record.shapes.size();
                boolean bl5 = false;
                int n4 = 0;
                while (n4 < n3 && !bl5) {
                    Shape shape = (Shape)record.shapes.elementAt(n4);
                    double[] dArray = shape.xCoords;
                    double[] dArray2 = shape.yCoords;
                    if (bl4 && dArray[0] >= d && dArray[0] <= d3 && dArray2[0] >= d2 && dArray2[0] <= d4) {
                        bl5 = true;
                        break;
                    }
                    if (bl2 && shape.containsPoint(d, d2)) {
                        bl5 = true;
                        break;
                    }
                    if (bl3) {
                        int n5 = 1;
                        while (n5 < dArray.length && !bl5) {
                            double d6 = dArray[n5];
                            double d7 = dArray2[n5];
                            if (d6 > d && d6 < d3 && d7 > d2 && d7 < d4) {
                                bl5 = true;
                                break;
                            }
                            double d8 = dArray[n5 - 1];
                            double d9 = dArray2[n5 - 1];
                            if (this.Intersects(d8, d9, d6, d7, d, d2, d3, d4, mathRec) || this.Intersects(d8, d9, d6, d7, d3, d2, d, d4, mathRec2)) {
                                bl5 = true;
                                break;
                            }
                            ++n5;
                        }
                    }
                    ++n4;
                }
                if (bl5) {
                    vector.addElement(record);
                    if (bl) break;
                }
                ++n2;
            }
        }
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    private boolean Intersects(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, MathRec mathRec) {
        double d9;
        double d10;
        double d11;
        double d12 = d3 - d;
        double d13 = d4 - d2;
        if (d13 == 0.0) {
            d11 = 0.0;
        } else if (d12 != 0.0) {
            d11 = d13 / d12;
        } else {
            d11 = 1.0E21;
            if (d13 < 0.0) {
                d11 = -d11;
            }
        }
        if (mathRec.k == d11) {
            return false;
        }
        double d14 = d2 - d11 * d;
        if (Math.abs(mathRec.k) < Math.abs(d11)) {
            d10 = mathRec.dx == 0.0 ? d5 : (d12 == 0.0 ? d : (d14 - mathRec.b) / (mathRec.k - d11));
            d9 = mathRec.dx == 0.0 ? d11 * d10 + d14 : mathRec.k * d10 + mathRec.b;
        } else {
            d10 = d12 == 0.0 ? d : (mathRec.dx == 0.0 ? d5 : (mathRec.b - d14) / (d11 - mathRec.k));
            d9 = mathRec.dx == 0.0 ? d11 * d10 + d14 : mathRec.k * d10 + mathRec.b;
        }
        return this.Between(d5, d7, d10) && this.Between(d6, d8, d9) && this.Between(d, d3, d10) && this.Between(d2, d4, d9);
    }

    private boolean Between(double d, double d2, double d3) {
        if (d >= d2 && d3 <= d && d3 >= d2) {
            return true;
        }
        return d <= d2 && d3 >= d && d3 <= d2;
    }

    public Vector findContainShape(Shape shape, boolean bl, boolean bl2) {
        if (null == shape || 0 == shape.xCoords.length || 0 == shape.yCoords.length || 1 > this.objectType || 4 < this.objectType) {
            return null;
        }
        Vector<Record> vector = new Vector<Record>();
        Vector vector2 = this.records;
        synchronized (vector2) {
            FloatRectangle floatRectangle = shape.calculateExtent();
            int n = this.records.size();
            if (0 < n) {
                double[] dArray = shape.xCoords;
                double[] dArray2 = shape.yCoords;
                int n2 = shape.xCoords.length;
                int n3 = 0;
                while (n3 < n) {
                    Record record = (Record)this.records.elementAt(n3);
                    if (null != record) {
                        if (null == record.extent) {
                            record.calculateExtent();
                        }
                        if (record.extent.intersects(floatRectangle)) {
                            boolean bl3 = bl;
                            int n4 = record.shapes.size();
                            int n5 = 0;
                            while (n5 < n4) {
                                Shape shape2 = (Shape)record.shapes.elementAt(n5);
                                int n6 = 0;
                                while (n6 < n2 && (bl ? bl3 : !bl3)) {
                                    bl3 = shape2.containsPoint(dArray[n6], dArray2[n6]);
                                    ++n6;
                                }
                                if (bl3) {
                                    vector.addElement(record);
                                    if (bl2) break;
                                }
                                ++n5;
                            }
                        }
                    }
                    ++n3;
                }
            }
        }
        if (0 == vector.size()) {
            vector = null;
        }
        return vector;
    }

    public Vector findWithinShape(Shape shape, boolean bl, boolean bl2) {
        if (null == shape || 0 == shape.xCoords.length || 0 == shape.yCoords.length || 1 > this.objectType || 4 < this.objectType) {
            return null;
        }
        Vector<Record> vector = new Vector<Record>();
        Vector vector2 = this.records;
        synchronized (vector2) {
            FloatRectangle floatRectangle = shape.calculateExtent();
            int n = this.records.size();
            if (0 < n) {
                int n2 = 0;
                while (n2 < n) {
                    boolean bl3 = bl;
                    Record record = (Record)this.records.elementAt(n2);
                    if (null != record) {
                        if (null == record.extent) {
                            record.calculateExtent();
                        }
                        if (record.extent.intersects(floatRectangle)) {
                            int n3 = record.shapes.size();
                            int n4 = 0;
                            while (n4 < n3 && (bl ? bl3 : !bl3)) {
                                Shape shape2 = (Shape)record.shapes.elementAt(n4);
                                double[] dArray = shape2.xCoords;
                                double[] dArray2 = shape2.yCoords;
                                int n5 = dArray.length;
                                if (bl || 1 == this.objectType) {
                                    int n6 = 0;
                                    while (n6 < n5 && (bl ? bl3 : !bl3)) {
                                        bl3 = shape.containsPoint(dArray[n6], dArray2[n6]);
                                        ++n6;
                                    }
                                } else {
                                    switch (this.objectType) {
                                        case 3: {
                                            FloatPoint floatPoint = new FloatPoint(dArray[n5 - 1], dArray2[n5 - 1]);
                                            bl3 = MapUtils.intersectShape(floatPoint, new FloatPoint(dArray[0], dArray2[0]), shape);
                                            if (bl3) break;
                                            floatPoint = null;
                                        }
                                        case 2: {
                                            FloatPoint floatPoint = new FloatPoint(dArray[0], dArray2[0]);
                                            FloatPoint floatPoint2 = new FloatPoint(0.0, 0.0);
                                            bl3 = shape.containsPoint(floatPoint);
                                            int n7 = 1;
                                            while (!bl3 && n7 < n5) {
                                                floatPoint2.setLocation(dArray[n7], dArray2[n7]);
                                                bl3 = MapUtils.intersectShape(floatPoint, floatPoint2, shape);
                                                if (!bl3) {
                                                    floatPoint.setLocation(floatPoint2.x, floatPoint2.y);
                                                }
                                                ++n7;
                                            }
                                            floatPoint2 = null;
                                            floatPoint = null;
                                        }
                                    }
                                }
                                ++n4;
                            }
                            if (bl3) {
                                vector.addElement(record);
                                if (bl2) break;
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        if (0 == vector.size()) {
            vector = null;
        }
        return vector;
    }

    public Vector findWithinCircle(FloatPoint floatPoint, double d, boolean bl, boolean bl2) {
        if (null == floatPoint || 1 > this.objectType || 4 < this.objectType) {
            return null;
        }
        Vector<Record> vector = new Vector<Record>();
        Vector vector2 = this.records;
        synchronized (vector2) {
            FloatRectangle floatRectangle = new FloatRectangle(floatPoint.x - d, floatPoint.y - d, floatPoint.x + d, floatPoint.y + d);
            double d2 = MapUtils.sqr(d);
            int n = this.records.size();
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < n) {
                bl3 = bl;
                Record record = (Record)this.records.elementAt(n2);
                if (null != record) {
                    if (null != record.extent) {
                        record.calculateExtent();
                    }
                    if (record.extent.intersects(floatRectangle)) {
                        int n3 = record.shapes.size();
                        int n4 = 0;
                        while (n4 < n3 && (bl ? bl3 : !bl3)) {
                            Shape shape = (Shape)record.shapes.elementAt(n4);
                            double[] dArray = shape.xCoords;
                            double[] dArray2 = shape.yCoords;
                            int n5 = dArray.length;
                            if (bl || 1 == this.objectType) {
                                int n6 = 0;
                                while (n6 < n5 && (bl ? bl3 : !bl3)) {
                                    bl3 = MapUtils.sqr(dArray[n6] - floatPoint.x) + MapUtils.sqr(dArray2[n6] - floatPoint.y) <= d2;
                                    ++n6;
                                }
                            } else {
                                switch (this.objectType) {
                                    case 3: {
                                        bl3 = shape.containsPoint(floatPoint) || MapUtils.intersectCircle(new FloatPoint(dArray[0], dArray2[0]), new FloatPoint(dArray[n5 - 1], dArray2[n5 - 1]), floatPoint, d);
                                        if (bl3) break;
                                    }
                                    case 2: {
                                        FloatPoint floatPoint2 = new FloatPoint(dArray[1] - floatPoint.x, dArray2[1] - floatPoint.y);
                                        FloatPoint floatPoint3 = new FloatPoint(0.0, 0.0);
                                        int n7 = 1;
                                        while (n7 < n5 - 1 && !bl3) {
                                            floatPoint3.setLocation(dArray[n7] - floatPoint.x, dArray2[n7] - floatPoint.y);
                                            boolean bl4 = bl3 = shape.containsPoint(floatPoint) || MapUtils.intersectCircle(floatPoint2, floatPoint3, d);
                                            if (!bl3) {
                                                floatPoint2.setLocation(floatPoint3.x, floatPoint3.y);
                                            }
                                            ++n7;
                                        }
                                        floatPoint3 = null;
                                        floatPoint2 = null;
                                    }
                                }
                            }
                            ++n4;
                        }
                        if (bl3) {
                            vector.addElement(record);
                            if (bl2) break;
                        }
                    }
                }
                ++n2;
            }
        }
        if (0 == vector.size()) {
            vector = null;
        }
        return vector;
    }

    public Record findById(String string) {
        int n = this.records.size();
        int n2 = 0;
        while (n2 < n) {
            Record record = (Record)this.records.elementAt(n2);
            if (record.getId().equals(string)) {
                return record;
            }
            ++n2;
        }
        return null;
    }

    public void resolveMetadata() throws AlovMapException {
        String string;
        super.resolveMetadata();
        if (this.objectType < 1) {
            this.objectType = this.metadata.getObjType();
        }
        if ((string = this.metadata.getVal(37)) != null) {
            try {
                this.dateType = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.dateType = string.equalsIgnoreCase("UniqueDate") || string.equalsIgnoreCase("InstanceDate") ? 2 : (string.equalsIgnoreCase("UniqueRange") || string.equalsIgnoreCase("InstanceRange") ? 1 : 0);
            }
        }
        if (this.dateType == 2) {
            this.f_dateLow = this.metadata.getVal(52);
        } else if (this.dateType == 1) {
            this.f_dateLow = this.metadata.getVal(53);
            this.f_dateHigh = this.metadata.getVal(54);
        }
        if (this.localFilter == null) {
            this.localFilter = this.metadata.getVal(150);
        }
        if (this.linkSearch == null) {
            this.linkSearch = this.metadata.getVal(301);
        }
        if (this.linkInfo == null) {
            this.linkInfo = this.metadata.getVal(302);
        }
        if (this.linkTips == null) {
            this.linkTips = this.metadata.getVal(310);
        }
        this.f_id = this.metadata.getVal(49);
        this.f_xmin = this.metadata.getVal(70);
        this.f_ymin = this.metadata.getVal(72);
        this.f_xmax = this.metadata.getVal(71);
        this.f_ymax = this.metadata.getVal(73);
        this.f_geoblob = this.metadata.getVal(74);
        this.f_x = this.metadata.getVal(75);
        this.f_y = this.metadata.getVal(76);
        this.f_description = this.metadata.getVal(51);
        this.tableName = this.metadata.getVal(43);
        if (!Strings.isNullOrBlank(this.tableName) && this.tableName.toUpperCase().startsWith("SELECT ")) {
            this.selectSQL = this.tableName;
        }
        this.fi_description = this.getFieldIndex(this.f_description);
    }

    public void prepareLayer() {
        Object object;
        block12: {
            Object object2;
            this.selectedSymbol.loadSymbolImages(this);
            Vector vector = this.metadata.getList(309);
            int n = vector == null ? 0 : vector.size();
            Vector<FieldDef> vector2 = new Vector<FieldDef>();
            int n2 = 0;
            while (n2 < n) {
                object = vector.elementAt(n2).toString();
                int n3 = ((String)object).indexOf("=");
                if (n3 > 0) {
                    String string = ((String)object).substring(0, n3).trim();
                    object2 = ((String)object).substring(n3 + 1).trim();
                    if (string.length() > 0 && ((String)object2).length() > 0) {
                        try {
                            RecordField recordField;
                            FieldDef fieldDef = new FieldDef();
                            fieldDef.name = string;
                            fieldDef.field = recordField = (RecordField)Class.forName((String)object2).newInstance();
                            recordField.init(this);
                            fieldDef.type = recordField.getFieldJdbcType(fieldDef);
                            vector2.addElement(fieldDef);
                        }
                        catch (Exception exception) {
                            System.out.println("Failed to initialize calculated field " + string + " class " + (String)object2);
                        }
                    }
                }
                ++n2;
            }
            n = vector2.size();
            if (n > 0) {
                int n4 = this.getFieldCount();
                FieldDef[] fieldDefArray = new FieldDef[n4 + n];
                if (this.getFields() != null) {
                    System.arraycopy(this.getFields(), 0, fieldDefArray, 0, n4);
                }
                int n5 = 0;
                while (n5 < n) {
                    fieldDefArray[n4 + n5] = object2 = (FieldDef)vector2.elementAt(n5);
                    ((FieldDef)object2).index = n4 + n5;
                    ++n5;
                }
                this.assignFields(fieldDefArray);
            }
            try {
                if (this.localFilter != null) {
                    this.filters.put("SF", new FilterExpression(this.localFilter, this));
                }
            }
            catch (Exception exception) {
                System.out.println(">>. " + exception.getMessage());
                if (!(this.parentMap instanceof Carte)) break block12;
                Log.addMessage(305, this.parentMap.getName(), this, this.localFilter + ". " + exception.getClass().getName() + ". " + exception.getMessage());
            }
        }
        if (this.timeVarying && (this.dateType == 1 || this.dateType == 2) && ((FilterRecords)(object = new FilterTime(this))).isActive()) {
            this.filters.put("TF", object);
            ((FilterTime)object).setTimeInterval(this.parentMap.getTimeInterval());
        }
        super.prepareLayer();
    }

    public void afterDeserialization() {
        super.afterDeserialization();
    }
}

