/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Dimension;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DisplayContext;
import org.alov.map.FilterExpression;
import org.alov.map.FilterRecords;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.util.Log;
import org.alov.util.Strings;

public class LayerZoomify
extends LayerVector {
    private static final String FILTER_LEVEL = "level";
    private static final String FILTER_ZEROLEVEL = "zerolevel";
    double geoWidth;
    double geoHeight;
    double imageWidth;
    double imageHeight;
    double tileSize;
    int levelCount = 0;
    private Vector levelFilters = new Vector();
    transient Hashtable imageLoaded = new Hashtable();
    private transient Hashtable imageOriginal = new Hashtable();
    private int fieldIndex = -1;
    public int transparency = -1;
    public double maxPixelSize = 2.0;

    public void setDimensions(double d, double d2, double d3, double d4, double d5, int n) {
        this.geoWidth = d;
        this.geoHeight = d2;
        this.imageWidth = d3;
        this.imageHeight = d4;
        this.tileSize = d5;
        this.levelCount = n;
        this.levelFilters.removeAllElements();
        try {
            this.levelFilters.addElement(new FilterExpression("level=0", this));
            this.filters.put(FILTER_ZEROLEVEL, (FilterExpression)this.levelFilters.elementAt(0));
            int n2 = 1;
            while (n2 < n) {
                this.levelFilters.addElement(new FilterExpression("(level=0) OR (level=" + n2 + ")", this));
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector filterRecords(Vector vector, boolean bl) {
        if (this.filters != null && vector != null) {
            FilterRecords filterRecords = bl ? (FilterRecords)this.filters.get(FILTER_LEVEL) : (FilterRecords)this.filters.get(FILTER_ZEROLEVEL);
            if (filterRecords != null) {
                vector = filterRecords.apply(vector);
            } else if (this.levelCount > 0) {
                vector = null;
            }
        }
        return vector;
    }

    private void setResolutionLevel(DisplayContext displayContext) {
        if (displayContext == null || this.levelCount < 1) {
            return;
        }
        FloatRectangle floatRectangle = displayContext.getLastExtent();
        Dimension dimension = displayContext.getSize();
        double d = Math.abs(floatRectangle.x2 - floatRectangle.x);
        if (floatRectangle == null || dimension == null) {
            return;
        }
        double d2 = (double)dimension.width / (floatRectangle.x2 - floatRectangle.x);
        double d3 = 1.0;
        int n = this.levelCount - 1;
        int n2 = this.levelCount - 1;
        while (n2 >= 0) {
            double d4 = this.imageWidth / this.geoWidth * d3;
            double d5 = d2 / d4;
            if (d5 >= this.maxPixelSize) break;
            n = n2--;
            d3 *= 0.5;
        }
        if (n >= this.levelCount) {
            n = this.levelCount - 1;
        }
        if (n < 0) {
            n = 0;
        }
        this.filters.put(FILTER_LEVEL, (FilterExpression)this.levelFilters.elementAt(n));
    }

    public boolean isVisibleNow(DisplayContext displayContext) {
        boolean bl = super.isVisibleNow(displayContext);
        if (this.isKeyMap || bl) {
            this.setResolutionLevel(displayContext);
        }
        return bl;
    }

    public void loadZoomifyImages(FloatRectangle floatRectangle) {
        if (this.fieldIndex < 0) {
            return;
        }
        Vector vector = this.getRecords();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            Image image;
            Record record = (Record)vector.elementAt(n2);
            if (floatRectangle == null || floatRectangle.intersects(record.extent)) {
                image = (Image)this.imageLoaded.get(record);
                if (image == null) {
                    String string = (String)record.getField(this.fieldIndex);
                    if (string == null) {
                        return;
                    }
                    String string2 = string;
                    try {
                        image = MapUtils.loadImage2(this, string2);
                        if (this.transparency > 0) {
                            if (!this.imageOriginal.containsKey(record)) {
                                this.imageOriginal.put(record, image);
                            }
                            image = MapUtils.makeColorTransparent(image, null, 255 - this.transparency);
                        }
                        if (!this.imageLoaded.containsKey(record)) {
                            bl = true;
                            this.imageLoaded.put(record, image);
                        }
                    }
                    catch (Exception exception) {
                        if (this.parentMap instanceof Carte) {
                            Log.addMessage(306, this.parentMap.getName(), this, "Can't load raster image " + string + "  " + exception.getMessage());
                        }
                    }
                }
            } else if (!"0".equals((String)record.getField(this.fieldIndex)) && this.imageLoaded.containsKey(record)) {
                image = (Image)this.imageLoaded.get(record);
                image = null;
                this.imageLoaded.remove(record);
                if (this.imageOriginal.containsKey(record)) {
                    image = (Image)this.imageOriginal.get(record);
                    image = null;
                    this.imageOriginal.remove(record);
                }
                bl2 = true;
            }
            ++n2;
        }
        if (bl && this.parentMap instanceof Carte) {
            ((Carte)this.parentMap).updateMap();
        }
        if (bl2) {
            System.gc();
        }
    }

    public void clear(boolean bl) {
        Object object;
        Enumeration enumeration = this.imageLoaded.keys();
        while (enumeration.hasMoreElements()) {
            object = (Image)this.imageLoaded.get((Record)enumeration.nextElement());
            object = null;
        }
        this.imageLoaded.clear();
        object = this.imageOriginal.keys();
        while (object.hasMoreElements()) {
            Image image = (Image)this.imageOriginal.get((Record)object.nextElement());
            image = null;
        }
        this.imageOriginal.clear();
        super.clear(bl);
    }

    public void prepareLayer() {
        super.prepareLayer();
        String string = this.metadata.getVal(310);
        if (Strings.isNullOrBlank(string)) {
            string = "image";
        }
        this.fieldIndex = this.getFieldIndex(string);
    }

    public void applyRasterFilters(int n) {
        this.transparency = n;
        if (this.transparency < 0) {
            return;
        }
        Enumeration enumeration = this.imageLoaded.keys();
        while (enumeration.hasMoreElements()) {
            Image image;
            Record record = (Record)enumeration.nextElement();
            if (this.imageOriginal.containsKey(record)) {
                image = (Image)this.imageOriginal.get(record);
            } else {
                image = (Image)this.imageLoaded.get(record);
                this.imageOriginal.put(record, image);
            }
            Image image2 = MapUtils.makeColorTransparent(image, null, 255 - this.transparency);
            Image image3 = (Image)this.imageLoaded.get(record);
            image3 = null;
            this.imageLoaded.remove(record);
            this.imageLoaded.put(record, image2);
        }
    }
}

