/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.alov.data.DataProviderFile;
import org.alov.data.DataProviderImg;
import org.alov.map.Carte;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Load2D;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Proxy;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.RendererImageCatalog;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.Log;
import org.alov.util.Strings;

public class ProxyLocal
implements Const,
LayerSetup,
Proxy {
    Carte map = null;
    private static final String DUMMY = "dummy";
    boolean zoomToOneResult = false;
    int sessionUser = 0;
    int sessionMagic = 0;
    String projectURL = null;
    String projectId = null;
    private Object loadLock = new Object();

    public void setupProxy(Carte carte) {
        this.projectId = carte.getParameter("pid", null);
        this.zoomToOneResult = carte.getParameter("zoomtooneresult", "no").equalsIgnoreCase("yes");
        if (this.projectId != null) {
            if (!this.projectId.toLowerCase().startsWith("http://") && (Strings.checkSuffix(this.projectId, ".xml") || Strings.checkSuffix(this.projectId, ".tms") || Strings.checkSuffix(this.projectId, ".raw"))) {
                this.setProjectURLLocal();
            } else {
                this.setProjectURLServer();
            }
        }
        this.map = carte;
    }

    void setProjectURLLocal() {
        this.projectURL = MapUtils.getRealPath(this.projectId);
        MapUtils.projectBase = Strings.extractDir(this.projectURL);
    }

    void setProjectURLServer() {
    }

    void loadProjectServer(InputStream inputStream) throws Exception {
        throw new AlovMapException(111, "ProxyLocal does not support client-server interaction");
    }

    int searchQuery(GeoReqParams geoReqParams) {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadProject() {
        boolean bl = false;
        Object object = this.loadLock;
        synchronized (object) {
            block16: {
                if (this.map.isProjectLoaded()) {
                    return;
                }
                this.map.broadcastMessage(10, null);
                Project project = null;
                try {
                    try {
                        this.sessionUser = 0;
                        this.sessionMagic = 0;
                        this.map.broadcastMessage(1, this.projectURL);
                        if (Strings.isNullOrBlank(this.projectURL)) {
                            throw new AlovMapException(112, "Project is not defined");
                        }
                        StreamCounter streamCounter = null;
                        if (Strings.checkSuffix(this.projectURL, ".raw") && (project = this.loadSerializedProject(this.projectURL)) != null) {
                            this.map.setProject(project);
                            Object var7_6 = null;
                            this.map.broadcastMessage(11, null);
                            return;
                        }
                        project = new Project();
                        this.map.setProject(project);
                        this.addStatusInfo(0, null, "Load Project: " + this.projectURL);
                        try {
                            streamCounter = MapUtils.openURL(this.projectURL);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!Strings.checkSuffix(this.projectURL, ".xml") && !Strings.checkSuffix(this.projectURL, ".tms")) {
                            this.loadProjectServer(streamCounter);
                        } else if (streamCounter == null) {
                            throw new AlovMapException(308, "Project file not found or inaccessible");
                        }
                        project.language = MapUtils.language;
                        project.load(streamCounter, this);
                    }
                    catch (AlovMapException alovMapException) {
                        int n = alovMapException.getCode();
                        this.addStatusInfo(n, null, alovMapException.getMessage());
                        this.map.broadcastMessage(n == 215 || n == 202 ? -7 : -8, "");
                        Object var7_8 = null;
                        this.map.broadcastMessage(11, null);
                        break block16;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.addStatusInfo(0, null, exception.getMessage());
                        this.map.broadcastMessage(-8, this.projectURL);
                        Object var7_9 = null;
                        this.map.broadcastMessage(11, null);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.map.broadcastMessage(11, null);
                    throw throwable;
                }
                Object var7_7 = null;
                this.map.broadcastMessage(11, null);
            }
            return;
        }
    }

    public Project loadSerializedProject(String string) {
        Project project = null;
        try {
            StreamCounter streamCounter = MapUtils.openURL(this.projectURL);
            project = Project.loadFromRawFile(streamCounter);
            ((InputStream)streamCounter).close();
            int n = project.layers.size();
            int n2 = 0;
            while (n2 < n) {
                Layer layer = (Layer)project.layers.elementAt(n2);
                layer.afterDeserialization();
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            project = null;
        }
        return project;
    }

    /*
     * Unable to fully structure code
     */
    public void handleRequest(ProxyRequest var1_1) throws Exception {
        block14: {
            if (!this.map.isProjectLoaded()) {
                return;
            }
            this.map.broadcastMessage(10, null);
            try {
                switch (var1_1.type) {
                    case 1: 
                    case 34: {
                        this.doGeoRequest(var1_1);
                        if (this.map.isFirstRequest) {
                            this.map.isFirstRequest = false;
                            this.map.zoomToDomain(this.map.getProject().startExtentName);
                            this.map.updateMap();
                            break;
                        }
                        if (var1_1.type != 34) break;
                        var2_2 = this.map.getProject().getLayerById(var1_1.layerId);
                        if (var2_2.zoomToExtentAfterCustomLoad) {
                            this.map.zoomToLayer(var2_2);
                        }
                        this.map.broadcastMessage(14, var1_1.layerId);
                        break;
                    }
                    case 2: {
                        this.doExtentRequest(var1_1);
                        break;
                    }
                    case 33: {
                        this.doCustomRequest(var1_1);
                        break;
                    }
                    default: {
                        this.doAttribRequest(var1_1);
                    }
                }
                var4_3 = null;
                var5_5 = this.map.getProject();
                var6_7 = var5_5.getLayerCount();
                var7_9 = 0;
                ** while (var7_9 < var6_7)
            }
            catch (Throwable var3_13) {
                var4_4 = null;
                var5_6 = this.map.getProject();
                var6_8 = var5_6.getLayerCount();
                var7_10 = 0;
                ** while (var7_10 < var6_8)
            }
lbl-1000:
            // 1 sources

            {
                var8_11 = var5_5.getLayerByIndex(var7_9);
                if (var8_11.metadata.networkActivity) {
                    var8_11.metadata.networkActivity = false;
                    this.map.broadcastMessage(11, "");
                }
                ++var7_9;
                continue;
            }
lbl-1000:
            // 1 sources

            {
                break block14;
            }
lbl-1000:
            // 1 sources

            {
                var8_12 = var5_6.getLayerByIndex(var7_10);
                if (var8_12.metadata.networkActivity) {
                    var8_12.metadata.networkActivity = false;
                    this.map.broadcastMessage(11, "");
                }
                ++var7_10;
                continue;
            }
lbl53:
            // 1 sources

            this.map.broadcastMessage(11, null);
            throw var3_13;
        }
        this.map.broadcastMessage(11, null);
    }

    private void doExtentRequest(ProxyRequest proxyRequest) throws Exception {
        this.doGeoRequest(proxyRequest);
        Layer layer = this.map.getProject().getLayerById(proxyRequest.layerId);
        Record record = ((LayerVector)layer).findById(proxyRequest.query);
        if (record != null) {
            this.map.selectObject(layer, record);
        }
    }

    void loadDirect(GeoReqParams geoReqParams, Layer layer) {
        if (layer.provider == null) {
            return;
        }
        this.map.broadcastMessage(2, layer.getName());
        try {
            block12: {
                try {
                    layer.metadata.networkActivity = true;
                    this.map.broadcastMessage(10, "");
                    layer.provider.loadComplete();
                    if (this.map.getProject().geoProjection != null) {
                        Load2D.makeProjection(layer, this.map.getProject().geoProjection);
                    }
                    geoReqParams.project.setSameLayers(layer, this);
                    geoReqParams.project.sortRenderersByLevels();
                    if (layer instanceof LayerVector) {
                        this.addStatusInfo(0, layer, "Download " + layer.records.size() + " records");
                    } else if (layer instanceof LayerRaster) {
                        this.addStatusInfo(0, layer, "Download image");
                    }
                    FloatRectangle floatRectangle = layer.getLayerExtent();
                    if (floatRectangle != null) {
                        this.map.addExtent(floatRectangle);
                        FloatRectangle floatRectangle2 = this.map.getLastExtent();
                        if (floatRectangle2 != null && floatRectangle2.intersects(floatRectangle)) {
                            this.map.updateMap();
                        }
                    }
                    if (layer.metadata.isNotLoaded) {
                        this.addStatusInfo(0, layer, "WARNING#307");
                    }
                    if (!(layer instanceof LayerZoomify) || !layer.isLoadComplete()) break block12;
                    ((LayerZoomify)layer).loadZoomifyImages(geoReqParams.rect);
                }
                catch (AlovMapException alovMapException) {
                    layer.metadata.loadFailed = true;
                    this.map.broadcastMessage(-8, layer.getName());
                    this.addStatusInfo(alovMapException.getCode(), layer, alovMapException.getMessage());
                    Object var6_7 = null;
                    layer.metadata.networkActivity = false;
                    this.map.broadcastMessage(11, "");
                }
            }
            Object var6_6 = null;
            layer.metadata.networkActivity = false;
            this.map.broadcastMessage(11, "");
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            layer.metadata.networkActivity = false;
            this.map.broadcastMessage(11, "");
            throw throwable;
        }
    }

    int processGeoRequest(GeoReqParams geoReqParams) throws Exception {
        geoReqParams.layerCount = geoReqParams.project.getLayerCount();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < geoReqParams.layerCount) {
            boolean bl;
            Layer layer = geoReqParams.req.layerId != null ? geoReqParams.project.getLayerById(geoReqParams.req.layerId) : geoReqParams.project.getLayerByIndex(n);
            String string = layer.metadata.getVal(303);
            boolean bl2 = layer.isLoadComplete();
            boolean bl3 = layer.isSomethingVisible(null);
            boolean bl4 = bl = (layer.isPassResolved() || Strings.isNullOrBlank(string)) && !bl3;
            if (this.map.loadedExtent != null && (bl2 || layer.metadata.loadFailed || bl)) {
                if (geoReqParams.req.layerId != null) {
                    break;
                }
            } else {
                if (!layer.isDataOnServer) {
                    this.loadDirect(geoReqParams, layer);
                } else {
                    layer.metadata.loadFailed = true;
                    this.map.broadcastMessage(-8, layer.getName());
                    this.addStatusInfo(111, layer, "This version supports only file based datasets");
                }
                if (geoReqParams.req.layerId != null) break;
            }
            ++n;
        }
        return 0;
    }

    void doGeoRequest(ProxyRequest proxyRequest) throws Exception {
        GeoReqParams geoReqParams = new GeoReqParams(proxyRequest);
        geoReqParams.rect = proxyRequest.extent;
        if (proxyRequest.type != 1 ? this.searchQuery(geoReqParams) < 0 : this.processGeoRequest(geoReqParams) < 0) {
            return;
        }
        this.processGeoResponse(geoReqParams);
    }

    void processGeoResponse(GeoReqParams geoReqParams) throws Exception {
    }

    private void doCustomRequest(ProxyRequest proxyRequest) throws Exception {
        this.map.broadcastMessage(Integer.parseInt(proxyRequest.query), null);
    }

    private void doAttribRequest(ProxyRequest proxyRequest) throws Exception {
        LayerVector layerVector;
        String string;
        if (proxyRequest.layerId == null) {
            return;
        }
        Project project = this.map.getProject();
        Layer layer = project.getLayerById(proxyRequest.layerId);
        if (layer == null || !layer.canSearch) {
            return;
        }
        String string2 = null;
        Vector vector = null;
        if (proxyRequest.type == 32 || proxyRequest.type == 35) {
            string = layer.linkSearch != null ? layer.linkSearch : project.linkSearch;
        } else {
            vector = layer.getSelection();
            if (proxyRequest.type == 30 || vector != null && vector.size() > 1) {
                layerVector = (LayerVector)layer;
                String string3 = string = layerVector.linkInfo != null ? layerVector.linkInfo : project.linkInfo;
                if (string != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = vector.size();
                    if (n > 255) {
                        n = 255;
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        Record record = (Record)vector.elementAt(n2);
                        stringBuffer.append(record.getId()).append(',');
                        ++n2;
                    }
                    proxyRequest.query = stringBuffer.toString().substring(0, stringBuffer.length() - 1);
                }
            } else {
                string = layer.linkMain != null ? layer.linkMain : project.linkMain;
            }
        }
        string2 = layer.getWebLink(string, vector, proxyRequest.query, proxyRequest.extent, "id=" + this.sessionUser + "&m=" + this.sessionMagic);
        if (string2 != null) {
            this.map.showURL(string2);
        } else if (layer instanceof LayerVector) {
            if (!this.map.showFrame) {
                return;
            }
            layerVector = (LayerVector)layer;
            if (proxyRequest.type == 32 || proxyRequest.type == 35) {
                if (!layer.isLoadComplete() && layer.isDataOnServer && layer.serverType != 23) {
                    this.doGeoRequest(proxyRequest);
                }
                if ((vector = proxyRequest.type == 32 ? layerVector.doSearch(proxyRequest.query) : layerVector.selectObjectsByExpr(proxyRequest.query)) == null || vector.size() == 0) {
                    this.map.broadcastMessage(114, "");
                } else {
                    this.map.broadcastMessage(115, String.valueOf(vector.size()));
                }
            }
            if (vector != null && vector.size() == 1 && this.zoomToOneResult && proxyRequest.type == 32) {
                this.map.selectObject((Layer)layerVector, vector);
            } else {
                this.map.host.showAttributes(layerVector, vector);
            }
        }
    }

    public Layer createLayer(Properties properties) throws AlovMapException {
        Layer layer;
        if (properties == null) {
            throw new AlovMapException(105, "");
        }
        String string = properties.getProperty("type");
        String string2 = properties.getProperty("id");
        String string3 = properties.getProperty("url");
        if ("group".equalsIgnoreCase(string)) {
            layer = new LayerGroup();
            layer.setLoadComplete(true);
            layer.datasetId = "";
            layer.notPrepared = false;
            layer.canSearch = false;
            layer.setLoadComplete(true);
        } else if (DUMMY.equalsIgnoreCase(string)) {
            layer = new LayerVector();
            layer.setLoadComplete(true);
            layer.datasetId = "";
            layer.notPrepared = false;
        } else {
            Object object;
            if (string3 == null && string2 == null) {
                throw new AlovMapException(105, "");
            }
            if (string == null) {
                string = string3 == null || Strings.checkSuffix(string3, ".shp") || Strings.checkSuffix(string3, ".mif") || Strings.checkSuffix(string3, ".zip") || Strings.checkSuffix(string3, ".dbf") || Strings.checkSuffix(string3, ".gml") || Strings.checkSuffix(string3, ".csv") || Strings.checkSuffix(string3, ".txt") || Strings.checkSuffix(string3, ".tmm") ? "" : "image";
                ((Hashtable)properties).put("type", string);
            }
            if (string.equalsIgnoreCase("image")) {
                layer = new LayerRaster();
            } else if (string.equalsIgnoreCase("image_zoomify")) {
                layer = new LayerZoomify();
                object = new RendererImageCatalog(layer);
                ((Renderer)object).enabled = true;
                layer.renderers.addElement(object);
                if (string3 != null) {
                    layer.datasetId = string3;
                    ((Hashtable)properties).put("url", string3);
                }
            } else {
                layer = new LayerVector();
            }
            object = properties.getProperty("direct");
            layer.isDataOnServer = object == null || !((String)object).equalsIgnoreCase("yes");
            layer.connectionData = properties;
            if (string2 != null) {
                if ("dynamic".equalsIgnoreCase(string)) {
                    layer.isFullLoad = true;
                    layer.setLoadComplete(true);
                }
                layer.isDataOnServer = true;
                if (layer instanceof LayerZoomify) {
                    layer.provider = new DataProviderFile(layer);
                }
            } else {
                layer.provider = string.equalsIgnoreCase("image") ? new DataProviderImg(layer) : new DataProviderFile(layer);
            }
            if (!layer.isDataOnServer) {
                ((Hashtable)properties).put("url", string3);
            }
            layer.datasetId = string2 == null ? string3 : string2;
        }
        return layer;
    }

    public void addStatusInfo(int n, Layer layer, String string) {
        Log.addMessage(n, this.map.getName(), layer, string);
    }

    class GeoReqParams {
        FloatRectangle rect;
        FloatRectangle newRect = null;
        String getMode = "";
        String lyrList = "";
        StringBuffer getReq = new StringBuffer();
        boolean hasImage = false;
        InputStream input = null;
        StreamCounter counter;
        int errorCode;
        URL url;
        Project project;
        int layerCount;
        int k;
        ProxyRequest req;

        GeoReqParams(ProxyRequest proxyRequest) {
            this.project = ProxyLocal.this.map.getProject();
            this.layerCount = this.project.getLayerCount();
            this.k = 0;
            this.req = proxyRequest;
        }
    }
}

