/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Shape;
import org.alov.util.ExDate;
import org.alov.util.Readers;
import org.alov.util.XmlUtils;

public class Record
implements Serializable {
    private String id = null;
    public FloatRectangle extent = new FloatRectangle();
    public FloatPoint centroid;
    public Vector shapes = new Vector();
    public Vector outline_shapes = new Vector();
    public boolean isHasHole = false;
    public byte figType = 0;
    Object[] fields;
    public boolean isNotSent = true;
    public boolean isDownloading = false;
    public ExDate dateLow = null;
    public ExDate dateHigh = null;
    public boolean dateInvalid = false;

    public Record() {
    }

    public Record(int n) {
        if (n > 0) {
            this.fields = new Object[n];
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Object getField(int n) {
        return this.fields[n];
    }

    public void setField(int n, Object object) {
        this.fields[n] = object;
    }

    public int readFromStream(DataInputStream dataInputStream, boolean bl) throws IOException {
        int n = dataInputStream.read();
        int n2 = 0;
        if (n == 255) {
            Shape shape = this.newShape(1);
            shape.setVertex(0, dataInputStream.readFloat(), dataInputStream.readFloat());
            n = 1;
        } else if (n == 254) {
            Shape shape = this.newShape(4);
            float f = dataInputStream.readFloat();
            float f2 = dataInputStream.readFloat();
            float f3 = dataInputStream.readFloat();
            float f4 = dataInputStream.readFloat();
            shape.xCoords[0] = f;
            shape.yCoords[0] = f2;
            shape.xCoords[1] = f;
            shape.yCoords[1] = f4;
            shape.xCoords[2] = f3;
            shape.yCoords[2] = f4;
            shape.xCoords[3] = f3;
            shape.yCoords[3] = f2;
            n = 4;
        } else {
            ++n;
            int n3 = Readers.readInt(dataInputStream);
            int n4 = Readers.readInt(dataInputStream);
            this.shapes.removeAllElements();
            switch (n3) {
                case 1: {
                    int n5;
                    Shape shape;
                    int n6 = 0;
                    while (n6 < n4) {
                        shape = new Shape();
                        n5 = Readers.readInt(dataInputStream);
                        n2 += n5;
                        shape.xCoords = new double[n5];
                        shape.yCoords = new double[n5];
                        float f = Readers.readFloat(dataInputStream);
                        float f5 = Readers.readFloat(dataInputStream);
                        float f6 = Readers.readFloat(dataInputStream);
                        float f7 = Readers.readFloat(dataInputStream);
                        int n7 = 0;
                        while (n7 < n5) {
                            shape.xCoords[n7] = (float)Readers.readShort(dataInputStream) * f6 + f;
                            shape.yCoords[n7] = (float)Readers.readShort(dataInputStream) * f7 + f5;
                            ++n7;
                        }
                        this.shapes.addElement(shape);
                        if (bl) {
                            this.isHasHole = this.isHasHole || n == 3 && shape.isClockWise();
                        }
                        ++n6;
                    }
                    break;
                }
                case 2: {
                    int n5;
                    Shape shape;
                    int n6 = 0;
                    while (n6 < n4) {
                        shape = new Shape();
                        n5 = Readers.readInt(dataInputStream);
                        n2 += n5;
                        shape.xCoords = new double[n5];
                        shape.yCoords = new double[n5];
                        int n8 = 0;
                        while (n8 < n5) {
                            shape.xCoords[n8] = Readers.readDouble(dataInputStream);
                            shape.yCoords[n8] = Readers.readDouble(dataInputStream);
                            ++n8;
                        }
                        this.shapes.addElement(shape);
                        this.isHasHole = this.isHasHole || n == 3 && shape.isClockWise();
                        ++n6;
                    }
                    break;
                }
                default: {
                    int n5;
                    Shape shape;
                    int n6 = 0;
                    while (n6 < n4) {
                        shape = new Shape();
                        n5 = Readers.readInt(dataInputStream);
                        n2 += n5;
                        shape.xCoords = new double[n5];
                        shape.yCoords = new double[n5];
                        int n9 = 0;
                        while (n9 < n5) {
                            shape.xCoords[n9] = Readers.readFloat(dataInputStream);
                            shape.yCoords[n9] = Readers.readFloat(dataInputStream);
                            ++n9;
                        }
                        this.shapes.addElement(shape);
                        this.isHasHole = this.isHasHole || n == 3 && shape.isClockWise();
                        ++n6;
                    }
                    break block0;
                }
            }
            if (this.isHasHole) {
                Shape shape = new Shape();
                if (n4 > 1) {
                    n2 += n4 - 1;
                }
                shape.xCoords = new double[n2];
                shape.yCoords = new double[n2];
                int n10 = 0;
                double d = 0.0;
                double d2 = 0.0;
                int n11 = 0;
                while (n11 < n4) {
                    Shape shape2 = (Shape)this.shapes.elementAt(n11);
                    int n12 = shape2.xCoords.length;
                    int n13 = 0;
                    while (n13 < n12) {
                        shape.xCoords[n13 + n10] = shape2.xCoords[n13];
                        shape.yCoords[n13 + n10] = shape2.yCoords[n13];
                        ++n13;
                    }
                    if (n11 == 0) {
                        d = shape2.xCoords[n10 + n12 - 1];
                        d2 = shape2.yCoords[n10 + n12 - 1];
                    } else {
                        shape.xCoords[n10 + n12] = d;
                        shape.yCoords[n10 + n12] = d2;
                        ++n10;
                    }
                    n10 += n12;
                    ++n11;
                }
                XmlUtils.addAll(this.outline_shapes, this.shapes);
                this.shapes.removeAllElements();
                this.shapes.addElement(shape);
            }
        }
        this.figType = (byte)n;
        return n;
    }

    public void calculateExtent() {
        int n = this.shapes.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        this.extent = null;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = (Shape)this.shapes.elementAt(n2);
            FloatRectangle floatRectangle = shape.calculateExtent();
            if (floatRectangle != null) {
                if (this.extent == null) {
                    this.extent = floatRectangle;
                    d = floatRectangle.x;
                    d2 = floatRectangle.y;
                    d3 = floatRectangle.x2;
                    d4 = floatRectangle.y2;
                } else {
                    if (floatRectangle.x < d) {
                        d = floatRectangle.x;
                    }
                    if (floatRectangle.x2 > d3) {
                        d3 = floatRectangle.x2;
                    }
                    if (floatRectangle.y < d2) {
                        d2 = floatRectangle.y;
                    }
                    if (floatRectangle.y2 > d4) {
                        d4 = floatRectangle.y2;
                    }
                }
            }
            ++n2;
        }
        if (this.extent != null) {
            this.extent.x = d;
            this.extent.y = d2;
            this.extent.x2 = d3;
            this.extent.y2 = d4;
            this.centroid = new FloatPoint((d + d3) / 2.0, (d2 + d4) / 2.0);
        }
    }

    public FloatPoint findCenterOfMass() {
        Serializable serializable;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = this.shapes.size();
        int n2 = 0;
        while (n2 < n) {
            serializable = (Shape)this.shapes.elementAt(n2);
            int n3 = ((Shape)serializable).xCoords.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = (n4 + 1) % n3;
                d += ((Shape)serializable).xCoords[n4] * ((Shape)serializable).yCoords[n5];
                d -= ((Shape)serializable).yCoords[n4] * ((Shape)serializable).xCoords[n5];
                d2 = ((Shape)serializable).xCoords[n4] * ((Shape)serializable).yCoords[n5] - ((Shape)serializable).xCoords[n5] * ((Shape)serializable).yCoords[n4];
                d3 += (((Shape)serializable).xCoords[n4] + ((Shape)serializable).xCoords[n5]) * d2;
                d4 += (((Shape)serializable).yCoords[n4] + ((Shape)serializable).yCoords[n5]) * d2;
                ++n4;
            }
            d /= 2.0;
            d = Math.abs(d);
            ++n2;
        }
        serializable = new FloatPoint();
        d2 = 1.0 / (d *= 6.0);
        serializable.x = Math.abs(d3 *= d2);
        serializable.y = Math.abs(d4 *= d2);
        return serializable;
    }

    public Shape newShape(int n) {
        Shape shape = new Shape();
        shape.xCoords = new double[n];
        shape.yCoords = new double[n];
        this.shapes.addElement(shape);
        return shape;
    }

    public void setFieldValues(Object[] objectArray) {
        this.fields = objectArray;
    }

    public Object[] getFieldValues() {
        return this.fields;
    }

    void clear() {
        int n = this.shapes.size();
        int n2 = 0;
        while (n2 < n) {
            Shape shape = (Shape)this.shapes.elementAt(n2);
            shape.xCoords = null;
            shape.yCoords = null;
            shape = null;
            ++n2;
        }
        n = this.outline_shapes.size();
        int n3 = 0;
        while (n3 < n) {
            Shape shape = (Shape)this.outline_shapes.elementAt(n3);
            shape.xCoords = null;
            shape.yCoords = null;
            shape = null;
            ++n3;
        }
        this.fields = null;
        this.extent = null;
        this.centroid = null;
    }
}

