/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Graphics;
import java.awt.Image;
import org.alov.map.DisplayContext;
import org.alov.map.FlashUtil;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;

public class RendererImage
extends Renderer {
    public RendererImage(Layer layer) {
        super(layer);
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        LayerRaster layerRaster = (LayerRaster)this.layer;
        if (layerRaster.image != null) {
            if (layerRaster.fixedPosition != null) {
                Graphics graphics = displayContext.getDrawToGraphics();
                if (graphics == null) {
                    return;
                }
                if (displayContext.getProjection().forSWF) {
                    FlashUtil.drawImage2(layerRaster.image, layerRaster.fixedPosition.x, layerRaster.fixedPosition.y, displayContext.getComponent());
                } else {
                    graphics.drawImage(layerRaster.image, layerRaster.fixedPosition.x, layerRaster.fixedPosition.y, displayContext.getComponent());
                }
            } else {
                RendererImage.drawImage(layerRaster.image, layerRaster.layerExtent, displayContext);
            }
        }
    }

    public static void drawImage(Image image, FloatRectangle floatRectangle, DisplayContext displayContext) {
        int n = image.getWidth(displayContext.getComponent());
        int n2 = image.getHeight(displayContext.getComponent());
        if (n <= 0 || n2 <= 0) {
            return;
        }
        Graphics graphics = displayContext.getDrawToGraphics();
        if (graphics == null) {
            return;
        }
        FloatRectangle floatRectangle2 = displayContext.getLastExtent();
        double d = floatRectangle2.x;
        double d2 = floatRectangle2.y2;
        double d3 = floatRectangle2.x2;
        double d4 = floatRectangle2.y;
        double d5 = floatRectangle.x;
        double d6 = floatRectangle.y2;
        double d7 = floatRectangle.x2;
        double d8 = floatRectangle.y;
        double d9 = (d7 - d5) / (1.0 * (double)n);
        double d10 = (d6 - d8) / (1.0 * (double)n2);
        if (d > d7 || d3 < d5 || d2 < d8 || d4 > d6) {
            return;
        }
        if (d < d5) {
            d = d5;
        }
        if (d3 > d7) {
            d3 = d7;
        }
        if (d2 > d6) {
            d2 = d6;
        }
        if (d4 < d8) {
            d4 = d8;
        }
        int n3 = (int)Math.floor((d - d5) / d9 - 0.0);
        int n4 = (int)Math.floor((d6 - d2) / d10 - 0.0);
        int n5 = (int)Math.ceil((d3 - d5) / d9 + 1.0);
        int n6 = (int)Math.ceil((d6 - d4) / d10 + 1.0);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 > n) {
            n5 = n;
        }
        if (n6 > n2) {
            n6 = n2;
        }
        d = d5 + (double)n3 * d9;
        d3 = d5 + (double)n5 * d9;
        d2 = d6 - (double)n4 * d10;
        d4 = d6 - (double)n6 * d10;
        Projection projection = displayContext.getProjection();
        double d11 = projection.zoom;
        double d12 = projection.shift.x;
        double d13 = projection.shift.y;
        if (projection.forSWF) {
            double d14 = (d + d12) * d11;
            double d15 = (d3 + d12) * d11;
            double d16 = (d13 - d2) * d11;
            double d17 = (d13 - d4) * d11;
            FlashUtil.drawImage1(image, d14, d16, d15, d17, n3, n4, n5, n6, displayContext.getComponent());
        } else {
            int n7 = (int)((d + d12) * d11);
            int n8 = (int)((d3 + d12) * d11);
            int n9 = (int)((d13 - d2) * d11);
            int n10 = (int)((d13 - d4) * d11);
            graphics.drawImage(image, n7, n9, n8, n10, n3, n4, n5, n6, displayContext.getComponent());
        }
    }
}

