/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.map.Shape;
import org.alov.map.StatusListener;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;

public class DistanceTool
extends Panel
implements CarteHostListener,
CarteListener,
ActionListener,
StatusListener {
    private static final String NAME_BTN_ADD = "distance_add";
    private static final String NAME_BTN_CLEAR = "distance_clear";
    private static final String NAME_LBL_INFO = "distance_info";
    private static byte TOOL_ADD_WAYPOINT = (byte)51;
    private Carte map = null;
    private CarteHost host = null;
    private Label lblInfo;
    private boolean drawingPath;
    private boolean isDrawAngle = false;
    private Vector waypoints = new Vector();
    private double pathLength = 0.0;
    private Point lastMousePosition = null;
    private String lastLabel = null;
    private int distUnits;
    private int unitsFormat = 1;
    private static final Font font = new Font("SansSerif", 1, 14);
    private static final int PATH_OVAL_RADIUS = 4;

    private void addWaypoint(float f, float f2) {
        this.addWaypoint(new FloatPoint(f, f2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWaypoint(FloatPoint floatPoint) {
        this.waypoints.addElement(floatPoint);
        this.recalculatePathLength();
        Graphics graphics = this.map.getGraphics();
        if (graphics != null) {
            try {
                this.drawWholePath(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    private void clearPath() {
        this.waypoints.removeAllElements();
        this.map.repaint();
        this.recalculatePathLength();
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        this.host = carteHost;
        this.map = carteHost.getMapByName(xmlElement);
        this.map.statusListeners.addElement(this);
        this.map.mapListeners.addElement(this);
        Container container = (Container)((Object)carteHost);
        MapUtils.addActionListener(this, container, NAME_BTN_CLEAR);
        String string = XmlUtils.getString("precision", xmlElement, null);
        try {
            int n = Integer.parseInt(string);
            int n2 = this.unitsFormat = Math.abs(n) > 5 ? 1 : (int)Math.pow(10.0, Math.abs(n));
            if (n < 0) {
                this.unitsFormat = -this.unitsFormat;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = XmlUtils.getString("units", xmlElement, null);
        this.distUnits = MapUtils.setUnits(string, -1);
        this.isDrawAngle = XmlUtils.getBoolean("angle", xmlElement, false);
    }

    public void stop() {
    }

    private void drawWholePath(Graphics graphics) {
        int n = this.waypoints.size();
        if (n <= 0) {
            return;
        }
        Point point = null;
        graphics.setColor(Color.black);
        for (int i = 0; i < n; ++i) {
            Point point2 = this.map.mapToScreen((FloatPoint)this.waypoints.elementAt(i));
            graphics.drawOval(point2.x - 4, point2.y - 4, 8, 8);
            if (point != null) {
                Shape.drawBoldLine(graphics, point.x, point.y, point2.x, point2.y);
            }
            point = point2;
        }
    }

    private void drawPathSegment(Graphics graphics, Point point, Point point2, boolean bl) {
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        int n = (int)Math.sqrt(d * d + d2 * d2);
        graphics.drawOval(point.x - n, point.y - n, n * 2, n * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mouseAt(Point point, boolean bl) {
        int n = this.waypoints.size();
        if (n > 0) {
            FloatPoint floatPoint = (FloatPoint)this.waypoints.elementAt(n - 1);
            Point point2 = this.map.mapToScreen(floatPoint);
            Graphics graphics = this.map.getGraphics();
            if (graphics != null) {
                try {
                    graphics.setFont(font);
                    graphics.setColor(Color.black);
                    graphics.setXORMode(Color.white);
                    if (this.lastMousePosition != null) {
                        this.drawPathSegment(graphics, point2, this.lastMousePosition, true);
                        graphics.drawString(this.lastLabel, this.lastMousePosition.x, this.lastMousePosition.y);
                    }
                    if (!bl) {
                        if (this.isDrawAngle) {
                            double d = Math.atan2(point.y - point2.y, point.x - point2.x);
                            if ((d = Math.toDegrees(d)) < 0.0) {
                                d = 360.0 + d;
                            }
                            d = d > 270.0 ? d - 270.0 : d + 90.0;
                            this.lastLabel = Strings.doubleToStr(d, 100) + " x ";
                        } else {
                            this.lastLabel = "";
                        }
                        FloatPoint floatPoint2 = this.map.screenToMap(point);
                        this.lastLabel = this.lastLabel + this.formatLength(this.getPathLength() + this.distance(floatPoint, floatPoint2));
                        this.drawPathSegment(graphics, point2, point, true);
                        graphics.drawString(this.lastLabel, point.x, point.y);
                        graphics.setXORMode(Color.black);
                        this.lastMousePosition = point;
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
        }
    }

    public void mouseMapPressed(MouseEvent mouseEvent) {
        if (this.map.getTool() == TOOL_ADD_WAYPOINT && (mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.waypoints.size() <= 0 || this.drawingPath) {
                this.drawingPath = mouseEvent.getClickCount() <= 1;
            } else {
                this.clearPath();
                this.drawingPath = true;
            }
            Point point = mouseEvent.getPoint();
            FloatPoint floatPoint = this.map.screenToMap(point);
            this.mouseAt(point, true);
            this.addWaypoint(floatPoint);
            this.lastMousePosition = null;
        }
    }

    public void mouseMapReleased(FloatRectangle floatRectangle, MouseEvent mouseEvent) {
    }

    public void mouseMapMoved(MouseEvent mouseEvent) {
        if (this.map.getTool() == TOOL_ADD_WAYPOINT && this.drawingPath) {
            Point point = mouseEvent.getPoint();
            this.mouseAt(point, false);
        }
    }

    public void afterMapDraw(Graphics graphics) {
        this.lastMousePosition = null;
        this.lastLabel = null;
        this.drawWholePath(graphics);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Component) {
            String string = ((Component)object).getName();
            if (string.equalsIgnoreCase(NAME_BTN_ADD)) {
                this.map.setTool(TOOL_ADD_WAYPOINT);
                if (object instanceof ImageButton) {
                    ((ImageButton)object).setDown(true);
                }
            } else if (string.equalsIgnoreCase(NAME_BTN_CLEAR)) {
                this.clearPath();
            }
        }
    }

    public void afterProjectLoaded(boolean bl) {
        Container container = (Container)((Object)this.host);
        MapUtils.addActionListener(this, container, NAME_BTN_ADD);
        MapUtils.addActionListener(this, container, NAME_LBL_INFO);
        this.lblInfo = (Label)this.host.findComponent(NAME_LBL_INFO);
        if (bl && this.distUnits == -1) {
            this.distUnits = this.map.getProject().ZoomUnits;
        }
    }

    public void notifyStatus(int n, Object object) {
        Component component;
        if (n == 11 && object != null) {
            this.clearPath();
        } else if (this.map.getTool() == TOOL_ADD_WAYPOINT && (component = this.host.findComponent(NAME_BTN_ADD)) instanceof ImageButton) {
            ((ImageButton)component).setDown(true);
        }
    }

    private void recalculatePathLength() {
        this.pathLength = this.getPathLength();
        if (this.lblInfo != null) {
            this.lblInfo.setText(this.formatLength(this.pathLength));
        }
    }

    private double getPathLength() {
        int n = this.waypoints.size();
        FloatPoint floatPoint = null;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            FloatPoint floatPoint2 = (FloatPoint)this.waypoints.elementAt(i);
            if (floatPoint != null) {
                d += this.distance(floatPoint, floatPoint2);
            }
            floatPoint = floatPoint2;
        }
        return d;
    }

    private String formatLength(double d) {
        String string;
        switch (this.distUnits) {
            case 1: {
                string = this.map.getResource("m");
                break;
            }
            case 0: 
            case 2: {
                string = this.map.getResource("km");
                break;
            }
            case 4: {
                string = this.map.getResource("ft");
                break;
            }
            case 5: {
                string = this.map.getResource("mi");
                break;
            }
            case 6: {
                string = this.map.getResource("nmi");
                break;
            }
            default: {
                string = "";
            }
        }
        return MapUtils.formatDistance(d, this.map.getProject().MapUnits, this.distUnits, this.unitsFormat, string);
    }

    private double distance(FloatPoint floatPoint, FloatPoint floatPoint2) {
        int n = this.map.getProject().MapUnits;
        return MapUtils.getDistance(floatPoint, floatPoint2, n);
    }
}

