/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.StatusListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class ScaleBar
extends Panel
implements CarteHostListener,
StatusListener {
    private Carte map = null;
    private final String _TEST_STR = "999999";
    private boolean metric = true;
    private static final int TP_NOTEXT = 0;
    private static final int TP_ONSIDES = 1;
    private static final int TP_TOP = 2;
    private static final int TP_BOTTOM = 3;
    private int textPosition = 3;
    private int border = 2;
    private int barThickness = 8;
    private boolean barFullLength = false;
    private Color color1 = Color.white;
    private Color color2 = Color.black;
    private double barExtent;
    private double roundBarExtent;
    private String unitsString;
    private double pixelsPerTic;
    private double unitsPerTic;
    private int ticCount;

    public void setMap(Carte carte) {
        this.map = carte;
        this.updateBar();
    }

    public void updateBar() {
        this.repaint();
    }

    private double getBarExtent() {
        if (this.map == null || !this.map.isProjectLoaded()) {
            return 0.0;
        }
        Dimension dimension = this.map.getSize();
        double d = dimension.width;
        if (d < 1.0 || !this.map.isProjectLoaded()) {
            return 0.0;
        }
        Project project = this.map.getProject();
        double d2 = MapUtils.getDistance(this.map.getExtent(), project.MapUnits, 1);
        d2 = this.metric ? (d2 *= 100.0) : d2 * 100.0 / (double)2.54f;
        dimension = this.getSize();
        return (double)dimension.width / d * d2;
    }

    private void calculateProperties() {
        int n;
        this.barExtent = this.getBarExtent();
        int n2 = String.valueOf(Math.round(this.barExtent)).length();
        this.unitsString = n2 > 5 ? this.map.getResource("km") : (n2 > 2 ? this.map.getResource("m") : this.map.getResource("cm"));
        switch (n2) {
            case 9: {
                n = 3;
                break;
            }
            case 8: {
                n = 2;
                break;
            }
            case 7: {
                n = 1;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = n2 > 9 ? 4 : 0;
            }
        }
        double d = this.barExtent / Math.pow(10.0, n2 - 1);
        this.roundBarExtent = Math.floor(d) * Math.pow(10.0, n2 - 1);
        n2 = (int)Math.floor(Math.floor(d) * Math.pow(10.0, n));
        n = n2 == 1 || n2 == 10 || n2 == 100 || n2 == 1000 || n2 == 10000 ? 10 : (n2 > 10000 ? (int)Math.floor((double)n2 / 10000.0) : (n2 > 1000 ? (int)Math.floor((double)n2 / 1000.0) : (n2 > 100 ? (int)Math.floor((double)n2 / 100.0) : (n2 > 10 ? (int)Math.floor((double)n2 / 10.0) : n2))));
        Dimension dimension = this.getSize();
        this.pixelsPerTic = Math.floor((double)dimension.width * this.roundBarExtent / this.barExtent / (double)n);
        this.unitsPerTic = (double)n2 / (double)n;
        this.ticCount = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.map == null || !this.map.isProjectLoaded()) {
            return;
        }
        Dimension dimension = this.map.getSize();
        if (dimension.width < 50) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth("999999");
        Dimension dimension2 = this.getSize();
        int n2 = dimension2.width;
        int n3 = dimension2.height;
        int n4 = this.textPosition == 1 ? n2 - 2 * n : n2;
        this.calculateProperties();
        if (this.ticCount < 1) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (this.textPosition) {
            case 0: 
            case 1: {
                n5 = (n3 - 2 * this.border) / 2 - this.barThickness / 2;
                n6 = n5 + this.barThickness;
                n7 = (n3 - 2 * this.border) / 2 - fontMetrics.getHeight() / 2;
                break;
            }
            case 2: {
                n5 = this.border + fontMetrics.getHeight();
                n6 = n5 + this.barThickness;
                n7 = this.border;
                break;
            }
            case 3: {
                n5 = this.border;
                n6 = n5 + this.barThickness;
                n7 = n6 + 1;
            }
        }
        int n8 = this.barFullLength ? this.border : this.border + (int)Math.round(((double)n2 - (double)this.ticCount * this.pixelsPerTic) / 2.0);
        for (int i = 0; this.barFullLength || i < this.ticCount; ++i) {
            if (i & true) {
                graphics.setColor(this.color1);
            } else {
                graphics.setColor(this.color2);
            }
            int n9 = n8 + (int)((double)i * this.pixelsPerTic);
            int n10 = n8 + (int)((double)(i + 1) * this.pixelsPerTic);
            if (n10 > n2 - n8) {
                n10 = n2 - n8;
            }
            if (this.barThickness == 1) {
                graphics.drawLine(n9, n5, n10, n6);
                continue;
            }
            graphics.fillRect(n9, n5, n10 - n9, n6 - n5);
            graphics.setColor(this.color2);
            graphics.drawRect(n9, n5, n10 - n9, n6 - n5);
            if (n10 < n2 - n8) continue;
        }
        if (this.textPosition != 0) {
            n7 += fontMetrics.getHeight();
            String string = String.valueOf((int)Math.floor(this.unitsPerTic * (double)this.ticCount)) + " " + this.unitsString;
            graphics.setColor(this.getForeground());
            if (this.textPosition == 1) {
                graphics.drawString("0", n8 - fontMetrics.charWidth('0'), n7);
                graphics.drawString(string, n2 - n8 + 1, n7);
            } else {
                graphics.drawString("0", n8 + 1, n7);
                graphics.drawString(string, (int)((double)n8 + this.pixelsPerTic * (double)this.ticCount - (double)fontMetrics.stringWidth(string) - 1.0), n7);
            }
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        this.textPosition = XmlUtils.getInt("style", xmlElement, 3);
        this.barThickness = XmlUtils.getInt("size", xmlElement, this.barThickness);
        this.color1 = XmlUtils.getColor("color1", xmlElement, this.color1);
        this.color2 = XmlUtils.getColor("color2", xmlElement, this.color2);
        this.map = carteHost.getMapByName(xmlElement);
        this.map.statusListeners.addElement(this);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bl) {
    }

    public void notifyStatus(int n, Object object) {
        if (n == 109) {
            this.updateBar();
        }
    }
}

