/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alov.data.Csv;
import org.alov.data.DataProvider;
import org.alov.data.Dbf;
import org.alov.data.Gml;
import org.alov.data.Mif;
import org.alov.data.SQLConst;
import org.alov.data.Shp;
import org.alov.map.FieldDef;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.MapUtils;
import org.alov.map.Meta;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class DataProviderFile
extends DataProvider {
    transient Dbf dbf = null;
    public boolean fixHoles = true;

    public DataProviderFile(Layer layer) {
        super(layer);
    }

    private static void readZip(byte[] byArray, ZipInputStream zipInputStream) throws IOException {
        int n;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = zipInputStream.read(byArray, n2, i);
            n2 += n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadComplete() throws AlovMapException {
        try {
            IOException iOException4;
            BufferedInputStream bufferedInputStream;
            ByteArrayInputStream byteArrayInputStream;
            block84: {
                if (this.layer.connectionData == null) throw new AlovMapException(105, this.layer.getName());
                String string = this.layer.connectionData.getProperty("url");
                if (string == null) {
                    throw new AlovMapException(105, this.layer.getName());
                }
                String string2 = null;
                String string3 = null;
                if (this.layer instanceof LayerZoomify && !Strings.checkSuffix(string, ".dbf")) {
                    if (this.layer.metadata.isNotLoaded) {
                        string2 = Strings.changeSuffix(string, ".xml");
                        try {
                            this.layer.metadata.loadMetadata(this.openURL(string2));
                        }
                        catch (AlovMapException alovMapException) {
                            throw new AlovMapException(alovMapException.getCode(), alovMapException.getMessage());
                        }
                        catch (Exception exception) {
                            throw new AlovMapException(314, "Can't load file " + string2);
                        }
                        string = Strings.getAbsPath(Strings.extractDir(string2), "ImageProperties.xml");
                    }
                    if (!string.endsWith("ImageProperties.xml")) throw new AlovMapException(314, "Can't load Zoomify file " + string);
                    this.loadZoomify(string);
                    return "";
                }
                StreamCounter streamCounter = null;
                byte[] byArray = null;
                byte[] byArray2 = null;
                byte[] byArray3 = null;
                byte[] byArray4 = null;
                byte[] byArray5 = null;
                byte[] byArray6 = null;
                Object var19_14 = null;
                StreamCounter streamCounter2 = null;
                InputStream inputStream = null;
                byteArrayInputStream = null;
                bufferedInputStream = null;
                try {
                    ByteArrayInputStream byteArrayInputStream2;
                    ZipInputStream zipInputStream;
                    try {
                        boolean bl = string.startsWith("file:/");
                        streamCounter = this.openURL(string);
                    }
                    catch (Exception exception) {
                        throw new AlovMapException(308, "Can't load file " + string);
                    }
                    if (streamCounter != null) {
                        try {
                            Meta meta = this.layer.metadata;
                            String string4 = null;
                            if (Strings.checkSuffix(string, ".zip")) {
                                Object object;
                                ZipEntry zipEntry;
                                zipInputStream = new ZipInputStream(streamCounter);
                                do {
                                    zipEntry = zipInputStream.getNextEntry();
                                    object = null;
                                    if (zipEntry == null) continue;
                                    String string5 = zipEntry.getName();
                                    int n = (int)zipEntry.getSize();
                                    if (byArray2 == null && Strings.checkSuffix(string5, ".dbf")) {
                                        byArray2 = new byte[n];
                                        object = byArray2;
                                    } else if (byArray3 == null && Strings.checkSuffix(string5, ".mid")) {
                                        byArray3 = new byte[n];
                                        object = byArray3;
                                    } else if (byArray == null && (Strings.checkSuffix(string5, ".xml") || Strings.checkSuffix(string5, ".tmm"))) {
                                        byArray = new byte[n];
                                        object = byArray;
                                    } else if (byArray4 == null && byArray5 == null) {
                                        if (Strings.checkSuffix(string5, ".shp")) {
                                            byArray4 = new byte[n];
                                            object = byArray4;
                                        } else if (Strings.checkSuffix(string5, ".mif")) {
                                            byArray5 = new byte[n];
                                            object = byArray5;
                                        } else if (Strings.checkSuffix(string5, ".csv") || Strings.checkSuffix(string5, ".txt")) {
                                            byArray6 = new byte[n];
                                            object = byArray6;
                                        }
                                    }
                                    if (object != null) {
                                        DataProviderFile.readZip((byte[])object, zipInputStream);
                                    }
                                    if (((byArray4 != null || byArray5 != null) && byArray2 != null || byArray5 != null && byArray3 != null) && byArray != null) break;
                                } while (zipEntry != null);
                                zipInputStream.close();
                                if (byArray != null && meta.isNotLoaded) {
                                    byteArrayInputStream2 = new ByteArrayInputStream(byArray);
                                    try {
                                        meta.loadMetadata(byteArrayInputStream2);
                                    }
                                    catch (AlovMapException alovMapException) {
                                        throw new AlovMapException(alovMapException.getCode(), alovMapException.getMessage());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    byteArrayInputStream2.close();
                                }
                                ((LayerVector)this.layer).resolveMetadata();
                                string4 = meta.getStr(305);
                                if (byArray2 != null) {
                                    byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
                                    this.dbf = new Dbf(byteArrayInputStream2, string4);
                                    byteArrayInputStream2.close();
                                    this.resolveFields();
                                }
                                if (byArray4 != null) {
                                    byteArrayInputStream2 = new ByteArrayInputStream(byArray4);
                                    Shp.loadFromStream(byteArrayInputStream2, this.dbf, (LayerVector)this.layer, this.fixHoles);
                                    byteArrayInputStream2.close();
                                } else if (byArray5 != null) {
                                    if (!MapUtils.isMIF_Enabled()) throw new AlovMapException(111, "MIF loader is not found.");
                                    byteArrayInputStream2 = new ByteArrayInputStream(byArray5);
                                    if (this.dbf != null) {
                                        Mif.loadFromStream(byteArrayInputStream2, null, this.dbf, (LayerVector)this.layer);
                                    } else if (byArray3 != null) {
                                        object = new ByteArrayInputStream(byArray3);
                                        Mif.loadFromStream(byteArrayInputStream2, (InputStream)object, null, (LayerVector)this.layer);
                                        ((ByteArrayInputStream)object).close();
                                        object = null;
                                    }
                                    byteArrayInputStream2.close();
                                } else if (this.dbf != null) {
                                    this.dbf.loadToLayer((LayerVector)this.layer);
                                } else if (byArray6 != null) {
                                    byteArrayInputStream2 = new ByteArrayInputStream(byArray6);
                                    Csv.loadFromStream(byteArrayInputStream2, (LayerVector)this.layer, string4);
                                    byteArrayInputStream2.close();
                                }
                            } else {
                                if (this.layer.metadata.isNotLoaded) {
                                    string2 = Strings.changeSuffix(string, ".xml");
                                    try {
                                        meta.loadMetadata(this.openURL(string2));
                                    }
                                    catch (AlovMapException alovMapException) {
                                        throw new AlovMapException(alovMapException.getCode(), alovMapException.getMessage());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    string3 = meta.getStr(34);
                                }
                                ((LayerVector)this.layer).resolveMetadata();
                                string4 = meta.getStr(305);
                                if ("gml".equalsIgnoreCase(string3)) throw new AlovMapException(310, "GML is not supported in this version.");
                                if (Strings.checkSuffix(string, ".gml")) {
                                    throw new AlovMapException(310, "GML is not supported in this version.");
                                }
                                if ("txt".equalsIgnoreCase(string3) || "csv".equalsIgnoreCase(string3) || Strings.checkSuffix(string, ".csv") || Strings.checkSuffix(string, ".txt")) {
                                    Csv.loadFromStream(streamCounter, (LayerVector)this.layer, string4);
                                } else {
                                    boolean bl;
                                    String string6;
                                    block83: {
                                        string6 = Strings.changeSuffix(string, ".dbf");
                                        streamCounter2 = null;
                                        bl = true;
                                        try {
                                            inputStream = this.openURL(string6);
                                        }
                                        catch (Exception exception) {
                                            bl = false;
                                            if ("shapefile".equalsIgnoreCase(string3)) throw new AlovMapException(308, "Can't load file " + string6);
                                            if (!Strings.checkSuffix(string, ".shp")) break block83;
                                            throw new AlovMapException(308, "Can't load file " + string6);
                                        }
                                    }
                                    if (!bl && ("mifmid".equalsIgnoreCase(string3) || Strings.checkSuffix(string, ".mif"))) {
                                        String string7 = Strings.changeSuffix(string, ".mid");
                                        try {
                                            streamCounter2 = this.openURL(string7);
                                        }
                                        catch (Exception exception) {
                                            throw new AlovMapException(308, "Can't load file " + string6 + " or " + string7);
                                        }
                                    }
                                    if (inputStream != null && bl) {
                                        this.dbf = new Dbf(inputStream, string4, true);
                                        this.resolveFields();
                                    }
                                    if ("shapefile".equalsIgnoreCase(string3) || Strings.checkSuffix(string, ".shp")) {
                                        Shp.loadFromStream(streamCounter, this.dbf, (LayerVector)this.layer, this.fixHoles);
                                    } else if ("mifmid".equalsIgnoreCase(string3) || Strings.checkSuffix(string, ".mif")) {
                                        if (bl) {
                                            Mif.loadFromStream(streamCounter, null, this.dbf, (LayerVector)this.layer);
                                        } else if (streamCounter2 != null) {
                                            Mif.loadFromStream(streamCounter, streamCounter2, null, (LayerVector)this.layer);
                                        }
                                    } else {
                                        if (!"dbase".equalsIgnoreCase(string3)) {
                                            if (!Strings.checkSuffix(string, ".dbf")) throw new AlovMapException(110, string);
                                        }
                                        this.dbf.loadToLayer((LayerVector)this.layer);
                                    }
                                }
                            }
                            try {
                                ((InputStream)streamCounter).close();
                            }
                            catch (Exception exception) {}
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                            throw new AlovMapException(309, "Can't load file " + string);
                        }
                    }
                    this.layer.setLoadComplete(true);
                    Object var33_42 = null;
                    streamCounter = null;
                    byteArrayInputStream2 = null;
                    Object var12_44 = null;
                    if (this.dbf != null) {
                        this.dbf.clear();
                    }
                    this.dbf = null;
                    byArray = null;
                    byArray2 = null;
                    byArray3 = null;
                    byArray4 = null;
                    byArray5 = null;
                    byArray6 = null;
                    var19_14 = null;
                    zipInputStream = null;
                    streamCounter2 = null;
                    if (inputStream == null) break block84;
                }
                catch (Throwable throwable) {
                    IOException iOException32;
                    Object var33_43 = null;
                    streamCounter = null;
                    Object var22_41 = null;
                    Object var12_45 = null;
                    if (this.dbf != null) {
                        this.dbf.clear();
                    }
                    this.dbf = null;
                    byArray = null;
                    byArray2 = null;
                    byArray3 = null;
                    byArray4 = null;
                    byArray5 = null;
                    byArray6 = null;
                    var19_14 = null;
                    Object var20_25 = null;
                    streamCounter2 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException32) {
                            // empty catch block
                        }
                        inputStream = null;
                    }
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException32) {
                            // empty catch block
                        }
                        bufferedInputStream = null;
                    }
                    if (byteArrayInputStream == null) throw throwable;
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException iOException32) {
                        // empty catch block
                    }
                    byteArrayInputStream = null;
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                inputStream = null;
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                bufferedInputStream = null;
            }
            if (byteArrayInputStream == null) return "";
            try {
                byteArrayInputStream.close();
                return "";
            }
            catch (IOException iOException4) {
                // empty catch block
            }
            return "";
        }
        catch (Error error) {
            this.layer.clear(false);
            if (!(error instanceof OutOfMemoryError)) return "";
            throw new AlovMapException(313, "Not enough memory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadZoomify(String string) throws AlovMapException {
        StreamCounter streamCounter = null;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        String string2 = ".jpg";
        boolean bl2 = true;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        try {
            String string3 = string;
            streamCounter = this.openURL(string3);
            XmlElement xmlElement = XmlUtils.parseStream(streamCounter, null);
            ((InputStream)streamCounter).close();
            if (xmlElement != null) {
                n = Integer.parseInt(xmlElement.getAttributeValue("NUMIMAGES"));
                n2 = Integer.parseInt(xmlElement.getAttributeValue("NUMTILES"));
                d = Integer.parseInt(xmlElement.getAttributeValue("WIDTH"));
                d2 = Integer.parseInt(xmlElement.getAttributeValue("HEIGHT"));
                d3 = Integer.parseInt(xmlElement.getAttributeValue("TILESIZE"));
                string2 = xmlElement.getAttributeValue("FORMAT");
                bl2 = !"no".equalsIgnoreCase(xmlElement.getAttributeValue("GROUPED"));
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new AlovMapException(308, "Can't load file " + string);
        }
        if (!bl) {
            return null;
        }
        if (Strings.isNullOrBlank(string2)) {
            string2 = ".jpg";
        }
        try {
            d4 = Double.valueOf(this.layer.metadata.getVal(142));
            d5 = Double.valueOf(this.layer.metadata.getVal(143));
            d8 = Double.valueOf(this.layer.metadata.getVal(144));
            d9 = -Double.valueOf(this.layer.metadata.getVal(145)).doubleValue();
            d4 -= d8 / 2.0;
            d5 += d9 / 2.0;
            d6 = d4 + (d8 *= d);
            d7 = d5 - (d9 *= d2);
        }
        catch (Exception exception) {
            d4 = this.layer.metadata.getDouble(4);
            d6 = this.layer.metadata.getDouble(5);
            d7 = this.layer.metadata.getDouble(6);
            d5 = this.layer.metadata.getDouble(7);
            d8 = d6 - d4;
            d9 = d5 - d7;
        }
        if (d8 == 0.0) {
            throw new AlovMapException(301, "X pixel size is zero");
        }
        if (d8 == 0.0) {
            throw new AlovMapException(301, "Y pixel size is zero");
        }
        double d10 = d3;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (d10 < d || d10 < d2) {
            d10 *= 2.0;
            ++n5;
        }
        String string4 = Strings.extractDir(string) + (bl2 ? "TileGroup" : "");
        FieldDef fieldDef = new FieldDef();
        fieldDef.index = 0;
        fieldDef.name = "level";
        fieldDef.type = 4;
        FieldDef fieldDef2 = new FieldDef();
        fieldDef2.index = 1;
        fieldDef2.name = "image";
        fieldDef2.type = 12;
        this.layer.dataStorage.initFields(2);
        this.layer.dataStorage.assignFields(new FieldDef[]{fieldDef, fieldDef2});
        this.layer.dataStorage.setObjectType(3);
        int n6 = 0;
        int n7 = 0;
        this.layer.dataStorage.openDataStorageSave(true);
        try {
            for (int i = 0; i < n5; ++i) {
                int n8 = (int)(Math.ceil(d / d10) + 0.01);
                int n9 = (int)(Math.ceil(d2 / d10) + 0.01);
                double d11 = d8 * (d10 / d);
                double d12 = d9 * (d10 / d2);
                double d13 = d5;
                int n10 = 0;
                while (n10 < n9) {
                    double d14 = d12;
                    if (d13 - d14 < d7) {
                        d14 = d13 - d7;
                    }
                    double d15 = d4;
                    int n11 = 0;
                    while (n11 < n8) {
                        double d16 = d11;
                        if (d15 + d16 > d6) {
                            d16 = d6 - d15;
                        }
                        Record record = this.layer.newRecord(n6);
                        Shape shape = record.newShape(4);
                        shape.xCoords = new double[]{d15, d15 + d16, d15 + d16, d15};
                        shape.yCoords = new double[]{d13, d13, d13 - d14, d13 - d14};
                        String string5 = string4;
                        if (bl2) {
                            string5 = string4 + n4;
                        }
                        string5 = string5 + "/" + i + "-" + n11 + "-" + n10 + string2;
                        record.setFieldValues(new Object[]{new Integer(i), string5});
                        ++n6;
                        this.layer.addRecord(record);
                        if (++n3 > 255 && bl2) {
                            n3 = 0;
                            ++n4;
                        }
                        ++n11;
                        d15 += d11;
                    }
                    ++n10;
                    d13 -= d12;
                }
                ++n7;
                d10 /= 2.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.layer.dataStorage.closeDataStorageSave();
        }
        LayerZoomify layerZoomify = (LayerZoomify)this.layer;
        layerZoomify.setDimensions(d8, d9, d, d2, d3, n7);
        this.layer.dataStorage.setObjectType(3);
        this.layer.setLoadComplete(true);
        this.layer.metadata.isNotLoaded = false;
        this.layer.metadata.loadFailed = false;
        this.layer.prepareLayer();
        this.layer.setLoadComplete(true);
        return null;
    }

    private void resolveGmlFields() {
        int n;
        if (Gml.f_names == null) {
            return;
        }
        int n2 = Gml.f_names.length;
        String string = this.layer.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(string)) {
            string = string + ',';
        }
        Vector<FieldDef> vector = new Vector<FieldDef>();
        for (n = 0; n < n2; ++n) {
            if (Strings.isNullOrBlank(Gml.f_names[n])) continue;
            FieldDef fieldDef = new FieldDef();
            fieldDef.type = 12;
            fieldDef.index = vector.size();
            fieldDef.name = Gml.f_names[n];
            fieldDef.label = this.layer.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
            fieldDef.visible = Strings.isNullOrBlank(string) || string.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            vector.addElement(fieldDef);
        }
        n2 = vector.size();
        this.layer.dataStorage.initFields(n2);
        for (n = 0; n < n2; ++n) {
            this.layer.setFieldDef(n, (FieldDef)vector.elementAt(n));
        }
        LayerVector layerVector = (LayerVector)this.layer;
        layerVector.fi_description = layerVector.getFieldIndex(layerVector.f_description);
        layerVector.fi_id = layerVector.getFieldIndex(layerVector.f_id);
        if (layerVector.fi_id >= 0) {
            layerVector.f_id_istext = SQLConst.isText(layerVector.getFieldDef((int)layerVector.fi_id).type);
        }
        this.layer.prepareLayer();
    }

    private void resolveFields() {
        int n;
        String string;
        int n2 = this.dbf == null ? 0 : this.dbf.getNumFields();
        String string2 = this.layer.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(string2)) {
            string2 = ',' + string2 + ',';
        }
        if (!Strings.isNullOrBlank(string = this.layer.metadata.getVal(312, MapUtils.language))) {
            string = ',' + string.toUpperCase() + ',';
        }
        Vector<FieldDef> vector = new Vector<FieldDef>();
        for (n = 0; n < n2; ++n) {
            int n3;
            char c = this.dbf.getFieldType(n);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'L': {
                    n3 = 1;
                    break;
                }
                case 'I': {
                    n3 = 4;
                    break;
                }
                case 'F': 
                case 'N': {
                    n3 = 8;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if (!SQLConst.isAllowedType(n3)) continue;
            FieldDef fieldDef = new FieldDef();
            fieldDef.type = n3;
            fieldDef.index = vector.size();
            fieldDef.name = this.dbf.getFieldName(n).toString();
            fieldDef.label = this.layer.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
            fieldDef.visible = Strings.isNullOrBlank(string2) || string2.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            fieldDef.editable = !Strings.isNullOrBlank(string) && string.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            fieldDef.fieldlen = this.dbf.fielddef[n].fieldlen;
            fieldDef.fieldnumdec = this.dbf.fielddef[n].fieldnumdec;
            vector.addElement(fieldDef);
        }
        n2 = vector.size();
        this.layer.dataStorage.initFields(n2);
        for (n = 0; n < n2; ++n) {
            this.layer.setFieldDef(n, (FieldDef)vector.elementAt(n));
        }
        LayerVector layerVector = (LayerVector)this.layer;
        layerVector.fi_description = layerVector.getFieldIndex(layerVector.f_description);
        layerVector.fi_id = layerVector.getFieldIndex(layerVector.f_id);
        if (layerVector.fi_id >= 0) {
            layerVector.f_id_istext = SQLConst.isText(layerVector.getFieldDef((int)layerVector.fi_id).type);
        }
        this.layer.prepareLayer();
    }
}

