/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import org.alov.data.DataProvider;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.MapUtils;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;

public class DataProviderImg
extends DataProvider {
    public DataProviderImg(Layer layer) {
        super(layer);
    }

    public String loadComplete() throws AlovMapException {
        String string;
        String string2 = null;
        LayerRaster layerRaster = (LayerRaster)this.layer;
        if (this.layer.connectionData == null || (string = this.layer.connectionData.getProperty("url")) == null) {
            throw new AlovMapException(105, this.layer.getName());
        }
        if (this.layer.serverType != 11 && this.layer.serverType != 34 && this.layer.serverType != 15) {
            if (this.layer.metadata.isNotLoaded) {
                string2 = Strings.changeSuffix(string, ".xml");
                try {
                    this.layer.metadata.loadMetadata(this.openURL(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.layer.metadata.isNotLoaded || this.layer.metadata.getDouble(144) == 0.0 && this.layer.metadata.getDouble(145) == 0.0) {
                int n = string.lastIndexOf(".");
                String string3 = string.substring(n);
                string3 = string3.substring(0, 2) + string3.charAt(string3.length() - 1) + 'w';
                String string4 = Strings.changeSuffix(string, string3);
                try {
                    this.layer.metadata.loadWorldfile(this.openURL(string4));
                }
                catch (AlovMapException alovMapException) {
                    throw alovMapException;
                }
                catch (Exception exception) {
                    Log.addMessage(0, this.layer.getMap() != null ? this.layer.getMap().getName() : null, this.layer, "WARNING#301Registration parameters not found. " + string2 + "  " + "OR" + "  " + string4);
                }
            }
        }
        layerRaster.imageUrl = string;
        this.layer.metadata.put(168, "imagefile");
        layerRaster.resolveMetadata();
        this.loadRaster();
        this.layer.prepareLayer();
        return "";
    }

    public void loadRaster() throws AlovMapException {
        LayerRaster layerRaster = (LayerRaster)this.layer;
        String string = layerRaster.imageUrl;
        if (!this.layer.isDataOnServer && layerRaster.isEmpty()) {
            if (Strings.checkSuffix(string, ".j2k")) {
                throw new AlovMapException(306, "Jpeg2000 is not supported in this version.");
            }
            if (Strings.checkSuffix(string, ".jpg") || Strings.checkSuffix(string, ".gif") || Strings.checkSuffix(string, ".png")) {
                try {
                    layerRaster.setImage(MapUtils.loadImageToByteArray(this.layer, string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new AlovMapException(306, "Can't load raster image " + string + "  " + exception.getMessage());
                }
            } else {
                throw new AlovMapException(110, string);
            }
        }
    }
}

