/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alov.data.DbfConsts;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.ExDate;
import org.alov.util.Readers;
import org.alov.util.Strings;

public class Dbf
implements DbfConsts {
    private int dbf_id;
    private int last_update_d;
    private int last_update_m;
    private int last_update_y;
    private int last_rec;
    private int position = -1;
    private int data_offset;
    private int rec_size;
    private StringBuffer[] records = null;
    private boolean hasmemo;
    private int filesize;
    private int numfields;
    private DataInputStream dataInput = null;
    private String encoding = null;
    public DbfFieldDef[] fielddef = null;

    public Dbf(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, true);
    }

    public Dbf(InputStream inputStream, String string, boolean bl) throws IOException {
        this.encoding = Strings.isNullOrBlank(string) ? Readers.ENCODING : string;
        this.dataInput = new DataInputStream(inputStream);
        this.init();
        if (bl) {
            this.records = this.GrabFile();
        }
    }

    public void clear() {
        int n;
        if (this.records != null) {
            for (n = 0; n < this.records.length; ++n) {
                this.records[n] = null;
            }
            this.records = null;
        }
        if (this.fielddef != null) {
            for (n = 0; n < this.fielddef.length; ++n) {
                this.fielddef[n] = null;
            }
            this.fielddef = null;
        }
    }

    public int getLastRec() {
        return this.last_rec;
    }

    public int getNumFields() {
        return this.numfields;
    }

    public int getFieldNumber(String string) {
        for (int i = 0; i < this.numfields; ++i) {
            if (!string.equalsIgnoreCase(this.fielddef[i].fieldname.toString())) continue;
            return i;
        }
        return -1;
    }

    public StringBuffer getFieldName(int n) {
        return this.fielddef[n].fieldname;
    }

    public char getFieldType(int n) {
        return this.fielddef[n].fieldtype;
    }

    private void init() throws IOException {
        DbfFileHeader dbfFileHeader = new DbfFileHeader(this.dataInput);
        this.fielddef = new DbfFieldDef[this.numfields];
        int n = 1;
        for (int i = 0; i < this.numfields; ++i) {
            this.fielddef[i] = new DbfFieldDef(this.dataInput, n);
            n += this.fielddef[i].fieldlen;
        }
        this.dataInput.skipBytes(1);
        this.position = -1;
    }

    private StringBuffer grabNextDbfRec() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.rec_size + this.numfields);
        if (this.position >= this.last_rec) {
            return stringBuffer;
        }
        long l = 1L;
        while (l > 0L) {
            char c = (char)this.dataInput.readUnsignedByte();
            if (c != ' ') {
                l = this.dataInput.skip(this.rec_size - 1);
                --this.last_rec;
                if (this.position != this.last_rec) continue;
                return stringBuffer;
            }
            stringBuffer.append(c);
            break;
        }
        for (int i = 1; i < this.rec_size; ++i) {
            char c = (char)this.dataInput.readUnsignedByte();
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    private StringBuffer[] GrabFile() throws IOException {
        StringBuffer[] stringBufferArray = new StringBuffer[this.last_rec];
        this.position = 0;
        while (this.position < this.last_rec) {
            stringBufferArray[this.position] = this.grabNextDbfRec();
            ++this.position;
        }
        this.position = -1;
        return stringBufferArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseNextDbfRecord(Record record) throws IOException {
        ++this.position;
        StringBuffer stringBuffer = this.records == null ? this.grabNextDbfRec() : this.records[this.position];
        try {
            if (record != null) {
                String string;
                Integer n = new Integer(0);
                Double d = new Double(0.0);
                String string2 = string = stringBuffer == null ? "" : stringBuffer.toString();
                if ("&".equals(string) || string.length() < 1) {
                    record = null;
                } else {
                    String string3;
                    int n2 = string.length();
                    block13: for (int i = 0; i < this.numfields; ++i) {
                        string3 = this.fielddef[i].fieldstart > n2 ? "" : string.substring(this.fielddef[i].fieldstart, this.fielddef[i].fieldstart + this.fielddef[i].fieldlen).trim();
                        switch (this.fielddef[i].fieldtype) {
                            case 'C': {
                                record.setField(i, Readers.Read2Unicode(string3, this.encoding).trim());
                                continue block13;
                            }
                            case 'D': {
                                record.setField(i, ExDate.parseDBFstring(string3));
                                continue block13;
                            }
                            case 'F': 
                            case 'I': 
                            case 'N': {
                                if (this.fielddef[i].fieldnumdec > 0) {
                                    try {
                                        record.setField(i, Double.valueOf(string3));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        record.setField(i, d);
                                    }
                                    continue block13;
                                }
                                try {
                                    record.setField(i, Integer.decode(string3));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    record.setField(i, n);
                                }
                                continue block13;
                            }
                            case 'L': {
                                record.setField(i, string3);
                                continue block13;
                            }
                        }
                    }
                    string3 = null;
                }
            }
        }
        finally {
            stringBuffer = null;
        }
    }

    public void loadToLayer(LayerVector layerVector) throws AlovMapException {
        layerVector.dataStorage.openDataStorageSave(true);
        try {
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            if (layerVector.isObjectType(4) || layerVector.isObjectType(2)) {
                n = layerVector.getFieldIndex(layerVector.f_xmin);
                n2 = layerVector.getFieldIndex(layerVector.f_xmax);
                n3 = layerVector.getFieldIndex(layerVector.f_ymin);
                n4 = layerVector.getFieldIndex(layerVector.f_ymax);
                if (n < 0 && n2 < 0 && n3 < 0 && n4 < 0) {
                    n = layerVector.getFieldIndex("xmin");
                    n2 = layerVector.getFieldIndex("xmax");
                    n3 = layerVector.getFieldIndex("ymin");
                    n4 = layerVector.getFieldIndex("ymax");
                }
                if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
                if (!layerVector.isObjectType(2)) {
                    layerVector.dataStorage.setObjectType(3);
                }
            } else {
                layerVector.dataStorage.setObjectType(1);
                n5 = layerVector.getFieldIndex(layerVector.f_x);
                n6 = layerVector.getFieldIndex(layerVector.f_y);
                if (n5 < 0 && n6 < 0) {
                    n5 = layerVector.getFieldIndex("LONG");
                    n6 = layerVector.getFieldIndex("LAT");
                }
                if (n5 < 0 && n6 < 0) {
                    n5 = layerVector.getFieldIndex("LONGITUDE");
                    n6 = layerVector.getFieldIndex("LATITUDE");
                }
                if (n5 < 0 && n6 < 0) {
                    n5 = layerVector.getFieldIndex("X");
                    n6 = layerVector.getFieldIndex("Y");
                }
                if (n5 < 0 || n6 < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
            }
            int n7 = this.records.length;
            int n8 = this.getNumFields();
            for (int i = 0; i < n7; ++i) {
                Shape shape;
                Record record = new Record(n8);
                this.parseNextDbfRecord(record);
                if (record == null) continue;
                if (layerVector.isObjectType(3)) {
                    shape = record.newShape(4);
                    shape.xCoords[0] = layerVector.getFieldDouble(record, n);
                    shape.yCoords[0] = layerVector.getFieldDouble(record, n3);
                    shape.xCoords[1] = shape.xCoords[0];
                    shape.yCoords[1] = layerVector.getFieldDouble(record, n4);
                    shape.xCoords[2] = layerVector.getFieldDouble(record, n2);
                    shape.yCoords[2] = shape.yCoords[1];
                    shape.xCoords[3] = shape.xCoords[2];
                    shape.yCoords[3] = shape.yCoords[0];
                } else if (layerVector.isObjectType(2)) {
                    shape = record.newShape(2);
                    shape.xCoords[0] = layerVector.getFieldDouble(record, n);
                    shape.yCoords[0] = layerVector.getFieldDouble(record, n3);
                    shape.xCoords[1] = layerVector.getFieldDouble(record, n2);
                    shape.yCoords[1] = layerVector.getFieldDouble(record, n4);
                } else {
                    shape = record.newShape(1);
                    shape.xCoords[0] = layerVector.getFieldDouble(record, n5);
                    shape.yCoords[0] = layerVector.getFieldDouble(record, n6);
                }
                layerVector.addRecord(record);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AlovMapException(106, exception.getMessage());
        }
        finally {
            layerVector.dataStorage.closeDataStorageSave();
        }
    }

    public class DbfFieldDef {
        public StringBuffer fieldname = new StringBuffer(11);
        public char fieldtype;
        public int fieldstart;
        public int fieldlen;
        public int fieldnumdec;

        DbfFieldDef(DataInputStream dataInputStream, int n) throws IOException {
            boolean bl = true;
            for (int i = 0; i < 11; ++i) {
                char c = (char)dataInputStream.readUnsignedByte();
                if (c > '\u0000' && bl) {
                    this.fieldname.append(c);
                    continue;
                }
                if (this.fieldname.length() <= 0) continue;
                bl = false;
            }
            this.fieldtype = (char)dataInputStream.readUnsignedByte();
            this.fieldstart = n;
            dataInputStream.skipBytes(4);
            switch (this.fieldtype) {
                case 'C': 
                case 'D': 
                case 'G': 
                case 'L': 
                case 'M': 
                case 'c': {
                    this.fieldlen = dataInputStream.readUnsignedByte();
                    this.fieldnumdec = dataInputStream.readUnsignedByte();
                    this.fieldnumdec = 0;
                    break;
                }
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    this.fieldlen = dataInputStream.readUnsignedByte();
                    this.fieldnumdec = dataInputStream.readUnsignedByte();
                    if (this.fieldnumdec != 0) break;
                    this.fieldtype = (char)73;
                    break;
                }
            }
            dataInputStream.skipBytes(14);
        }
    }

    class DbfFileHeader {
        DbfFileHeader(DataInputStream dataInputStream) throws IOException {
            this.getDbfFileHeader(dataInputStream);
        }

        private void getDbfFileHeader(DataInputStream dataInputStream) throws IOException {
            Dbf.this.dbf_id = dataInputStream.readUnsignedByte();
            if (Dbf.this.dbf_id == 3) {
                Dbf.this.hasmemo = true;
            } else {
                Dbf.this.hasmemo = false;
            }
            Dbf.this.last_update_y = dataInputStream.readUnsignedByte();
            Dbf.this.last_update_m = dataInputStream.readUnsignedByte();
            Dbf.this.last_update_d = dataInputStream.readUnsignedByte();
            Dbf.this.last_rec = Readers.readInt(dataInputStream);
            Dbf.this.data_offset = Readers.readShort(dataInputStream);
            Dbf.this.rec_size = Readers.readShort(dataInputStream);
            Dbf.this.filesize = Dbf.this.rec_size * Dbf.this.last_rec + Dbf.this.data_offset + 1;
            Dbf.this.numfields = (Dbf.this.data_offset - 32 - 1) / 32;
            dataInputStream.skipBytes(20);
        }
    }
}

