/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.alov.data.Csv;
import org.alov.data.Dbf;
import org.alov.data.MifHeader;
import org.alov.map.FieldDef;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.Strings;

public class Mif {
    private static final String REGION = "REGION ";
    private static final String PLINE_MULTIPLE = "PLINE MULTIPLE ";
    private static final String PLINE = "PLINE ";
    private static final String POINT = "POINT ";
    private static final String LINE = "LINE ";
    private static final String EMPTY = "";
    private static final int MIF_POINT = 1;
    private static final int MIF_LINE = 2;
    private static final int MIF_POLYGON = 3;
    private MifHeader header;

    public Mif(InputStream inputStream, Dbf dbf) {
        this.header = new MifHeader(inputStream, null, dbf, -1);
    }

    public Mif(InputStream inputStream, InputStream inputStream2, Dbf dbf) {
        this.header = new MifHeader(inputStream, inputStream2, dbf, -1);
    }

    public int getObjectType() {
        return this.header.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadFromStream(InputStream inputStream, InputStream inputStream2, Dbf dbf, LayerVector layerVector) {
        MifHeader mifHeader = new MifHeader(inputStream, inputStream2, dbf, layerVector.fi_id);
        if (dbf == null) {
            Csv.resolveCsvFields(mifHeader.fieldNames, mifHeader.fieldsType, layerVector);
            for (int i = 0; i < mifHeader.fieldsType.length; ++i) {
                FieldDef fieldDef = layerVector.getFieldDef(i);
                fieldDef.fieldlen = mifHeader.fieldLens[i];
                fieldDef.fieldnumdec = mifHeader.fieldNumDec[i];
            }
        }
        layerVector.dataStorage.openDataStorageSave(true);
        try {
            Record record;
            while ((record = Mif.readNextObject(mifHeader)) != null) {
                if (layerVector.isObjectType(-1) || layerVector.isObjectType(mifHeader.type)) {
                    layerVector.addRecord(record);
                    continue;
                }
                record = null;
            }
            layerVector.dataStorage.setObjectType(mifHeader.type);
            layerVector.metadata.maxExtent = layerVector.getLayerExtent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            layerVector.dataStorage.closeDataStorageSave();
        }
        return mifHeader.objectNumber > 0;
    }

    public Record readNextObject() throws IOException {
        return Mif.readNextObject(this.header);
    }

    private static Record readNextObject(MifHeader mifHeader) throws IOException {
        String string;
        Record record = null;
        Dbf dbf = mifHeader.dbf;
        BufferedReader bufferedReader = mifHeader.reader;
        int n = dbf != null ? dbf.getNumFields() : mifHeader.fieldCountMid;
        while ((string = bufferedReader.readLine()) != null) {
            Shape shape;
            int n2;
            StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
            Strings.deleteSpaces(stringBuffer);
            string = stringBuffer.toString();
            if (string.startsWith(REGION) || string.startsWith(PLINE_MULTIPLE) || string.startsWith(PLINE)) {
                String string2;
                boolean bl = false;
                if (string.startsWith(REGION)) {
                    mifHeader.type = 3;
                    string2 = REGION;
                } else {
                    if (string.startsWith(PLINE_MULTIPLE)) {
                        string2 = PLINE_MULTIPLE;
                    } else {
                        string2 = PLINE;
                        bl = true;
                    }
                    mifHeader.type = 2;
                }
                int n3 = Integer.parseInt(string.substring(string2.length()).trim());
                int n4 = 0;
                if (bl) {
                    n4 = n3;
                    n3 = 1;
                }
                record = new Record(n);
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!bl) {
                        n4 = Integer.parseInt(bufferedReader.readLine().trim());
                    }
                    shape = record.newShape(n4);
                    for (int i = 0; i < n4; ++i) {
                        stringBuffer = new StringBuffer(bufferedReader.readLine());
                        Strings.deleteSpaces(stringBuffer);
                        string = stringBuffer.toString();
                        int n5 = string.indexOf(32, 0);
                        shape.xCoords[i] = MapUtils.toDouble(string.substring(0, n5));
                        shape.yCoords[i] = MapUtils.toDouble(string.substring(n5 + 1));
                    }
                }
            } else if (string.startsWith(POINT)) {
                mifHeader.type = 1;
                string = string.substring(POINT.length());
                int n6 = string.indexOf(32, 0);
                double d = MapUtils.toDouble(string.substring(0, n6));
                double d2 = MapUtils.toDouble(string.substring(n6 + 1));
                record = new Record(n);
                shape = record.newShape(1);
                shape.setVertex(0, d, d2);
            } else if (string.startsWith(LINE)) {
                mifHeader.type = 2;
                string = string.substring(LINE.length());
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                record = new Record(n);
                Shape shape2 = record.newShape(2);
                shape2.setVertex(0, MapUtils.toDouble(stringTokenizer.nextToken()), MapUtils.toDouble(stringTokenizer.nextToken()));
                shape2.setVertex(1, MapUtils.toDouble(stringTokenizer.nextToken()), MapUtils.toDouble(stringTokenizer.nextToken()));
            }
            if (record == null) continue;
            if (dbf != null) {
                dbf.parseNextDbfRecord(record);
            } else {
                Integer n7 = new Integer(0);
                Double d = new Double(0.0);
                StringBuffer stringBuffer2 = Mif.GrabNextMidRec(mifHeader);
                Record record2 = Csv.ParseCsvRecord(stringBuffer2.toString(), EMPTY, n);
                block12: for (n2 = 0; n2 < n; ++n2) {
                    switch (mifHeader.fieldsType[n2]) {
                        case 'C': 
                        case 'D': 
                        case 'L': {
                            record.setField(n2, record2.getField(n2));
                            continue block12;
                        }
                        case 'F': 
                        case 'N': {
                            try {
                                record.setField(n2, Double.valueOf((String)record2.getField(n2)));
                            }
                            catch (NumberFormatException numberFormatException) {
                                record.setField(n2, d);
                            }
                            continue block12;
                        }
                        case 'I': {
                            try {
                                record.setField(n2, Integer.decode((String)record2.getField(n2)));
                                continue block12;
                            }
                            catch (NumberFormatException numberFormatException) {
                                record.setField(n2, n7);
                            }
                        }
                    }
                }
            }
            return record;
        }
        return null;
    }

    private static StringBuffer GrabNextMidRec(MifHeader mifHeader) throws IOException {
        String string = mifHeader.readerMid.readLine();
        StringBuffer stringBuffer = new StringBuffer(string);
        Strings.deleteSpaces(stringBuffer);
        return stringBuffer;
    }

    public int getFieldCount() {
        return this.header != null ? this.header.fieldCountMid : -1;
    }

    public String getFieldName(int n) {
        if (this.header != null && n >= 0 && n < this.header.fieldCountMid) {
            return this.header.fieldNames[n];
        }
        return null;
    }

    public char getFieldType(int n) {
        if (this.header != null && n >= 0 && n < this.header.fieldCountMid) {
            return this.header.fieldsType[n];
        }
        return '\u0000';
    }

    public int getFieldLen(int n) {
        if (this.header != null && n >= 0 && n < this.header.fieldCountMid) {
            return this.header.fieldLens[n];
        }
        return 0;
    }

    public int getFieldNumDec(int n) {
        if (this.header != null && n >= 0 && n < this.header.fieldCountMid) {
            return this.header.fieldNumDec[n];
        }
        return 0;
    }

    public int getFieldNumber(String string) {
        if (this.header != null) {
            for (int i = 0; i < this.header.fieldCountMid; ++i) {
                if (!string.equalsIgnoreCase(this.header.fieldNames[i])) continue;
                return i;
            }
        }
        return -1;
    }
}

