/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import org.alov.data.Dbf;
import org.alov.data.ShpHeader;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.Readers;

public class Shp
implements Const {
    public static final int SHP_NULL = 0;
    public static final int SHP_POINT = 1;
    public static final int SHP_POLYLINE = 3;
    public static final int SHP_POLYGON = 5;
    public static final int SHP_MULTIPOINT = 8;
    public static final int SHP_POINTZ = 11;
    public static final int SHP_POLYLINEZ = 13;
    public static final int SHP_POLYGONZ = 15;
    public static final int SHP_MULTIPOINTZ = 18;
    ShpHeader header = null;
    private DataInputStream dataInput = null;

    public Shp(InputStream inputStream, Dbf dbf) throws Exception {
        this(inputStream, dbf, null);
    }

    public Shp(InputStream inputStream, Dbf dbf, LayerVector layerVector) throws Exception {
        if (inputStream != null) {
            this.dataInput = new DataInputStream(inputStream);
            this.header = new ShpHeader(this.dataInput, dbf, false, -1);
            if (layerVector != null) {
                Shp.setLayerParameters(layerVector, this.header);
            }
        } else {
            throw new Exception("Trying to instantiate Shp with InputStream == null");
        }
    }

    public static void loadFromStream(InputStream inputStream, Dbf dbf, LayerVector layerVector, boolean bl) throws AlovMapException {
        try {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 65536);
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                ShpHeader shpHeader = new ShpHeader(dataInputStream, dbf, bl, layerVector.fi_id);
                Shp.setLayerParameters(layerVector, shpHeader);
                layerVector.dataStorage.openDataStorageSave(true);
                int n = 1;
                while (shpHeader.position < shpHeader.length && dataInputStream.available() > 0) {
                    Record record;
                    if ((record = Shp.readNextShape(shpHeader, n++)) == null) continue;
                    layerVector.addRecord(record);
                }
                Object var10_14 = null;
                bufferedInputStream = null;
                dataInputStream = null;
                shpHeader = null;
                layerVector.dataStorage.closeDataStorageSave();
            }
            catch (AlovMapException alovMapException) {
                throw alovMapException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new AlovMapException(324, exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            Object var4_5 = null;
            Object var5_7 = null;
            Object var6_9 = null;
            layerVector.dataStorage.closeDataStorageSave();
            throw throwable;
        }
    }

    private static void setLayerParameters(Layer layer, ShpHeader shpHeader) {
        switch (shpHeader.type) {
            case 1: 
            case 8: {
                layer.dataStorage.setObjectType(1);
                break;
            }
            case 3: {
                layer.dataStorage.setObjectType(2);
                break;
            }
            case 5: {
                layer.dataStorage.setObjectType(3);
            }
        }
        layer.metadata.maxExtent = new FloatRectangle(shpHeader.xmin, shpHeader.ymin, shpHeader.xmax, shpHeader.ymax);
    }

    public Record readNextShape(int n) throws Exception {
        return Shp.readNextShape(this.header, n);
    }

    private static Record readNextShape(ShpHeader shpHeader, int n) throws Exception {
        if (shpHeader.position >= shpHeader.length) {
            throw new Exception("Trying to read past end of Shape file");
        }
        Dbf dbf = shpHeader.dbf;
        boolean bl = shpHeader.fixHoles;
        Record record = null;
        DataInputStream dataInputStream = shpHeader.dataInput;
        int n2 = dataInputStream.readInt();
        if (n != n2) {
            if (dbf != null) {
                dbf.parseNextDbfRecord(null);
            }
            return null;
        }
        int n3 = dataInputStream.readInt();
        int n4 = Readers.readInt(dataInputStream);
        int n5 = dbf != null ? dbf.getNumFields() : 0;
        shpHeader.position += n3 + 4;
        if (n4 != 0) {
            if (!(n4 == shpHeader.type || 1 == shpHeader.type && n4 == 11 || 8 == shpHeader.type && n4 == 18 || 3 == shpHeader.type && n4 == 13 || 5 == shpHeader.type && n4 == 15)) {
                throw new AlovMapException(323, "Shape type doesn't correspond with header type");
            }
            record = new Record(n5);
            record.index = shpHeader.objectNumber;
            switch (n4) {
                case 1: 
                case 11: {
                    Shape shape = record.newShape(1);
                    shape.xCoords[0] = Readers.readDouble(dataInputStream);
                    shape.yCoords[0] = Readers.readDouble(dataInputStream);
                    if (11 != n4) break;
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    break;
                }
                case 8: 
                case 18: {
                    int n6;
                    Readers.readRectangleLittle(dataInputStream);
                    int n7 = Readers.readInt(dataInputStream);
                    if (n7 < 0) {
                        throw new Exception("Shp corrupted. Invalid number of points : " + n7);
                    }
                    Shape shape = record.newShape(n7);
                    for (n6 = 0; n6 < n7; ++n6) {
                        shape.xCoords[n6] = Readers.readDouble(dataInputStream);
                        shape.yCoords[n6] = Readers.readDouble(dataInputStream);
                    }
                    if (18 != n4) break;
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    for (n6 = 0; n6 < n7; ++n6) {
                        Readers.readDouble(dataInputStream);
                    }
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    for (n6 = 0; n6 < n7; ++n6) {
                        Readers.readDouble(dataInputStream);
                    }
                    break;
                }
                case 3: 
                case 5: 
                case 13: 
                case 15: {
                    int n8;
                    int n9;
                    int n10;
                    Readers.readRectangleLittle(dataInputStream);
                    int n11 = Readers.readInt(dataInputStream);
                    int n12 = n10 = Readers.readInt(dataInputStream);
                    int n13 = n10;
                    if (n11 < 1) {
                        if (dbf != null) {
                            dbf.parseNextDbfRecord(null);
                        }
                        return null;
                    }
                    int[] nArray = shpHeader.tempArray;
                    if (nArray == null || nArray.length < n11) {
                        shpHeader.tempArray = nArray = new int[n11];
                    }
                    int n14 = 0;
                    int n15 = Readers.readInt(dataInputStream);
                    for (n9 = 0; n9 < n11 - 1; ++n9) {
                        nArray[n9] = Readers.readInt(dataInputStream) - n14;
                        n14 += nArray[n9];
                    }
                    if (n11 > 0) {
                        nArray[n11 - 1] = n10 - n14;
                    }
                    record.initShapes(n11);
                    boolean bl2 = false;
                    n12 = 0;
                    for (n9 = 0; n9 < n11; ++n9) {
                        n8 = nArray[n9];
                        int n16 = n8 = n8 < 0 ? 0 : (n8 > n10 ? n10 : n8);
                        if (n9 == n11 - 1 && (n10 -= n8) > 0) {
                            n8 = n10;
                        }
                        Shape shape = new Shape();
                        shape.xCoords = new double[n8];
                        shape.yCoords = new double[n8];
                        boolean bl3 = false;
                        for (int i = 0; i < n8; ++i) {
                            shape.xCoords[i] = Readers.readDouble(dataInputStream);
                            shape.yCoords[i] = Readers.readDouble(dataInputStream);
                            ++n12;
                        }
                        record.setShape(n9, shape);
                        bl2 = bl && (bl2 || (n4 == 5 || n4 == 15) && Shape.isClockWise(shape));
                    }
                    if (bl2) {
                        Record.addDoughnutShape(record, n12);
                    }
                    if (n4 != 15 && n4 != 13) break;
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    for (n8 = 0; n8 < n13; ++n8) {
                        Readers.readDouble(dataInputStream);
                        Readers.readDouble(dataInputStream);
                    }
                    Readers.readDouble(dataInputStream);
                    Readers.readDouble(dataInputStream);
                    for (n8 = 0; n8 < n13; ++n8) {
                        Readers.readDouble(dataInputStream);
                        Readers.readDouble(dataInputStream);
                    }
                    break;
                }
            }
            if (dbf != null) {
                dbf.parseNextDbfRecord(record);
            }
            ++shpHeader.objectNumber;
        } else {
            dbf.parseNextDbfRecord(null);
        }
        switch (n4) {
            case 11: {
                n4 = 1;
                break;
            }
            case 13: {
                n4 = 3;
                break;
            }
            case 15: {
                n4 = 5;
                break;
            }
            case 18: {
                n4 = 8;
            }
        }
        return record;
    }
}

