/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.DisplayContext;
import org.alov.map.DisplayContextImpl;
import org.alov.map.Domain;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.Lock;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Projection;
import org.alov.map.Proxy;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.SLD_Loader;
import org.alov.map.StatusListener;
import org.alov.map.Utils2D;
import org.alov.util.Log;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;
import org.alov.util.Utils;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Carte
extends Canvas
implements Runnable,
ImageObserver,
DisplayContext,
CarteHostListener,
ActionListener,
StatusListener,
TimerListener {
    private Properties parameters = new Properties();
    public static final byte TOOL_NONE = 0;
    public static final byte TOOL_CENTER = 1;
    public static final byte TOOL_ZOOMIN = 2;
    public static final byte TOOL_ZOOMOUT = 3;
    public static final byte TOOL_PAN = 4;
    public static final byte TOOL_SELECT = 5;
    public static final byte TOOL_WEBLINK = 6;
    public static final byte TOOL_RECT_SRCH = 7;
    public static final byte TOOL_RECT = 8;
    public static final byte TOOL_SELPOINT = 9;
    private static final int MAX_RECENT_EXTENTS = 20;
    public static final int SEARCH_EXACT = 1;
    public static final int SEARCH_LIKE = 2;
    public static final int SEARCH_QUERY = 3;
    public static final int SEARCH_WHERE = 4;
    public Proxy proxy = null;
    private Carte mainMap = null;
    CarteHost host = null;
    public Vector mapListeners = new Vector();
    public Vector statusListeners = new Vector();
    public boolean supressAttributeFrame = false;
    public boolean isMultiLayerSelectionMode = true;
    public boolean isShowAttributeAfterSelection = false;
    private int defaultAttributeReqType = 31;
    public Properties stringResources = null;
    private Image backImage = null;
    private Graphics drawTo = null;
    private boolean repaintStaticNeeded = false;
    private boolean repaintNeeded = false;
    private Lock paintLock = new Lock();
    private Integer pntCounter = new Integer(0);
    private boolean dontRedraw = false;
    private byte currentTool = 0;
    private byte alterTool = 0;
    private Point mouseDownPoint = null;
    private Point currentPoint = null;
    Vector usedSpaces = new Vector();
    String sDependent_Maps = null;
    long ext_changing = 0L;
    protected Projection projection = null;
    private FloatRectangle lastExtent = null;
    protected FloatRectangle loadedExtent;
    private FloatRectangle lastSelectExt = null;
    private TimeInterval timeInterval = null;
    private PopupMenu pmSelection = new PopupMenu();
    private boolean moveBeyondProject = false;
    private Vector recentExtents = new Vector();
    private int undoIndex = 0;
    private ProxyRequest request = new ProxyRequest();
    private Layer activeLayer = null;
    private String thematicMap = null;
    private Vector SLD_styles = null;
    private String SLD_url = null;
    private Thread serviceThread;
    private boolean sthRunning = false;
    private boolean stopped = true;
    private boolean isKilled = false;
    protected boolean isFirstRequest = true;
    private boolean isKeyMap = false;
    private Project project;
    private FloatRectangle lastRectSelection = null;
    private FloatPoint lastPointSelection = null;
    private Hashtable customCursors = null;
    private SimpleTimer animationTimer;
    private String sPreviousTipsURL = "";
    private static final Font waitFont = new Font("SansSerif", 1, 14);
    private boolean logExtent = false;
    private int gcEach_10_paints = 0;
    private final String _MSG_SWITCH = "Switch on layers to view map";
    private final String _MSG_WAITPLS = "Wait please...";
    private static final String BTN_CENTER = "btn_center";
    private static final String BTN_ZOOMOUT = "btn_zoomout";
    private static final String BTN_ZOOMIN = "btn_zoomin";
    private static final String BTN_PAN = "btn_pan";
    private static final String BTN_SELECT = "btn_select";
    private static final String BTN_WEBLINK = "btn_weblink";
    private static final String BTN_RECT = "btn_rect";
    private static final String BTN_SELRECT = "btn_selrect";
    private static final String BTN_SELPOINT = "btn_selpoint";

    public Carte() {
        this.setBackground(Color.white);
        this.enableEvents(49L);
        this.add(this.pmSelection);
        this.pmSelection.addActionListener(this);
    }

    public void start() {
        this.stopped = false;
        this.startServiceThread();
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        if (this.project == null) {
            return;
        }
        int n = this.project.getLayerCount();
        if (n == 0) {
            return;
        }
        this.timeInterval = timeInterval;
        for (int i = 0; i < n; ++i) {
            Layer layer = this.project.getLayerByIndex(i);
            layer.setTimeInterval(timeInterval);
        }
        this.extentChanged();
        this.broadcastMessage(108, timeInterval);
        this.updateMap();
    }

    public void extentChanged() {
        if (this.projection != null && !this.stopped) {
            this.lastExtent = this.project.maxExtent.isZero() ? new FloatRectangle(0.0, 0.0, 0.0, 0.0) : this.getExtent();
            this.request.setSpatialExtent(this.lastExtent, null);
            this.startServiceThread();
        }
    }

    public void downloadLayer(String string) {
        if (this.projection != null && !this.stopped) {
            this.lastExtent = this.project.maxExtent.isZero() ? new FloatRectangle(0.0, 0.0, 0.0, 0.0) : this.getExtent();
            this.request.setSpatialExtent(this.lastExtent, string);
            this.startServiceThread();
        }
    }

    private synchronized void startServiceThread() {
        if (!this.sthRunning && !this.isKilled) {
            try {
                this.sthRunning = true;
                this.serviceThread = new Thread(this);
                this.serviceThread.setPriority(5);
                this.serviceThread.start();
            }
            catch (Exception exception) {
                this.sthRunning = false;
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (this.proxy != null) {
            if (!this.isProjectLoaded()) {
                int n;
                this.proxy.loadProject();
                boolean bl = this.isProjectLoaded();
                if (bl && this.project.startLayer == null) {
                    this.project.startLayer = ((Layer)this.project.layers.elementAt((int)0)).id;
                }
                int n2 = this.statusListeners.size();
                for (n = 0; n < n2; ++n) {
                    ((StatusListener)this.statusListeners.elementAt(n)).afterProjectLoaded(bl);
                }
                this.host.refreshLayout();
                if (bl) {
                    if (!Strings.isNullOrBlank(this.SLD_url) && this.SLD_styles != null) {
                        if (MapUtils.isSLD_Enabled()) {
                            try {
                                SLD_Loader.setStyleForProject((Project)this.project, (String)this.getRealPath(this.SLD_url), (Vector)this.SLD_styles);
                                this.project.sortRenderersByLevels();
                            }
                            catch (Exception exception) {
                                Log.addMessage(312, this.getName(), null, exception.getMessage());
                            }
                        } else {
                            Log.addMessage(312, this.getName(), null, "SLD loader is not found");
                        }
                    }
                    this.setBackground(this.project.mapBackground);
                    n = this.project.getLayerCount();
                    for (int i = 0; i < n; ++i) {
                        this.project.getLayerByIndex(i).setParentMap(this);
                    }
                    this.moveBeyondProject = this.project.moveBeyondProject;
                    this.projection = new Projection();
                    this.loadedExtent = null;
                    this.stopped = false;
                    if (this.project.maxExtent.isZero()) {
                        this.extentChanged();
                    } else {
                        this.isFirstRequest = false;
                        this.loadedExtent = new FloatRectangle(this.project.maxExtent);
                        this.zoomToDomain(this.project.startExtentName);
                    }
                    this.setActiveLayer(this.project.getLayerById(this.project.startLayer));
                    this.setThematicMap(this.project.startTheme);
                    this.updateMap();
                } else {
                    this.sthRunning = false;
                    return;
                }
            }
            while (!this.request.isClear()) {
                ProxyRequest proxyRequest;
                ProxyRequest proxyRequest2 = this.request;
                synchronized (proxyRequest2) {
                    proxyRequest = this.request.copy();
                    this.request.clear();
                }
                try {
                    this.proxy.handleRequest(proxyRequest);
                    if (this.animationTimer != null || this.project.rendererDynamicCount <= 0 || this.project.animationDelay <= 0) continue;
                    this.animationTimer = new SimpleTimer(this.project.animationDelay, this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.sthRunning = false;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public final boolean isProjectLoaded() {
        return this.project != null && this.project.isLoaded;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.repaintStaticNeeded = true;
        super.setBounds(n, n2, n3, n4);
    }

    public void repaintMap() {
        this.updateMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMap() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.repaintStaticNeeded = true;
            try {
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMap(boolean bl) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paintMap(graphics, bl);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    private void paintRendererLevel(Vector vector, DisplayContext displayContext, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, int n) {
        Layer layer;
        Renderer renderer;
        int n2;
        Vector vector2 = new Vector();
        int n3 = vector.size();
        Vector<Renderer> vector3 = new Vector<Renderer>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                renderer = (Renderer)vector.elementAt(n2);
            }
            catch (Exception exception) {
                return;
            }
            layer = renderer.getLayer();
            if (!renderer.enabled || (this.isKeyMap || !layer.isVisibleNow(displayContext)) && (!this.isKeyMap || !layer.isKeyMap) || !renderer.isRendererVisible(displayContext)) continue;
            RecordsArray recordsArray = null;
            if (!this.isKeyMap) {
                recordsArray = (RecordsArray)hashtable2.get(layer);
            }
            if (recordsArray == null) {
                recordsArray = layer.paintRecords2(renderer, displayContext, n);
                if (recordsArray != null) {
                    hashtable2.put(layer, recordsArray);
                }
            } else if (layer instanceof LayerVector) {
                ((LayerVector)layer).paintRecords3(recordsArray, renderer, false, displayContext, n);
            }
            if (this.isStopPaint(n)) {
                return;
            }
            if (this.activeLayer == null || !this.activeLayer.id.equals(layer.id)) continue;
            vector3.addElement(renderer);
        }
        if (!this.isKeyMap) {
            n3 = vector3.size();
            for (n2 = 0; n2 < n3; ++n2) {
                renderer = (Renderer)vector3.elementAt(n2);
                layer = renderer.getLayer();
                if (!(layer instanceof LayerVector)) continue;
                ((LayerVector)layer).paintRecords3(layer.getSelection(), renderer, true, displayContext, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintMap(Graphics graphics, boolean bl) {
        if (!this.isProjectLoaded()) {
            return;
        }
        Lock lock = this.paintLock;
        synchronized (lock) {
            this.repaintNeeded = true;
            boolean bl2 = this.repaintStaticNeeded = this.repaintStaticNeeded && !bl;
            if (this.dontRedraw) {
                return;
            }
            if (!this.paintLock.tryLock()) {
                return;
            }
        }
        try {
            do {
                Cloneable cloneable;
                this.repaintNeeded = false;
                boolean bl3 = this.repaintStaticNeeded;
                this.repaintStaticNeeded = false;
                int n = this.project.getLayerCount();
                Dimension dimension = this.getSize();
                int n2 = dimension.width;
                int n3 = dimension.height;
                if (n2 < 1) break;
                if (n3 < 1) {
                    break;
                }
                DisplayContextImpl displayContextImpl = new DisplayContextImpl(this, null, this.projection, this.getLastExtent());
                this.usedSpaces.removeAllElements();
                Vector vector = this.project.renderers;
                int n4 = vector.size();
                int n5 = this.project.rendererDynamicCount;
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                Hashtable hashtable3 = new Hashtable();
                Integer n6 = this.pntCounter;
                synchronized (n6) {
                    this.pntCounter = new Integer(this.pntCounter + 1);
                }
                int n7 = this.pntCounter;
                if (this.backImage == null || bl3) {
                    Cloneable cloneable2;
                    this.backImage = this.createImage(n2, n3);
                    displayContextImpl.graphics = this.drawTo = this.backImage.getGraphics();
                    this.lastExtent = this.getExtent();
                    this.drawTo.setColor(this.getBackground());
                    this.drawTo.fillRect(0, 0, n2, n3);
                    for (int i = 0; i < n4 - n5 && i < vector.size(); ++i) {
                        cloneable2 = (Vector)vector.elementAt(i);
                        this.paintRendererLevel((Vector)cloneable2, displayContextImpl, hashtable3, hashtable, hashtable2, n7);
                    }
                    if (this.isKeyMap && this.mainMap != null) {
                        FloatRectangle floatRectangle = this.mainMap.getLastExtent();
                        if (floatRectangle != null) {
                            cloneable2 = this.mapToScreen_(floatRectangle.x, floatRectangle.y2);
                            cloneable = this.mapToScreen_(floatRectangle.x2, floatRectangle.y);
                            if (((Point)cloneable).y - ((Point)cloneable2).y < 6) {
                                n3 = 6;
                                ((Point)cloneable2).y -= 2;
                            } else {
                                n3 = ((Point)cloneable).y - ((Point)cloneable2).y;
                            }
                            if (((Point)cloneable).x - ((Point)cloneable2).x < 6) {
                                n2 = 6;
                                ((Point)cloneable2).x -= 2;
                            } else {
                                n2 = ((Point)cloneable).x - ((Point)cloneable2).x;
                            }
                            this.drawTo.setColor(this.project.keyMapOutline);
                            this.drawTo.drawRect(((Point)cloneable2).x, ((Point)cloneable2).y, n2, n3);
                        }
                    } else if (this.lastRectSelection != null) {
                        Point point = this.mapToScreen_(this.lastRectSelection.x, this.lastRectSelection.y);
                        cloneable2 = this.mapToScreen_(this.lastRectSelection.x2, this.lastRectSelection.y2);
                        this.drawTo.setColor(Color.red);
                        this.drawTo.drawRect(point.x, ((Point)cloneable2).y, ((Point)cloneable2).x - point.x, point.y - ((Point)cloneable2).y);
                    } else if (this.lastPointSelection != null) {
                        Point point = this.mapToScreen(this.lastPointSelection);
                        this.drawTo.setColor(Color.red);
                        this.drawTo.drawOval(point.x - 3, point.y - 3, 6, 6);
                    }
                    this.drawTo.dispose();
                }
                Image image = this.createImage(dimension.width, dimension.height);
                this.drawTo = image.getGraphics();
                if (this.backImage != null) {
                    this.drawTo.drawImage(this.backImage, 0, 0, null);
                }
                displayContextImpl.graphics = this.drawTo;
                for (int i = n4 - n5; i < n4; ++i) {
                    cloneable = (Vector)vector.elementAt(i);
                    this.paintRendererLevel((Vector)cloneable, displayContextImpl, hashtable3, hashtable, hashtable2, n7);
                }
                if (!this.isKeyMap && !this.isKilled) {
                    this.drawTo.setFont(MapUtils.defaultPlainFont);
                    String string = "v0.99y9";
                    int n8 = n2 - graphics.getFontMetrics().stringWidth(string);
                    this.drawTo.setColor(Color.white);
                    this.drawTo.drawString(string, n8 + 1, n3 - 5);
                    this.drawTo.setColor(Color.black);
                    this.drawTo.drawString(string, n8, n3 - 6);
                }
                this.drawTo.dispose();
                graphics.drawImage(image, 0, 0, null);
                image.flush();
            } while (this.repaintNeeded);
        }
        finally {
            this.paintLock.unlock();
        }
        if (this.gcEach_10_paints > 10) {
            System.gc();
            this.gcEach_10_paints = 0;
            Utils.showMemoryUsage();
        }
        ++this.gcEach_10_paints;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        if (dimension.width > 0 && dimension.height > 0) {
            int n;
            boolean bl = true;
            boolean bl2 = true;
            int n2 = this.project != null ? this.project.getLayerCount() : 0;
            for (n = 0; n < n2; ++n) {
                Layer layer = this.project.getLayerByIndex(n);
                if (layer.isVisible()) {
                    bl2 = false;
                }
                if (layer.isEmpty()) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (!this.isKeyMap) {
                    String string = this.getResource(bl2 ? "Switch on layers to view map" : "Wait please...");
                    graphics.setColor(Color.white);
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                    graphics.setFont(waitFont);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, dimension.width / 2 - graphics.getFontMetrics().stringWidth(string) / 2, dimension.height / 2 + 12);
                }
            } else {
                this.paintMap(graphics, false);
            }
            if (graphics != null && !this.isKeyMap && !this.isKilled) {
                n = this.mapListeners.size();
                for (int i = 0; i < n; ++i) {
                    ((CarteListener)this.mapListeners.elementAt(i)).afterMapDraw(graphics);
                }
            }
        }
    }

    public FloatPoint screenToMap(Point point) {
        if (this.projection == null || this.projection.zoom <= 0.0) {
            return null;
        }
        return new FloatPoint((double)point.x / this.projection.zoom - this.projection.shift.x, -((double)point.y / this.projection.zoom - this.projection.shift.y));
    }

    public Point mapToScreen(FloatPoint floatPoint) {
        if (this.projection == null) {
            return null;
        }
        return new Point((int)((floatPoint.x + this.projection.shift.x) * this.projection.zoom), (int)((-floatPoint.y + this.projection.shift.y) * this.projection.zoom));
    }

    public Point mapToScreen_(double d, double d2) {
        if (this.projection == null) {
            return null;
        }
        return new Point((int)((d + this.projection.shift.x) * this.projection.zoom), (int)((-d2 + this.projection.shift.y) * this.projection.zoom));
    }

    public void zoomToLayer(Layer layer) {
        if (layer != null) {
            FloatRectangle floatRectangle;
            FloatRectangle floatRectangle2 = floatRectangle = layer.isLoadComplete() && layer.getLayerExtent() != null ? layer.getLayerExtent() : layer.metadata.maxExtent;
            if (floatRectangle != null && !floatRectangle.isZero()) {
                this.zoomToExtent(floatRectangle);
                this.broadcastMessage(100, layer.getName());
                this.updateMap();
            }
        }
    }

    public Layer getLayer(String string) {
        Layer layer = this.project.getLayerById(string);
        if (layer == null) {
            layer = this.project.getLayerByName(string);
        }
        return layer;
    }

    public void setExtent(FloatRectangle floatRectangle, FloatPoint floatPoint) {
        this.setExtent(floatRectangle, floatPoint, null);
        this.storeExtent();
    }

    private void setExtent(FloatRectangle floatRectangle, FloatPoint floatPoint, FloatPoint floatPoint2) {
        boolean bl = this.calcProjection(floatRectangle, floatPoint, floatPoint2);
        this.extentChanged();
        if (bl) {
            this.broadcastMessage(109, new Float(this.getDistance(this.getExtent())));
        }
        if (!this.isKeyMap && !Strings.isNullOrBlank(this.sDependent_Maps)) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.sDependent_Maps, " ,;");
            ++this.ext_changing;
            while (stringTokenizer.hasMoreTokens()) {
                Carte carte = this.host.getMapByName(stringTokenizer.nextToken());
                if (carte == null) continue;
                carte.setExtentDependent(this.getExtent(), this.ext_changing);
            }
        }
    }

    void setExtentDependent(FloatRectangle floatRectangle, long l) {
        if (this.ext_changing != l) {
            this.setExtent(floatRectangle, null);
            this.updateMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcProjection(FloatRectangle floatRectangle, FloatPoint floatPoint, FloatPoint floatPoint2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        if (this.projection != null) {
            d8 = this.projection.shift.x;
            d7 = this.projection.shift.y;
            d6 = this.projection.zoom;
            d5 = this.projection.minzoom;
            d4 = this.projection.maxzoom;
            d3 = d6;
        } else {
            d8 = 0.0;
            d7 = 0.0;
            d6 = 1.0;
            d5 = 1.0;
            d4 = 1.0;
            d3 = -1.0;
        }
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        boolean bl = true;
        boolean bl2 = true;
        if (floatPoint2 != null) {
            if (this.projection == null) {
                return false;
            }
            d8 = floatPoint2.x;
            d7 = -floatPoint2.y;
            floatRectangle = new FloatRectangle(-d8, d7 - (double)n2 / d6, (double)n / d6 - d8, d7);
        } else if (floatRectangle == null) {
            if (this.projection == null || floatPoint == null) {
                return false;
            }
            d2 = (double)n / d6 / 2.0;
            d = (double)n2 / d6 / 2.0;
            floatRectangle = new FloatRectangle(floatPoint.x - d2, floatPoint.y - d, floatPoint.x + d2, floatPoint.y + d);
        } else {
            if (this.project.maxExtent == null || this.project.maxExtent.isZero()) {
                if (this.loadedExtent == null) {
                    return false;
                }
                this.project.maxExtent = new FloatRectangle(this.loadedExtent);
            }
            if (this.project.MapUnits == -1) {
                int n3 = this.project.MapUnits = Math.abs(this.project.maxExtent.x2) < 361.0 && Math.abs(this.project.maxExtent.x) < 361.0 && Math.abs(this.project.maxExtent.y) < 140.0 && Math.abs(this.project.maxExtent.y2) < 140.0 ? 0 : 1;
            }
            if (this.project.zmax < 0.0) {
                d2 = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x);
                d = Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y);
                this.project.zmax = d > d2 && d2 > 0.0 ? this.getDistance(this.project.maxExtent.scale(d / d2)) : this.getDistance(this.project.maxExtent);
            }
            if (this.project.zmin < 1.0E-4) {
                this.project.zmin = this.getDistance(this.project.maxExtent) / 600.0;
            }
            d2 = Math.abs(floatRectangle.x2 - floatRectangle.x);
            d = Math.abs(floatRectangle.y2 - floatRectangle.y);
            double d9 = MapUtils.toMapUnits(this.project.zmax, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
            double d10 = MapUtils.toMapUnits(this.project.zmin, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
            d5 = (double)n / d10;
            d4 = (double)n / d9;
            if (this.project.zmax > 0.0 && d2 > d9) {
                d6 = d4;
            } else if (this.project.zmin > 0.0 && d2 < d10) {
                d6 = d5;
            } else {
                d9 = d2 > Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x) ? Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x) : d2;
                d10 = d > Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y) ? Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y) : d;
                d9 = (double)n / d9;
                d10 = (double)n2 / d10;
                double d11 = d6 = d9 > d10 ? d10 : d9;
            }
            if (floatPoint != null) {
                floatRectangle.x = floatPoint.x - (d2 /= 2.0);
                floatRectangle.y = floatPoint.y - (d /= 2.0);
                floatRectangle.x2 = floatPoint.x + d2;
                floatRectangle.y2 = floatPoint.y + d;
            }
        }
        if (!this.moveBeyondProject && !this.project.maxExtent.isZero()) {
            double d12 = this.project.maxExtent.x;
            double d13 = this.project.maxExtent.y;
            double d14 = this.project.maxExtent.x2;
            double d15 = this.project.maxExtent.y2;
            double d16 = d14 - d12;
            double d17 = d15 - d13;
            d2 = floatRectangle.x2 - floatRectangle.x;
            d = floatRectangle.y2 - floatRectangle.y;
            if (d16 < d2) {
                floatRectangle.x = (d12 + d14 - d2) / 2.0;
                floatRectangle.x2 = floatRectangle.x + d2;
            } else if (floatRectangle.x < d12) {
                floatRectangle.x = d12;
                floatRectangle.x2 = d12 + d2;
            } else if (floatRectangle.x2 > d14) {
                floatRectangle.x2 = d14;
                floatRectangle.x = d14 - d2;
            } else {
                bl = false;
            }
            if (d17 < d) {
                floatRectangle.y = (d13 + d15 - d) / 2.0;
                floatRectangle.y2 = floatRectangle.y + d;
            } else if (floatRectangle.y < d13) {
                floatRectangle.y = d13;
                floatRectangle.y2 = d13 + d;
            } else if (floatRectangle.y2 > d15) {
                floatRectangle.y2 = d15;
                floatRectangle.y = d15 - d;
            } else {
                bl2 = false;
            }
        }
        if (floatPoint2 == null || bl) {
            d8 = ((double)n / d6 - (floatRectangle.x2 - floatRectangle.x)) / 2.0 - floatRectangle.x;
        }
        if (floatPoint2 == null || bl2) {
            d7 = floatRectangle.y2 + ((double)n2 / d6 - (floatRectangle.y2 - floatRectangle.y)) / 2.0;
        }
        if (this.projection == null) {
            this.projection = new Projection();
        }
        Projection projection = this.projection;
        synchronized (projection) {
            this.projection.zoom = d6;
            this.projection.shift.x = d8;
            this.projection.shift.y = d7;
            this.projection.minzoom = d5;
            this.projection.maxzoom = d4;
        }
        return d6 != d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtent(FloatRectangle floatRectangle) {
        if (floatRectangle != null) {
            if (this.loadedExtent == null || this.loadedExtent.isZero()) {
                this.loadedExtent = floatRectangle;
            } else {
                FloatRectangle floatRectangle2 = this.loadedExtent;
                synchronized (floatRectangle2) {
                    this.loadedExtent.union(floatRectangle);
                }
            }
        }
    }

    private void drawSelectRect(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.mouseDownPoint.x > this.currentPoint.x) {
            n4 = this.currentPoint.x;
            n3 = this.mouseDownPoint.x;
        } else {
            n3 = this.currentPoint.x;
            n4 = this.mouseDownPoint.x;
        }
        if (this.mouseDownPoint.y > this.currentPoint.y) {
            n2 = this.currentPoint.y;
            n = this.mouseDownPoint.y;
        } else {
            n = this.currentPoint.y;
            n2 = this.mouseDownPoint.y;
        }
        graphics.drawRect(n4, n2, n3 - n4 + 1, n - n2 + 1);
    }

    public void zoomToExtent(FloatRectangle floatRectangle) {
        if (floatRectangle == null || floatRectangle.isZero()) {
            this.zoomToFullExtent();
        } else {
            this.setExtent(floatRectangle, null);
        }
    }

    public synchronized void zoomToFullExtent() {
        if (this.loadedExtent != null) {
            this.setExtent(this.loadedExtent, null);
        }
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public void setActiveLayer(Layer layer) {
        if (!(layer == null || this.activeLayer == layer && layer.isPassResolved())) {
            this.clearSelection();
            this.activeLayer = layer;
            String string = this.activeLayer == null ? "" : this.activeLayer.getName();
            this.broadcastMessage(107, string);
        }
    }

    public void clearSelection() {
        int n = this.project.getLayerCount();
        for (int i = 0; i < n; ++i) {
            this.project.getLayerByIndex(i).setSelection(null);
        }
    }

    public void setThematicMap(String string) {
        if (string == null || this.project == null || this.project.themes == null) {
            return;
        }
        String string2 = (String)this.project.themes.get(string);
        if (string2 != null) {
            this.thematicMap = string2;
            this.extentChanged();
            Layer layer = this.project.getLayerById((String)this.project.themesLayer.get(string));
            this.setActiveLayer(layer);
        } else if (this.thematicMap == null && this.project.themesNames != null) {
            this.thematicMap = (String)this.project.themes.get(this.project.themesNames);
        }
        if (this.thematicMap != null) {
            this.broadcastMessage(106, string);
        }
    }

    public void zoomToDomain(String string) {
        if (string == null || this.project == null || this.project.domains == null) {
            return;
        }
        try {
            Domain domain = (Domain)this.project.domains.get(string);
            this.zoomToExtent(domain.ext);
            Layer layer = this.project.getLayerById(domain.layerId);
            this.setActiveLayer(layer);
            this.broadcastMessage(102, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte getTool() {
        return this.currentTool;
    }

    public void setTool(byte by) {
        this.currentTool = by;
        this.setCursor(by);
        this.broadcastMessage(112, new Byte(by));
    }

    public static String getToolName(byte by) {
        String string = null;
        switch (by) {
            case 1: {
                string = BTN_CENTER;
                break;
            }
            case 2: {
                string = BTN_ZOOMIN;
                break;
            }
            case 3: {
                string = BTN_ZOOMOUT;
                break;
            }
            case 4: {
                string = BTN_PAN;
                break;
            }
            case 5: {
                string = BTN_SELECT;
                break;
            }
            case 6: {
                string = BTN_WEBLINK;
                break;
            }
            case 7: {
                string = BTN_RECT;
                break;
            }
            case 8: {
                string = BTN_SELRECT;
                break;
            }
            case 9: {
                string = BTN_SELPOINT;
            }
        }
        return string;
    }

    public static byte getToolCode(String string) {
        int n = 0;
        if (string.equalsIgnoreCase(BTN_CENTER)) {
            n = 1;
        } else if (string.equalsIgnoreCase(BTN_ZOOMIN)) {
            n = 2;
        } else if (string.equalsIgnoreCase(BTN_ZOOMOUT)) {
            n = 3;
        } else if (string.equalsIgnoreCase(BTN_PAN)) {
            n = 4;
        } else if (string.equalsIgnoreCase(BTN_SELECT)) {
            n = 5;
        } else if (string.equalsIgnoreCase(BTN_WEBLINK)) {
            n = 6;
        } else if (string.equalsIgnoreCase(BTN_RECT)) {
            n = 7;
        } else if (string.equalsIgnoreCase(BTN_SELRECT)) {
            n = 8;
        } else if (string.equalsIgnoreCase(BTN_SELPOINT)) {
            n = 9;
        }
        return (byte)n;
    }

    void setCursor(int n) {
        Cursor cursor;
        if (this.customCursors != null && (cursor = (Cursor)this.customCursors.get(String.valueOf(n))) != null) {
            this.setCursor(cursor);
            return;
        }
        switch (n) {
            case 2: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        switch (n) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        switch (n) {
            case 503: {
                this.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n = componentEvent.getID();
        switch (n) {
            case 101: {
                this.componentResized(componentEvent);
            }
        }
    }

    public void centerAt(double d, double d2) {
        if (this.project != null && this.projection != null && this.project.maxExtent != null) {
            double d3 = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x);
            double d4 = d3 / 10.0;
            FloatRectangle floatRectangle = new FloatRectangle(d - d4, d2 - d4, d + d4, d2 + d4);
            this.setExtent(floatRectangle, null);
            this.updateMap();
        }
    }

    public void selectObject(Layer layer, Record record) {
        if (record != null) {
            RecordsArray recordsArray = new RecordsArray(layer.dataStorage);
            recordsArray.addRecord(record);
            this.selectObjects(layer, recordsArray);
        }
    }

    public void selectObjectByExpr(Layer layer, String string) {
        if (layer instanceof LayerVector) {
            try {
                RecordsArray recordsArray = ((LayerVector)layer).findByExpression(string);
                if (MapUtils.isNotEmptyRecs(recordsArray)) {
                    System.out.print(".");
                    this.selectObjects(layer, recordsArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void selectObjects(Layer layer, RecordsArray recordsArray) {
        if (layer instanceof LayerVector && MapUtils.isNotEmptyRecs(recordsArray)) {
            int n;
            Object object;
            LayerVector layerVector = (LayerVector)layer;
            int n2 = recordsArray.size();
            layerVector.setSelection(recordsArray);
            FloatRectangle floatRectangle = recordsArray.getExtent();
            Record record = recordsArray.getRecord(0);
            if (floatRectangle.x2 == floatRectangle.x) {
                object = this.getLastExtent();
                double d = Math.abs(((FloatRectangle)object).x2 - ((FloatRectangle)object).x) / 100.0;
                floatRectangle.x2 += d;
                floatRectangle.x -= d;
            }
            if (layerVector.zoom_for_select == 0.0f) {
                this.setExtent(null, new FloatPoint(floatRectangle.x + (floatRectangle.x2 - floatRectangle.x) / 2.0, floatRectangle.y + (floatRectangle.y2 - floatRectangle.y) / 2.0));
            } else if (layerVector.zoom_for_select > 0.0f && layerVector.zoom_for_select <= 1.0f) {
                this.setExtent(this.project.maxExtent.scale(layerVector.zoom_for_select), new FloatPoint(floatRectangle.x + (floatRectangle.x2 - floatRectangle.x) / 2.0, floatRectangle.y + (floatRectangle.y2 - floatRectangle.y) / 2.0));
            } else {
                double d;
                if (layerVector.zoom_for_select > 1.0f) {
                    d = MapUtils.toMapUnits(layerVector.zoom_for_select, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
                    floatRectangle = floatRectangle.scale((d + d / 100.0) / Math.abs(floatRectangle.x2 - floatRectangle.x));
                } else {
                    double d2;
                    double d3;
                    double d4 = MapUtils.toMapUnits(this.project.zmin, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
                    d4 = d4 < (d3 = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x)) / 10.0 ? d3 / 10.0 : (d4 *= 3.0);
                    if (n2 == 1 && layerVector.isObjectType(1)) {
                        object = record.getRecordExtent();
                        FloatPoint floatPoint = ((FloatRectangle)object).getCentre();
                        floatRectangle = new FloatRectangle(floatPoint.x - d4, floatPoint.y - d4, floatPoint.x + d4, floatPoint.y + d4);
                    } else {
                        floatRectangle = floatRectangle.scale(2.0);
                    }
                    d = d3;
                    if (layerVector.withinZoom) {
                        double d5;
                        if (layerVector.zmin > 0.0f && d4 < (d5 = MapUtils.toMapUnits(layerVector.zmin, floatRectangle, this.project.MapUnits, this.project.ZoomUnits))) {
                            d4 = d5;
                        }
                        if (layerVector.zmax > 0.0f) {
                            d = MapUtils.toMapUnits(layerVector.zmax, floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
                        }
                    }
                    if ((d2 = Math.abs(floatRectangle.x2 - floatRectangle.x)) > d) {
                        floatRectangle = floatRectangle.scale(d / d2);
                    }
                    if (d2 < d4) {
                        floatRectangle = floatRectangle.scale((d4 + d4 / 100.0) / d2);
                    }
                }
                floatRectangle.y += (floatRectangle.y2 - floatRectangle.y) / 2.0;
                floatRectangle.y2 = floatRectangle.y;
                this.setExtent(floatRectangle, null);
            }
            object = " [" + layerVector.getName() + ']';
            if (n2 == 1) {
                object = (layerVector.fi_description >= 0 && layerVector.fi_description < layerVector.getFieldCount() ? layerVector.getFieldString(record, layerVector.fi_description) : layerVector.getId(record)) + (String)object;
                n = 103;
            } else {
                object = n2 + (String)object;
                n = 104;
            }
            this.activeLayer = layerVector;
            this.broadcastMessage(n, object);
            this.updateMap();
        }
    }

    public void selectObjectsById(String string, String string2) {
        try {
            Layer layer = this.project.getLayerByName(string);
            if (layer == null && (layer = this.project.getLayerById(string)) == null) {
                layer = this.project.getLayerByDsId(string);
            }
            if (layer != null && layer instanceof LayerVector) {
                RecordsArray recordsArray = ((LayerVector)layer).findByIds(string2);
                if (MapUtils.isNotEmptyRecs(recordsArray)) {
                    this.selectObjects(layer, recordsArray);
                } else {
                    recordsArray = null;
                    this.request.setQuery(2, layer.id, string2);
                    this.startServiceThread();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FloatRectangle getFullExtent() {
        return new FloatRectangle(this.loadedExtent);
    }

    synchronized void storeExtent() {
        int n;
        for (n = 0; n < this.undoIndex; ++n) {
            this.recentExtents.removeElementAt(0);
        }
        this.recentExtents.insertElementAt(this.getExtent(), 0);
        n = this.recentExtents.size();
        if (n > 20) {
            this.recentExtents.removeElementAt(n - 1);
        }
        this.undoIndex = 0;
    }

    public void undoExtent() {
        if (this.doUndoExtent()) {
            this.updateMap();
        }
    }

    public void redoExtent() {
        if (this.doRedoExtent()) {
            this.updateMap();
        }
    }

    synchronized boolean doUndoExtent() {
        if (this.undoIndex < this.recentExtents.size() - 1) {
            this.setExtent((FloatRectangle)this.recentExtents.elementAt(++this.undoIndex), null, null);
            return true;
        }
        return false;
    }

    synchronized boolean doRedoExtent() {
        if (this.undoIndex > 0) {
            this.setExtent((FloatRectangle)this.recentExtents.elementAt(--this.undoIndex), null, null);
            return true;
        }
        return false;
    }

    public void showAttribForSelection(String string, int n, FloatRectangle floatRectangle) {
        Layer layer;
        if (!this.isProjectLoaded()) {
            return;
        }
        Layer layer2 = layer = string == null ? this.getActiveLayer() : this.project.getLayerById(string);
        if (layer != null && MapUtils.isNotEmptyRecs(layer.getSelection())) {
            this.request.clear();
            this.request.setSpatialExtent(floatRectangle, null);
            this.request.setQuery(n, layer.id, null);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public void executeRequest(int n) {
        if (!this.stopped) {
            this.request.setQuery(33, null, String.valueOf(n));
            this.startServiceThread();
        }
    }

    public void searchAttribute(String string, String string2, int n) {
        if ((n == 1 || n == 2 || n == 3 || n == 4) && string2 != null && string2.length() > 0 && this.isProjectLoaded()) {
            if (string == null) {
                string = this.activeLayer.id;
            }
            Layer layer = this.project.getLayerById(string);
            if (n == 2 && string2 != null && !layer.isGeocoding) {
                string2 = '%' + string2 + '%';
            }
            int n2 = n == 3 ? 34 : (n == 4 ? 35 : 32);
            if (layer.metadata.loadOnSearchRequestOnly) {
                layer.clear(false);
            }
            this.request.clear();
            this.request.setQuery(n2, string, string2);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public void searchRectangle(FloatRectangle floatRectangle) {
        if (this.activeLayer != null) {
            this.request.clear();
            this.request.setSpatialExtent(floatRectangle, null);
            this.request.setQuery(31, this.activeLayer.id, null);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public CarteHost getCarteHost() {
        return this.host;
    }

    public void showURL(String string) {
        if (string != null && string.length() > 0) {
            this.host.showURL(string, "");
        }
    }

    public FloatRectangle getExtent() {
        if (this.projection == null) {
            return null;
        }
        FloatRectangle floatRectangle = new FloatRectangle();
        FloatPoint floatPoint = this.screenToMap(new Point(0, 0));
        if (floatPoint == null) {
            return null;
        }
        floatRectangle.x = floatPoint.x;
        floatRectangle.y2 = floatPoint.y;
        Dimension dimension = this.getSize();
        floatPoint = this.screenToMap(new Point(dimension.width - 1, dimension.height - 1));
        floatRectangle.x2 = floatPoint.x;
        floatRectangle.y = floatPoint.y;
        return floatRectangle;
    }

    public void requestSelection(FloatRectangle floatRectangle) {
        this.pmSelection.removeAll();
        String string = null;
        int n = this.project.getLayerCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Layer layer = this.project.getLayerByIndex(i);
            RecordsArray recordsArray = layer.getSelection();
            int n3 = n2 = recordsArray == null || layer instanceof LayerRaster && layer.linkMain == null ? 0 : recordsArray.size();
            if (n2 <= 0) continue;
            MenuItem menuItem = new MenuItem(layer.getName() + " [" + n2 + ']', null);
            menuItem.setActionCommand(layer.id);
            this.pmSelection.add(menuItem);
            string = layer.id;
        }
        if (this.pmSelection.getItemCount() > 1) {
            Point point = null != floatRectangle ? this.mapToScreen(new FloatPoint(floatRectangle.x2, floatRectangle.y)) : new Point(this.getBounds().width / 2, this.getBounds().height / 2);
            this.pmSelection.show(this, point.x, point.y);
        } else if (this.pmSelection.getItemCount() == 1) {
            this.showAttribForSelection(string, this.defaultAttributeReqType, floatRectangle);
        }
    }

    void mouseMoved(MouseEvent mouseEvent) {
        if (this.isKilled) {
            return;
        }
        int n = this.mapListeners.size();
        for (int i = 0; i < n; ++i) {
            ((CarteListener)this.mapListeners.elementAt(i)).mouseMapMoved(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void mouseDragged(MouseEvent mouseEvent) {
        if (this.loadedExtent == null || this.projection == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) return;
        try {
            switch (this.currentTool) {
                case 4: {
                    if (this.mouseDownPoint == null) return;
                    Point point = mouseEvent.getPoint();
                    int n = point.x - this.mouseDownPoint.x;
                    int n2 = point.y - this.mouseDownPoint.y;
                    Dimension dimension = this.getSize();
                    int n3 = dimension.width;
                    int n4 = dimension.height;
                    graphics.setColor(this.getBackground());
                    if (n > 0) {
                        graphics.fillRect(0, 0, n, n4);
                    } else if (n < 0) {
                        graphics.fillRect(n3 + n, 0, -n, n4);
                    }
                    if (n2 > 0) {
                        graphics.fillRect(0, 0, n3, n2);
                    } else if (n2 < 0) {
                        graphics.fillRect(0, n4 + n2, n3, -n2);
                    }
                    graphics.drawImage(this.backImage, n, n2, null);
                    return;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.mouseDownPoint == null) return;
                    graphics.setColor(Color.black);
                    graphics.setXORMode(Color.white);
                    this.drawSelectRect(graphics);
                    this.currentPoint = mouseEvent.getPoint();
                    this.drawSelectRect(graphics);
                    graphics.setXORMode(Color.black);
                    return;
                }
                default: {
                    int n = this.mapListeners.size();
                    for (int i = 0; i < n; ++i) {
                        ((CarteListener)this.mapListeners.elementAt(i)).mouseMapMoved(mouseEvent);
                    }
                    return;
                }
            }
        }
        finally {
            graphics.dispose();
            graphics = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.lastSelectExt = null;
        if (this.projection == null || this.isKilled) {
            return;
        }
        if (this.loadedExtent == null) {
            this.dontRedraw = false;
            return;
        }
        if (this.getTool() < 50) {
            n = mouseEvent.getModifiers();
            this.alterTool = this.getTool();
            if ((n & 4) != 0 || (n & 8) != 0) {
                if ((n & 1) != 0) {
                    this.setTool((byte)3);
                } else {
                    this.setTool((byte)4);
                }
            } else if ((n & 0x10) != 0) {
                if ((n & 1) != 0) {
                    this.setTool((byte)2);
                } else if ((n & 2) != 0) {
                    this.setTool((byte)6);
                }
            }
        }
        n = this.mapListeners.size();
        for (int i = 0; i < n; ++i) {
            ((CarteListener)this.mapListeners.elementAt(i)).mouseMapPressed(mouseEvent);
        }
        this.mouseDownPoint = mouseEvent.getPoint();
        this.currentPoint = new Point(this.mouseDownPoint);
        switch (this.currentTool) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.lastPointSelection = null;
                this.lastRectSelection = null;
            }
            case 2: {
                this.dontRedraw = true;
                Graphics graphics = this.getGraphics();
                if (graphics == null) break;
                try {
                    graphics.setXORMode(Color.white);
                    this.drawSelectRect(graphics);
                    graphics.setXORMode(Color.black);
                    break;
                }
                finally {
                    graphics.dispose();
                }
            }
            case 4: {
                if (this.backImage == null) {
                    Dimension dimension = this.getSize();
                    this.backImage = this.createImage(dimension.width, dimension.height);
                    Graphics graphics = this.backImage.getGraphics();
                    try {
                        this.paint(graphics);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
                this.dontRedraw = true;
                break;
            }
            case 1: {
                FloatPoint floatPoint = this.screenToMap(mouseEvent.getPoint());
                this.setExtent(null, floatPoint);
                this.updateMap();
                break;
            }
            case 3: {
                FloatPoint floatPoint = this.screenToMap(mouseEvent.getPoint());
                this.setExtent(this.getExtent().scale(2.0), floatPoint);
                this.updateMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mouseReleased(MouseEvent mouseEvent) {
        FloatPoint floatPoint;
        Serializable serializable;
        if (this.projection == null || this.isKilled) {
            return;
        }
        FloatRectangle floatRectangle = null;
        this.dontRedraw = false;
        if (this.loadedExtent != null && this.mouseDownPoint != null) {
            Object object;
            double d;
            double d2;
            double d3;
            double d4;
            boolean bl;
            floatRectangle = new FloatRectangle();
            this.currentPoint = mouseEvent.getPoint();
            if (this.currentTool == 9 || Math.abs(this.mouseDownPoint.x - this.currentPoint.x) < 6 && Math.abs(this.mouseDownPoint.y - this.currentPoint.y) < 6) {
                bl = true;
                this.currentPoint = new Point(this.currentPoint.x + 3, this.currentPoint.y + 3);
                this.mouseDownPoint = new Point(this.currentPoint.x - 3, this.currentPoint.y - 3);
            } else {
                bl = false;
            }
            serializable = this.screenToMap(this.mouseDownPoint);
            floatPoint = this.screenToMap(this.currentPoint);
            if (serializable.x < floatPoint.x) {
                d4 = serializable.x;
                d3 = floatPoint.x;
            } else {
                d4 = floatPoint.x;
                d3 = serializable.x;
            }
            if (serializable.y < floatPoint.y) {
                d2 = serializable.y;
                d = floatPoint.y;
            } else {
                d2 = floatPoint.y;
                d = serializable.y;
            }
            floatRectangle.x = d4;
            floatRectangle.y = d2;
            floatRectangle.x2 = d3;
            floatRectangle.y2 = d;
            if (this.currentTool == 4) {
                object = mouseEvent.getPoint();
                int n = ((Point)object).x - this.mouseDownPoint.x;
                int n2 = ((Point)object).y - this.mouseDownPoint.y;
                if (n != 0 || n2 != 0) {
                    FloatPoint floatPoint2 = this.screenToMap(new Point(-n, -n2));
                    floatPoint2.x = -floatPoint2.x;
                    floatPoint2.y = -floatPoint2.y;
                    this.setExtent(null, null, floatPoint2);
                    this.storeExtent();
                    this.updateMap();
                }
            } else if (this.currentTool != 3 && this.currentTool != 1 && this.currentTool < 50) {
                object = this.getGraphics();
                if (object != null) {
                    try {
                        ((Graphics)object).setColor(Color.black);
                        ((Graphics)object).setXORMode(Color.white);
                        this.drawSelectRect((Graphics)object);
                        ((Graphics)object).setXORMode(Color.black);
                    }
                    finally {
                        ((Graphics)object).dispose();
                    }
                }
                switch (this.currentTool) {
                    case 8: 
                    case 9: {
                        if (bl || this.currentTool == 9) {
                            this.lastPointSelection = this.screenToMap(mouseEvent.getPoint());
                            this.lastRectSelection = null;
                            break;
                        }
                        this.lastRectSelection = floatRectangle;
                        this.lastPointSelection = null;
                        this.updateMap();
                        break;
                    }
                    case 2: {
                        if (!bl) {
                            this.setExtent(floatRectangle, null);
                        } else {
                            FloatPoint floatPoint3 = this.screenToMap(this.mouseDownPoint);
                            this.setExtent(this.getExtent().scale(0.5), floatPoint3);
                        }
                        this.updateMap();
                        break;
                    }
                    case 7: {
                        this.searchRectangle(floatRectangle);
                        break;
                    }
                    case 5: 
                    case 6: {
                        Object object2;
                        int n;
                        floatRectangle = floatRectangle.intersection(this.getExtent());
                        int n3 = mouseEvent.getModifiers();
                        if ((n3 & 2) == 0) {
                            this.clearSelection();
                        }
                        Layer layer = null;
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        String string = null;
                        int n7 = this.project.getLayerCount();
                        this.lastSelectExt = floatRectangle;
                        for (n = 0; n < n7; ++n) {
                            layer = this.project.getLayerByIndex(n);
                            if (!layer.isVisibleNow(this) || !layer.canSearch || !layer.canSelectByMouse) continue;
                            object2 = bl && layer.hotSpot != null && layer.isObjectType(1) && layer instanceof LayerVector ? ((LayerVector)layer).findWithinScreenRect(this.mouseDownPoint, false) : layer.findWithinRect(floatRectangle, false);
                            layer.setSelection((RecordsArray)object2);
                            if (!MapUtils.isNotEmptyRecs((RecordsArray)object2)) continue;
                            n4 = ((RecordsArray)object2).size();
                            ++n6;
                            string = layer.id;
                            if (this.activeLayer != layer) continue;
                            n5 = n4;
                        }
                        n = 14;
                        object2 = "";
                        if (n5 > 0) {
                            object2 = " [" + this.activeLayer.getName() + ']';
                            if (n5 == 1) {
                                Record record = this.activeLayer.getSelection().getRecord(0);
                                object2 = (String)object2 + this.activeLayer.getFieldString(record, this.activeLayer.fi_description);
                                n = 103;
                            } else {
                                n = 104;
                                object2 = n5 + (String)object2;
                            }
                        }
                        this.broadcastMessage(n, object2);
                        this.updateMap();
                        if (this.currentTool == 5 && this.isShowAttributeAfterSelection) {
                            this.showAttribForSelection(null, 30, floatRectangle);
                            break;
                        }
                        if (this.currentTool != 6) break;
                        if (this.isMultiLayerSelectionMode && n6 == 1) {
                            this.showAttribForSelection(string, this.defaultAttributeReqType, floatRectangle);
                            break;
                        }
                        if (!this.isMultiLayerSelectionMode && n5 > 0) {
                            this.showAttribForSelection(this.activeLayer.id, this.defaultAttributeReqType, floatRectangle);
                            break;
                        }
                        if (!this.isMultiLayerSelectionMode) break;
                        this.requestSelection(floatRectangle);
                    }
                }
            }
        }
        if (this.currentTool < 50) {
            this.setTool(this.alterTool);
        }
        if (this.isKeyMap && floatRectangle != null && this.mainMap != null) {
            Point point = this.mapToScreen(new FloatPoint(floatRectangle.x, floatRectangle.y2));
            serializable = this.mapToScreen(new FloatPoint(floatRectangle.x2, floatRectangle.y));
            if (point != null && serializable != null) {
                if (((Point)serializable).y - point.y < 6 || ((Point)serializable).x - point.x < 6) {
                    floatPoint = new FloatPoint(floatRectangle.x, floatRectangle.y2);
                    this.mainMap.setExtent(this.mainMap.getExtent(), floatPoint);
                } else {
                    this.mainMap.setExtent(floatRectangle, null);
                }
                this.mainMap.updateMap();
            }
        }
        int n = this.mapListeners.size();
        for (int i = 0; i < n; ++i) {
            ((CarteListener)this.mapListeners.elementAt(i)).mouseMapReleased(floatRectangle, mouseEvent);
        }
        this.mouseDownPoint = null;
        this.currentPoint = null;
    }

    public String getResource(String string) {
        String string2 = this.getResource_(string);
        return Strings.isNullOrBlank(string2) ? string : string2;
    }

    public String getResource_(String string) {
        if (this.stringResources == null || string == null) {
            return "";
        }
        String string2 = this.stringResources.getProperty(string.toLowerCase());
        return string2 == null ? "" : string2;
    }

    void componentResized(ComponentEvent componentEvent) {
        if (this.projection == null) {
            return;
        }
        if (this.lastExtent != null) {
            this.setExtent(this.lastExtent, null);
        } else {
            this.extentChanged();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public String getThematicMapName() {
        if (this.project != null) {
            Enumeration enumeration = this.project.themes.keys();
            Enumeration enumeration2 = this.project.themes.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!((String)enumeration2.nextElement()).equals(this.thematicMap)) continue;
                return string;
            }
        }
        return "";
    }

    public void setDrawToGraphics(Graphics graphics) {
        this.drawTo = graphics;
    }

    public Graphics getDrawToGraphics() {
        return this.drawTo;
    }

    public String getThematicMap() {
        return this.thematicMap;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public FloatRectangle getLastExtent() {
        return this.lastExtent;
    }

    public Vector getUsedSpaces() {
        return this.usedSpaces;
    }

    public double getDistance(FloatRectangle floatRectangle) {
        if (floatRectangle == null) {
            floatRectangle = this.getExtent();
        }
        return MapUtils.getDistance(floatRectangle, this.project.MapUnits, this.project.ZoomUnits);
    }

    public Component getComponent() {
        return this;
    }

    public String getRealPath(String string) {
        return MapUtils.getRealPath(string);
    }

    public void broadcastMessage(int n, Object object) {
        if (this.isKilled) {
            return;
        }
        int n2 = this.statusListeners.size();
        for (int i = 0; i < n2; ++i) {
            ((StatusListener)this.statusListeners.elementAt(i)).notifyStatus(n, object);
        }
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public boolean isStopPaint(int n) {
        return this.isKilled || this.pntCounter > n;
    }

    public String getParameter(String string, String string2) {
        String string3 = this.parameters.getProperty(string, null);
        if (string3 == null) {
            string3 = this.host.getParameter(string, null);
            if (string3 != null) {
                ((Hashtable)this.parameters).put(string, string3);
                return string3;
            }
            return string2;
        }
        return string3;
    }

    public String getSRS() {
        return this.project.geoProjection;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!Strings.isNullOrBlank(string)) {
            this.showAttribForSelection(string, this.defaultAttributeReqType, this.lastSelectExt);
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        Object object;
        byte by;
        Vector vector = xmlElement.getElementsByTagName("param");
        for (by = 0; by < vector.size(); ++by) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(by);
            String string = xmlElement2.getAttributeValue("name");
            if (Strings.isNullOrBlank(string) || Strings.isNullOrBlank((String)(object = carteHost.getParameter(string, xmlElement2.getAttributeValue("value"))))) continue;
            ((Hashtable)this.parameters).put(string, object);
        }
        this.host = carteHost;
        this.SLD_url = this.getParameter("sld", null);
        if (!Strings.isNullOrBlank(this.SLD_url) && MapUtils.isSLD_Enabled()) {
            this.SLD_styles = SLD_Loader.getStylesTable((String)this.getParameter("sld_layers", null), (String)this.getParameter("sld_styles", null));
        } else {
            this.SLD_url = null;
        }
        this.isKeyMap = XmlUtils.getBoolean("keymap", xmlElement, false) || "keymap".equalsIgnoreCase(XmlUtils.getString("type", xmlElement, null));
        this.isMultiLayerSelectionMode = XmlUtils.getBoolean("multiselect", xmlElement, true);
        this.isShowAttributeAfterSelection = XmlUtils.getBoolean("showinfo", xmlElement, false);
        this.defaultAttributeReqType = this.isShowAttributeAfterSelection ? 30 : 31;
        this.sDependent_Maps = XmlUtils.getString("dependent", xmlElement, null);
        if (!this.isKeyMap) {
            if (Utils2D.have2d()) {
                Vector vector2 = xmlElement.getElementsByTagName("cursor");
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    object = (XmlElement)vector2.elementAt(i);
                    String string = XmlUtils.getString("tool", (XmlElement)object, null);
                    if (string == null) continue;
                    String string2 = XmlUtils.getString("image", (XmlElement)object, null);
                    Image image = null;
                    try {
                        image = MapUtils.loadImage2(null, string2);
                        Cursor cursor = Utils2D.createCursor(image, string);
                        if (cursor == null) continue;
                        if (this.customCursors == null) {
                            this.customCursors = new Hashtable();
                        }
                        this.customCursors.put(string, cursor);
                        continue;
                    }
                    catch (Exception exception) {
                        Log.addMessage(306, this.getName(), null, "Can't load raster image " + string2);
                    }
                }
            }
            this.proxy.setupProxy(this);
            MapUtils.isTipsActive = XmlUtils.getBoolean("tips", xmlElement, false);
            by = 6;
            String string = XmlUtils.getString("starttool", xmlElement, "");
            try {
                by = Byte.parseByte(string);
            }
            catch (Exception exception) {
                by = Carte.getToolCode(string);
            }
            if (by == 0) {
                by = 6;
            }
            this.setTool(by);
        } else {
            this.setVisible(false);
            this.mainMap = carteHost.getMapByName(xmlElement);
            this.mainMap.statusListeners.addElement(this);
        }
    }

    public void stop() {
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProject(String string) {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        try {
            try {
                while (this.sthRunning) {
                    Thread.sleep(300L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.project != null) {
                this.project.kill();
                this.project = null;
                System.gc();
            }
            this.isFirstRequest = true;
            this.projection = null;
            this.lastExtent = null;
            this.loadedExtent = null;
            ((Hashtable)this.parameters).put("pid", string);
            this.proxy.setupProxy(this);
        }
        finally {
            this.isKilled = false;
        }
        this.start();
    }

    public void kill() {
        this.isKilled = true;
        try {
            while (this.sthRunning) {
                Thread.sleep(300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.project != null) {
            this.project.kill();
            this.project = null;
        }
        Log.kill();
        this.mapListeners = null;
        this.statusListeners = null;
        if (this.stringResources != null) {
            ((Hashtable)this.stringResources).clear();
        }
        this.stringResources = null;
        this.proxy = null;
    }

    public void afterProjectLoaded(boolean bl) {
        if (this.mainMap != null && this.mainMap.isProjectLoaded() && this.mainMap.getProject().hasKeyMap) {
            this.setVisible(true);
            this.setProject(this.mainMap.getProject());
            this.setBackground(this.project.keyMapBackground);
            this.moveBeyondProject = false;
            this.projection = new Projection();
            if (this.project.keyMapTheme != null) {
                this.thematicMap = this.project.keyMapTheme;
            } else {
                this.setThematicMap(this.project.startTheme);
            }
            this.stopped = false;
            this.setTool((byte)8);
        } else {
            this.setVisible(false);
        }
    }

    public void notifyStatus(int n, Object object) {
        if (!this.isKilled && this.isProjectLoaded() && n == 11 && object == null) {
            this.loadedExtent = new FloatRectangle(this.project.maxExtent);
            this.zoomToFullExtent();
            this.updateMap();
        }
    }

    public void timerTick() {
        this.updateMap(true);
    }

    public void setLoadedExtent(FloatRectangle floatRectangle) {
        this.lastExtent = null;
        this.loadedExtent = floatRectangle;
        this.projection = new Projection();
    }
}

