/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.alov.map.DataStorage;
import org.alov.map.FloatRectangle;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Shape;
import org.alov.util.ExDate;
import org.alov.util.Readers;
import org.alov.util.Writers;

public class DataStorageCompact
extends DataStorage {
    protected byte[] spatialData = null;
    protected int[] spatialIndex = null;
    protected byte[] attributeData = null;
    protected int[] attributeIndex = null;
    private ByteArrayInputStream bis = null;
    private DataInputStream is = null;
    private ByteArrayInputStream bisa = null;
    private DataInputStream isa = null;
    private ByteArrayOutputStream bos = null;
    private DataOutputStream os = null;
    private ByteArrayOutputStream bosa = null;
    private DataOutputStream osa = null;
    private RecordsArray tempIndexS = null;
    private RecordsArray tempIndexA = null;

    public void afterDeserialization() {
        super.afterDeserialization();
    }

    public int size() {
        return this.spatialIndex == null ? 0 : this.spatialIndex.length;
    }

    private void saveDataStorageIndex(int n) {
        if (this.tempIndexA == null) {
            this.spatialIndex[n] = this.os.size();
            if (this.osa != null) {
                this.attributeIndex[n] = this.osa.size();
            }
        } else {
            this.tempIndexS.add(this.os.size());
            this.tempIndexA.add(this.osa.size());
        }
    }

    private void saveDataStorageCoords(Record record) throws IOException {
        if (this.getObjectType() == 1) {
            Shape shape = record.getShape(0);
            this.os.writeFloat((float)shape.xCoords[0]);
            this.os.writeFloat((float)shape.yCoords[0]);
        } else {
            int n = record.getShapeCount();
            Writers.writeInt4(this.os, n);
            for (int i = 0; i < n; ++i) {
                Shape shape = record.getShape(i);
                int n2 = shape.xCoords.length;
                this.os.write(shape.typeFill);
                Writers.writeInt4(this.os, n2);
                for (int j = 0; j < n2; ++j) {
                    this.os.writeFloat((float)shape.xCoords[j]);
                    this.os.writeFloat((float)shape.yCoords[j]);
                }
            }
        }
    }

    public void saveDataStorageRec(Record record, boolean bl) throws IOException {
        this.saveDataStorageIndex(record.index);
        this.saveDataStorageCoords(record);
        if (bl) {
            for (int i = 0; i < this.fieldOriginalCount; ++i) {
                Writers.writeObject(this.osa, record.getField(i), this.fieldDefs[i].type);
            }
        }
        record = null;
    }

    public void openDataStorageSave(boolean bl) {
        this.bos = new ByteArrayOutputStream();
        this.os = new DataOutputStream(this.bos);
        this.bosa = new ByteArrayOutputStream();
        this.osa = new DataOutputStream(this.bosa);
        if (bl) {
            this.tempIndexS = new RecordsArray(null);
            this.tempIndexA = new RecordsArray(null);
        }
    }

    public void openDataStorageSaveCoordinates() {
        this.bos = new ByteArrayOutputStream();
        this.os = new DataOutputStream(this.bos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDataStorageSave() {
        try {
            block8: {
                try {
                    if (this.bos != null) {
                        this.spatialData = this.bos.toByteArray();
                        this.bos.close();
                    }
                    if (this.bosa != null) {
                        this.attributeData = this.bosa.toByteArray();
                        this.bosa.close();
                    }
                    if (this.tempIndexA != null) {
                        this.spatialIndex = this.tempIndexS.getArray();
                        this.attributeIndex = this.tempIndexA.getArray();
                        this.tempIndexS = null;
                        this.tempIndexA = null;
                    }
                    if (this.os != null) {
                        this.os.close();
                    }
                    if (this.osa == null) break block8;
                    this.osa.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var3_2 = null;
                    this.os = null;
                    this.bos = null;
                    this.osa = null;
                    this.bosa = null;
                }
            }
            Object var3_1 = null;
            this.os = null;
            this.bos = null;
            this.osa = null;
            this.bosa = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.os = null;
            this.bos = null;
            this.osa = null;
            this.bosa = null;
            throw throwable;
        }
    }

    public void openDataStorage(boolean bl) {
        if (this.spatialData != null && this.spatialData.length > 0) {
            this.bis = new ByteArrayInputStream(this.spatialData);
            this.is = new DataInputStream(this.bis);
            if (bl) {
                this.bisa = new ByteArrayInputStream(this.attributeData);
                this.isa = new DataInputStream(this.bisa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDataStorage() {
        try {
            block7: {
                try {
                    if (this.is != null) {
                        this.is.close();
                    }
                    if (this.bis != null) {
                        this.bis.close();
                    }
                    if (this.isa != null) {
                        this.isa.close();
                    }
                    if (this.bisa == null) break block7;
                    this.bisa.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var3_2 = null;
                    this.is = null;
                    this.bis = null;
                    this.isa = null;
                    this.bisa = null;
                }
            }
            Object var3_1 = null;
            this.is = null;
            this.bis = null;
            this.isa = null;
            this.bisa = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.is = null;
            this.bis = null;
            this.isa = null;
            this.bisa = null;
            throw throwable;
        }
    }

    public void skipAttribute(int n) throws IOException {
        if (n < this.attributeIndex.length - 1) {
            this.isa.skipBytes(this.attributeIndex[n + 1] - this.attributeIndex[n]);
        }
    }

    protected void skipAttribute2(int n, int n2) throws IOException {
        int n3 = this.attributeIndex[n] - this.attributeIndex[n2];
        this.isa.skipBytes(n3);
    }

    protected void skipSpatial(int n) throws IOException {
        if (n < this.spatialIndex.length - 1) {
            this.is.skipBytes(this.spatialIndex[n + 1] - this.spatialIndex[n]);
        }
    }

    protected void skipSpatial2(int n, int n2) throws IOException {
        int n3 = this.spatialIndex[n] - this.spatialIndex[n2];
        this.is.skipBytes(n3);
    }

    public void readRecAttribute(Record record) throws IOException {
        block10: for (int i = 0; i < this.fieldOriginalCount; ++i) {
            switch (this.fieldDefs[i].type) {
                case -7: 
                case -6: {
                    record.setField(i, new Byte(this.isa.readByte()));
                    continue block10;
                }
                case 5: {
                    record.setField(i, new Short(this.isa.readShort()));
                    continue block10;
                }
                case 4: {
                    record.setField(i, new Integer(this.isa.readInt()));
                    continue block10;
                }
                case -5: {
                    record.setField(i, new Long(this.isa.readLong()));
                    continue block10;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    record.setField(i, new Float(this.isa.readFloat()));
                    continue block10;
                }
                case 8: {
                    record.setField(i, new Double(this.isa.readDouble()));
                    continue block10;
                }
                case -1: 
                case 1: 
                case 12: {
                    String string = new String(this.isa.readUTF());
                    record.setField(i, string);
                    continue block10;
                }
                case 91: 
                case 92: 
                case 93: {
                    record.setField(i, new ExDate(this.isa.readDouble()));
                    continue block10;
                }
                default: {
                    record.setField(i, "");
                }
            }
        }
    }

    public boolean readRecCoords(Record record, FloatRectangle floatRectangle) throws IOException {
        boolean bl = false;
        if (this.getObjectType() == 1) {
            float f = this.is.readFloat();
            float f2 = this.is.readFloat();
            boolean bl2 = bl = floatRectangle == null || floatRectangle.isZero() || floatRectangle.contain(f, f2);
            if (bl) {
                Shape shape = record.newShape(1);
                shape.setVertex(0, f, f2);
            }
        } else {
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            int n = Readers.readInt(this.is);
            record.initShapes(n);
            for (int i = 0; i < n; ++i) {
                Shape shape = new Shape();
                shape.typeFill = (byte)this.is.read();
                int n2 = Readers.readInt(this.is);
                shape.xCoords = new double[n2];
                shape.yCoords = new double[n2];
                for (int j = 0; j < n2; ++j) {
                    float f = this.is.readFloat();
                    float f3 = this.is.readFloat();
                    if (d < (double)f) {
                        d = f;
                    }
                    if (d3 > (double)f) {
                        d3 = f;
                    }
                    if (d2 < (double)f3) {
                        d2 = f3;
                    }
                    if (d4 > (double)f3) {
                        d4 = f3;
                    }
                    shape.xCoords[j] = f;
                    shape.yCoords[j] = f3;
                }
                record.setShape(i, shape);
            }
            FloatRectangle floatRectangle2 = new FloatRectangle(d3, d4, d, d2);
            record.setRecordExtent(floatRectangle2);
            bl = floatRectangle == null || floatRectangle.intersects(floatRectangle2);
        }
        return bl;
    }

    public Record newRecord(int n) {
        Record record = new Record(this.fieldOriginalCount);
        record.index = n;
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getRecord(int n, int n2) {
        Record record = null;
        if (n >= 0 && n < this.size()) {
            DataStorageCompact dataStorageCompact = this;
            synchronized (dataStorageCompact) {
                try {
                    this.openDataStorage(n2 < 2);
                    if (n2 < 2) {
                        record = new Record(this.fieldOriginalCount);
                        this.isa.skipBytes(this.attributeIndex[n]);
                        this.readRecAttribute(record);
                    } else {
                        record = new Record();
                    }
                    record.index = n;
                    if (n2 != 1) {
                        this.is.skipBytes(this.spatialIndex[n]);
                        this.readRecCoords(record, null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.closeDataStorage();
                }
            }
        }
        return record;
    }

    public void clear() {
        this.spatialData = null;
        this.spatialIndex = null;
        this.attributeData = null;
        this.attributeIndex = null;
    }

    public DataStorage copy() {
        DataStorageCompact dataStorageCompact = new DataStorageCompact();
        dataStorageCompact.spatialData = this.spatialData;
        dataStorageCompact.spatialIndex = this.spatialIndex;
        dataStorageCompact.attributeData = this.attributeData;
        dataStorageCompact.attributeIndex = this.attributeIndex;
        dataStorageCompact.fieldOriginalCount = this.fieldOriginalCount;
        return dataStorageCompact;
    }

    public void deleteRecord(Record record) {
        int n = 0;
        int n2 = 0;
        if (record.index == this.spatialIndex.length - 1) {
            n = this.spatialData.length - this.spatialIndex[record.index];
            n2 = this.attributeData.length - this.attributeIndex[record.index];
        } else {
            n = this.spatialIndex[record.index + 1] - this.spatialIndex[record.index];
            n2 = this.attributeIndex[record.index + 1] - this.attributeIndex[record.index];
        }
        byte[] byArray = new byte[this.spatialData.length - n];
        byte[] byArray2 = new byte[this.attributeData.length - n2];
        if (this.spatialIndex[record.index] > 0) {
            System.arraycopy(this.spatialData, 0, byArray, 0, this.spatialIndex[record.index]);
        }
        if (record.index != this.spatialIndex.length - 1) {
            System.arraycopy(this.spatialData, this.spatialIndex[record.index + 1], byArray, this.spatialIndex[record.index], this.spatialData.length - this.spatialIndex[record.index + 1]);
        }
        if (this.attributeIndex[record.index] > 0) {
            System.arraycopy(this.attributeData, 0, byArray2, 0, this.attributeIndex[record.index]);
        }
        if (record.index != this.attributeIndex.length - 1) {
            System.arraycopy(this.attributeData, this.attributeIndex[record.index + 1], byArray2, this.attributeIndex[record.index], this.attributeData.length - this.attributeIndex[record.index + 1]);
        }
        for (int i = record.index + 1; i < this.spatialIndex.length; ++i) {
            this.spatialIndex[i] = this.spatialIndex[i] - n;
            this.attributeIndex[i] = this.attributeIndex[i] - n2;
        }
        int[] nArray = new int[this.spatialIndex.length - 1];
        int[] nArray2 = new int[this.attributeIndex.length - 1];
        if (record.index > 0) {
            System.arraycopy(this.spatialIndex, 0, nArray, 0, record.index);
            System.arraycopy(this.attributeIndex, 0, nArray2, 0, record.index);
        }
        if (record.index != this.attributeIndex.length - 1) {
            System.arraycopy(this.spatialIndex, record.index + 1, nArray, record.index, this.spatialIndex.length - record.index - 1);
            System.arraycopy(this.attributeIndex, record.index + 1, nArray2, record.index, this.attributeIndex.length - record.index - 1);
        }
        this.clear();
        this.spatialData = byArray;
        this.spatialIndex = nArray;
        this.attributeData = byArray2;
        this.attributeIndex = nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRecord(Record record, int n) {
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        int n5;
        if (this.bos != null) {
            try {
                this.saveDataStorageRec(record, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            block34: {
                try {
                    if (n != 1) {
                        this.bos = new ByteArrayOutputStream();
                        this.os = new DataOutputStream(this.bos);
                        this.saveDataStorageCoords(record);
                        byArray2 = this.bos.toByteArray();
                        if (this.os != null) {
                            this.os.close();
                        }
                    }
                    if (n == 2) break block34;
                    this.bosa = new ByteArrayOutputStream();
                    this.osa = new DataOutputStream(this.bosa);
                    for (n5 = 0; n5 < this.fieldOriginalCount; ++n5) {
                        Writers.writeObject(this.osa, record.getField(n5), this.fieldDefs[n5].type);
                    }
                    byArray3 = this.bosa.toByteArray();
                    if (this.osa == null) break block34;
                    this.osa.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var7_9 = null;
                    this.os = null;
                    this.bos = null;
                    this.osa = null;
                    this.bosa = null;
                    return;
                }
            }
            Object var7_8 = null;
            this.os = null;
            this.bos = null;
            this.osa = null;
            this.bosa = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.os = null;
            this.bos = null;
            this.osa = null;
            this.bosa = null;
            throw throwable;
        }
        if (byArray2 != null) {
            int n6 = n5 = record.index > -1 ? 1 : 0;
            if (this.spatialIndex == null) {
                this.spatialIndex = new int[0];
                this.spatialData = new byte[0];
            }
            n4 = n5 != 0 ? this.spatialIndex[record.index] : this.spatialData.length;
            int n7 = 0;
            if (record.index == this.spatialIndex.length - 1) {
                n7 = this.spatialData.length - n4;
            } else if (n5 != 0) {
                n7 = this.spatialIndex[record.index + 1] - n4;
            }
            n3 = byArray2.length - n7;
            if (n3 == 0) {
                System.arraycopy(byArray2, 0, this.spatialData, n4, byArray2.length);
            } else {
                byArray = new byte[this.spatialData.length + n3];
                if (n4 > 0) {
                    System.arraycopy(this.spatialData, 0, byArray, 0, n4);
                }
                System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
                if (n5 != 0 && record.index != this.spatialIndex.length - 1) {
                    System.arraycopy(this.spatialData, this.spatialIndex[record.index + 1], byArray, n4 + byArray2.length, this.spatialData.length - this.spatialIndex[record.index + 1]);
                }
                if (n5 != 0) {
                    for (n2 = record.index + 1; n2 < this.spatialIndex.length; ++n2) {
                        this.spatialIndex[n2] = this.spatialIndex[n2] + n3;
                    }
                } else {
                    int[] nArray = new int[this.spatialIndex.length + 1];
                    System.arraycopy(this.spatialIndex, 0, nArray, 0, this.spatialIndex.length);
                    nArray[this.spatialIndex.length] = this.spatialData.length;
                    this.spatialIndex = null;
                    this.spatialIndex = nArray;
                }
                this.spatialData = null;
                this.spatialData = byArray;
            }
        }
        if (byArray3 != null) {
            int n8 = n5 = record.index > -1 ? 1 : 0;
            if (this.attributeIndex == null) {
                this.attributeIndex = new int[0];
                this.attributeData = new byte[0];
            }
            n4 = n5 != 0 ? this.attributeIndex[record.index] : this.attributeData.length;
            int n9 = 0;
            if (record.index == this.attributeIndex.length - 1) {
                n9 = this.attributeData.length - n4;
            } else if (n5 != 0) {
                n9 = this.attributeIndex[record.index + 1] - n4;
            }
            n3 = byArray3.length - n9;
            if (n3 == 0) {
                System.arraycopy(byArray3, 0, this.attributeData, n4, byArray3.length);
            } else {
                byArray = new byte[this.attributeData.length + n3];
                if (n4 > 0) {
                    System.arraycopy(this.attributeData, 0, byArray, 0, n4);
                }
                System.arraycopy(byArray3, 0, byArray, n4, byArray3.length);
                if (n5 != 0 && record.index != this.attributeIndex.length - 1) {
                    System.arraycopy(this.attributeData, this.attributeIndex[record.index + 1], byArray, n4 + byArray3.length, this.attributeData.length - this.attributeIndex[record.index + 1]);
                }
                if (n5 != 0) {
                    for (n2 = record.index + 1; n2 < this.attributeIndex.length; ++n2) {
                        this.attributeIndex[n2] = this.attributeIndex[n2] + n3;
                    }
                } else {
                    int[] nArray = new int[this.attributeIndex.length + 1];
                    System.arraycopy(this.attributeIndex, 0, nArray, 0, this.attributeIndex.length);
                    record.index = this.attributeIndex.length;
                    nArray[record.index] = this.attributeData.length;
                    this.attributeIndex = null;
                    this.attributeIndex = nArray;
                }
                this.attributeData = null;
                this.attributeData = byArray;
            }
        }
    }

    protected void unionStorages(DataStorage dataStorage) {
        DataStorageCompact dataStorageCompact = (DataStorageCompact)dataStorage;
        if (this.spatialData == null) {
            this.spatialData = dataStorageCompact.spatialData;
            this.spatialIndex = dataStorageCompact.spatialIndex;
            this.attributeData = dataStorageCompact.attributeData;
            this.attributeIndex = dataStorageCompact.attributeIndex;
        } else {
            byte[] byArray = new byte[this.spatialData.length + dataStorageCompact.spatialData.length];
            byte[] byArray2 = new byte[this.attributeData.length + dataStorageCompact.attributeData.length];
            System.arraycopy(this.spatialData, 0, byArray, 0, this.spatialData.length);
            System.arraycopy(this.attributeData, 0, byArray2, 0, this.attributeData.length);
            System.arraycopy(dataStorageCompact.spatialData, 0, byArray, this.spatialData.length, dataStorageCompact.spatialData.length);
            System.arraycopy(dataStorageCompact.attributeData, 0, byArray2, this.attributeData.length, dataStorageCompact.attributeData.length);
            int n = dataStorageCompact.spatialIndex.length;
            int n2 = this.spatialData.length;
            int n3 = this.attributeData.length;
            for (int i = 0; i < n; ++i) {
                dataStorageCompact.spatialIndex[i] = dataStorageCompact.spatialIndex[i] + n2;
                dataStorageCompact.attributeIndex[i] = dataStorageCompact.attributeIndex[i] + n3;
            }
            int[] nArray = new int[this.spatialIndex.length + dataStorageCompact.spatialIndex.length];
            int[] nArray2 = new int[this.attributeIndex.length + dataStorageCompact.attributeIndex.length];
            System.arraycopy(this.spatialIndex, 0, nArray, 0, this.spatialIndex.length);
            System.arraycopy(this.attributeIndex, 0, nArray2, 0, this.attributeIndex.length);
            System.arraycopy(dataStorageCompact.spatialIndex, 0, nArray, this.spatialIndex.length, dataStorageCompact.spatialIndex.length);
            System.arraycopy(dataStorageCompact.attributeIndex, 0, nArray2, this.attributeIndex.length, dataStorageCompact.attributeIndex.length);
            this.clear();
            this.spatialData = byArray;
            this.spatialIndex = nArray;
            this.attributeData = byArray2;
            this.attributeIndex = nArray2;
        }
    }

    public void write(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.spatialData);
        objectOutputStream.writeObject(this.spatialIndex);
        objectOutputStream.writeObject(this.attributeData);
        objectOutputStream.writeObject(this.attributeIndex);
        objectOutputStream.close();
    }

    public void read(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.spatialData = (byte[])objectInputStream.readObject();
        this.spatialIndex = (int[])objectInputStream.readObject();
        this.attributeData = (byte[])objectInputStream.readObject();
        this.attributeIndex = (int[])objectInputStream.readObject();
        objectInputStream.close();
    }
}

